package healthwatcher.view.command;

import healthwatcher.model.complaint.DiseaseType;
import healthwatcher.model.complaint.Symptom;
import healthwatcher.view.IFacade;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;

import lib.exceptions.ObjectNotFoundException;
import lib.util.HTMLCode;

public class SearchDiseaseData extends CommandServlet {

	public void executeCommand(IFacade receiver) {
		PrintWriter out = null;
		try {
			out = response.getWriter();
		} catch (IOException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}

		response.setContentType("text/html");

		int codigoTipoDoenca = Integer.parseInt(request
				.getParameter("codTipoDoenca"));

		try {
			DiseaseType tp = receiver.searchDiseaseType(codigoTipoDoenca);

			out.println(HTMLCode.open("Queries - Diseases"));
			out.println("<body><h1>Querie result<br>Disease</h1>");

			out.println("<P><h3>Name: " + tp.getName() + "</h3></P>");
			out.println("<P>Description: " + tp.getDescription() + "</P>");
			out.println("<P>How manifests: " + tp.getManifestation() + " </P>");
			out.println("<P>Duration: " + tp.getDuration() + " </P>");
			out.println("<P>Symptoms: </P>");

			Iterator i = tp.getSymptoms().iterator();

			if (!i.hasNext()) {
				out.println("<P>There isn't registered symptoms.</P>");
			} else {
				while (i.hasNext()) {
					Symptom s = (Symptom) i.next();
					out.println("<li> " + s.getDescription() + " </li>");
				}
			}
			out.println(HTMLCode.closeQueries());

		} catch (ObjectNotFoundException e) {
			out.println("<P> " + e.getMessage() + " </P>");
		} catch (Exception e) {
			out.println(lib.util.HTMLCode
					.errorPage("Comunitation error, please try again later."));
			e.printStackTrace(out);
		} finally {
			out.close();
		}
	}
}