package healthwatcher.view.command;

import healthwatcher.model.address.Address;
import healthwatcher.model.complaint.Complaint;
import healthwatcher.model.complaint.FoodComplaint;
import healthwatcher.view.IFacade;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Calendar;

import lib.exceptions.ObjectAlreadyInsertedException;
import lib.exceptions.ObjectNotValidException;
import lib.util.Date;
import lib.util.HTMLCode;

public class InsertFoodComplaint extends CommandServlet {

	public void executeCommand(IFacade receiver) {
		PrintWriter out = null;
		try {
			out = response.getWriter();
		} catch (IOException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}

		response.setContentType("text/html");

		try {
			// Queixa Normal
			String descricaoQueixa = request.getParameter("descricaoQueixa");
			String observacaoQueixa = request.getParameter("observacaoQueixa");
			String nomeSolicitante = request.getParameter("nomeSolicitante");
			String ruaSolicitante = request.getParameter("ruaSolicitante");
			String compSolicitante = request.getParameter("compSolicitante");
			String bairroSolicitante = request
					.getParameter("bairroSolicitante");
			String cidadeSolicitante = request
					.getParameter("cidadeSolicitante");
			String ufSolicitante = request.getParameter("ufSolicitante");
			String cepSolicitante = request.getParameter("cepSolicitante ");
			String telefoneSolicitante = request
					.getParameter("telefoneSolicitante");
			Address endSolicitante = new Address(ruaSolicitante,
					compSolicitante, cepSolicitante, ufSolicitante,
					telefoneSolicitante, cidadeSolicitante, bairroSolicitante);
			String emailSolicitante = request.getParameter("emailSolicitante");

			// Queixa Alimentar
			// String nomeVitima = request.getParameter("nomeVitima");
			String ruaVitima = request.getParameter("ruaVitima");
			String compVitima = request.getParameter("compVitima");
			String bairroVitima = request.getParameter("bairroVitima");
			String cidadeVitima = request.getParameter("cidadeVitima");
			String ufVitima = request.getParameter("ufVitima");
			String cepVitima = request.getParameter("cepVitima ");
			String telefoneVitima = request.getParameter("telefoneVitima");
			Address endVitima = new Address(ruaVitima, compVitima, cepVitima,
					ufVitima, telefoneVitima, cidadeVitima, bairroVitima);

			short qtdeComensais = Short.parseShort(request
					.getParameter("qtdeComensais"));
			short qtdeDoentes = Short.parseShort(request
					.getParameter("qtdeDoentes"));
			short qtdeInternacoes = Short.parseShort(request
					.getParameter("qtdeInternacoes"));
			short qtdeObitos = Short.parseShort(request
					.getParameter("qtdeObitos"));

			String localAtendimento = request.getParameter("localAtendimento");
			String refeicaoSuspeita = request.getParameter("refeicaoSuspeita");
			Calendar agora = Calendar.getInstance();

			Complaint queixa = new FoodComplaint(nomeSolicitante,
					descricaoQueixa, observacaoQueixa, emailSolicitante, null,
					1, null, new Date(agora.get(Calendar.DAY_OF_MONTH), agora
							.get(Calendar.MONTH), agora.get(Calendar.YEAR)),
					endSolicitante, qtdeComensais, qtdeDoentes,
					qtdeInternacoes, qtdeObitos, localAtendimento,
					refeicaoSuspeita, endVitima);

			int codigo = receiver.insertComplaint(queixa);

			out.println(HTMLCode.htmlPage("Complaint inserted",
					"<p> <h2> Food Complaint inserted</h2> </p>"
							+ "<p> <h2> Save the complaint number: " + codigo
							+ "</h2> </p>"));

		} catch (ObjectAlreadyInsertedException e) {
			out.println(HTMLCode.errorPage("Esta queixa jah existe no BD"));
			e.printStackTrace(out);
		} catch (ObjectNotValidException e) {
			out.println(HTMLCode.errorPage("Erro ao inserir esta queixa"));
			e.printStackTrace(out);
		} catch (Exception e) {
			e.printStackTrace();
			out.println(lib.util.HTMLCode
					.errorPage("Comunitation error, please try again later."));
			e.printStackTrace(out);
		} finally {
			out.println(HTMLCode.close());
			out.close();
		}
	}
}