package healthwatcher.view.command;

import healthwatcher.model.employee.Employee;
import healthwatcher.view.IFacade;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.http.HttpSession;

import lib.exceptions.InvalidSessionException;
import lib.exceptions.ObjectAlreadyInsertedException;
import lib.exceptions.ObjectNotValidException;
import lib.util.HTMLCode;

public class InsertEmployee extends CommandServlet {

	public void executeCommand(IFacade receiver) {
		PrintWriter out = null;
		Employee employee;
		HttpSession session = request.getSession(false);

		response.setContentType("text/html");

		try {
			out = response.getWriter();
		} catch (IOException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}

		try {
			if (session == null) {
				throw new InvalidSessionException();
			}

			// Complaint Normal
			String name = request.getParameter("name");
			String login = request.getParameter("login");
			String password = request.getParameter("password");

			employee = new Employee(login, password, name);

			receiver.insert(employee);

			out.println(HTMLCode.htmlPageAdministrator("Operation executed",
					"Employee inserted"));
		} catch (ObjectAlreadyInsertedException e) {
			out.println(lib.util.HTMLCode
					.errorPageAdministrator(e.getMessage()));
			e.printStackTrace(out);
		} catch (ObjectNotValidException e) {
			out.println(lib.util.HTMLCode
					.errorPageAdministrator(e.getMessage()));
			e.printStackTrace(out);
		} catch (InvalidSessionException e) {
			out.println(lib.util.HTMLCode
					.errorPageAdministrator(e.getMessage()));
			e.printStackTrace(out);
		} finally {
			out.close();
		}
	}
}