package healthwatcher.data.rdb;

import healthwatcher.data.IAddressRepository;
import healthwatcher.model.address.Address;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import lib.exceptions.ExceptionMessages;
import lib.exceptions.ObjectAlreadyInsertedException;
import lib.exceptions.ObjectNotFoundException;
import lib.exceptions.ObjectNotValidException;
import lib.exceptions.PersistenceMechanismException;
import lib.exceptions.RepositoryException;
import lib.persistence.IPersistenceMechanism;




/**
 * Repositorio responsvel por realizar a persitncia
 * de endereos. Esse persistncia  realizada em banco
 * de dados relacional utilizando JDBC
 */
public class AddressRepositoryRDB implements IAddressRepository {

	private IPersistenceMechanism mp;

	private ResultSet resultSet;

	public AddressRepositoryRDB(IPersistenceMechanism mp) {
		this.mp = mp;
	}

	/**
	 * Mtodo para atualizao de um endereo.
	 * Na verso atual do sistema disque sade
	 * essa funcionalidade no est implementada.
	 */
	public void update(Address end) throws RepositoryException, ObjectNotFoundException {
	}

	/**
	 * Mtodo para verificao da existncia de um
	 * endereo com cdigo especficado como parmetro.
	 * Na verso atual do sistema disque sade essa
	 * funcionalidade no est implementada.
	 */
	public boolean exists(int codigo) throws RepositoryException {
		return false;
	}

	/**
	 * Mtodo para insero de endereo no repositrrio persistente.
	 * Essa implementao faz a persistncia atravs de JDBC
	 * conectando com um banco de dados relacional.
	 */
	public int insert(Address end) throws ObjectAlreadyInsertedException, ObjectNotValidException,
		ObjectNotValidException, RepositoryException {
		
		// teste da validade do objeto a ser inserido
		if (end == null) {
			throw new ObjectNotValidException(ExceptionMessages.EXC_NULO);
		}

		Statement stmt;

		try {

			// Bloco para a recuperao de um cdigo sequencial do
			// banco de dados para ser utilizado como identificador
			// e cdigo da tabela de endereos.
			String consulta = null;
			try {

				//pega id e codigo e seta no objeto primeiro
				consulta = "select * from SCBS_endereco";

				stmt = (Statement) mp.getCommunicationChannel();
				resultSet = stmt.executeQuery(consulta);

				int count = 0;
				while (resultSet.next()) {
					count++;
				}
				end.setCode(count + 1);

				count++;

				resultSet.close();
				stmt.close();

			} catch (SQLException e) {
				System.out.println(consulta);
				throw new RepositoryException(ExceptionMessages.EXC_FALHA_BD);
			}

			// Consulta na tabela ao cdigo gerado pelo trecho anterior.
			// Caso o cdigo j esteja em uso uma exceo  levantada.
			try {
				stmt = (Statement) mp.getCommunicationChannel();
				String sql = "SELECT * FROM SCBS_endereco WHERE codigo = '" + end.getCode() + "'";
				resultSet = stmt.executeQuery(sql);

				if (resultSet.next()) {
					throw new ObjectAlreadyInsertedException(ExceptionMessages.EXC_JA_EXISTE);
				}
				resultSet.close();
				stmt.close();
			} catch (SQLException e) {
				throw new PersistenceMechanismException(ExceptionMessages.EXC_FALHA_BD);
			}

			// Essa ltima etapa da insero insere de fato os valores
			// recebidos no objeto do parmetro com cdigo e
			// identificador devidamente alterados
			try {
				String sql = "INSERT INTO SCBS_endereco VALUES(";

				//sql += end.getId() + ",";
				sql += "'" + end.getCode() + "',";
				sql += "'" + end.getStreet() + "',";
				sql += "'" + end.getComplement() + "',";
				sql += "'" + end.getZip() + "',";
				sql += "'" + end.getState() + "',";
				sql += "'" + end.getPhone() + "',";
				sql += "'" + end.getCity() + "',";
				sql += "'" + end.getNeighbourhood() + "')";

				stmt = (Statement) this.mp.getCommunicationChannel();
				stmt.executeUpdate(sql);
				stmt.close();

			} catch (SQLException e) {
				throw new RepositoryException(ExceptionMessages.EXC_FALHA_BD);
			}
		} catch (PersistenceMechanismException e) {
			throw new RepositoryException(ExceptionMessages.EXC_FALHA_INCLUSAO);
		}
		
		// TODO THIS IS WRONG!!!
		return -1;
	}

	/**
	 * Mtodo para recuperao de endereo a partir do cdigo.
	 *
	 * @param codigo Cdigo identificador do endereo a 
	 *				 ser recuperado.
	 * @return endereo montado com os dados recuperados do bd
	 * @exception RepositorioException caso ocorra algum problema
	 *			  relacionado ao acesso aos dados persistentes.
	 * @exception ObjetoInexistenteException caso o endereo
	 *			  no seja encontrada nos dados persistentes
	 */
	public Address search(int code) throws RepositoryException, ObjectNotFoundException {
		Address end = null;
		String sql = null;
		try {
			sql = "select * from SCBS_endereco where " + " codigo = '" + code + "'";

			Statement stmt = (Statement) this.mp.getCommunicationChannel();

			//System.out.println(sql);
			resultSet = stmt.executeQuery(sql);

			if (resultSet.next()) {
				//long id = resultSet.getLong("ID");
				code = (new Integer(resultSet.getString("codigo"))).intValue();

				String rua = resultSet.getString("rua");
				String complemento = resultSet.getString("complemento");
				String cep = resultSet.getString("cep");
				String uf = resultSet.getString("uf");
				String fone = resultSet.getString("fone");
				String cidade = resultSet.getString("cidade");
				String bairro = resultSet.getString("bairro");
				end = new Address(rua, complemento, cep, uf, fone, cidade, bairro);
				end.setCode(code);

			} else {
				throw new ObjectNotFoundException(ExceptionMessages.EXC_FALHA_PROCURA);
			}
			resultSet.close();
			stmt.close();

		} catch (PersistenceMechanismException e) {
			throw new RepositoryException(ExceptionMessages.EXC_FALHA_BD);
		} catch (SQLException e) {
			System.out.println(sql);
			throw new RepositoryException(ExceptionMessages.EXC_FALHA_BD);
		}

		return end;
	}

	public void remove(int code) throws ObjectNotFoundException, RepositoryException {
	}
}
