/**
 * Copyright (c) 2006 Macacos.org. All Rights Reserved
 *
 * This library is free software; you can redistribute it and/or modify it under the terms of the 
 * GNU Lesser General Public License as published by the Free Software Foundation; either version 
 * 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See 
 * the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this library;
 * if not, write to the Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, 
 * MA  02110-1301  USA
 * 
 * You can find the license also here: http://www.gnu.org/copyleft/lesser.html
 * 
 * 
 * Created on Sep 19, 2006 by Thiago Tonelli Bartolomei
 * -------------------------------------------------
 *           \                                                                           
 *            \                                                                          
 *               __                                                                      
 *          w  c(..)o                                                                    
 *           \__(o)                                                                      
 *               /\                                                                      
 *            w_/(_)-~                                                                   
 *                /|                                                                     
 *               | \                                                                     
 *               m  m   
 */
package healthwatcher.aspects.patterns;

import healthwatcher.business.HealthWatcherFacade;
import healthwatcher.view.servlets.*;
import healthwatcher.view.IFacade;
import healthwatcher.view.command.CommandServlet;
import healthwatcher.view.command.ConfigRMI;
import healthwatcher.view.command.GetDataForSearchByDiseaseType;
import healthwatcher.view.command.GetDataForSearchByHealthUnit;
import healthwatcher.view.command.GetDataForSearchBySpeciality;
import healthwatcher.view.command.InsertAnimalComplaint;
import healthwatcher.view.command.InsertEmployee;
import healthwatcher.view.command.InsertFoodComplaint;
import healthwatcher.view.command.InsertSpecialComplaint;
import healthwatcher.view.command.Login;
import healthwatcher.view.command.LoginMenu;
import healthwatcher.view.command.SearchComplaintData;
import healthwatcher.view.command.SearchDiseaseData;
import healthwatcher.view.command.SearchHealthUnitsBySpecialty;
import healthwatcher.view.command.SearchSpecialtiesByHealthUnit;
import healthwatcher.view.command.UpdateComplaintData;
import healthwatcher.view.command.UpdateComplaintList;
import healthwatcher.view.command.UpdateComplaintSearch;
import healthwatcher.view.command.UpdateEmployeeData;
import healthwatcher.view.command.UpdateEmployeeSearch;
import healthwatcher.view.command.UpdateHealthUnitData;
import healthwatcher.view.command.UpdateHealthUnitList;
import healthwatcher.view.command.UpdateHealthUnitSearch;

import java.util.Hashtable;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import lib.patterns.*;

/**
 * TODO - describe this file
 * 
 * @author Thiago Tonelli Bartolomei <thiago.bartolomei@gmail.com>
 */
public deployed cclass ServletCommanding extends CommandProtocol {
	
	private Hashtable commandTable;
	
	public cclass Command wraps CommandServlet {

	    public void executeCommand(CommandReceiver receiver) {
	    	wrappee.executeCommand(((FacadeReceiver) receiver).getFacade());
	    }
	}
	
	public cclass FacadeReceiver extends CommandReceiver wraps IFacade {
		public IFacade getFacade() {
			return wrappee;
		}
	}
	
	private static final String CommandConfigRMI		             = "ConfigRMI";
	private static final String CommandGetDataForSearchByDiseaseType = "SearchByDiseaseType";
	private static final String CommandGetDataForSearchByHealthUnit  = "SearchByHealthUnit";
	private static final String CommandGetDataForSearchBySpeciality  = "SearchBySpecialty";
	private static final String CommandInsertAnimalComplaint         = "InsertAnimalComplaint";
	private static final String CommandInsertEmployee                = "InsertEmployee";
	private static final String CommandInsertFoodComplaint           = "InsertFoodComplaint";
	private static final String CommandInsertSpecialComplaint        = "InsertSpecialComplaint";
	private static final String CommandLogin                         = "Login";
	private static final String CommandLoginMenu                     = "LoginMenu";
	private static final String CommandSearchComplaintData           = "SearchComplaintData";
	private static final String CommandSearchDiseaseData             = "SearchDiseaseData";
	private static final String CommandSearchHealthUnitsBySpecialty  = "SearchHealthUnitsBySpecialty";
	private static final String CommandSearchSpecialtiesByHealthUnit = "SearchSpecialtiesByHealthUnit";
	private static final String CommandUpdateComplaintData           = "UpdateComplaintData";
	private static final String CommandUpdateComplaintList           = "UpdateComplaintList";
	private static final String CommandUpdateComplaintSearch         = "UpdateComplaintSearch";
	private static final String CommandUpdateEmployeeData            = "UpdateEmployeeData";
	private static final String CommandUpdateEmployeeSearch          = "UpdateEmployeeSearch";
	private static final String CommandUpdateHealthUnitData          = "UpdateHealthUnitData";
	private static final String CommandUpdateHealthUnitSearch        = "UpdateHealthUnitSearch";
	private static final String CommandUpdateHealthUnitList          = "UpdateHealthUnitList";

	after() : execution(void HWServlet.init(..)) {
		commandTable = new Hashtable();
    	registerCommand(CommandConfigRMI, new ConfigRMI());
    	registerCommand(CommandGetDataForSearchByDiseaseType, new GetDataForSearchByDiseaseType());
    	registerCommand(CommandGetDataForSearchByHealthUnit, new GetDataForSearchByHealthUnit());
   	 	registerCommand(CommandGetDataForSearchBySpeciality, new GetDataForSearchBySpeciality());
    	registerCommand(CommandInsertAnimalComplaint, new InsertAnimalComplaint());
    	registerCommand(CommandInsertEmployee, new InsertEmployee());
    	registerCommand(CommandInsertFoodComplaint, new InsertFoodComplaint());
    	registerCommand(CommandInsertSpecialComplaint, new InsertSpecialComplaint());
    	registerCommand(CommandLogin, new Login());
    	registerCommand(CommandLoginMenu, new LoginMenu());
    	registerCommand(CommandSearchComplaintData, new SearchComplaintData());
    	registerCommand(CommandSearchDiseaseData, new SearchDiseaseData());
    	registerCommand(CommandSearchHealthUnitsBySpecialty, new SearchHealthUnitsBySpecialty());
    	registerCommand(CommandSearchSpecialtiesByHealthUnit, new SearchSpecialtiesByHealthUnit());
    	registerCommand(CommandUpdateComplaintData, new UpdateComplaintData());
    	registerCommand(CommandUpdateComplaintList, new UpdateComplaintList());
    	registerCommand(CommandUpdateComplaintSearch, new UpdateComplaintSearch());
    	registerCommand(CommandUpdateEmployeeData, new UpdateEmployeeData());
    	registerCommand(CommandUpdateEmployeeSearch, new UpdateEmployeeSearch());
    	registerCommand(CommandUpdateHealthUnitData, new UpdateHealthUnitData());
    	registerCommand(CommandUpdateHealthUnitSearch, new UpdateHealthUnitSearch());
    	registerCommand(CommandUpdateHealthUnitList, new UpdateHealthUnitList());
    }
	
	/**
	 * Register this command with this key in the command table and uses it
	 * as a key to the health watcher facade in the protocol's table
	 */
	protected void registerCommand(String key, CommandServlet command) {
		commandTable.put(key, command);
    	setReceiver(Command(command), FacadeReceiver(HealthWatcherFacade.getInstance()));
	}

	/**
	 * The join points after which to execute the command. This replaces the
	 * normally scattered myCommand.execute() calls. In this example, a call to
	 * <code>Button.clicked()</code> triggers the execution of the command.
	 * 
	 * @param invoker
	 *            the object invoking the command
	 */
	protected pointcut commandTrigger(CommandInvoker invoker) :
		call(* CommandInvoker.trigger()) && target(invoker) && this(ServletCommanding);

	/**
	 * Before the execution of the servlet, create an invoker object for the operation and 
	 * register the mappings in the protocol. This is needed, because HK implementation only
	 * support a 1-1 mapping between invoker and command. Since we have only the servlet as
	 * an invoker, we need to create this objects to fake invokers.
	 * It is not needed to unregister, because the mapping uses a weak hash map which releases
	 * mappings when references are gone. 
	 */
	before(HttpServletRequest request, HttpServletResponse response) : 
		(execution(void HWServlet.doPost(HttpServletRequest, HttpServletResponse)) ||
		 execution(void HWServlet.doGet(HttpServletRequest, HttpServletResponse))) && 
		 args(request, response) && 
		 within(HWServlet) {

		String operation = (String) request.getParameter("operation");
		CommandServlet command = (CommandServlet) commandTable.get(operation);
		command.setRequest(request);
    	command.setReponse(response);
    	CommandInvoker invoker = new CommandInvoker();
		setCommand(invoker, Command(command));
		invoker.trigger();
	}
}
