/**
 * Copyright (c) 2006 Macacos.org. All Rights Reserved
 *
 * This library is free software; you can redistribute it and/or modify it under the terms of the 
 * GNU Lesser General Public License as published by the Free Software Foundation; either version 
 * 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See 
 * the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this library;
 * if not, write to the Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, 
 * MA  02110-1301  USA
 * 
 * You can find the license also here: http://www.gnu.org/copyleft/lesser.html
 * 
 * 
 * Created on Sep 18, 2006 by Thiago Tonelli Bartolomei
 * -------------------------------------------------
 *           \                                                                           
 *            \                                                                          
 *               __                                                                      
 *          w  c(..)o                                                                    
 *           \__(o)                                                                      
 *               /\                                                                      
 *            w_/(_)-~                                                                   
 *                /|                                                                     
 *               | \                                                                     
 *               m  m   
 */
package healthwatcher.aspects.distribution;

import healthwatcher.business.HealthWatcherFacade;
import healthwatcher.business.HealthWatcherServer;

import java.rmi.server.UnicastRemoteObject;
import org.caesarj.runtime.rmi.*;

/**
 * TODO - describe this file
 * 
 * @author Thiago Tonelli Bartolomei <thiago.bartolomei@gmail.com>
 */
public deployed cclass HWServerDistribution {

	/**
	 * Publishes the server when it starts
	 */
	void around(): execution(static void HealthWatcherServer.main(String[])) {
		try {
			System.out.println("Creating RMI server...");
			CaesarHost host = new CaesarHost(healthwatcher.Constants.SERVER_NAME);
			System.out.println("Object exported");
			System.out.println(healthwatcher.Constants.SYSTEM_NAME);
			host.publish(healthwatcher.Constants.SYSTEM_NAME, HealthWatcherFacade.getInstance());
			System.out.println("Server created and ready.");
		} catch (CaesarRemoteException rmiEx) {
			rmiFacadeExceptionHandling(rmiEx);
		}
	}

	private void rmiFacadeExceptionHandling(Throwable exception) {
		System.out.println("**************************************************");
		System.out.println("* Error during server initialization!            *");
		System.out.println("* The exception message is:                      *");
		System.out.println("      " + exception.getMessage());
		System.out.println("* You may have to restart the server or registry.*");
		System.out.println("**************************************************");
		exception.printStackTrace();
	}
}
