/**
 * Copyright (c) 2006 Macacos.org. All Rights Reserved
 *
 * This library is free software; you can redistribute it and/or modify it under the terms of the 
 * GNU Lesser General Public License as published by the Free Software Foundation; either version 
 * 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See 
 * the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this library;
 * if not, write to the Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, 
 * MA  02110-1301  USA
 * 
 * You can find the license also here: http://www.gnu.org/copyleft/lesser.html
 * 
 * 
 * Created on Sep 18, 2006 by Thiago Tonelli Bartolomei
 * -------------------------------------------------
 *           \                                                                           
 *            \                                                                          
 *               __                                                                      
 *          w  c(..)o                                                                    
 *           \__(o)                                                                      
 *               /\                                                                      
 *            w_/(_)-~                                                                   
 *                /|                                                                     
 *               | \                                                                     
 *               m  m   
 */
package healthwatcher.aspects.distribution;

import healthwatcher.business.*;
import healthwatcher.view.command.*;
import healthwatcher.view.servlets.*;
import healthwatcher.view.*;

import java.rmi.Remote;
import java.rmi.RemoteException;

import lib.distribution.rmi.IteratorRMISourceAdapter;
import lib.distribution.rmi.IteratorRMITargetAdapter;
import lib.distribution.rmi.MethodExecutor;
import lib.util.LocalIterator;

/**
 * TODO - describe this file
 * 
 * @author Thiago Tonelli Bartolomei <thiago.bartolomei@gmail.com>
 */
public deployed cclass HWClientDistribution {

	// Makes soft the communication exceptions in the clients
	//declare soft : CommunicationException : call(* IteratorDsk+.*(..));
	
	// Makes soft remote exceptions raised in this aspect
	//declare soft : RemoteException : within(HWClientDistribution+);
	
	/**
	 * Keeps the remote instance
	 */
	protected HealthWatcherFacade facade = null;
    
	/**
     * Returns null so that the client cannot really use a facade
     */
	/*
	 * This advice is cosmetic, but helps to find errors
	 *
	Object around() : call(static * HealthWatcherFacade.getInstance()) && this(HWServlet+) {
		return null;
    }*/
	
    /**
     * Redirects the facade methods call to the distributed instance methods using reflection
     */
	Object around() : call(* IFacade+.*(..)) && ! call(static * *.*(..)) && this(CommandServlet)  {
	    Object obj = MethodExecutor.invoke(
	    	getRemoteFacade(), thisJoinPoint.getSignature().getName(), thisJoinPoint.getArgs());
	    if (obj instanceof LocalIterator) {
	    	try {
	    		IteratorRMITargetAdapter iteratorTA = new IteratorRMITargetAdapter((LocalIterator) obj, 3);
	    		return new IteratorRMISourceAdapter(iteratorTA, (LocalIterator) obj, 3);
	    	} catch (RemoteException e) {
	    		throw new RuntimeException(e);
	    	}
	    }
	    return obj;
    }
    
    /**
     * Retrieves the remote instance, creating if needed
     */
	private synchronized HealthWatcherFacade getRemoteFacade() {        
		if (facade == null) {
			try {
	            System.out.println("About to lookup...");
	            facade = (HealthWatcherFacade) java.rmi.Naming.lookup("//" + healthwatcher.Constants.SERVER_NAME + "/" + healthwatcher.Constants.SYSTEM_NAME);
	            System.out.println("Remote DisqueSaude found");
	        } catch (java.rmi.RemoteException rmiEx) {
	            rmiInitExceptionHandling(rmiEx);
	        } catch (java.rmi.NotBoundException rmiEx) {
	            rmiInitExceptionHandling(rmiEx);
	        } catch (java.net.MalformedURLException rmiEx) {
	            rmiInitExceptionHandling(rmiEx);
	        }
		}
		return facade;
    }
	
    protected void rmiInitExceptionHandling(Throwable exception) {
    	String error =  "<p>****************************************************<br>" +
                 "Error during servlet initialization!<br>" +
                 "The exception message is:<br><dd>" + exception.getMessage() +
                 "<p>You may have to restart the servlet container.<br>" +
                 "*******************************************************";
        System.out.println(error);
    }
}
