/**
 * Copyright (c) 2006 Macacos.org. All Rights Reserved
 *
 * This library is free software; you can redistribute it and/or modify it under the terms of the 
 * GNU Lesser General Public License as published by the Free Software Foundation; either version 
 * 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See 
 * the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this library;
 * if not, write to the Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, 
 * MA  02110-1301  USA
 * 
 * You can find the license also here: http://www.gnu.org/copyleft/lesser.html
 * 
 * 
 * Created on Sep 15, 2006 by Thiago Tonelli Bartolomei
 * -------------------------------------------------
 *           \                                                                           
 *            \                                                                          
 *               __                                                                      
 *          w  c(..)o                                                                    
 *           \__(o)                                                                      
 *               /\                                                                      
 *            w_/(_)-~                                                                   
 *                /|                                                                     
 *               | \                                                                     
 *               m  m   
 */
package healthwatcher.aspects.concurrency;

import healthwatcher.data.rdb.ComplaintRepositoryRDB;
import healthwatcher.model.complaint.Complaint;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import lib.exceptions.ExceptionMessages;
import lib.exceptions.ObjectNotFoundException;
import lib.exceptions.PersistenceMechanismException;
import lib.exceptions.RepositoryException;
import lib.persistence.PersistenceMechanism;

import org.caesarj.runtime.rmi.*;

import java.util.*;

/**
 * TODO - describe this file
 * 
 * @author Thiago Tonelli Bartolomei <thiago.bartolomei@gmail.com>
 */
public deployed cclass HWTimestamp {

	// Declares the fields and methods necessary for timestamps in Complaints
	public cclass TimestampRecord {
		
		private long timestamp;
		
		public TimestampRecord(long timestamp) {
			this.timestamp = timestamp;
		}
		
		public long getTimestamp() {
			return timestamp;
		}
	}
	
	protected static Map records = new Hashtable();
	
	// After inserting, update the DB
	after(Complaint complaint) : execution(* ComplaintRepositoryRDB.insert(Complaint)) && args(complaint) {
		updateTimestamp("0", "SCBS_queixa", complaint.getCodigo() + "");
	}
	
	// After searching, load from the DB
	after() returning(Complaint complaint) : execution(* ComplaintRepositoryRDB.search(int)) {
		long timestamp = searchTimestamp("SCBS_queixa", complaint.getCodigo() + "");
		records.put(complaint.getCodigo() + "", new TimestampRecord(timestamp));
	}
	
	// When updating, check the TS before and update DB after
	void around (Complaint complaint, ComplaintRepositoryRDB repository) : 
		 execution(* ComplaintRepositoryRDB.update(Complaint)) && args(complaint) && this(repository){

		synchronized (this) {
			String sql = null;
			TimestampRecord record = (TimestampRecord) records.get(complaint.getCodigo() + "");
			// This prevents 2 different clients from accessing at the same time 
			if (record == null) {
				throw new RepositoryException(
						ExceptionMessages.EXC_FALHA_ATUALIZACAO_COPIA);
			}
			try {
				long timestamp;
				Statement stmt = (Statement) PersistenceMechanism.getInstance().getCommunicationChannel();
				// vendo se a verso do objeto  a mesma no BD
				sql = "select ts from SCBS_queixa " + " where codigo='"
						+ complaint.getCodigo() + "'";
				ResultSet resultSet = stmt.executeQuery(sql);
				if (resultSet.next()) {
					timestamp = (new Long(resultSet.getString("ts"))).longValue();
					if (timestamp != record.getTimestamp()) {
							throw new RepositoryException(
								ExceptionMessages.EXC_FALHA_ATUALIZACAO_COPIA);
					}
				} else {
					throw new RuntimeException(new ObjectNotFoundException(
						ExceptionMessages.EXC_FALHA_ATUALIZACAO));
				}
				resultSet.close();
				stmt.close();
			} catch (SQLException e) {
				System.out.println(sql);
					new RepositoryException(ExceptionMessages.EXC_FALHA_BD);
			} catch (PersistenceMechanismException e) {
					new RepositoryException(ExceptionMessages.EXC_FALHA_ATUALIZACAO);
			}
		
			proceed(complaint, repository);
		
			updateTimestamp((record.getTimestamp() + 1 ) + "", "SCBS_queixa", complaint.getCodigo()
					+ "");
			records.remove(record);
		}
	}
	
	// Auxiliary Methods
	private void updateTimestamp(String value, String tableName, String id) {
		Statement stmt = null;
		int result = 0;
		try {
			String sql = "update " + tableName + " set ts='" + value + "' where codigo='" + id
					+ "'";
			stmt = (Statement) PersistenceMechanism.getInstance().getCommunicationChannel();
			result = stmt.executeUpdate(sql);
			if (result == 0) {
				throw new RuntimeException("ERRO no aspecto TimestampAspectHealthWatcher ##2");
			}
		} catch (Exception ex) {

			ex.printStackTrace();
			throw new RuntimeException(ex);
		} finally {
			try {
				if (stmt != null)
					stmt.close();
			} catch (Exception ex) {
				throw new RuntimeException(ex);
			}
		}
	}

	private long searchTimestamp(String tableName, String id) {
		Statement stmt = null;
		ResultSet resultSet = null;
		long answer = 0;
		try {
			String sql = "SELECT ts FROM " + tableName + " WHERE codigo='" + id + "'";

			PersistenceMechanism pm = PersistenceMechanism.getInstance();
			stmt = (Statement) pm.getCommunicationChannel();
			resultSet = stmt.executeQuery(sql);
			if (resultSet.next()) {
				answer = resultSet.getLong(1);
			} else {
				throw new RuntimeException("ERRO no aspecto TimestampAspectHealthWatcher ##2");
			}
			return answer;
		} catch (Exception ex) {
			ex.printStackTrace();
			throw new RuntimeException(ex);
		} finally {
			try {
				if (resultSet != null)
					resultSet.close();
				if (stmt != null)
					stmt.close();
			} catch (Exception ex) {
				throw new RuntimeException(ex);
			}
		}
	}

}
