/**
 * Copyright (c) 2006 Macacos.org. All Rights Reserved
 *
 * This library is free software; you can redistribute it and/or modify it under the terms of the 
 * GNU Lesser General Public License as published by the Free Software Foundation; either version 
 * 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See 
 * the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this library;
 * if not, write to the Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, 
 * MA  02110-1301  USA
 * 
 * You can find the license also here: http://www.gnu.org/copyleft/lesser.html
 * 
 * 
 * Created on Sep 15, 2006 by Thiago Tonelli Bartolomei
 * -------------------------------------------------
 *           \                                                                           
 *            \                                                                          
 *               __                                                                      
 *          w  c(..)o                                                                    
 *           \__(o)                                                                      
 *               /\                                                                      
 *            w_/(_)-~                                                                   
 *                /|                                                                     
 *               | \                                                                     
 *               m  m   
 */
package healthwatcher.aspects.concurrency;

import healthwatcher.model.employee.Employee;
import healthwatcher.business.employee.*;
import lib.concurrency.ConcurrencyManager;


/**
 * TODO - describe this file
 * 
 * @author Thiago Tonelli Bartolomei <thiago.bartolomei@gmail.com>
 */
public deployed cclass HWManagedSynchronization {

	private ConcurrencyManager manager = new ConcurrencyManager();
	
	public pointcut synchronizationPoints(Employee employee) :
		execution(* EmployeeRecord.insert(Employee)) && args(employee);
	
	before(Employee employee) : synchronizationPoints(employee) {
		manager.beginExecution(employee.getLogin());
	}
	
	after(Employee employee) : synchronizationPoints(employee) {
		manager.endExecution(employee.getLogin());
	}
}
