/*
 * Created on Oct 29, 2004
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package applet;

import java.awt.HeadlessException;

import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

import contas.Conta;
import contas.ContaJaCadastradaException;
import contas.ContaNaoEncontradaException;
import contas.RepositorioContasArray;
import fachada.Banco;
/**
 * @author Sergio
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class AppletBanco extends JApplet {

	private Banco banco;
	
	private javax.swing.JPanel jContentPane = null;

	private JTextField tf_numero = null;
	private JTextField tf_valor = null;
	private JButton bt_debitar = null;
	private JButton bt_creditar = null;
	private JButton bt_cadastrar = null;
	private JButton bt_remover = null;
	private JButton bt_saldo = null;
	/**
	 * @throws java.awt.HeadlessException
	 */
	public AppletBanco() throws HeadlessException {
		super();
		banco = new Banco(new RepositorioContasArray());		
		init();
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	public void init() {
		this.setSize(300,200);
		this.setContentPane(getJContentPane());
	}
	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private javax.swing.JPanel getJContentPane() {
		if(jContentPane == null) {
			javax.swing.JLabel lb_title = new JLabel();
			javax.swing.JLabel jLabel1 = new JLabel();
			javax.swing.JLabel jLabel = new JLabel();
			jContentPane = new javax.swing.JPanel();
			jContentPane.setLayout(null);
			lb_title.setBounds(63, 14, 178, 23);
			lb_title.setText("Applet Banco");
			lb_title.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
			jLabel.setBounds(17, 48, 56, 27);
			jLabel.setText("Nmero:");
			jLabel1.setBounds(16, 80, 59, 26);
			jLabel1.setText("Valor:");
			jContentPane.add(lb_title, null);
			jContentPane.add(jLabel, null);
			jContentPane.add(jLabel1, null);
			jContentPane.add(getJTextField(), null);
			jContentPane.add(getJTextField2(), null);
			jContentPane.add(getJButton(), null);
			jContentPane.add(getJButton2(), null);
			jContentPane.add(getJButton3(), null);
			jContentPane.add(getJButton1(), null);
			jContentPane.add(getJButton22(), null);
		}
		return jContentPane;
	}
	/**
	 * This method initializes jTextField	
	 * 	
	 * @return javax.swing.JTextField	
	 */    
	private JTextField getJTextField() {
		if (tf_numero == null) {
			tf_numero = new JTextField();
			tf_numero.setBounds(90, 48, 90, 26);
		}
		return tf_numero;
	}
	/**
	 * This method initializes jTextField	
	 * 	
	 * @return javax.swing.JTextField	
	 */    
	private JTextField getJTextField2() {
		if (tf_valor == null) {
			tf_valor = new JTextField();
			tf_valor.setBounds(91, 81, 88, 24);
		}
		return tf_valor;
	}
	/**
	 * This method initializes jButton	
	 * 	
	 * @return javax.swing.JButton	
	 */    
	private JButton getJButton() {
		if (bt_debitar == null) {
			bt_debitar = new JButton();
			bt_debitar.setBounds(197, 47, 86, 25);
			bt_debitar.setText("Debitar");
			bt_debitar.setEnabled(false);
		}
		return bt_debitar;
	}
	/**
	 * This method initializes jButton	
	 * 	
	 * @return javax.swing.JButton	
	 */    
	private JButton getJButton2() {
		if (bt_creditar == null) {
			bt_creditar = new JButton();
			bt_creditar.setBounds(197, 79, 86, 25);
			bt_creditar.setText("Creditar");
			bt_creditar.addActionListener(new java.awt.event.ActionListener() { 
				public void actionPerformed(java.awt.event.ActionEvent e) {    
					creditar();
				}

			});
		}
		return bt_creditar;
	}
	/**
	 * This method initializes jButton	
	 * 	
	 * @return javax.swing.JButton	
	 */    
	private JButton getJButton3() {
		if (bt_cadastrar == null) {
			bt_cadastrar = new JButton();
			bt_cadastrar.setBounds(10, 111, 93, 25);
			bt_cadastrar.setText("Cadastrar");
			bt_cadastrar.addActionListener(new java.awt.event.ActionListener() { 
				public void actionPerformed(java.awt.event.ActionEvent e) {    
					cadastrarConta();				
				}				
			});
		}
		return bt_cadastrar;
	}
	/**
	 * This method initializes jButton1	
	 * 	
	 * @return javax.swing.JButton	
	 */    
	private JButton getJButton1() {
		if (bt_remover == null) {
			bt_remover = new JButton();
			bt_remover.setBounds(106, 111, 86, 25);
			bt_remover.setText("Remover");
			bt_remover.setEnabled(false);
		}
		return bt_remover;
	}
	/**
	 * This method initializes jButton2	
	 * 	
	 * @return javax.swing.JButton	
	 */    
	private JButton getJButton22() {
		if (bt_saldo == null) {
			bt_saldo = new JButton();
			bt_saldo.setBounds(197, 111, 86, 25);
			bt_saldo.setText("Saldo");
			bt_saldo.addActionListener(new java.awt.event.ActionListener() { 
				public void actionPerformed(java.awt.event.ActionEvent e) {    
					saldo();
				}
			});
		}
		return bt_saldo;
	}
	
	private void saldo() {
		String numero = tf_numero.getText();
		if (numero.equals("")) {
			JOptionPane.showMessageDialog(this, "Informe o nmero da conta.");
		} else {
			try {
				double saldo = banco.saldo(numero);
				JOptionPane.showMessageDialog(this, "Saldo da conta "+numero+" = "+saldo);			
			} catch (ContaNaoEncontradaException cnee) {
				JOptionPane.showMessageDialog(this, "Conta " + numero + " nao existe!");
			} finally {
				tf_numero.setText("");
				tf_valor.setText("");
			}
		}
	}
		
	private void cadastrarConta() {		
		String numero = this.tf_numero.getText();
		String valorStr = tf_valor.getText();
		if (valorStr.equals(""))
			valorStr = "0.0";
		if (numero.equals("")) {
			JOptionPane.showMessageDialog(this, "Informe o nmero da conta.");
		} else {
			try {
				double saldo = new Double(valorStr).doubleValue();
				Conta nova = new Conta(numero, saldo);
				banco.cadastrar(nova);
				JOptionPane.showMessageDialog(this, "Cadastro executado com sucesso!");			
			} catch (ContaJaCadastradaException cee) {
				JOptionPane.showMessageDialog(this, "Conta " + numero + " ja existe!");
			} catch (NumberFormatException cee) {
				JOptionPane.showMessageDialog(this, "Digite um nmero!");
			} catch (IllegalArgumentException iae) {
				JOptionPane.showMessageDialog(this, "Entre em contato com o operador do sistema!");
			} finally {
				tf_numero.setText("");
				tf_valor.setText("");
			}
		}
	}
	private void creditar() {
		String numero = this.tf_numero.getText();
		String valorStr = tf_valor.getText();
		if (numero.equals("")) {
			JOptionPane.showMessageDialog(this, "Informe o nmero da conta.");
		} else if (valorStr.equals("")) {
			JOptionPane.showMessageDialog(this, "Informe o valor a ser creditado.");
		} else {
			try {
				double valor = new Double(valorStr).doubleValue();
				banco.creditar(numero, valor);
				JOptionPane.showMessageDialog(this, "Crdito executado com sucesso!");				
			} catch (ContaNaoEncontradaException cnee) {
				JOptionPane.showMessageDialog(this, "Conta " + numero + " nao existe!");
			} catch (NumberFormatException cee) {
				JOptionPane.showMessageDialog(this, "Digite um nmero!");
			} finally {
				tf_numero.setText("");
				tf_valor.setText("");
			}
		} 
	}	
}
