#include <process.h>
#include <windows.h>

//renomeando tipo da API do Windows para algo mais compreensivel
typedef _cdecl EnderecoFuncao;

//Definindo uma estrutura Thread para reuso
typedef struct thread{
    
    //um identificador para o Thread
    char* nome;
    
    //a funcao que dever ser executada pelo Thread
    EnderecoFuncao* run;
    
    //um manipulador para o Thread
    //Utilizado, por exemplo, para saber se o Thread ainda est vivo
    HANDLE handle;

} Thread;

//Construtor do Thread
Thread* newThread(char* nome, EnderecoFuncao* funcaoThread);

//funcao start inicia a execuo do Thread em paralelo com a execuo atual
void start(Thread* t, void* parametros);

//funcao faz o Thread atual dormir por no mnimo tempoEmMiliSegundos
void sleep(int tempoEmMiliSegundos);

//Faz a Thread atual aguardar pela concluso do Thread t
void join(Thread* t);

//Faz o Thread atual abidicar pela sua parcela atual de tempo na CPU
void yield();
