#include "Thread.h"

Thread* newThread(char* nome, EnderecoFuncao* funcaoThread){
    Thread* retorno = (Thread*)malloc(sizeof(Thread));
    int tamanhoNome = strlen(nome);    
    
    //apontando para a funcao
    retorno->run = funcaoThread;
    
    //copiando atributos    
    retorno->nome = (char*)malloc(sizeof(char)*tamanhoNome);
    strcpy(retorno->nome,nome);
    
    return retorno;
}

void start(Thread* t, void* parametros){
    EnderecoFuncao* funcao = ((Thread*)t)->run;
    HANDLE handle = CreateThread(NULL,0, funcao, parametros,0,NULL);
    t->handle = handle;
}

void sleep(int tempoEmMiliSegundos){
    //escondendo a API do windows
    Sleep(tempoEmMiliSegundos);
}

void yield(){
    Sleep(0);
}

void join(Thread* t){
    HANDLE handle = t->handle;
    LPDWORD exitCode;
    
    GetExitCodeThread(handle,&exitCode);
    while(exitCode==STILL_ACTIVE){
           yield();
           GetExitCodeThread(handle,&exitCode);
    }
}
