;///////////////////////////////////////////////////////////////////////////////
; Macro     : EscreverArquivo
; Descrio : Escreve uma string no arquivo especificado
;///////////////////////////////////////////////////////////////////////////////
EscreverArquivo MACRO file, buffer, nbytes

PUSH AX
PUSH BX
PUSH CX
PUSH DX

  MOV AH, 40h                  ; servio para escrever no arquivo
  MOV BX, file                 ; file handle do arquivo
  MOV CX, nbytes               ; tamanho da string a escrever
  LEA DX, buffer               ;move o segmento do buffer para o DS
                               ; string para ser escrita no arquivo
  INT 21h                      ; executa a escrita

POP DX
POP CX
POP BX
POP AX
ENDM

;///////////////////////////////////////////////////////////////////////////////
; Macro     : CriarArquivo
; Descrio : Cria o arquivo especificado
;///////////////////////////////////////////////////////////////////////////////
LimpaArquivo MACRO nome_arquivo

PUSH AX
PUSH BX
PUSH CX
PUSH DX

  LEA DX, nome_arquivo         ; pega o nome do arquivo
  MOV AH, 3Ch                  ; servio para a criao de arquivo
  MOV CX, 00h                  ; arquivo comum
  INT 21h                      ; cria o arquivo
  mov ArqHandle, ax

POP DX
POP CX
POP BX
POP AX
ENDM


EscreveNoArquivo proc near

      LimpaArquivo ArqScore
      EscreverArquivo ArqHandle, ScName1, Arqtam

ret
EscreveNoArquivo endp


;****************************************************************************************************************
; Funo DesenharFrase
;
; Desenha uma frase na tela. A frase deve acabar com um byte 0.
; Se a frase contiver $ haver uma quebra de linha e um retorno de carro
;
; Parmetros:
; DS:SI - ponteiro para o incio da frase
; DH - Cor para desenhar
; DI, CL - posio (X, Y) para desenhar
;****************************************************************************************************************
DesenharFrase		PROC NEAR

                        push di
                        push bx
                        mov bx, di

LerLetra:
         ;  cmp podeSair, 1
         ;     jne nsair
           ;   cmp sair_hist, 1
         ;     je FraseVoltar
           nsair:
           lodsb		; ler uma letra
			cmp al, 0	; byte 0 indica o fim da frase
			je FraseVoltar
			cmp al, ' '     ; detectado um espao na frase
			je DarEspaco	; pular o desenho da letra
			                ; e dar soh o espao
                        cmp  al, '$'
                        je PularLinha
			call DesenharLetra
			;jc LerLetra	; se o flag de carry estiver ligado,
			                ; algum simbolo no suportado foi
			                ; encontrado, pular ele
DarEspaco:
                        add di, 6
			jmp LerLetra

PularLinha:
                        add cl,10
                        mov di, bx
                        jmp LerLetra

FraseVoltar:
                        pop bx
                        pop di

                        RET

DesenharFrase		ENDP
;-------------------------------------------------------------------------------
; Fim da Funo DesenharFrase
;-------------------------------------------------------------------------------

;****************************************************************************************************************
; Funcao DesenharLetra
;
; Desenha uma letra na tela
;
; Parmetros:
; AL - Letra para Desenhar (codigo ascii)
; DH - Cor para desenhar
; DI, CL - Localizacao (X, Y)
;
; Retorno:
; Flag de carry ser ativado se a funo no terminar corretamente (cdigo
; passado no  uma letra)
;
; Observaes:
; Se o codigo especificado no for de uma letra valida, nada ser desenhado.
;****************************************************************************************************************
DesenharLetra		PROC NEAR

                        push bx
                        push ds
                        push si
                        push ax

			stc
			mov bx, ax
			mov ax, seg Letras
			mov ds, ax
			LEA si, Letras	; colocar o ponteiro no inicio dos sprites de letras
			mov ax, bx
                        cmp al, ','
                        je Virgula
                        cmp al, '-'
                        je Traco
                        cmp al, '!'
                        je Exclamacao
                        cmp al, '.'
                        je Ponto
                        cmp al, '?'
                        je Interrogacao
                        cmp al, ''
                        je a_agudo
                        cmp al, ''
                        je a_vovo
                        cmp al, ''
                        je a_til
                        cmp al, ''
                        je a_til
                        cmp al, ':'
                        je DoisPontos
                        cmp al, ''
                        je i_agudo
                        cmp al, ''
                        je e_agudo
                        cmp al, ''
                        je e_vovo
                        cmp al, ''
                        je e_vovo
                        cmp al, ''
                        je cedilha
                        cmp al, ''
                        je cedilha
                        cmp al, 20h
                        je espaco_
                       	cmp al, '0'
                       	je numero0
                       	cmp al, '1'
                       	je numero1
                       	cmp al, '2'
                       	je numero2
                       	cmp al, '3'
                       	je numero3
                       	cmp al, '4'
                       	je numero4
                       	cmp al, '5'
                       	je numero5
                       	cmp al, '6'
                       	je numero6
                       	cmp al, '7'
                       	je numero7
                       	cmp al, '8'
                       	je numero8
                       	cmp al, '9'
                       	je numero9
                       	cmp al, '('
                       	je parDir
                       	cmp al, ')'
                       	je parEsq
                       	cmp al, '/'
                       	je barra
       		stc
            test al, 20h	; verificar letra minuscula
			jz maiuscula
			add si, 260	; pular para o 'a' minusculo
			and al, 0dfh	; desativar o bit de minuscula
maiuscula:
                        cmp al, 'A'
			jb DesenharLetraRet
			cmp al, 'Z'
			jg DesenharLetraRet
			sub al, 'A'	; retirar o codigo ascii
			xor ah, ah	; multiplicar por 10 (numero de bytes
			shl ax, 1	; por sprite de letra)
			mov bx, ax	;
			shl ax, 1	;
			shl ax, 1	; multiplicacao terminada
			add bx, ax
			add si, bx	; agora esta na letra (sprite) certa
			push di
			mov al, cl	; conversao de parametros - al esta com a posicao Y
			push cx
			mov ah, 6	; numero de colunas
			mov dl, 10	; numero de linhas
			call DesenharSprite
			pop cx
			pop di
			clc


DesenharLetraRet:
                        cmp al, '-'
                        je Virgula
                        jmp FinalR
Virgula:
			add si, 520	; agora esta na letra (sprite) certa
			mov al, cl	; conversao de parametros - al esta com a posicao Y
			mov ah, 6	; numero de colunas
			mov dl, 10	; numero de linhas
			call DesenharSprite
                        jmp FinalR
Traco:
                        add si, 560	; agora esta na letra (sprite) certa
			mov al, cl	; conversao de parametros - al esta com a posicao Y
			mov ah, 6	; numero de colunas
			mov dl, 10	; numero de linhas
			call DesenharSprite
                        jmp FinalR

Exclamacao:
                        add si, 550	; agora esta na letra (sprite) certa
			mov al, cl	; conversao de parametros - al esta com a posicao Y
			mov ah, 6	; numero de colunas
			mov dl, 10	; numero de linhas
			call DesenharSprite
                        jmp FinalR
Ponto:
                        add si, 570	; agora esta na letra (sprite) certa
                        jmp Economiza
Interrogacao:
                        add si, 530	; agora esta na letra (sprite) certa
                        jmp Economiza
DoisPontos:
                        add si, 540	; agora esta na letra (sprite) certa
                        jmp Economiza
a_agudo:
                        add si, 580	; agora esta na letra (sprite) certa
                        jmp Economiza
a_til:
                        add si, 590	; agora esta na letra (sprite) certa
                        jmp Economiza
a_vovo:
                        add si, 600     ; agora esta na letra (sprite) certa
                        jmp Economiza
i_agudo:
                        add si, 610     ; agora esta na letra (sprite) certa
                        jmp Economiza
cedilha:
                        add si, 620     ; agora esta na letra (sprite) certa
                        jmp Economiza
e_agudo:
                        add si, 630     ; agora esta na letra (sprite) certa
                        jmp Economiza
e_vovo:
                        add si, 640     ; agora esta na letra (sprite) certa
                        jmp Economiza
espaco_:
                        add si, 650     ; agora esta na letra (sprite) certa
                        jmp Economiza

numero0:
                        add si, 660     ; agora esta na letra (sprite) certa
                        jmp Economiza

numero1:
                        add si, 670     ; agora esta na letra (sprite) certa
                        jmp Economiza

numero2:
                        add si, 680     ; agora esta na letra (sprite) certa
                        jmp Economiza
numero3:
                        add si, 690     ; agora esta na letra (sprite) certa
                        jmp Economiza
numero4:
                        add si, 700     ; agora esta na letra (sprite) certa
                        jmp Economiza
numero5:
                        add si, 710     ; agora esta na letra (sprite) certa
                        jmp Economiza

numero6:
                        add si, 720     ; agora esta na letra (sprite) certa
                        jmp Economiza

numero7:
                        add si, 730     ; agora esta na letra (sprite) certa
                        jmp Economiza
numero8:
                        add si, 740     ; agora esta na letra (sprite) certa
                        jmp Economiza
numero9:
                        add si, 750     ; agora esta na letra (sprite) certa
                        jmp Economiza

parDir:
                        add si, 760     ; agora esta na letra (sprite) certa
                        jmp Economiza
parEsq:
                        add si, 770     ; agora esta na letra (sprite) certa
                        jmp Economiza
barra:
                        add si, 780     ; agora esta na letra (sprite) certa
                        jmp Economiza


Economiza:
          		mov al, cl	; conversao de parametros - al esta com a posicao Y
			mov ah, 6	; numero de colunas
			mov dl, 10	; numero de linhas
			call DesenharSprite
                        jmp FinalR
FinalR:
                        pop ax
			pop si
			pop ds
			pop bx

                        RET

DesenharLetra		ENDP

;-------------------------------------------------------------------------------
; Fim Da Funcao DesenharLetra
;-------------------------------------------------------------------------------

;****************************************************************************************************************
; Funcao Desenhar Sprite
;
; Desenha um Sprite qualquer na tela
;
; Parmetros:
; DS:SI tem que apontar para o inicio dos desenhos do sprite
; DL - Numero de Linhas
; AH - Numero de Colunas
; DH - Cor para desenhar
; DI, AL - Localizacao (X, Y) (320x240)
;****************************************************************************************************************
DesenharSprite		PROC NEAR


              altera:
                        push cx
                        push ax
                        push bx
                        push di
                        push es
                        push si
                        push dx

           ; Calcular Posicao e Colocar em DI
			mov ch, ah	; ch agora esta com o numero de colunas
			mov AH,0
			SHL AX,1	; esses shifts todos multiplicam o ax
			SHL AX,1	; por 320, ou seja, calculam o valor na
			SHL AX,1	; memoria de video do inicio da linha
			SHL AX,1	;
			SHL AX,1	;
			SHL AX,1	;
			mov BX, AX
			SHL AX,1	;
			SHL AX,1	;
			add BX, AX	; somar com o DI (X) para ter o endereco
			add DI, BX	; correto
			mov AX,	0a000h  ; inicio da memoria de video
			mov ES, AX
			mov ah, ch	; ah fica como "constante"
			mov ch, 0
;Desenhar Linha a Linha			; para poder usar o ch como contador
DesenharLinha:		mov bh, ah	; bh tem o numero de colunas restantes
DesenharByte:		LODSB 		; AL contem a linha a ser desenhada
			mov bl, al	; preciso usar o al para enviar para o video
			mov al, dh	;
			cmp bh, 8
			jg ColunaDemais
ColunaDemenos:
		mov cl, bh
            jmp DesenharGrupo

ColunaDemais:
           mov cl, 8
DesenharGrupo:
		sub bh, cl
DesenharBit:
		test bl, 80h	; testar o bit mais significativo
			jz NaoDesenhar	; nao desenhar se o bit for 0
			stosb		; store byte
			jmp Desenhado	; pular o eskema do 0 (DI jah incrementado)
NaoDesenhar:
		inc DI		; stosb nao foi executado, passar para o proximo pixel
Desenhado:
		shl bl, 1	; deslocar o bl para o proximo bit
			loop DesenharBit; passar para o proximo bit
			cmp bh, 0
			jnz DesenharByte
			add di, 320	; posicionar para a proxima linha
			mov al, ah
			mov ah, 0
			sub di, ax	; posicionamento concluido
			mov ah, al
			dec dl
			jnz DesenharLinha; repetir ateh acabar as linhas
                                                ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
                        push cx
                        mov cx, 850
                        awq:
                        ;call atraso
                        loop awq

                        pop cx

                        pop dx
                        pop si
                        pop es
                        pop di
                        pop bx
                        pop ax
                        pop cx

			RET

DesenharSprite		ENDP

;-------------------------------------------------------------------------------
; Fim Da Funcao DesenharSprite
;-------------------------------------------------------------------------------

;****************************************************************************************************************
; Funcao DesenharNumero
;
; Desenha um numero com base decimal em um ponto da tela.
;
; Parmetros:
; BH - Digito mais significativo
; BL
; CH
; CL
; DL - Digito menos signiticativo
; DH - Cor para desenhar
; DI, AH - Localizacao (X, Y) (320x240)
;****************************************************************************************************************
DesenharNumero          PROC NEAR

                        push ax
                        push cx

                        mov al, bh
                        push cx
                        mov cl, ah
                        call DesenharDigito
                        pop cx
                        add di, 7
                        mov al, bl
                        push cx
                        mov cl, ah
                        call DesenharDigito
                        pop cx
                        add di, 7
                        mov al, ch
                        push cx
                        mov cl, ah
                        call DesenharDigito
                        pop cx
                        add di, 7
                        mov al, cl
                        mov cl, ah
                        call DesenharDigito
                        add di, 7
                        mov al, dl
                        mov cl, ah
                        call DesenharDigito

                        pop cx
                        pop ax
                        RET

DesenharNumero          ENDP
;-------------------------------------------------------------------------------
; Fim da Funcao DesenharNumero
;-------------------------------------------------------------------------------

;****************************************************************************************************************
; Funcao DesenharDigito
;
; AL - Numero para Desenhar
; DH - Cor para desenhar
; DI, CL - Localizacao (X, Y)
;
; Retorno:
; Flag de carry ser ativado se a funo no terminar corretamente (cdigo
; passado no  uma letra)
;
; Observaes:
; Se o codigo especificado no for de uma letra valida, nada ser desenhado.
;****************************************************************************************************************
DesenharDigito		PROC NEAR

                        push bx
                        push ds
                        push si
                        push ax
                        push dx

			stc
			mov si, seg Letras
			mov ds, si
			LEA si, Numeros	; colocar o ponteiro no inicio dos sprites de numeros
                        cmp al, 10
                        jg DesenharDigitoRet
			xor ah, ah	; multiplicar por 8
			mov bx, ax
			shl ax, 3	;
			sub ax, bx      ; diminuir o numero (resultado: ax = ax * 7)
			add si, ax	; agora esta no numero (sprite) certo
			push di
			mov al, cl	; conversao de parametros - al esta com a posicao Y
			push cx
			mov ah, 6	; numero de colunas
			mov dl, 7	; numero de linhas
			call DesenharSprite
			pop cx
			pop di
			clc


DesenharDigitoRet:      pop dx
			pop ax
			pop si
			pop ds
			pop bx

                        RET

DesenharDigito          ENDP

;-------------------------------------------------------------------------------
; Fim da Funcao DesenharDigito
;-------------------------------------------------------------------------------


;****************************************************************************************************************
; Funcao ConverterDecimal
;
; Parmetros:
; AX - contem o numero
;
; Retorno :
;
; BH - mais significativo
; BL
; CH
; CL
; DL - menos significativo
;
;****************************************************************************************************************
ConverterDecimal	PROC NEAR

                        push ax
                        push di

                        xor dx, dx
                        mov di, 10000
                        div di
                        mov bh, al        ; Quociente
                        mov ax, dx        ; Resto

                        xor dx, dx
                        mov di, 1000
                        div di
                        mov bl, al        ; Quociente
                        mov ax, dx        ; Resto

                        xor dx, dx
                        mov di, 100
                        div di
                        mov ch, al        ; Quociente
                        mov ax, dx        ; Resto

                        xor dx, dx
                        mov di, 10
                        div di
                        mov cl, al        ; Quociente em CL e Resto em DL


                        pop di
                        pop ax

                        RET

ConverterDecimal       ENDP

;---------------------------------------------------------------------------------------------------
;Fim ConverterDecimal
;---------------------------------------------------------------------------------------------------


CheckHighScore   PROC    NEAR
        ; empilha registradores
        pusha
        push ds es

        ; DS e ES apontam para o segmento de dados
        mov ax, @data
        mov ds, ax
        mov es, ax

        mov ax,ptsPedro
        mov bx,ptsBino
        cmp ax,bx
        jge prim1
        mov Pontos,bx
        mov ganhou, 1
        jmp depo
prim1:
		mov Pontos,ax
		mov ganhou, 0
depo:
  ; coloca em AX a pontuacao
        mov ax, Pontos;[ds:Pontos]

        ; verifica se eh maior que o quinto colocado
        cmp ax, [ds:ScScore5]
        jle CHSExit

        ; verifica se eh maior que o quarto colocado
        cmp ax, [ds:ScScore4]
        jg  CHSPos4

        ; ES:DI aponta para o nome do quinto colocado,
        ; enquanto eh escrito seu valor no score
        mov [ds:ScScore5], ax
        mov colocacao, 5
        mov ScName5[0], " "
        mov ScName5[1], " "
        mov ScName5[2], " "
        mov ScName5[3], " "
        mov ScName5[4], " "
        mov ScName5[5], " "
        mov ScName5[6], " "
        mov ScName5[7], " "
        call PegaNome
        push dx
        mov dl, Array_nome[0]
        mov ScName5[0], dl
        mov dl, Array_nome[1]
        mov ScName5[1], dl
        mov dl, Array_nome[2]
        mov ScName5[2], dl
        mov dl, Array_nome[3]
        mov ScName5[3], dl
        mov dl, Array_nome[4]
        mov ScName5[4], dl
        mov dl, Array_nome[5]
        mov ScName5[5], dl
        mov dl, Array_nome[6]
        mov ScName5[6], dl
        mov dl, Array_nome[7]
        mov ScName5[7], dl
        mov ScName5[8], '$'
        pop dx
        jmp CHSExit

    CHSPos4:
        ; transfere o quarto para o quinto colocado
        mov di, offset ScName5
        mov si, offset ScName4
        mov cx, 12
        rep movsb

        ; verifica se eh maior que o terceiro colocado
        cmp ax, [ds:ScScore3]
        jg  CHSPos3

        ; ES:DI aponta para o nome do quinto colocado,
        ; enquanto eh escrito seu valor no score
        mov [ds:ScScore4], ax
        mov colocacao, 4
        mov ScName4[0], " "
        mov ScName4[1], " "
        mov ScName4[2], " "
        mov ScName4[3], " "
        mov ScName4[4], " "
        mov ScName4[5], " "
        mov ScName4[6], " "
        mov ScName4[7], " "
        call PegaNome
        push dx
        mov dl, Array_nome[0]
        mov ScName4[0], dl
        mov dl, Array_nome[1]
        mov ScName4[1], dl
        mov dl, Array_nome[2]
        mov ScName4[2], dl
        mov dl, Array_nome[3]
        mov ScName4[3], dl
        mov dl, Array_nome[4]
        mov ScName4[4], dl
        mov dl, Array_nome[5]
        mov ScName4[5], dl
        mov dl, Array_nome[6]
        mov ScName4[6], dl
        mov dl, Array_nome[7]
        mov ScName4[7], dl
        mov ScName4[8], '$'
        pop dx
        jmp CHSExit

    CHSPos3:
        ; transfere o quarto para o quinto colocado

        mov di, offset ScName4
        mov si, offset ScName3
        mov cx, 12
        rep movsb

        ; verifica se eh maior que o segundo colocado
        cmp ax, [ds:ScScore2]
        jg  CHSPos2

        ; ES:DI aponta para o nome do quinto colocado,
        ; enquanto eh escrito seu valor no score
        mov [ds:ScScore3], ax
        mov colocacao, 3
        mov ScName3[0], " "
        mov ScName3[1], " "
        mov ScName3[2], " "
        mov ScName3[3], " "
        mov ScName3[4], " "
        mov ScName3[5], " "
        mov ScName3[6], " "
        mov ScName3[7], " "
        call PegaNome
        push dx
        mov dl, Array_nome[0]
        mov ScName3[0], dl
        mov dl, Array_nome[1]
        mov ScName3[1], dl
        mov dl, Array_nome[2]
        mov ScName3[2], dl
        mov dl, Array_nome[3]
        mov ScName3[3], dl
        mov dl, Array_nome[4]
        mov ScName3[4], dl
        mov dl, Array_nome[5]
        mov ScName3[5], dl
        mov dl, Array_nome[6]
        mov ScName3[6], dl
        mov dl, Array_nome[7]
        mov ScName3[7], dl
        mov ScName3[8], '$'
        pop dx
        jmp CHSExit

    CHSPos2:
        ; transfere o quarto para o quinto colocado


        mov di, offset ScName3
        mov si, offset ScName2
        mov cx, 12
        rep movsb

        ; verifica se eh maior que o terceiro colocado
        cmp ax, [ds:ScScore1]
        jg  CHSPos1

        ; ES:DI aponta para o nome do quinto colocado,
        ; enquanto eh escrito seu valor no score
        mov [ds:ScScore2], ax
        mov colocacao, 2
        mov ScName2[0], " "
        mov ScName2[1], " "
        mov ScName2[2], " "
        mov ScName2[3], " "
        mov ScName2[4], " "
        mov ScName2[5], " "
        mov ScName2[6], " "
        mov ScName2[7], " "
        call PegaNome
        push dx
        mov dl, Array_nome[0]
        mov ScName2[0], dl
        mov dl, Array_nome[1]
        mov ScName2[1], dl
        mov dl, Array_nome[2]
        mov ScName2[2], dl
        mov dl, Array_nome[3]
        mov ScName2[3], dl
        mov dl, Array_nome[4]
        mov ScName2[4], dl
        mov dl, Array_nome[5]
        mov ScName2[5], dl
        mov dl, Array_nome[6]
        mov ScName2[6], dl
        mov dl, Array_nome[7]
        mov ScName2[7], dl
        mov ScName2[8], '$'
        pop dx

        jmp CHSExit

    CHSPos1:
        ; transfere o quarto para o quinto colocado
        mov di, offset ScName2
        mov si, offset ScName1
        mov cx, 12
        rep movsb

        ; ES:DI aponta para o nome do quinto colocado,
        ; enquanto eh escrito seu valor no score
        mov [ds:ScScore1], ax
        mov colocacao, 1
        mov ScName1[0], " "
        mov ScName1[1], " "
        mov ScName1[2], " "
        mov ScName1[3], " "
        mov ScName1[4], " "
        mov ScName1[5], " "
        mov ScName1[6], " "
        mov ScName1[7], " "
        call PegaNome
        push dx
        mov dl, Array_nome[0]
        mov ScName1[0], dl
        mov dl, Array_nome[1]
        mov ScName1[1], dl
        mov dl, Array_nome[2]
        mov ScName1[2], dl
        mov dl, Array_nome[3]
        mov ScName1[3], dl
        mov dl, Array_nome[4]
        mov ScName1[4], dl
        mov dl, Array_nome[5]
        mov ScName1[5], dl
        mov dl, Array_nome[6]
        mov ScName1[6], dl
        mov dl, Array_nome[7]
        mov ScName1[7], dl
        mov ScName1[8], '$'
        pop dx

        CHSExit:
        ; desempilha registradores
        pop es ds
        popa
        ret
    CheckHighScore   ENDP

;-----------------------------------------------------------------------------------------------------------
;Fim CheckHighScore
;-----------------------------------------------------------------------------------------------------------


;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x Procedimento PegaNome                                                        x
;x Mostra tela que solicita o jogador que teve score alto a digitar seu nome    x
;x Lembrar de desligar o keyboardHandler antes de chamar esse procedimento      x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
PegaNome PROC NEAR

pusha

mov quebrouScore, 0

carrega_paleta tela_recordes_pal, paleta_buffer

call CoolDown
imprimir_tela tela_recordes_dat

;mov podeSair, 0
mov espera, 0

cmp colocacao, 1
jne p2

cmp ganhou, 1
je ganhouBino
mov si, offset digiteNomePedro1
jmp continua1
ganhouBino:

        mov si, offset digiteNomeBino1

continua1:

  mov linhaRec, 46
  push cx dx bx
  ; 1 nome / score
  mov ch, 46
  mov dx, offset ScLimpo
  mov bx, Pontos                               ;Pontos guarda a pontuao do jogador que fez mais pontos na partida.
  call imprimeRecordes

  ; 2 nome / score
  mov ch, 60
  mov dx, offset ScName2
  mov bx, ScScore2
  call imprimeRecordes

  ; 3 nome / score
  mov ch, 74
  mov dx, offset ScName3
  mov bx, ScScore3
  call imprimeRecordes

  ; 4 nome / score
  mov ch, 88
  mov dx, offset ScName4
  mov bx, ScScore4
  call imprimeRecordes

  ; 5 nome / score
  mov ch, 102
  mov dx, offset ScName5
  mov bx, ScScore5
  call imprimeRecordes

  pop bx dx cx

jmp depois

p2:
cmp colocacao, 2
jne p3

cmp ganhou, 1
je ganhouBino2
mov si, offset digiteNomePedro2
jmp continua2
ganhouBino2:

        mov si, offset digiteNomeBino2

continua2:

  mov linhaRec, 60
  push cx dx bx
  ; 1 nome / score
  mov ch, 46
  mov dx, offset ScName1
  mov bx, ScScore1
  call imprimeRecordes

  ; 2 nome / score
  mov ch, 60
  mov dx, offset ScLimpo
  mov bx, Pontos
  call imprimeRecordes

  ; 3 nome / score
  mov ch, 74
  mov dx, offset ScName3
  mov bx, ScScore3
  call imprimeRecordes

  ; 4 nome / score
  mov ch, 88
  mov dx, offset ScName4
  mov bx, ScScore4
  call imprimeRecordes

  ; 5 nome / score
  mov ch, 102
  mov dx, offset ScName5
  mov bx, ScScore5
  call imprimeRecordes

  pop bx dx cx
jmp depois

p3:
cmp colocacao, 3
jne p4

cmp ganhou, 1
je ganhouBino3
mov si, offset digiteNomePedro3
jmp continua3
ganhouBino3:

        mov si, offset digiteNomeBino3

continua3:

  mov linhaRec, 74

  push cx dx bx
  ; 1 nome / score
  mov ch, 46
  mov dx, offset ScName1
  mov bx, ScScore1
  call imprimeRecordes

  ; 2 nome / score
  mov ch, 60
  mov dx, offset ScName2
  mov bx, ScScore2
  call imprimeRecordes

  ; 3 nome / score
  mov ch, 74
  mov dx, offset ScLimpo
  mov bx, Pontos
  call imprimeRecordes

  ; 4 nome / score
  mov ch, 88
  mov dx, offset ScName4
  mov bx, ScScore4
  call imprimeRecordes

  ; 5 nome / score
  mov ch, 102
  mov dx, offset ScName5
  mov bx, ScScore5
  call imprimeRecordes

  pop bx dx cx
jmp depois

p4:
cmp colocacao, 4
jne p5

cmp ganhou, 1
je ganhouBino4
mov si, offset digiteNomePedro4
jmp continua4
ganhouBino4:

        mov si, offset digiteNomeBino4

continua4:

  mov linhaRec, 88
  push cx dx bx
  ; 1 nome / score
  mov ch, 46
  mov dx, offset ScName1
  mov bx, ScScore1
  call imprimeRecordes

  ; 2 nome / score
  mov ch, 60
  mov dx, offset ScName2
  mov bx, ScScore2
  call imprimeRecordes

  ; 3 nome / score
  mov ch, 74
  mov dx, offset ScName3
  mov bx, ScScore3
  call imprimeRecordes

  ; 4 nome / score
  mov ch, 88
  mov dx, offset ScLimpo
  mov bx, Pontos
  call imprimeRecordes

  ; 5 nome / score
  mov ch, 102
  mov dx, offset ScName5
  mov bx, ScScore5
  call imprimeRecordes

  pop bx dx cx
jmp depois
p5:
cmp colocacao, 5
jne FimLoop

cmp ganhou, 1
je ganhouBino5
mov si, offset digiteNomePedro5
jmp continua5

ganhouBino5:

        mov si, offset digiteNomeBino5

continua5:

  mov linhaRec, 102       ;LINHA NA TELA ONDE SERA ESCRITO O NOME
  push cx dx bx
  ; 1 nome / score
  mov ch, 46
  mov dx, offset ScName1
  mov bx, ScScore1
  call imprimeRecordes

  ; 2 nome / score
  mov ch, 60
  mov dx, offset ScName2
  mov bx, ScScore2
  call imprimeRecordes

  ; 3 nome / score
  mov ch, 74
  mov dx, offset ScName3
  mov bx, ScScore3
  call imprimeRecordes

  ; 4 nome / score
  mov ch, 88
  mov dx, offset ScName4
  mov bx, ScScore4
  call imprimeRecordes

  ; 5 nome / score
  mov ch, 102
  mov dx, offset ScLimpo
  mov bx, Pontos
  call imprimeRecordes

  pop bx dx cx
jmp depois

depois:


;**************Parte que desenha a frase pedindo ao usurio para digitar o seu nome**********************************

mov di, 45                             ; pos x
mov cl, 5                              ; pos y
mov dh, 000h;fh                          ;  cor
call DesenharFrase       ;
;********************************************************************************************************************

mov bx, 8              ;tamanho mximo do nome
mov di, 725             ;
mov Array_nome[0], ' '
mov Array_nome[1], ' '
mov Array_nome[2], ' '
mov Array_nome[3], ' '
mov Array_nome[4], ' '
mov Array_nome[5], ' '
mov Array_nome[6], ' '
mov Array_nome[7], ' '
mov Array_nome[8], '$'

PegaLetra:
cmp bx, 0
je Fim11

;call resetarInt15
        mov ax, 0000h
        int 16h
;call setarInt15

;ah -- keyboard scan code  al -- ascii code para tecla e 0 para outros
; keyboard BIOS services

cmp al, tecla_enter
je FimLoop

cmp al, 08h
je TrataBack

cmp al, tecla_espaco
je TrataEspaco

cmp al, 00h ;tecla especial
je PegaLetra
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
add di, 7             ; incremento para colocar o caracter no lugar certo, inicio = 193
mov cl, linhaRec      ; linha onde vai ser impresso
mov dh, 108;0fh           ; cor
call DesenharLetra    ; di,cl (x,y)
push dx               ;
mov dx, 8             ;
sub dx,bx             ;
push bx               ;
mov bx,dx             ;
mov Array_nome[bx],al ;
pop bx dx             ;
dec bx                ; decrementa o numero de caracter que podem ser escritos

jmp PegaLetra

TrataEspaco:
add di, 7
mov cl, linhaRec
mov dh, 195;0FFh
call DesenharLetra
push dx
mov dx, 8
sub dx,bx
push bx
mov bx,dx
mov Array_nome[bx]," "
pop bx dx
dec bx
jmp PegaLetra

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
TrataBack:                              ;;
push cx                                 ;;
mov cx, bx                              ;;
cmp cx, 8                               ;;
je ww                                   ;;
inc bx                                  ;;
                                        ;;
ww:                                     ;;
push dx                                 ;;
mov dx, 8
sub dx,bx
push bx
mov bx,dx

mov Array_nome[bx]," "
pop bx dx

mov bx, cx

cmp bx, 8
je PegaLetra

mov dh, 0ffh;00h
mov al, 20h
mov cl, linhaRec
call DesenharLetra

;mov dh, 000h
sub di, 7
inc bx
pop cx
jmp PegaLetra
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Fim11:
;call resetarInt15
        mov ax, 0000h
        int 16h
;call setarInt15

cmp al, 08h
je TrataBack

cmp al, tecla_enter
jne Fim11

FimLoop:
popa
ret
PegaNome ENDP

;-------------------------------------------------------------------------------------------------------
;Fim PegaNome
;-------------------------------------------------------------------------------------------------------


;**********************************************
; Procedimento que imprime o valor dos Recordes na tela
; ch -> linha
; dx -> offset do nome
; bx -> numero
;**********************************************

imprimeRecordes PROC NEAR

pusha
push di si

  mov ax, @data
  mov ds, ax
  mov si, dx
; DESENHAR FRASE
  mov dh, 032h  ;DH - Cor para desenhar
  mov di, 90
  mov cl, ch    ;DI, CL - posio (X, Y) para desenhar

  push cx bx
  call DesenharFrase
  pop bx cx

  mov dl, ch
  mov ah, ch

  push ax
  mov ax, bx
  call ConverterDecimal
  pop ax

;Desenha pontuao
  mov dh, 04fh ;COR DO NUMERO
  mov di, 205   ;
  ;mov ah, ch;ch
  call DesenharNumero


pop si di
popa
ret
imprimeRecordes ENDP

;-------------------------------------------------------------------------------------------------------
;Fim imprimeRecordes
;-------------------------------------------------------------------------------------------------------


;**********************************************
;Imprime todos recordes na tela
;**********************************************
imprimeTodos PROC NEAR

;  mov podeSair, 0
  ;mov espera, 3
  push cx dx bx

  
mov si, offset hallOfFame
mov di, 125;50;93        ; pos x
mov cl, 35               ; pos y
mov dh, 000h;199;0fh             ;  cor
call DesenharFrase       ;


  ; 1 nome / score
  mov ch, 49
  mov dx, offset ScName1
  mov bx, ScScore1
  call imprimeRecordes

  ; 2 nome / score
  mov ch, 63
  mov dx, offset ScName2
  mov bx, ScScore2
  call imprimeRecordes

  ; 3 nome / score
  mov ch, 77
  mov dx, offset ScName3
  mov bx, ScScore3
  call imprimeRecordes

  ; 4 nome / score
  mov ch, 91
  mov dx, offset ScName4
  mov bx, ScScore4
  call imprimeRecordes

  ; 5 nome / score
  mov ch, 105
  mov dx, offset ScName5
  mov bx, ScScore5
  call imprimeRecordes

  pop bx dx cx
  ret

imprimeTodos ENDP

;-------------------------------------------------------------------------------------------------------
;Fim imprimeTodos
;-------------------------------------------------------------------------------------------------------

;-------------------------------------------------------------------------------------------------------
;Funo que adiquire a imagem com a histria a ser aparesentada
;-------------------------------------------------------------------------------------------------------
 Apresenta MACRO tela_dat, tela_pal, tela_texto, tela_posx, tela_posy, tela_texto_cor

            ;guarda o valor dos registradores na pilha
            push AX
            push BX
            push CX
            push DX
            push DS

            call CoolDown
            carrega_paleta tela_pal, paleta_buffer
            imprimir_tela tela_dat

               mov si, offset tela_texto
               mov di, tela_posx;50;93        ; pos x
               mov cl, tela_posy               ; pos y
               mov dh, tela_texto_cor;199;0fh             ;  cor
               call DesenharFrase       ;
               
               ;mov ah, 01h
	       ;int 21h

            ;recupera o valor dos registradores na pilha
            pop DS
            pop DX
            pop CX
            pop BX
            pop AX

 ENDM
;-------------------------------------------------------------------------------------------------------
;Fim Apresenta
;-------------------------------------------------------------------------------------------------------
