;*******************************************************************************************************************
; Procedimento Setarint15                                                                                          *
;                                                                                                                  *
; Descrio: Substitui a Interrupo 15h original pelo KeyboardHandler, guardando o seu segmento e offset          *
;            nas variaveis segmento_int15h e offset_int15h.                                                        *
;*******************************************************************************************************************

SetarInt15 PROC NEAR

                        push ax
                        push es
                        push bx
                        push ds
                        push dx

                        mov ax, @data
                        mov ds, ax

			mov ah, 35h
                        mov al, 15h
			int 21h
                        mov [segmento_int15h], es
                        mov [offset_int15h], bx
			mov ax, seg KeyboardHandler
			mov ds, ax
			mov dx, offset KeyboardHandler
			mov ah, 25h
                        mov al, 15h
			int 21h

			pop dx
			pop ds
			pop bx
			pop es
			pop ax

                        RET

SetarInt15 ENDP

;--------------------------------------------------------------------------------------------------------------------
;Fim SetarInt15
;--------------------------------------------------------------------------------------------------------------------

;********************************************************************************************************************
; Procedimento ResetarInt15                                                                                         *
;                                                                                                                   *
; Descrio: retorna a interrupo 15h original pelo meio das variveis segmento_int15h e offset_int15h.            *
;                                                                                                                   *
;********************************************************************************************************************
ResetarInt15 PROC FAR

                        push ax
			push ds
			push dx

                        mov ax, @data
                        mov ds, ax

			mov dx, [offset_int15h]
                        mov ax, [segmento_int15h]
			mov ds, ax
			mov ax, 2515h
			int 21h

			pop dx
			pop ds
			pop ax

			RET

ResetarInt15 ENDP

;------------------------------------------------------------------------------------------------------------------
;Fim ResetarInt15
;------------------------------------------------------------------------------------------------------------------


;******************************************************************************************************************
;Procedimento KeyboardHandler                                                                                     *
;                                                                                                                 *
;Descrio: Procedimento que substituir a interrupcao 15h original para podermos tratar o teclado da forma que   *
;           quisermos.                                                                                            *
;******************************************************************************************************************
KeyboardHandler		PROC FAR

                        cli

                        push ds
                        push bx
                        push ax

                        mov bx, @data
                        mov ds, bx

			cmp ah, 04fh		; eh pra eu tratar?
			jnz naoTratar

			test al, 80h            ;  evento de tecla pressionada?
			jnz PressionarFrente1
			mov [PressionouTecla], 1


PressionarFrente1:	cmp al, tecla_direita1
                        jnz SoltarFrente1
                        mov ds:[varDireita1], 1
                        jmp KeyboardHandlerVoltar

SoltarFrente1:           cmp al, soltar_direita1
                        jnz PressionarTraz1
                        mov ds:[varDireita1], 0
                        jmp KeyboardHandlerVoltar

PressionarTraz1:         cmp al, tecla_esquerda1
                        jnz SoltarTraz1
                        mov ds:[varEsquerda1], 1
                        jmp KeyboardHandlerVoltar

SoltarTraz1:             cmp al, soltar_esquerda1
                        jnz PressionarCima1
                        mov ds:[varEsquerda1], 0
                        jmp KeyboardHandlerVoltar

PressionarCima1:         cmp al, tecla_cima1
                        jnz SoltarCima1
                        mov ds:[varCima1], 1
                        jmp KeyboardHandlerVoltar

SoltarCima1:             cmp al, soltar_cima1
                        jnz PressionarBaixo1
                        mov ds:[varCima1], 0
                        jmp KeyboardHandlerVoltar


PressionarBaixo1:        cmp al, tecla_baixo1
                        jnz SoltarBaixo1
                        mov ds:[varBaixo1], 1
                        jmp KeyboardHandlerVoltar


SoltarBaixo1:            cmp al, soltar_baixo1
                        jnz PressionarTiro1
                        mov ds:[varBaixo1], 0
                        jmp KeyboardHandlerVoltar

PressionarTiro1:
                        cmp al, tecla_tiro1
                        jnz SoltarTiro1
                        mov ds:[varTiro1], 1
                        jmp KeyboardHandlerVoltar

SoltarTiro1:
                        cmp al, soltar_tiro1
                        jnz PressionarFrente2
                        mov ds:[varTiro1], 0
                        jmp KeyboardHandlerVoltar

PressionarFrente2:	cmp al, tecla_direita2
                        jnz SoltarFrente2
                        mov ds:[varDireita2], 1
                        jmp KeyboardHandlerVoltar

SoltarFrente2:           cmp al, soltar_direita2
                        jnz PressionarTraz2
                        mov ds:[varDireita2], 0
                        jmp KeyboardHandlerVoltar

PressionarTraz2:         cmp al, tecla_esquerda2
                        jnz SoltarTraz2
                        mov ds:[varEsquerda2], 1
                        jmp KeyboardHandlerVoltar

SoltarTraz2:             cmp al, soltar_esquerda2
                        jnz PressionarCima2
                        mov ds:[varEsquerda2], 0
                        jmp KeyboardHandlerVoltar

PressionarCima2:         cmp al, tecla_cima2
                        jnz SoltarCima2
                        mov ds:[varCima2], 1
                        jmp KeyboardHandlerVoltar

SoltarCima2:             cmp al, soltar_cima2
                        jnz PressionarBaixo2
                        mov ds:[varCima2], 0
                        jmp KeyboardHandlerVoltar


PressionarBaixo2:        cmp al, tecla_baixo2
                        jnz SoltarBaixo2
                        mov ds:[varBaixo2], 1
                        jmp KeyboardHandlerVoltar


SoltarBaixo2:            cmp al, soltar_baixo2
                        jnz PressionarTiro2
                        mov ds:[varBaixo2], 0
                        jmp KeyboardHandlerVoltar

PressionarTiro2:
                        cmp al, tecla_tiro2
                        jnz SoltarTiro2
                        mov ds:[varTiro2], 1
                        jmp KeyboardHandlerVoltar

SoltarTiro2:
                        cmp al, soltar_tiro2
                        jnz pressionarEsc
                        mov ds:[varTiro2], 0
                        jmp KeyboardHandlerVoltar

;***********************PARTE MODIFICADA******************************************************************************************
pressionarEsc:
                        cmp al, tecla_esc
                        jnz Pressionarf2
                        mov ds:[varEsc], 1
                        jmp KeyboardHandlerVoltar


Pressionarf2:
                        cmp al, 03Ch
                        jnz soltarf2
                        mov ds : [varF2], 1
                        jmp KeyboardHandlerVoltar

soltarf2:
                        cmp al, 0BBh
                        jnz Pressionarf1
                        mov ds : [varF2], 0
                        jmp KeyboardHandlerVoltar

Pressionarf1:           cmp al, 03bh
                        jnz soltarf1
                        mov ds:[varF1], 1
                        jmp KeyboardHandlerVoltar

soltarf1:               cmp al, 0bbh
                        jnz naoTratar
                        mov ds:[varF1], 0
                        jmp KeyboardHandlerVoltar

;***********************FIM PARTE MODIFICADA******************************************************************************************



;*********************************************************
;
;se ficar meio lento modificar o acesso a mem em baixo
;
;*********************************************************


naoTratar:
                        push ax
                        push es
                        push di
                        push si
                        push ds

                        mov ax,40h
                        mov es,ax
                        mov ds,ax
                        mov di,1ch
                        mov si,1ah
                        movsw

                        pop ds
                        pop si
                        pop di
                        pop es
		        pop ax

			clc

KeyboardHandlerVoltar:
                        pop ax
                        pop bx
                        pop ds

			sti

			IRET

KeyboardHandler		ENDP

;--------------------------------------------------------------------------------------------------------------------
;Fim KeyboardHandler
;--------------------------------------------------------------------------------------------------------------------

SetarInt1C PROC NEAR

                        push ax
                        push es
                        push bx
                        push ds
                        push dx

                        mov ax, @data
                        mov ds, ax

                        ;pega o vetor de interrupo
			mov ah, 35h
                        mov al, 1Ch
			int 21h
                        mov [segmento_int1Ch], es
                        mov [offset_int1Ch], bx
			mov ax, seg Timer
			mov ds, ax
			mov dx, offset Timer
			
                        ;seta o vetor de interrupo
                        mov ah, 25h
                        mov al, 1Ch
			int 21h

			pop dx
			pop ds
			pop bx
			pop es
			pop ax

                        RET



SetarInt1C ENDP

;--------------------------------------------------------------------------------------------------------
;Fim SetarInt1C
;---------------------------------------------------------------------------------------------------------

ResetarInt1C PROC FAR

                        push ax
			push ds
			push dx

                        mov ax, @data
                        mov ds, ax

			mov dx, [offset_int1Ch]
                        mov ax, [segmento_int1Ch]
			mov ds, ax
			mov ax, 251Ch
			int 21h

			pop dx
			pop ds
			pop ax

			RET

ResetarInt1C ENDP

;------------------------------------------------------------------------------------------------------
;Fim ResetarInt1C
;------------------------------------------------------------------------------------------------------

;Este procedimento sera chamado a cada 55 milisegundos, pois ele substituir a interrupo 1Ch

Timer PROC FAR

      cli
      push DS
      push AX
      push BX
      push CX

      mov AX, @data
      mov DS, AX

      xor AX, AX
      xor BX, BX
      xor CX, CX
      
;delay do tempo da bala do tank1
      cmp nao_atira, 1
      jne naoAtira2
      mov BX, tempo_nao_atira
      add BX, 55
      cmp BX, 500
      jb naoAtira2
      mov nao_atira, 0
      mov BX, 0


;delay do tempo da bala do tank2
naoAtira2:

      cmp nao_atira2, 1
      jne segCount
      mov CX, tempo_nao_atira2
      add CX, 55
      cmp CX, 500
      jb segCount
      mov nao_atira2, 0
      mov CX, 0


segCount:
         mov AX, MSEC                     ;AX recebe o numero de milisegundos que se passaram
         add AX, 55                       ;adiciona 55 a AX pois essa rotina ser chamada em 55 milisegundos
         add tempoConfrontos, 1
         cmp AX, 1000                     ;Verifica se ja se passou 1 segundo
         jb setMSEC                       ;caso nao tenha passado 1 segundo ainda, passa o valor de AX para MSEC
         inc SEC                          ;incrementa SEC se ja passou um segundo
         sub AX, 1000
         cmp tempoConfrontos, 500
         jl setMSEC                           ;AQUI
         mov tempoConfrontos, 0

setMSEC:

        mov MSEC, AX                   ;atualiza o valor de MSEC
        mov tempo_nao_atira, BX
        mov tempo_nao_atira2, CX
        pop CX
        pop BX
        pop AX
        pop DS
        sti
        IRET

Timer ENDP


;********************************************************************************************************************
;                                                                                                                   *
;Procedimento deslocamento                                                                                          *
;                                                                                                                   *
;Descrio: Este procedimento atualiza a posio dos objetos de acordo com a tecla pressionada.                     *
;********************************************************************************************************************
deslocamento PROC NEAR

   Dir1:

             cmp explodiu, 1
             je Dir2
             cmp ds:[varDireita1], 1
             jne Esq1
             ;add contadorTeclas, 1      ;novo
             add posX_tank, 1
             mov direcao, 3
             cmp posX_tank, 300
             jne Tiro1
             ;jne Esq1
             sub posX_tank, 1
             jmp Tiro1

   Esq1:

             cmp ds:[varEsquerda1], 1
             jne Cim1
             ;add contadorTeclas, 1
             sub posX_tank, 1
             mov direcao, 4
             cmp posX_tank, 0
             jne Tiro1
             add posX_tank, 1                        ;tank virado para esquerda
             jmp Tiro1
   Cim1:

             cmp ds:[varCima1], 1
             jne Bai1
             ;add contadorTeclas, 1
             sub posY_tank, 1
             mov direcao, 1
             cmp posY_tank, 0                         ;tank virado para cima
             jne Tiro1
             add posY_tank, 1
             jmp Tiro1
   Bai1:

             cmp ds:[varBaixo1], 1
             jne Tiro1
             ;add contadorTeclas, 1
             add posY_tank, 1                      ;tank virado para baixo
             mov direcao, 2
             cmp posY_tank, 186;180
             jne Tiro1
             sub posY_tank, 1
             jmp Tiro1
   Tiro1:

             cmp nao_atira, 1
             je Dir2
             cmp ds:[varTiro1], 1
             jne Dir2
         ;SO ENTRA AQUI SE O CARA PUDER ATIRAR
             sub ptsPedro, 5                               ;perde ponto por atirar. necessario?
             mov nao_atira, 1                              ;Pula para a verificao das teclas relacionadas ao jogador 2.
             cmp direcaoBala, 0
             jne Dir2
             cmp balasTank, 1
             jl Dir2
             cmp direcao, 1                        ;verifica a direo do tank para descobrir a direo em que a bala vai sair.
             je PosBalaCima
             cmp direcao, 2
             je PosBalaBaixo
             cmp direcao, 3
             je PosBalaDir
             cmp direcao, 4
             je PosBalaEsq
             jmp Dir2


   PosBalaDir :
              mov direcaoBala, 3
              mov cx, posX_tank            ;
              add cx, 19                   ;
              mov posX_bala, cx            ;gambiarras
              mov cx, posY_tank            ;
              add cx, 6                    ;
              mov posY_bala, cx
              ;----
              mov cx, balasTank
              sub cx, 1
              mov balasTank, cx
              jmp Dir2

   PosBalaEsq :
              mov direcaoBala, 4
              mov cx, posX_tank
              sub cx, 2
              mov posX_bala, cx
              mov cx, posY_tank
              add cx, 6
              mov posY_bala, cx
              mov cx, balasTank
              sub cx, 1
              mov balasTank, cx
              jmp Dir2

   PosBalaCima :
              mov direcaoBala, 1
              mov cx, posX_tank
              add cx, 7
              mov posX_bala, cx
              mov cx, posY_tank
              sub cx, 1
              mov posY_bala, cx
              mov cx, balasTank
              sub cx, 1
              mov balasTank, cx
              jmp Dir2

   PosBalaBaixo :
              mov direcaoBala, 2
              mov cx, posX_tank
              add cx, 6
              mov posX_bala, cx
              mov cx, posY_tank
              add cx, 18
              mov posY_bala, cx
              mov cx, balasTank
              sub cx, 1
              mov balasTank, cx
              jmp Dir2

   Dir2:
             cmp explodiu, 1
             je sair
             cmp ds:[varDireita2], 1
             jne Esq2
             ;add contadorTeclas, 1
             add posX_tank2, 1
             mov direcao2, 3
             cmp posX_tank2, 300
             jne Tiro2
             ;jne Esq1
             sub posX_tank2, 1
             jmp Tiro2

   Esq2:

             cmp ds:[varEsquerda2], 1
             jne Cim2
             ;add contadorTeclas, 1
             sub posX_tank2, 1
             mov direcao2, 4
             cmp posX_tank2, 0
             jne Tiro2
             add posX_tank2, 1                        ;tank virado para esquerda
             jmp Tiro2
   Cim2:

             cmp ds:[varCima2], 1
             jne Bai2
             ;add contadorTeclas, 1
             sub posY_tank2, 1
             mov direcao2, 1
             cmp posY_tank2, 0                         ;tank virado para cima
             jne Tiro2
             add posY_tank2, 1
             jmp Tiro2
   Bai2:

             cmp ds:[varBaixo2], 1
             jne Tiro2
             ;add contadorTeclas, 1
             add posY_tank2, 1                      ;tank virado para baixo
             mov direcao2, 2
             cmp posY_tank2, 186;180
             jne Tiro2
             sub posY_tank2, 1
             jmp Tiro2
   Tiro2:

             cmp nao_atira2, 1
             je sair
             cmp ds:[varTiro2], 1
             jne sair
             sub ptsBino, 5                        ;perde ponto por gastar bala.  necessario?
             mov nao_atira2, 1
             cmp direcaoBala2, 0
             jne sair
             cmp balasTank2, 1
             jl sair
             cmp direcao2, 1
             je PosBalaCima2
             cmp direcao2, 2
             je PosBalaBaixo2
             cmp direcao2, 3
             je PosBalaDir2
             cmp direcao2, 4
             je PosBalaEsq2
             jmp sair


  PosBalaDir2 :
              mov direcaoBala2, 3
              mov cx, posX_tank2            ;
              add cx, 19                   ;
              mov posX_bala2, cx            ;gambiarras
              mov cx, posY_tank2            ;
              add cx, 6                    ;
              mov posY_bala2, cx
              mov cx, balasTank2
              sub cx, 1
              mov balasTank2, cx
              jmp sair

   PosBalaEsq2 :
              mov direcaoBala2, 4
              mov cx, posX_tank2
              sub cx, 4
              mov posX_bala2, cx
              mov cx, posY_tank2
              add cx, 6
              mov posY_bala2, cx
              mov cx, balasTank2
              sub cx, 1
              mov balasTank2, cx
              jmp sair

   PosBalaCima2 :
              mov direcaoBala2, 1
              mov cx, posX_tank2
              add cx, 6
              mov posX_bala2, cx
              mov cx, posY_tank2
              sub cx, 1
              mov posY_bala2, cx
              mov cx, balasTank2
              sub cx, 1
              mov balasTank2, cx
              jmp sair

   PosBalaBaixo2 :
              mov direcaoBala2, 2
              mov cx, posX_tank2
              add cx, 6
              mov posX_bala2, cx
              mov cx, posY_tank2
              add cx, 18
              mov posY_bala2, cx
              mov cx, balasTank2
              sub cx, 1
              mov balasTank2, cx
              jmp sair

   sair:

        RET

deslocamento ENDP

;-------------------------------------------------------------------------------------------------------------------
;Fim deslocamento
;-------------------------------------------------------------------------------------------------------------------

desenhar MACRO

         call colisaoTankCenario
         barraColisaoTanquesPontoX
         barraColisaoBala1Tanque2PontoX
         barraColisaoBala2Tanque1PontoX


    ;     call colisaoTanques
    ;     call colisaoBala1                           ;colisao da bala do tanque1 com o tanque2
    ;     call colisaoBala2                           ;colisao da bala do tanque2 com o tanque1
         call colisaoBalaCenario
         call colisaoTanque1Item
         call colisaoTanque2Item
         copiar_buffer buffer_painel, buffer, 64000
         carregarEstrelas
         desenharTanques
         desenharBalas
         DesenhaTankPiscando
         desenharPosto

ENDM


;====================================================================================================================
; Desenha o posto na primeira fase como segundo plano
;====================================================================================================================
desenharPosto MACRO
    cmp faseUm, 1
    je desenhaPosto
    jmp fimDesenhaPosto
    desenhaPosto:
        carregar_figura buffer_posto, 227, 145, 52, 90

    fimDesenhaPosto:

ENDM


;====================================================================================================================
; barraColisaoTanquesPontoX
; Macro utilizada para barrar ou no a coliso entre os tanques quando um estiver em cima e o outro embaixo no pontoX
;====================================================================================================================
barraColisaoTanquesPontoX MACRO

    cmp temTanqueNoPontoX, 1
    je verificarPosicoesTanques1
    jmp barrar

    verificarPosicoesTanques1:
        cmp tanque1EmCima, 1
        je verificarPosicoesTanques2
        jmp verificarPosicoesTanques3

        verificarPosicoesTanques2:
            cmp tanque2EmCima, 0
            je naoBarrar
            jmp barrar

        verificarPosicoesTanques3:
            cmp tanque2EmCima, 1
            je naoBarrar
            jmp barrar

    barrar:
         call colisaoTanques


    naoBarrar:

ENDM

;=====================================================================================================================
; barraColisaoBala1Tanque2PontoX
; Macro utilizada para barrar a coliso entre a bala e um tanque quando um estiver em cima e o outro embaixo no pontoX
;=====================================================================================================================
barraColisaoBala1Tanque2PontoX MACRO

    cmp temTanqueNoPontoX, 1
    je verificarPosicoesTanques4
    jmp barrar2

    verificarPosicoesTanques4:
        cmp tanque1EmCima, 1
        je verificarPosicoesTanques5
        jmp verificarPosicoesTanques6

        verificarPosicoesTanques5:
            cmp tanque2EmCima, 0
            je naoBarrar2
            jmp barrar2

        verificarPosicoesTanques6:
            cmp tanque2EmCima, 1
            je naoBarrar2
            jmp barrar2

    barrar2:
         call colisaoBala1;colisaoTanques
         jmp fimBarraColisaoBala1Tanque2PontoX

    naoBarrar2:
          mov naoImprimirBala1, 0

    fimBarraColisaoBala1Tanque2PontoX:

ENDM

;=====================================================================================================================
; barraColisaoBala2Tanque1PontoX
; Macro utilizada para barrar a coliso entre a bala e um tanque quando um estiver em cima e o outro embaixo no pontoX
;=====================================================================================================================
barraColisaoBala2Tanque1PontoX MACRO

    cmp temTanqueNoPontoX, 1
    je verificarPosicoesTanques7
    jmp barrar3

    verificarPosicoesTanques7:
        cmp tanque2EmCima, 1
        je verificarPosicoesTanques8
        jmp verificarPosicoesTanques9

        verificarPosicoesTanques8:
            cmp tanque1EmCima, 0
            je naoBarrar3
            jmp barrar3

        verificarPosicoesTanques9:
            cmp tanque1EmCima, 1
            je naoBarrar3
            jmp barrar3

    barrar3:
         call colisaoBala2;colisaoTanques
         jmp fimBarraColisaoBala2Tanque1PontoX

    naoBarrar3:
         mov naoImprimirBala2, 0


    fimBarraColisaoBala2Tanque1PontoX:

ENDM

;=====================================================================================================================
; Recarrega a municao do tanque1 quando ele est sem bala e no pontoX, em cima
;=====================================================================================================================
recarregarMunicao MACRO

      cmp tanque1NoPontoAbastecimento, 1
      je inicioRecarregarMunicao
      jmp fimRecarregarMunicao

      inicioRecarregarMunicao:

          cmp balasTank, 1
          jl recarregarTanque1

          jmp fimRecarregarMunicao

          recarregarTanque1:
              cmp tanque1EmCima, 1
              je recarregarTanque1Final
              jmp fimRecarregarMunicao

              recarregarTanque1Final:
                  mov balasTank, 10
                  jmp fimRecarregarMunicao

       fimRecarregarMunicao:



ENDM

;=====================================================================================================================
; Recarrega a municao do tanque2 quando ele est sem bala e no pontoX, em cima
;=====================================================================================================================
recarregarMunicao2 MACRO

      cmp tanque2NoPontoAbastecimento, 1
      je inicioRecarregarMunicao2
      jmp fimRecarregarMunicao2

      inicioRecarregarMunicao2:

          cmp balasTank2, 1
          jl recarregarTanque2
          jmp fimRecarregarMunicao2

          recarregarTanque2:
              cmp tanque2EmCima, 1
              je recarregarTanque2Final
              jmp fimRecarregarMunicao2

              recarregarTanque2Final:
                  mov balasTank2, 10
                  jmp fimRecarregarMunicao2

      fimRecarregarMunicao2:

ENDM

;*******************************************************************************************************
;Macro que carrega no buffer os caminhes e os tanques de Pedro e Bino
;*******************************************************************************************************

desenharTanques MACRO


             cmp naoImprimir, 1
             je voltarPosAntigas

    pos_tank1:
             cmp direcao, 1
             je tankCima
             cmp direcao, 2
             je tankBaixo
             cmp direcao, 3
             je tankDireita
             cmp direcao, 4
             je tankEsquerda
             jmp tankCima2

   tankCima:

            cmp ehTank1, 0
            je caminhaoCima
            carregar_figura buffer_tankC, posX_tank, posY_tank, tank_largura, tank_comprimento

            cmp tanque1EmCima, 0
            je desenharPontoXEmCima1
            jmp pos_tank2

            desenharPontoXEmCima1:

                carregar_figura buffer_pontoX, 138, 88, 30, 28

            jmp pos_tank2

   caminhaoCima:

                carregar_figura buffer_caminhaoC, posX_tank, posY_tank, tank_largura, tank_comprimento

                ;call desenharPontoXEmCima  ; imprime o pontoX na tela caso o caminhao/tanque esteja embaixo

                cmp tanque1EmCima, 0
                je desenharPontoXEmCima1Caminhao
                jmp pos_tank2

                desenharPontoXEmCima1Caminhao:

                    carregar_figura buffer_pontoX, 138, 88, 30, 28

                jmp pos_tank2

   tankBaixo:

             cmp ehTank1, 0
             je caminhaoBaixo
             carregar_figura buffer_tankB, posX_tank, posY_tank, tank_largura, tank_comprimento
             ;call desenharPontoXEmCima  ; imprime o pontoX na tela caso o caminhao/tanque esteja embaixo

             cmp tanque1EmCima, 0
             je desenharPontoXEmCima2
             jmp pos_tank2

             desenharPontoXEmCima2:

                 carregar_figura buffer_pontoX, 138, 88, 30, 28


             jmp pos_tank2

   caminhaoBaixo:

                carregar_figura buffer_caminhaoB, posX_tank, posY_tank, tank_largura, tank_comprimento

                ;call desenharPontoXEmCima  ; imprime o pontoX na tela caso o caminhao/tanque esteja embaixo

                cmp tanque1EmCima, 0
                je desenharPontoXEmCima2Caminhao
                jmp pos_tank2

                desenharPontoXEmCima2Caminhao:

                    carregar_figura buffer_pontoX, 138, 88, 30, 28

                jmp pos_tank2


   tankDireita:

               cmp ehTank1, 0
               je caminhaoDireita
               carregar_figura buffer_tankD, posX_tank, posY_tank, tank_comprimento, tank_largura

               ;call desenharPontoXEmCima  ; imprime o pontoX na tela caso o caminhao/tanque esteja embaixo
               cmp tanque1EmCima, 0
               je desenharPontoXEmCima3

               jmp pos_tank2

               desenharPontoXEmCima3:

                   carregar_figura buffer_pontoX, 138, 88, 30, 28


               jmp pos_tank2

   caminhaoDireita:

               carregar_figura buffer_caminhaoD, posX_tank, posY_tank, tank_comprimento, tank_largura


               ; call desenharPontoXEmCima  ; imprime o pontoX na tela caso o caminhao/tanque esteja embaixo

               cmp tanque1EmCima, 0
               je desenharPontoXEmCima3Caminhao
               jmp pos_tank2

               desenharPontoXEmCima3Caminhao:

                   carregar_figura buffer_pontoX, 138, 88, 30, 28


                jmp pos_tank2


   tankEsquerda:

               cmp ehTank1, 0
               je caminhaoEsquerda
               carregar_figura buffer_tankE, posX_tank, posY_tank, tank_comprimento, tank_largura

               cmp tanque1EmCima, 0
               je desenharPontoXEmCima4

               jmp pos_tank2

               desenharPontoXEmCima4:
                   carregar_figura buffer_pontoX, 138, 88, 30, 28


               jmp pos_tank2

   caminhaoEsquerda:

                carregar_figura buffer_caminhaoE, posX_tank, posY_tank, tank_comprimento, tank_largura

                cmp tanque1EmCima, 0
                je desenharPontoXEmCima4Caminhao
                jmp pos_tank2

                desenharPontoXEmCima4Caminhao:
                    carregar_figura buffer_pontoX, 138, 88, 30, 28

                jmp pos_tank2


   ;SEGUNDO TANQUE
   pos_tank2:

             cmp direcao2, 1
             je tankCima2
             cmp direcao2, 2
             je tankBaixo2
             cmp direcao2, 3
             je tankDireita2
             cmp direcao2, 4
             je tankEsquerda2
             jmp tankCima2

   tankCima2:

            cmp ehTank2, 0
            je caminhaoCima2
            carregar_figura buffer_tank2C, posX_tank2, posY_tank2, tank_largura, tank_comprimento

            cmp tanque2EmCima, 0
            je desenharPontoXEmCima5

            jmp atualizaPosAntigas

            desenharPontoXEmCima5:

               carregar_figura buffer_pontoX, 138, 88, 30, 28

               cmp tanque1EmCima, 1
               je comparacoes1
               jmp atualizaPosAntigas

               comparacoes1:
                   cmp direcao, 1
                   je tankViadutoCima
                   cmp direcao, 2
                   je tankViadutoBaixo
                   cmp direcao, 3
                   je tankViadutoDireita
                   cmp direcao, 4
                   je tankViadutoEsquerda


            jmp atualizaPosAntigas

   caminhaoCima2:

                carregar_figura buffer_caminhao2C, posX_tank2, posY_tank2, tank_largura, tank_comprimento

                cmp tanque2EmCima, 0
                je desenharPontoXEmCima5Caminhao

                jmp atualizaPosAntigas

                desenharPontoXEmCima5Caminhao:

                   carregar_figura buffer_pontoX, 138, 88, 30, 28

                   cmp tanque1EmCima, 1
                   je comparacoes1Caminhao
                   jmp atualizaPosAntigas

                   comparacoes1Caminhao:
                       cmp direcao, 1
                       je tankViadutoCima
                       cmp direcao, 2
                       je tankViadutoBaixo
                       cmp direcao, 3
                       je tankViadutoDireita
                       cmp direcao, 4
                       je tankViadutoEsquerda


                jmp atualizaPosAntigas


   tankBaixo2:

             cmp ehTank2, 0
             je caminhaoBaixo2
             carregar_figura buffer_tank2B, posX_tank2, posY_tank2, tank_largura, tank_comprimento

             cmp tanque2EmCima, 0
             je desenharPontoXEmCima6
             jmp atualizaPosAntigas

             desenharPontoXEmCima6:
                 carregar_figura buffer_pontoX, 138, 88, 30, 28

                 cmp tanque1EmCima, 1
                 je comparacoes2
                 jmp atualizaPosAntigas

                 comparacoes2:
                     cmp direcao, 1
                     je tankViadutoCima
                     cmp direcao, 2
                     je tankViadutoBaixo
                     cmp direcao, 3
                     je tankViadutoDireita
                     cmp direcao, 4
                     je tankViadutoEsquerda


             jmp atualizaPosAntigas

    caminhaoBaixo2:

                carregar_figura buffer_caminhao2B, posX_tank2, posY_tank2, tank_largura, tank_comprimento

                cmp tanque2EmCima, 0
                je desenharPontoXEmCima6Caminhao
                jmp atualizaPosAntigas

                desenharPontoXEmCima6Caminhao:
                    carregar_figura buffer_pontoX, 138, 88, 30, 28

                    cmp tanque1EmCima, 1
                    je comparacoes2Caminhao
                    jmp atualizaPosAntigas

                    comparacoes2Caminhao:
                        cmp direcao, 1
                        je tankViadutoCima
                        cmp direcao, 2
                        je tankViadutoBaixo
                        cmp direcao, 3
                        je tankViadutoDireita
                        cmp direcao, 4
                        je tankViadutoEsquerda


                jmp atualizaPosAntigas



   tankDireita2:

               cmp ehTank2, 0
               je caminhaoDireita2
               carregar_figura buffer_tank2D, posX_tank2, posY_tank2, tank_comprimento, tank_largura

               cmp tanque2EmCima, 0
               je desenharPontoXEmCima7

               jmp atualizaPosAntigas

               desenharPontoXEmCima7:

                  carregar_figura buffer_pontoX, 138, 88, 30, 28

                  cmp tanque1EmCima, 1
                  je comparacoes3
                  jmp atualizaPosAntigas

                  comparacoes3:
                      cmp direcao, 1
                      je tankViadutoCima
                      cmp direcao, 2
                      je tankViadutoBaixo
                      cmp direcao, 3
                      je tankViadutoDireita
                      cmp direcao, 4
                      je tankViadutoEsquerda


               jmp atualizaPosAntigas

    caminhaoDireita2:

                carregar_figura buffer_caminhao2D, posX_tank2, posY_tank2, tank_comprimento, tank_largura

                cmp tanque2EmCima, 0
                je desenharPontoXEmCima7Caminhao

                jmp atualizaPosAntigas

                desenharPontoXEmCima7Caminhao:

                   carregar_figura buffer_pontoX, 138, 88, 30, 28

                   cmp tanque1EmCima, 1
                   je comparacoes3Caminhao
                   jmp atualizaPosAntigas

                   comparacoes3Caminhao:
                       cmp direcao, 1
                       je tankViadutoCima
                       cmp direcao, 2
                       je tankViadutoBaixo
                       cmp direcao, 3
                       je tankViadutoDireita
                       cmp direcao, 4
                       je tankViadutoEsquerda


                jmp atualizaPosAntigas


   tankEsquerda2:

               cmp ehTank2, 0
               je caminhaoEsquerda2
               carregar_figura buffer_tank2E, posX_tank2, posY_tank2, tank_comprimento, tank_largura

               cmp tanque2EmCima, 0
               je desenharPontoXEmCima8

               jmp atualizaPosAntigas

               desenharPontoXEmCima8:

                   carregar_figura buffer_pontoX, 138, 88, 30, 28

               cmp tanque1EmCima, 1
               je comparacoes4
               jmp atualizaPosAntigas

               comparacoes4:

                   cmp direcao, 1
                   je tankViadutoCima
                   cmp direcao, 2
                   je tankViadutoBaixo
                   cmp direcao, 3
                   je tankViadutoDireita
                   cmp direcao, 4
                   je tankViadutoEsquerda


               jmp atualizaPosAntigas

   caminhaoEsquerda2:

               carregar_figura buffer_caminhao2E, posX_tank2, posY_tank2, tank_comprimento, tank_largura

               cmp tanque2EmCima, 0
               je desenharPontoXEmCima8Caminhao

               jmp atualizaPosAntigas

               desenharPontoXEmCima8Caminhao:

                   carregar_figura buffer_pontoX, 138, 88, 30, 28

               cmp tanque1EmCima, 1
               je comparacoes4Caminhao
               jmp atualizaPosAntigas

               comparacoes4Caminhao:

                   cmp direcao, 1
                   je tankViadutoCima
                   cmp direcao, 2
                   je tankViadutoBaixo
                   cmp direcao, 3
                   je tankViadutoDireita
                   cmp direcao, 4
                   je tankViadutoEsquerda


               jmp atualizaPosAntigas


               tankViadutoCima:
                         cmp ehTank1, 1
                         je tanqueEmcimaDoViaduto
                         jmp caminhaoEmcimaDoViaduto

                         tanqueEmcimaDoViaduto:
                             carregar_figura buffer_tankC, posX_tank, posY_tank, tank_largura, tank_comprimento
                             jmp atualizaPosAntigas

                         caminhaoEmcimaDoViaduto:
                             carregar_figura buffer_caminhaoC, posX_tank, posY_tank, tank_largura, tank_comprimento

                         jmp atualizaPosAntigas

               tankViadutoBaixo:
                         cmp ehTank1, 1
                         je tanqueEmcimaDoViaduto2
                         jmp caminhaoEmcimaDoViaduto2

                         tanqueEmcimaDoViaduto2:
                             carregar_figura buffer_tankB, posX_tank, posY_tank, tank_largura, tank_comprimento
                             jmp atualizaPosAntigas

                         caminhaoEmcimaDoViaduto2:
                             carregar_figura buffer_caminhaoB, posX_tank, posY_tank, tank_largura, tank_comprimento

                         jmp atualizaPosAntigas

               tankViadutoDireita:
                         cmp ehTank1, 1
                         je tanqueEmcimaDoViaduto3
                         jmp caminhaoEmcimaDoViaduto3

                         tanqueEmcimaDoViaduto3:
                             carregar_figura buffer_tankD, posX_tank, posY_tank, tank_comprimento, tank_largura
                             jmp atualizaPosAntigas

                         caminhaoEmcimaDoViaduto3:
                             carregar_figura buffer_caminhaoD, posX_tank, posY_tank, tank_comprimento, tank_largura

                         jmp atualizaPosAntigas

               tankViadutoEsquerda:
                         cmp ehTank1, 1
                         je tanqueEmcimaDoViaduto4
                         jmp caminhaoEmcimaDoViaduto4


                         tanqueEmcimaDoViaduto4:
                             carregar_figura buffer_tankE, posX_tank, posY_tank, tank_comprimento, tank_largura
                             jmp atualizaPosAntigas

                         caminhaoEmcimaDoViaduto4:
                             carregar_figura buffer_caminhaoE, posX_tank, posY_tank, tank_comprimento, tank_largura

                         jmp atualizaPosAntigas


   atualizaPosAntigas:     ;s entra aqui se o tanque mudar de posio

             mov cx, posX_tank
             mov posX_tank_antiga, cx
             mov cx, posY_tank
             mov posY_tank_antiga, cx
             mov cx, posX_tank2
             mov posX_tank2_antiga, cx
             mov cx, posY_tank2
             mov posY_tank2_antiga, cx
             jmp sair4

   voltarPosAntigas:      ;entra aqui se os tanques se colidirem

             mov cx, posX_tank_antiga
             mov posX_tank, cx
             mov cx, posY_tank_antiga
             mov posY_tank, cx
             mov cx, posX_tank2_antiga
             mov posX_tank2, cx
             mov cx, posY_tank2_antiga
             mov posY_tank2, cx
             jmp pos_tank1

   sair4:


ENDM

;*******************************************************************************************************
;Macro que carrega no buffer as balas dos taqnues.
;*******************************************************************************************************

desenharBalas MACRO

            cmp balasTank, 0
            jl pos_bala2
            cmp naoImprimirBala1, 1
            je resetarPosBala      ;aqui
            cmp direcaoBala, 1
            je atirarCima_b1
            cmp direcaoBala, 2
            je atirarBaixo_b1
            cmp direcaoBala, 3
            je atirarDireita_b1
            cmp direcaoBala, 4
            je atirarEsquerda_b1
            jmp pos_bala2

   atirarCima_b1 :

              cmp posY_bala, 0
              jg atirarCima2_b1
              jmp resetarPosBala

   atirarCima2_b1 :

              carregar_figura buffer_balaVert, posX_bala, posY_bala, bala_largura, bala_comprimento
              sub posY_bala, 3
              jmp pos_bala2

   atirarBaixo_b1 :

              cmp posY_bala, 200
              jl atirarBaixo2_b1
              jmp resetarPosBala

   atirarBaixo2_b1 :

              carregar_figura buffer_balaVert, posX_bala, posY_bala, bala_largura, bala_comprimento
              add posY_bala, 3
              jmp pos_bala2

   atirarDireita_b1 :

              cmp posX_bala, 315
              jl atirarDireita2_b1
              jmp resetarPosBala

   atirarDireita2_b1:

            carregar_figura buffer_bala, posX_bala, posY_bala, bala_comprimento, bala_largura

            ; paulo inicio
            cmp tanque1EmCima, 0
            je desenharPontoXEmCima9

            jmp fimAtirarDireita2_b1

            desenharPontoXEmCima9:

                   carregar_figura buffer_pontoX, 138, 88, 30, 28

            fimAtirarDireita2_b1:
            ;paulo fim
            add posX_bala, 3
            jmp pos_bala2

   atirarEsquerda_b1 :

              cmp posX_bala, 0
              jg atirarEsquerda2_b1
              jmp resetarPosBala

   atirarEsquerda2_b1:

            carregar_figura buffer_bala, posX_bala, posY_bala, bala_comprimento, bala_largura
            ; paulo inicio

            cmp tanque1EmCima, 0
            je desenharPontoXEmCima10

            jmp fimAtirarEsquerda2_b1

            desenharPontoXEmCima10:

                 carregar_figura buffer_pontoX, 138, 88, 30, 28

            fimAtirarEsquerda2_b1:
            ;paulo fim

            sub posX_bala, 3
            jmp pos_bala2

   pos_bala2:

            cmp balasTank2, 0
            jl resetarPosBala2
            cmp naoImprimirBala2, 1
            je resetarPosBala2
            cmp direcaoBala2, 1
            je atirarCima_b2
            cmp direcaoBala2, 2             ; o erro ocorre quando o tank2  atingido. Simplesmente
            je atirarBaixo_b2                 ;as posies da bala1 no so atualizadas pra zero
            cmp direcaoBala2, 3
            je atirarDireita_b2
            cmp direcaoBala2, 4
            je atirarEsquerda_b2
            jmp resetarPosBala2

   atirarCima_b2 :

              cmp posY_bala2, 0
              jg atirarCima2_b2
              jmp resetarPosBala2

   atirarCima2_b2 :

              carregar_figura buffer_balaVert, posX_bala2, posY_bala2, bala_largura, bala_comprimento
              sub posY_bala2, 3
              jmp sair5

   atirarBaixo_b2 :

              cmp posY_bala2, 200
              jl atirarBaixo2_b2
              jmp resetarPosBala2

   atirarBaixo2_b2 :

              carregar_figura buffer_balaVert, posX_bala2, posY_bala2, bala_largura, bala_comprimento
              add posY_bala2, 3
              jmp sair5

   atirarDireita_b2 :

              cmp posX_bala2, 315
              jl atirarDireita2_b2
              jmp resetarPosBala2

   atirarDireita2_b2:

            carregar_figura buffer_bala, posX_bala2, posY_bala2, bala_comprimento, bala_largura
            ; paulo inicio
            cmp tanque2EmCima, 0
            je desenharPontoXEmCima11
            jmp fimAtirarDireita2_b2

            desenharPontoXEmCima11:
                carregar_figura buffer_pontoX, 138, 88, 30, 28

            fimAtirarDireita2_b2:
              ;paulo fim

            add posX_bala2, 3
            jmp sair5

   atirarEsquerda_b2 :

              cmp posX_bala2, 0
              jg atirarEsquerda2_b2
              jmp resetarPosBala2

   atirarEsquerda2_b2:

            carregar_figura buffer_bala, posX_bala2, posY_bala2, bala_comprimento, bala_largura
            ; paulo inicio

            cmp tanque2EmCima, 0
            je desenharPontoXEmCima12
            jmp fimAtirarEsquerda2_b2

            desenharPontoXEmCima12:
                  carregar_figura buffer_pontoX, 138, 88, 30, 28

            fimAtirarEsquerda2_b2:
            ;paulo fim

            sub posX_bala2, 3
            jmp sair5

    resetarPosBala :

              mov posX_bala, 0
              mov posY_bala, 0
              mov tiroPress, 0
              mov direcaoBala, 0
              jmp pos_bala2
              ;jmp resetarPosBala2   ;aqui

   resetarPosBala2 :
              ;DesenhaTankPiscando
              mov posX_bala2, 0
              mov posY_bala2, 0
              mov tiroPress, 0
              mov direcaoBala2, 0
              jmp sair5

   sair5:
; paulo - para desenhar o tanque quando a bala passa por baixo e ele estiver em cima.

              cmp temTanqueNoPontoX, 1
              je desenharTanque1EmCima
              jmp fimDesenharBalas

              desenharTanque1EmCima:
                   cmp tanque1EmCima, 1
                   je comparacoes5
                   cmp tanque2EmCima, 1
                   je desenharTanque2EmCima

                   jmp fimDesenharBalas

                   comparacoes5:

                   cmp direcao, 1
                   je tankViadutoCima2
                   cmp direcao, 2
                   je tankViadutoBaixo2
                   cmp direcao, 3
                   je tankViadutoDireita2
                   cmp direcao, 4
                   je tankViadutoEsquerda2



                   jmp fimDesenharBalas


                   tankViadutoCima2:
                       cmp ehTank1, 1
                       je tanqueEmcimaDoViaduto5
                       jmp caminhaoEmcimaDoViaduto5

                       tanqueEmcimaDoViaduto5:
                            carregar_figura buffer_tankC, posX_tank, posY_tank, tank_largura, tank_comprimento
                            jmp fimDesenharBalas

                       caminhaoEmcimaDoViaduto5:
                            carregar_figura buffer_caminhaoC, posX_tank, posY_tank, tank_largura, tank_comprimento

                       jmp fimDesenharBalas


                   tankViadutoBaixo2:
                       cmp ehTank1, 1
                       je tanqueEmcimaDoViaduto6
                       jmp caminhaoEmcimaDoViaduto6

                       tanqueEmcimaDoViaduto6:
                           carregar_figura buffer_tankB, posX_tank, posY_tank, tank_largura, tank_comprimento
                           jmp fimDesenharBalas

                       caminhaoEmcimaDoViaduto6:
                           carregar_figura buffer_caminhaoB, posX_tank, posY_tank, tank_largura, tank_comprimento

                       jmp fimDesenharBalas


                   tankViadutoDireita2:
                       cmp ehTank1, 1
                       je tanqueEmcimaDoViaduto7
                       jmp caminhaoEmcimaDoViaduto7

                       tanqueEmcimaDoViaduto7:
                            carregar_figura buffer_tankD, posX_tank, posY_tank, tank_comprimento, tank_largura
                            jmp fimDesenharBalas

                       caminhaoEmcimaDoViaduto7:
                            carregar_figura buffer_caminhaoD, posX_tank, posY_tank, tank_comprimento, tank_largura

                       jmp fimDesenharBalas


                   tankViadutoEsquerda2:
                       cmp ehTank1, 1
                       je tanqueEmcimaDoViaduto8
                       jmp caminhaoEmcimaDoViaduto8

                       tanqueEmcimaDoViaduto8:
                            carregar_figura buffer_tankE, posX_tank, posY_tank, tank_comprimento, tank_largura
                            jmp fimDesenharBalas

                       caminhaoEmcimaDoViaduto8:
                            carregar_figura buffer_caminhaoE, posX_tank, posY_tank, tank_comprimento, tank_largura

                       jmp fimDesenharBalas



              desenharTanque2EmCima:

                   cmp direcao2, 1
                   je tank2ViadutoCima2
                   cmp direcao2, 2
                   je tank2ViadutoBaixo2
                   cmp direcao2, 3
                   je tank2ViadutoDireita2
                   cmp direcao2, 4
                   je tank2ViadutoEsquerda2



                   jmp fimDesenharBalas


                   tank2ViadutoCima2:
                       cmp ehTank2, 1
                       je tanque2EmcimaDoViaduto
                       jmp caminhao2EmcimaDoViaduto

                       tanque2EmcimaDoViaduto:
                           carregar_figura buffer_tank2C, posX_tank2, posY_tank2, tank_largura, tank_comprimento
                           jmp fimDesenharBalas

                       caminhao2EmcimaDoViaduto:
                           carregar_figura buffer_caminhao2C, posX_tank2, posY_tank2, tank_largura, tank_comprimento

                       jmp fimDesenharBalas


                   tank2ViadutoBaixo2:
                       cmp ehTank2, 1
                       je tanque2EmcimaDoViaduto2
                       jmp caminhao2EmcimaDoViaduto2

                       tanque2EmcimaDoViaduto2:
                           carregar_figura buffer_tank2B, posX_tank2, posY_tank2, tank_largura, tank_comprimento
                           jmp fimDesenharBalas

                       caminhao2EmcimaDoViaduto2:
                           carregar_figura buffer_caminhao2B, posX_tank2, posY_tank2, tank_largura, tank_comprimento

                       jmp fimDesenharBalas


                   tank2ViadutoDireita2:
                       cmp ehTank2, 1
                       je tanque2EmcimaDoViaduto3
                       jmp caminhao2EmcimaDoViaduto3

                       tanque2EmcimaDoViaduto3:
                           carregar_figura buffer_tank2D, posX_tank2, posY_tank2, tank_comprimento, tank_largura
                           jmp fimDesenharBalas

                       caminhao2EmcimaDoViaduto3:
                           carregar_figura buffer_caminhao2D, posX_tank2, posY_tank2, tank_comprimento, tank_largura

                       jmp fimDesenharBalas


                   tank2ViadutoEsquerda2:
                       cmp ehTank2, 1
                       je tanque2EmcimaDoViaduto4
                       jmp caminhao2EmcimaDoViaduto4

                       tanque2EmcimaDoViaduto4:
                           carregar_figura buffer_tank2E, posX_tank2, posY_tank2, tank_comprimento, tank_largura
                           jmp fimDesenharBalas

                       caminhao2EmcimaDoViaduto4:
                            carregar_figura buffer_caminhao2E, posX_tank2, posY_tank2, tank_comprimento, tank_largura


                       jmp fimDesenharBalas


        fimDesenharBalas:


ENDM


;*********************************************************************************************************************
;                                                                                                                    *
;Macro desenharTudo                                                                                                  *
;                                                                                                                    *
;Descrio: Essa macro carrega o plano de fundo e o tank para o buffer principal e depois descarrega todo buffer     *
;           no video. a posio do tank  calculada em funo da varivel direo.                                   *
;*********************************************************************************************************************



;---------------------------------------------------------------------------------------------------------------------
;Fim desenhaTudo
;---------------------------------------------------------------------------------------------------------------------

;*********************************************************************************************************************
;                                                                                                                    *
;Procedimento inicializar_jogo                                                                                       *
;                                                                                                                    *
;Descrio: Procedimento que ir executar rotinas para necessrias para iniciarmos um novo jogo                      *
;*********************************************************************************************************************
inicializar_jogo PROC NEAR

     ;PONTUAO INICIAL

            mov ptsPedro, 100
            mov ptsBino, 100

;********************PARTE MODIFICADA********************************
            mov vitoriasPedro, 0
            mov vitoriasBino, 0
;********************************************************************

            call carrega_buffer            ;carrega todas as figuras do jogo no seu devido buffer
            call SetarInt15                 ;muda a intrrup 15h
            call SetarInt1C
            call inicializar_fases

inicializar_jogo ENDP

;---------------------------------------------------------------------------------------------------------------------
;Fim inicializar_jogo
;---------------------------------------------------------------------------------------------------------------------

inicializar_fases PROC NEAR

         ;SETA AS POSIES INICIAIS DE CADA FIGURA NA TELA
            mov posX_tank, 2                ;seta as posies iniciais dos dois tanques e da bala
            mov posY_tank, 185
            mov posX_tank_antiga, 2
            mov posY_tank_antiga, 2
            mov posX_tank2, 295
            mov posY_tank2, 2
            mov posX_tank2_antiga, 100
            mov posY_tank2_antiga, 100
            mov posX_bala, 0
            mov posY_bala, 0
            mov posX_bala2, 0
            mov posY_bala2, 0
            mov posX_item, 20
            mov posY_item, 80
            mov posX_item2, 250
            mov posY_item2, 150

            mov direcao, 3                  ;tank1 aparecer apontando para direita
            mov direcao2, 4                 ;tank2 aparecer apontando para esquerda
            mov direcaoBala, 0
            mov direcaoBala2, 0

            mov vidasTank2, 3
            mov vidasTank, 3
            mov balasTank, 10
            mov balasTank2, 10
            mov espera, 1
            mov explodiu, 0
            mov explosaoTank1, 0
            mov explosaoTank2, 0
            mov seed2, 0
            mov apareceu_item, 0
            mov apareceu_item2, 0
            mov vamos, 0
            mov vamos2, 0
            mov vamos3, 0
            mov vamos4, 0
            mov ehTank1, 0
            mov ehTank2, 0
            mov confrontos, 0
            mov confrontos2, 0
            mov confrontos3, 0
            mov tempoConfrontos, 0
            mov contEstrelas, 0

            mov tanque1EmCima, 1
            mov tanque2EmCima, 1
            mov bala1EmCima, 1
            mov bala2EmCima, 1
            mov temTanqueNoPontoX, 0
            mov tanque1NoPontoAbastecimento, 0
            mov tanque2NoPontoAbastecimento, 0

     ;ZERA VARIAVEIS UTILIZADAS PARA TRATAR O TECLADO
            mov DS:[varEsc], 0
            mov DS:[varEsquerda1], 0
            mov DS:[varDireita1], 0
            mov DS:[varCima1], 0
            mov DS:[varBaixo1], 0
            mov DS:[varTiro1], 0
            mov DS:[varEsquerda2], 0
            mov DS:[varDireita2], 0
            mov DS:[varCima2], 0
            mov DS:[varBaixo2], 0
            mov DS:[varTiro2], 0
            mov DS:[varF1], 0
            mov DS:[varF2], 0

            mov boom, 0                     ;ninguem explodiu (ainda)
            mov SEC, 0
            mov MSEC, 0

            call Rand2                     ;calcula de forma aleatoria o tempo em que o item aparecer na tela
            mov AX, seed2                  ;atribui o resultado a tempo_item
            mov tempo_item, AX
            mov tank1_item1, 0

            mov colidiu_item, 0
            mov colidiu_item2, 0

inicializar_fases ENDP


Delay      PROC NEAR
   pusha
   push ds

   mov ax, @data
   mov ds, ax
   mov bh, espera
   cmp bh,0
   je fimDelay
   loopDelay:
   call CoolDown

   dec bh
   cmp bh, 0
   jne loopDelay
   fimDelay:
   pop ds

   popa

   ret

Delay ENDP

;----------------------------------------------------------------------------------------------------------------------
;Fim Delay
;----------------------------------------------------------------------------------------------------------------------

CoolDown 	PROC	NEAR

;Empilha dx, ax
push dx ax ds

;Porta do registrador de status do monitor
mov dx, 03DAh

;Espera o bit 3 zerar (periodo ativo)
loop1:
  in   al, dx
  test al, 8
  jnz  loop1

;Espera o bit 3 setar (periodo de retraco)

loop2:
  in   al, dx
  test al, 8
  jz   loop2

;Desempilha ax, dx
pop ds ax dx
ret

CoolDown    ENDP

;***************************************************************************************************************
;Procedimento que verifica se houve coliso entre os tanques.
;Quando ocorre coliso, a varivel naoImprimir recebe 1.
;***************************************************************************************************************
colisaoTanques PROC NEAR

        push ax cx dx bx
        mov ax, @data
        mov ds, ax

        mov cx, posX_tank
        add cx, 14
        mov ax, posX_tank
        mov bx, posX_tank2
        add bx, 16

        choqueX:                          ;compara as posies X dos dois tanques
               cmp cx, posX_tank2
               jl tchau
               cmp bx, posX_tank
               jl tchau
               jmp setaValores1

        setaValores1:
                mov cx, posY_tank
                add cx, 14
                mov ax, posY_tank2
                mov bx, posY_tank2
                add bx, 12
        vert:
             cmp cx, ax                   ;compara as posies Y dos dois tanques
             jl tchau
             cmp bx, posY_tank
             jl tchau
             jmp chocou

        chocou:
               mov naoImprimir, 1
               jmp sair2

        tchau :
              mov naoImprimir, 0         ;se no houve coliso "naoImprimir"  setado para 0

        sair2:
              pop bx dx cx ax
              ret

colisaoTanques endP

;****************************************************************************************************************
;Procedimento que verifica se a bala do tanque1 colidiu com o tanque2.
;Quando ocorre coliso as variveis "naoImprimirBala1" e "acretou2" recebem 1,
;e a vida do tanque2  decrementada.
;****************************************************************************************************************
colisaoBala1 PROC NEAR

             push ax cx dx bx
             mov ax, @data
             mov ds, ax

             mov cx, posY_tank2
             add cx, 14
             mov bx, posX_bala
             mov ax, posX_tank2
             add ax, 17

             choque1:                        ;compara a posio X do tanque2 com a posicao X da bala1
                     cmp bx, posX_tank2
                     jl tchau2
                     cmp ax, bx
                     jl tchau2
                     jmp setaValores2

             setaValores2:                  ;compara a posio Y do tanque2 com a posicao Y da bala1
                     mov bx, posY_bala
                     cmp bx, posY_tank2
                     jl tchau2
                     cmp cx, bx
                     jl tchau2
                     jmp chocouBala

             chocouBala:          ;entra aqui se houve choque de bala. segundo jogador perde ponto

                    sub ptsBino, 15           ;bino perde 15 pts por errar o tiro
                    cmp ehTank1, 0            ;compara se  caminhao ainda
                    je pontoBalaCaminhao      ;pula para esse rotulo se for caminhao ainda
                    add ptsPedro, 20          ;se pedro for um tanque ganha 20 pts.
                    jmp continuaChocouBala

             pontoBalaCaminhao:

                    add ptsPedro, 15           ;se pedro acertou a bala como um caminhao ele ganha 15 pts

             continuaChocouBala:

                    mov naoImprimirBala1, 1
                    mov acertou2, 1
                    cmp ehTank2, 1        ;se for tanque, pula para outro rtulo.
                    je chocouTank2
                    sub vidasTank2, 1     ;decrementa quando o jogador atingido for caminho.
                    mov ehTank2, 0
                    jmp sair3

             chocouTank2:          ;esse rtulo decrementa a vida quando o jogador  um tanque.

                       cmp contadorVidas2, 0     ;o tanque precisa ser atingido duas vezes para perder uma vida.
                       je setaContadorVidas2
                       sub vidasTank2, 1
                       mov ehTank2, 0
                       mov contadorVidas2, 0
                       jmp sair3

             setaContadorVidas2:
                               mov contadorVidas2, 1   ;contadorVidas = 1, quer dizer que o tanque j foi atingido uma vez e
                                                       ;se for atingido mais uma vez perder uma vida.
                               jmp sair3

               tchau2 :
                     mov naoImprimirBala1, 0    ;se no houve coliso, "naoImprimirBala1  setado para 1

              sair3:
                    pop bx dx cx ax
                    ret

colisaoBala1 endP

;****************************************************************************************************************
;Procedimento que verifica se a bala do tanque2 colidiu com o tanque1.
;Quando ocorre coliso as variveis "naoImprimirBala2" e "acretou1" recebem 1,
;e a vida do tanque1  decrementada.
;****************************************************************************************************************
colisaoBala2 PROC NEAR

             push ax cx dx bx
             mov ax, @data
             mov ds, ax

             mov cx, posY_tank
             add cx, 14
             mov bx, posX_bala2
             mov ax, posX_tank
             add ax, 17

             choque2:
                     cmp bx, posX_tank       ;compara a posio X do tanque1 com a posicao X da bala2
                     jl tchau3
                     cmp ax, bx
                     jl tchau3
                     jmp setaValores3

             setaValores3:                  ;compara a posio Y do tanque1 com a posicao Y da bala2
                     mov bx, posY_bala2
                     cmp bx, posY_tank
                     jl tchau3
                     cmp cx, bx
                     jl tchau3
                     jmp chocouBala2

             chocouBala2:

                    sub ptsPedro, 15          ;pedro perde 15 pts por levar o tiro

                    cmp ehTank2, 0            ;compara se  caminhao ainda
                    je pontoBalaCaminhao2      ;pula para esse rotulo se for caminhao ainda
                    add ptsBino, 20           ;se Bino for um tanque ganha 20 pts.
                    jmp continuaChocouBala2

             pontoBalaCaminhao2:

                    add ptsBino, 15           ;se pedro acertou a bala como um caminhao ele ganha 15 pts

             continuaChocouBala2:

                    mov naoImprimirBala2, 1
                    mov acertou, 1
                    cmp ehTank1, 1            ;se for tanque, pula para outro rtulo.
                    je chocouTank1
                    sub vidasTank, 1          ;decrementa quando o jogador atingido for caminho.
                    mov ehTank1, 0
                    jmp sair6

             chocouTank1:                     ;esse rtulo decrementa a vida quando o jogador  um tanque.

                       cmp contadorVidas1, 0      ;o tanque precisa ser atingido duas vezes para perder uma vida.
                       je setaContadorVidas1
                       sub vidasTank, 1
                       mov ehTank1, 0
                       mov contadorVidas1, 0
                       jmp sair3

             setaContadorVidas1:
                               mov contadorVidas1, 1   ;contadorVidas1 = 1, quer dizer que o tanque j foi atingido uma vez e
                                                       ;se for atingido mais uma vez perder uma vida.
                               jmp sair3

               tchau3 :
                     mov naoImprimirBala2, 0         ;se no houve coliso, "naoImprimirBala2  setado para 1

              sair6:
                    pop bx dx cx ax
                    ret

colisaoBala2 endP



colisaoTanque1Item PROC NEAR

        push ax cx dx bx
        mov ax, @data
        mov ds, ax

        cmp ehTank1, 1
        je sair24
        cmp apareceu_item, 1
        jne colisaoTanque1Item2
        ;jne sair24

        mov cx, posX_tank
        add cx, 14
        mov ax, posX_tank
        mov bx, posX_item
        add bx, 2;10

        choqueX4:
               cmp cx, posX_item
               jl tchau4
               cmp bx, posX_tank
               jl tchau4
               jmp setaValores4

        setaValores4:
                mov cx, posY_tank
                add cx, 14
                mov ax, posY_item
                add ax, 4
                mov bx, posY_item
                add bx, 4;8
        vert4:
             cmp cx, ax
             jl tchau4
             cmp bx, posY_tank
             jl tchau4
             jmp chocou4

        chocou4:

               add ptsPedro, 50
               mov ehTank1, 1
               mov apareceu_item, 0
               ;jmp sair24
               jmp colisaoTanque1Item2

        tchau4 :
              jmp colisaoTanque1Item2


        colisaoTanque1Item2:

                     cmp apareceu_item2, 1
                     jne sair24

                     mov cx, posX_tank
                     add cx, 14
                     mov ax, posX_tank
                     mov bx, posX_item2
                     add bx, 2;10

        choqueX5:
               cmp cx, posX_item2
               jl tchau5
               cmp bx, posX_tank
               jl tchau5
               jmp setaValores5

        setaValores5:
                mov cx, posY_tank
                add cx, 14
                mov ax, posY_item2
                add ax, 4
                mov bx, posY_item2
                add bx, 4;8
        vert5:
             cmp cx, ax
             jl tchau5
             cmp bx, posY_tank
             jl tchau5
             jmp chocou5

        chocou5:

               add ptsPedro, 50
               mov ehTank1, 1
               mov apareceu_item2, 0
               jmp sair24

        tchau5:

        sair24:
              pop bx dx cx ax
              ret

colisaoTanque1Item endP

;------------------------------------------------------------------------------------------------------------------

colisaoTanque2Item PROC NEAR

        push ax cx dx bx
        mov ax, @data
        mov ds, ax

        cmp ehTank2, 1
        je sair25
        cmp apareceu_item, 1
        jne colisaoTanque2Item2
        ;jne sair24

        mov cx, posX_tank2
        add cx, 14
        mov ax, posX_tank2
        mov bx, posX_item
        add bx, 2;6;10

        choqueX6:
               cmp cx, posX_item
               jl tchau6
               cmp bx, posX_tank2
               jl tchau6
               jmp setaValores6

        setaValores6:
                mov cx, posY_tank2
                add cx, 14
                mov ax, posY_item
                add ax, 4
                mov bx, posY_item
                add bx, 4;8
        vert6:
             cmp cx, ax
             jl tchau6
             cmp bx, posY_tank2
             jl tchau6
             jmp chocou6

        chocou6:

               add ptsBino, 50
               mov ehTank2, 1
               mov apareceu_item, 0
               ;jmp sair24
               jmp colisaoTanque2Item2

        tchau6 :
              jmp colisaoTanque2Item2


        colisaoTanque2Item2:

                     cmp apareceu_item2, 1
                     jne sair25

                     mov cx, posX_tank2
                     add cx, 14
                     mov ax, posX_tank2
                     mov bx, posX_item2
                     add bx, 2;6;10

        choqueX7:
               cmp cx, posX_item2
               jl tchau7
               cmp bx, posX_tank2
               jl tchau7
               jmp setaValores7

        setaValores7:
                mov cx, posY_tank2
                add cx, 14
                mov ax, posY_item2
                add ax, 4;2
                mov bx, posY_item2
                add bx, 4;6;8
        vert7:
             cmp cx, ax
             jl tchau7
             cmp bx, posY_tank2
             jl tchau7
             jmp chocou7

        chocou7:

               add ptsBino, 50
               mov ehTank2, 1
               mov apareceu_item2, 0
               jmp sair25

        tchau7:

        sair25:
              pop bx dx cx ax
              ret

colisaoTanque2Item endP


;------------------------------------------------------------------------------------------------------------------------------------

colisaoTankCenario PROC NEAR

                push AX
                push BX
                push CX
                push DX
                push DS
                push ES
                push DI

                mov AX, @data
                mov DS, AX

;----------------------------------------------------------------------------------------------------
                ;tank1
;----------------------------------------------------------------------------------------------------

                ;zera DI
                xor DI, DI

                ;DI vai apontar para o primeiro pixel do tank1
                mov bx, posX_tank       ;posicoes atualizadas
                mov dx, posY_tank
                mov di, bx
                mov bx, dx
                shl dx, 8                ;shift left 8 vezes
                shl bx, 6                ;shif left 6 vezes
                add dx, bx
                add di, dx               ;pos_y*320 + pos_X

                mov AX, SEG buffer_mascara
                mov ES, AX                          ;ES:[DI] aponta para o primeiro pixel do tank dentro da mascara

                cmp direcao, 1
                je vertical
                cmp direcao, 2
                je vertical
                cmp direcao, 3
                je horizontal
                cmp direcao, 4
                je horizontal
                jmp colisaoTank2
                ;jmp tt

                vertical:

                     mov DX, 0Fh;10h;tank_largura - voltar para 10h caso no de certo - pftbm 05-11-05
                     mov BX, 0Fh;tank_comprimento
                     jmp loop_linha
                horizontal:

                     mov DX, 0fh;tank_comprimento
                     mov BX, 0fh;tank_largura


                loop_linha:

                 mov CX, BX

                 loop_coluna:

                      mov AH, ES:[DI]            ;move um byte do buffer da figura para AH
                      cmp AH, 000h          ;compara AH com o codigo de uma cor que no deve ser imprimida
                      je colidiu

                      continuar:


                       ; PAULO acrescentou daqui at o "incrementa:"
                      ; verificar se est no pontoX

                       call setarSituacaoTanque1

                      ; fim setarSituacaoTanque1

                     ; continuar2:

                      cmp AH, 0FFh; BRANCO - para ver se o tanque esta no ponto de abastecimento de balas
                      je setarTanque1PontoAbastecimento
                      jmp resetarTanque1PontoAbastecimento

                      setarTanque1PontoAbastecimento:
                          mov tanque1NoPontoAbastecimento, 1
                          jmp pularResetarTanque1PontoAbastecimento

                      resetarTanque1PontoAbastecimento:
                          mov tanque1NoPontoAbastecimento, 0

                      pularResetarTanque1PontoAbastecimento:

                      cmp AH, 0E0h ; vermelha
                      je tanqueNoPontoX
                      cmp AH, 003h ; azul
                      je tanqueNoPontoX
                      cmp AH, 010h ; verde ; PAULO 02-11-05
                      je tanqueNoPontoX    ; PAULO 02-11-05
                      cmp AH, 0FFh; BRANCO
                      je tanqueNoPontoX    ; PAULO 02-11-05

                      semTanqueNoPontoX:
                          mov temTanqueNoPontoX, 0
                          jmp comparacaoTanque1Embaixo

                      tanqueNoPontoX:
                          mov temTanqueNoPontoX, 1

                      ; comparaes para o tanque ficar barrado no ponto X

                      comparacaoTanque1Embaixo:

                          cmp tanque1EmCima, 0
                          je comparaCorAzul
                          jmp comparacaoTanque1EmCima

                          comparaCorAzul:
                                  cmp AH, 003h
                                  je colidiu


                      comparacaoTanque1EmCima:
                              cmp tanque1EmCima, 1
                              je comparaCorVermelha
                              jmp incrementa

                              comparaCorVermelha:
                                  cmp AH, 0E0h
                                  je colidiu


                      incrementa:  ; paulo

                      inc DI


                 loop loop_coluna           ;volta para o loop coluna_loop

                 add DI, 320
                 sub DI, BX                   ;DI recebe 320-largura.
                 dec DX                        ;decrementa o valor de DX
                 cmp DX, 0                     ;compara o valor de DX com zero para saber se chegou ao fim do linha_loop
                 jne loop_linha                ;volta para linha_loop caso DX for diferente de zero

                 jmp colisaoTank2
                 ;jmp tt
                colidiu:

                        ;retoma os valores antigos das posicoes do tank
                        mov AX, posX_tank_antiga
                        mov posX_tank, AX

                        mov AX, posY_tank_antiga
                        mov posY_tank, AX

                        jmp continuar

                 ;tt:
;-----------------------------------------------------------------------------------------
;                              Tank2
;-----------------------------------------------------------------------------------------
 colisaoTank2:


                xor DI, DI

                ;DI vai apontar para o primeiro pixel do tank1
                mov bx, posX_tank2      ;posicoes atualizadas
                mov dx, posY_tank2
                mov di, bx
                mov bx, dx
                shl dx, 8                ;shift left 8 vezes
                shl bx, 6                ;shif left 6 vezes
                add dx, bx
                add di, dx               ;pos_y*320 + pos_X

                mov AX, SEG buffer_mascara
                mov ES, AX                          ;ES:[DI] aponta para o primeiro pixel do tank dentro da mascara

                cmp direcao2, 1
                je vertical2
                cmp direcao2, 2
                je vertical2
                cmp direcao2, 3
                je horizontal2
                cmp direcao2, 4
                je horizontal2
                jmp fimColi

                vertical2:

                     mov DX, 0Fh;tank_largura ;   - paulo substituiu 05-11-05
                     mov BX, 0fh;tank_comprimento
                     jmp loop_linha2
                horizontal2:

                     mov DX, 0fh
                     mov BX, 0fh


                loop_linha2:

                 mov CX, BX

                 loop_coluna2:

                      mov AH, ES:[DI]            ;move um byte do buffer da figura para AH
                      cmp AH, 000h          ;compara AH com o codigo de uma cor que no deve ser imprimida
                      je colidiu2

                      continuar3: ; PAULO acrescentou daqui at da linha de "incrementa:"

                      call setarSituacaoTanque2


                      ; fim setarSituacaoTanque2
                      ; continuar4:


                      cmp AH, 0FFh; BRANCO - para ver se o tanque esta no ponto de abastecimento de balas
                      je setarTanque2PontoAbastecimento
                      jmp resetarTanque2PontoAbastecimento

                      setarTanque2PontoAbastecimento:
                          mov tanque2NoPontoAbastecimento, 1
                          jmp pularResetarTanque2PontoAbastecimento

                      resetarTanque2PontoAbastecimento:
                          mov tanque2NoPontoAbastecimento, 0

                      pularResetarTanque2PontoAbastecimento:


                      cmp temTanqueNoPontoX, 0
                      je verificaTanqueNoCentro
                      jmp comparacaoTanque2Embaixo2

                      verificaTanqueNoCentro:

                      cmp AH, 010h  ; verde ; PAULO 02-11-05
                      je tanqueNoPontoX2    ; PAULO 02-11-05
                      cmp AH, 003h  ; azul
                      je tanqueNoPontoX2
                      cmp AH, 0FFh; BRANCO
                      je tanqueNoPontoX2    ; PAULO 02-11-05



                      semTanqueNoPontoX2:
                          mov temTanqueNoPontoX, 0
                          jmp comparacaoTanque2Embaixo2

                      tanqueNoPontoX2:
                          mov temTanqueNoPontoX, 1


                      comparacaoTanque2Embaixo2:
                              cmp tanque2EmCima, 0
                              je comparaCorAzul2
                              jmp comparacaoTanque2EmCima

                              comparaCorAzul2:
                                  cmp AH, 003h
                                  je colidiu2


                      comparacaoTanque2EmCima:
                              cmp tanque2EmCima, 1
                              je comparaCorVermelha2
                              jmp incrementa2

                              comparaCorVermelha2:
                                  cmp AH, 0E0h
                                  je colidiu2


                      incrementa2:

                      inc DI


                 loop loop_coluna2           ;volta para o loop coluna_loop

                 add DI, 320
                 sub DI, BX                   ;DI recebe 320-largura.
                 dec DX                        ;decrementa o valor de DX
                 cmp DX, 0                     ;compara o valor de DX com zero para saber se chegou ao fim do linha_loop
                 jne loop_linha2                ;volta para linha_loop caso DX for diferente de zero

                 jmp fimColi

                colidiu2:

                        ;retoma os valores antigos das posicoes do tank
                        mov AX, posX_tank2_antiga
                        mov posX_tank2, AX

                        mov AX, posY_tank2_antiga
                        mov posY_tank2, AX
                        
                        jmp continuar3

                fimColi:

                 pop DI
                 pop ES
                 pop DS
                 pop DX
                 pop CX
                 pop BX
                 pop AX
                 RET

colisaoTankCenario ENDP
;----------------------------------------------------------------------------------------------------------------
;Fim colisaoTankCenario
;----------------------------------------------------------------------------------------------------------------

setarSituacaoTanque1 PROC NEAR

      cmp AH, 0E1h ; rosa - para ver se o tanque est embaixo
      je setarTanque1Embaixo
      cmp AH, 0FCh ; amarelo
      je setarTanque1EmCima
      jmp fimSetarSituacaoTanque1

      setarTanque1Embaixo:
          mov tanque1EmCima, 0
          jmp fimSetarSituacaoTanque1

      setarTanque1EmCima:
          mov tanque1EmCima, 1


      fimSetarSituacaoTanque1:

      RET
setarSituacaoTanque1 ENDP

;**************************************************************************************************

setarSituacaoTanque2 PROC NEAR

                      cmp AH, 0E1h ; rosa
                      je setarTanque2Embaixo
                      jmp setarTanque2EmCima

                      setarTanque2Embaixo:
                          mov tanque2EmCima, 0
                          jmp fimSetarSituacaoTanque2


                      setarTanque2EmCima:
                          cmp AH, 0FCh ; amarelo
                          je setarTanque2EmCima2
                          jmp fimSetarSituacaoTanque2

                          setarTanque2EmCima2:
                              mov tanque2EmCima, 1

                       fimSetarSituacaoTanque2:
                       
                       RET

setarSituacaoTanque2 ENDP

;***********************************************************************************************************
colisaoBalaCenario PROC NEAR


                push AX
                push BX
                push CX
                push DX
                push DS
                push ES
                push DI

                mov AX, @data
                mov DS, AX

;----------------------------------------------------------------------------------------------------
                ;tank1
;----------------------------------------------------------------------------------------------------

                ;zera DI
                xor DI, DI

                ;DI vai apontar para o primeiro pixel do tank1
                mov bx, posX_bala       ;posicoes atualizadas
                mov dx, posY_bala
                mov di, bx
                mov bx, dx
                shl dx, 8                ;shift left 8 vezes
                shl bx, 6                ;shif left 6 vezes
                add dx, bx
                add di, dx               ;pos_y*320 + pos_X

                mov AX, SEG buffer_mascara
                mov ES, AX                          ;ES:[DI] aponta para o primeiro pixel da bala dentro da mascara

                cmp direcaoBala, 1
                je verticalBala
                cmp direcaoBala, 2
                je verticalBala
                cmp direcaoBala, 3
                je horizontalBala
                cmp direcaoBala, 4
                je horizontalBala
                jmp colisaoBala2Cenario

                verticalBala:

                     mov DX, bala_largura
                     mov BX, bala_comprimento

                horizontalBala:

                     mov DX, bala_comprimento
                     mov BX, bala_largura


                loop_linha_bala:

                 mov CX, BX

                 loop_coluna_bala:

                      mov AH, ES:[DI]            ;move um byte do buffer da figura para AH
                      cmp AH, 000h          ;compara AH com o codigo de uma cor que no deve ser imprimida
                      je colidiuBala

                      ; inicio paulo
                      cmp tanque1EmCima, 1
                      je colideVermelho
                      jmp colideVerde1
                      colideVermelho:
                          cmp direcao, 3 ; direita
                          je vermelhoDirecaoDireita
                          cmp direcao, 4 ; esquerda
                          je vermelhoDirecaoDireita

                          jmp incrementa3
                          vermelhoDirecaoDireita:
                              cmp AH, 0E0h  ; vermelho
                              je colidiuBala
                              jmp incrementa3

                      colideVerde1: ; com o tanque embaixo - para impedir que o tiro do tanque quando est embaixo
                                    ;    no pontoX aparea em cima, na vertical

                          cmp AH, 003h ; azul
                          je comparaDirecao1
                          jmp incrementa3
                          comparaDirecao1:
                              cmp direcao, 1
                              je colidiuBala
                              cmp direcao, 2
                              je colidiuBala

                              jmp incrementa3
                      ; fim paulo

                      incrementa3:
                      inc DI


                 loop loop_coluna_bala           ;volta para o loop coluna_loop

                 add DI, 320
                 sub DI, BX                   ;DI recebe 320-largura.
                 dec DX                        ;decrementa o valor de DX
                 cmp DX, 0                     ;compara o valor de DX com zero para saber se chegou ao fim do linha_loop
                 jne loop_linha_bala                ;volta para linha_loop caso DX for diferente de zero

                 jmp colisaoBala2Cenario

                colidiuBala:

                mov naoImprimirBala1, 1

;-----------------------------------------------------------------------------------------
;                              Tank2
;-----------------------------------------------------------------------------------------

    colisaoBala2Cenario:


                xor DI, DI

                ;DI vai apontar para o primeiro pixel do tank1
                mov bx, posX_bala2      ;posicoes atualizadas
                mov dx, posY_bala2
                mov di, bx
                mov bx, dx
                shl dx, 8                ;shift left 8 vezes
                shl bx, 6                ;shif left 6 vezes
                add dx, bx
                add di, dx               ;pos_y*320 + pos_X

                mov AX, SEG buffer_mascara
                mov ES, AX                          ;ES:[DI] aponta para o primeiro pixel da bala dentro da mascara

                cmp direcaoBala2, 1
                je verticalBala2
                cmp direcaoBala2, 2
                je verticalBala2
                cmp direcaoBala2, 3
                je horizontalBala2
                cmp direcaoBala2, 4
                je horizontalBala2
                jmp fimColiBala

                verticalBala2:

                     mov DX, bala_largura
                     mov BX, bala_comprimento

                horizontalBala2:

                     mov DX, bala_comprimento
                     mov BX, bala_largura


                loop_linha_bala2:

                 mov CX, BX

                 loop_coluna_bala2:

                      mov AH, ES:[DI]            ;move um byte do buffer da figura para AH
                      cmp AH, 000h          ;compara AH com o codigo de uma cor que no deve ser imprimida
                      je colidiuBala2

                      ; inicio paulo
                       ; faz colidir o tiro com o cenrio quando o tanque2 est no ponto X em cima.
                      cmp tanque2EmCima, 1
                      je colideVermelho2
                      jmp colideVerde2
                      colideVermelho2:
                          cmp AH, 0E0h  ; vermelho
                          je colidiuBala2
                          jmp incrementa4

                          colideVerde2: ; com o tanque embaixo - para impedir que o tiro do tanque quando est embaixo
                                    ;    no pontoX aparea em cima, na vertical
                          cmp AH, 003h
                          je comparaDirecao2
                          jmp incrementa4

                          comparaDirecao2:
                              cmp direcao2, 1
                              je colidiuBala2
                              cmp direcao2, 2
                              je colidiuBala2

                              jmp incrementa4


                      incrementa4:
                      ; fim paulo
                      inc DI


                 loop loop_coluna_bala2           ;volta para o loop coluna_loop

                 add DI, 320
                 sub DI, BX                   ;DI recebe 320-largura.
                 dec DX                        ;decrementa o valor de DX
                 cmp DX, 0                     ;compara o valor de DX com zero para saber se chegou ao fim do linha_loop
                 jne loop_linha_bala2                ;volta para linha_loop caso DX for diferente de zero

                 jmp fimColiBala

                colidiuBala2:

                      mov naoImprimirBala2, 1

                fimColiBala:


                 pop DI
                 pop ES
                 pop DS
                 pop DX
                 pop CX
                 pop BX
                 pop AX
                 RET


colisaoBalaCenario ENDP

;**************************************************************************************************************************************

colisaoItemCenario PROC NEAR


                push AX
                push BX
                push CX
                push DX
                push DS
                push ES
                push DI

                mov AX, @data
                mov DS, AX

                xor DI, DI

                ;DI vai apontar para o primeiro pixel do tank1
                mov bx, posX_item      ;posicoes atualizadas
                mov dx, posY_item
                mov di, bx
                mov bx, dx
                shl dx, 8                ;shift left 8 vezes
                shl bx, 6                ;shif left 6 vezes
                add dx, bx
                add di, dx               ;pos_y*320 + pos_X

                mov AX, SEG buffer_masc2
                mov ES, AX                          ;ES:[DI] aponta para o primeiro pixel da bala dentro da mascara

                mov DX, item_largura
                mov BX, item_comprimento

                loop_linha_item:

                 mov CX, BX

                 loop_coluna_item:

                      mov AH, ES:[DI]            ;move um byte do buffer da figura para AH
                      cmp AH, 000h          ;compara AH com o codigo de uma cor que no deve ser imprimida
                      je colidiuItem
                      ;cmp AH, 0ffh          ;compara AH com o codigo de uma cor que no deve ser imprimida
                      ;je colidiuItem
                      inc DI


                 loop loop_coluna_item           ;volta para o loop coluna_loop

                 add DI, 320
                 sub DI, BX                   ;DI recebe 320-largura.
                 dec DX                        ;decrementa o valor de DX
                 cmp DX, 0                     ;compara o valor de DX com zero para saber se chegou ao fim do linha_loop
                 jne loop_linha_item                ;volta para linha_loop caso DX for diferente de zero

                 jmp fimColiItem

                colidiuItem:

                      mov colidiu_item, 1

                fimColiItem:

                 pop DI
                 pop ES
                 pop DS
                 pop DX
                 pop CX
                 pop BX
                 pop AX
                 RET


colisaoItemCenario ENDP

;-------------------------------------------------------------------------------------------------------

colisaoItem2Cenario PROC NEAR


                push AX
                push BX
                push CX
                push DX
                push DS
                push ES
                push DI

                mov AX, @data
                mov DS, AX

                xor DI, DI

                ;DI vai apontar para o primeiro pixel do tank1
                mov bx, posX_item2      ;posicoes atualizadas
                mov dx, posY_item2
                mov di, bx
                mov bx, dx
                shl dx, 8                ;shift left 8 vezes
                shl bx, 6                ;shif left 6 vezes
                add dx, bx
                add di, dx               ;pos_y*320 + pos_X

                mov AX, SEG buffer_masc3;buffer_mascara
                mov ES, AX                          ;ES:[DI] aponta para o primeiro pixel da bala dentro da mascara

                mov DX, item_largura
                mov BX, item_comprimento

                loop_linha_item2:

                 mov CX, BX

                 loop_coluna_item2:

                      mov AH, ES:[DI]            ;move um byte do buffer da figura para AH
                      cmp AH, 000h          ;compara AH com o codigo de uma cor que no deve ser imprimida
                      je colidiuItem2
                      ;cmp AH, 0ffh          ;compara AH com o codigo de uma cor que no deve ser imprimida
                      ;je colidiuItem2
                      inc DI


                 loop loop_coluna_item2           ;volta para o loop coluna_loop

                 add DI, 320
                 sub DI, BX                   ;DI recebe 320-largura.
                 dec DX                        ;decrementa o valor de DX
                 cmp DX, 0                     ;compara o valor de DX com zero para saber se chegou ao fim do linha_loop
                 jne loop_linha_item2                ;volta para linha_loop caso DX for diferente de zero

                 jmp fimColiItem2

                colidiuItem2:

                      mov colidiu_item2, 1

                fimColiItem2:

                 pop DI
                 pop ES
                 pop DS
                 pop DX
                 pop CX
                 pop BX
                 pop AX
                 RET


colisaoItem2Cenario ENDP


colisaoItem3Cenario PROC NEAR


                push AX
                push BX
                push CX
                push DX
                push DS
                push ES
                push DI

                mov AX, @data
                mov DS, AX

                xor DI, DI

                ;DI vai apontar para o primeiro pixel do tank1
                mov bx, posX_item2      ;posicoes atualizadas
                mov dx, posY_item2
                mov di, bx
                mov bx, dx
                shl dx, 8                ;shift left 8 vezes
                shl bx, 6                ;shif left 6 vezes
                add dx, bx
                add di, dx               ;pos_y*320 + pos_X

                mov AX, SEG buffer_mascara
                mov ES, AX                          ;ES:[DI] aponta para o primeiro pixel da bala dentro da mascara

                mov DX, item_largura
                mov BX, item_comprimento

                loop_linha_item3:

                 mov CX, BX

                 loop_coluna_item3:

                      mov AH, ES:[DI]            ;move um byte do buffer da figura para AH
                      ;cmp AH, 000h          ;compara AH com o codigo de uma cor que no deve ser imprimida
                      ;je colidiuItem3
                      cmp AH, 000h          ;compara AH com o codigo de uma cor que no deve ser imprimida
                      je colidiuItem3
                      inc DI


                 loop loop_coluna_item3           ;volta para o loop coluna_loop

                 add DI, 320
                 sub DI, BX                   ;DI recebe 320-largura.
                 dec DX                        ;decrementa o valor de DX
                 cmp DX, 0                     ;compara o valor de DX com zero para saber se chegou ao fim do linha_loop
                 jne loop_linha_item3                ;volta para linha_loop caso DX for diferente de zero

                 jmp fimColiItem3

                colidiuItem3:

                      mov colidiu_item2, 1

                fimColiItem3:

                 pop DI
                 pop ES
                 pop DS
                 pop DX
                 pop CX
                 pop BX
                 pop AX
                 RET


colisaoItem3Cenario ENDP




;****************************************************************************************************************
;Procedimento que faz o tanque ou o caminho piscar toda vez que forem atingidos por uma bala
;****************************************************************************************************************
DesenhaTankPiscando Macro

              cmp balasTank, 0
              jl destroi1
              cmp acertou2, 1
              je destroi2
              jmp destroi1

              destroi2:                        ;faz o tanque1 piscar
                      cmp direcao2, 1
                      je piscaCima2
                      cmp direcao2, 2
                      je piscaBaixo2
                      cmp direcao2, 3
                      je piscaDir2
                      cmp direcao2, 4
                      je piscaEsq2
                      jmp destroi1

              piscaCima2:

                      cmp ehTank2, 1
                      je piscaTanque1Cima
                      jmp piscaCaminhao

                      piscaTanque1Cima:
                          carregar_figura buffer_piscadaC, posX_tank2, posY_tank2, tank_largura, tank_comprimento
                          jmp fimPiscaCima2
                      piscaCaminhao:
                          carregar_figura buffer_piscCamC, posX_tank2, posY_tank2, tank_largura, tank_comprimento

                      fimPiscaCima2:

                      mov acertou2, 0
                      jmp destroi1

              piscaBaixo2:

                      cmp ehTank2, 1
                      je piscaTanque1Baixo
                      jmp piscaCaminhaoBaixo

                      piscaTanque1Baixo:
                          carregar_figura buffer_piscadaB, posX_tank2, posY_tank2, tank_largura, tank_comprimento
                          jmp fimPiscaBaixo2
                      piscaCaminhaoBaixo:
                          carregar_figura buffer_piscCamB, posX_tank2, posY_tank2, tank_largura, tank_comprimento

                      fimPiscaBaixo2:
                      mov acertou2, 0
                      jmp destroi1

              piscaDir2:
                      cmp ehTank2, 1
                      je piscaTanque1Direita
                      jmp piscaCaminhaoDireita

                      piscaTanque1Direita:
                          carregar_figura buffer_piscadaD, posX_tank2, posY_tank2, tank_comprimento, tank_largura
                          jmp fimPiscaDir2
                      piscaCaminhaoDireita:
                          carregar_figura buffer_piscCamD, posX_tank2, posY_tank2, tank_comprimento, tank_largura

                      fimPiscaDir2:
                      mov acertou2, 0
                      jmp destroi1

              piscaEsq2:

                      cmp ehTank2, 1
                      je piscaTanque1Esquerda
                      jmp piscaCaminhaoEsquerda

                      piscaTanque1Esquerda:
                           carregar_figura buffer_piscadaE, posX_tank2, posY_tank2, tank_comprimento, tank_largura
                           jmp fimPiscaEsq2

                      piscaCaminhaoEsquerda:
                            carregar_figura buffer_piscCamE, posX_tank2, posY_tank2, tank_comprimento, tank_largura

                      fimPiscaEsq2:

                      mov acertou2, 0
                      jmp destroi1

              destroi1:


                      cmp balasTank2, 0           ;faz o tanque2 piscar
                      jl sair00
                      cmp acertou, 0
                      je sair00
                      cmp direcao, 1
                      je piscaCima
                      cmp direcao, 2
                      je piscaBaixo
                      cmp direcao, 3
                      je piscaDir
                      cmp direcao, 4
                      je piscaEsq
                      jmp sair00

              piscaCima:

                      cmp ehTank1, 1
                      je piscaTanque2Esquerda
                      jmp piscaCaminhao2Esquerda

                      piscaTanque2Cima:
                          carregar_figura buffer_piscadaC, posX_tank, posY_tank, tank_largura, tank_comprimento
                          jmp fimPiscaCima
                      piscaCaminhao2Cima:
                          carregar_figura buffer_piscCamC, posX_tank, posY_tank, tank_largura, tank_comprimento

                      fimPiscaCima:
                      mov acertou, 0
                      jmp sair00

              piscaBaixo:

                      cmp ehTank1, 1
                      je piscaTanque2Baixo
                      jmp piscaCaminhao2Baixo

                      piscaTanque2Baixo:
                          carregar_figura buffer_piscadaB, posX_tank, posY_tank, tank_largura, tank_comprimento
                          jmp fimPiscaBaixo
                      piscaCaminhao2Baixo:
                           carregar_figura buffer_piscCamB, posX_tank, posY_tank, tank_largura, tank_comprimento

                      fimPiscaBaixo:
                      mov acertou, 0
                      jmp sair00

              piscaDir:
                      cmp ehTank1, 1
                      je piscaTanque2Direita
                      jmp piscaCaminhao2Direita

                      piscaTanque2Direita:
                          carregar_figura buffer_piscadaD, posX_tank, posY_tank, tank_comprimento, tank_largura
                          jmp fimPiscaDir
                      piscaCaminhao2Direita:
                          carregar_figura buffer_piscCamD, posX_tank, posY_tank, tank_comprimento, tank_largura
                      fimPiscaDir:
                      mov acertou, 0
                      jmp sair00

              piscaEsq:
                      cmp ehTank1, 1
                      je piscaTanque2Esquerda
                      jmp piscaCaminhao2Esquerda

                      piscaTanque2Esquerda:
                          carregar_figura buffer_piscadaE, posX_tank, posY_tank, tank_comprimento, tank_largura
                          jmp fimPiscaEsq

                      piscaCaminhao2Esquerda:
                          carregar_figura buffer_piscCamE, posX_tank, posY_tank, tank_comprimento, tank_largura

                      fimPiscaEsq:
                      mov acertou, 0
                      jmp sair00

              sair00:

ENDM

;************************************************************************************************************
;Procedimento que atribui os valores geradados por Rand3 s posies X e Y da estrela1
;************************************************************************************************************
Rand PROC NEAR

     push AX

     call Rand3

     mov AX, vamos2
     mov posX_item, AX

     mov AX, vamos
     mov posY_item, AX

     pop AX

     RET

Rand ENDP

;************************************************************************************************************
;Procedimento que atribui os valores geradados por Rand4 s posies X e Y da estrela2
;************************************************************************************************************
Rand1 PROC NEAR

      push AX

      call Rand4

      mov AX, vamos4
      mov posX_item2, AX

      mov AX, vamos3
      mov posY_item2, AX

      pop AX

      RET

Rand1 ENDP

;*****************************************************************************************************
;Procedimento que ira gerar o numero dos segundos em que as duas estrelas aparecero na tela.
;*****************************************************************************************************
Rand2 PROC NEAR

      push AX
      push BX
      push CX
      push DX

      mov AH, 2Ch
      int 21h

      xor AX, AX
      mov AL, DL ;DL= milisegundos
      mov BH, 10
      div BH
      xor BX, BX
      mov BL, AH
      mov seed2, BX         ;AH recebe o resto da divisao entre AX e BH.

      pop DX
      pop CX
      pop BX
      pop AX
      RET

Rand2 ENDP


;*******************************************************************************************************
;Procedimento que calcula a posio da estrela1 randomicamente atravs da hora atual
;*******************************************************************************************************
Rand3 PROC NEAR

      push AX
      push BX
      push CX
      push DX

      mov AH, 2Ch
      int 21h
      
posicao1:     ;calcula a posicao Y da estrela

      xor AX, AX
      mov AL, DL            ;DL= milisegundos
      add AL, DL
      mov BH, 180
      div BH
      xor BX, BX
      mov BL, AH            ;AH recebe o resto da divisao entre AX e BH.
      mov vamos, BX

posicao2:     ;calcula a posicao X da estrela

      xor AX, AX
      mov AL, DL
      add AL, DH        ;aqui
      mov BH, 140;150
      div BH
      xor BX, BX
      mov BL, AH
      mov vamos2, BX

      pop DX
      pop CX
      pop BX
      pop AX
      RET

Rand3 ENDP

;*******************************************************************************************************
;Procedimento que calcula a posio da estrela2 randomicamente, atravs da hora atual
;*******************************************************************************************************
Rand4 PROC NEAR

      push AX
      push BX
      push CX
      push DX

      mov AH, 2Ch          ;funo que pega a hora atual
      int 21h

      xor AX, AX
      mov AL, DL           ;DL= milisegundos
      add AL, DL
      add AL, DL
      add AL, DL
      mov BH, 190
      div BH
      xor BX, BX
      mov BL, AH           ;AH recebe o resto da divisao entre AX e BH.
      mov vamos3, BX

      xor AX, AX
      mov AL, DL           ;DL= milisegundos
      add AL, DH
      add AL, DL
      add AL, DL
      add AL, DL   ;aqui
      add AL, DL
      mov BH, 250
      div BH
      xor BX, BX
      mov BL, AH           ;AH recebe o resto da divisao entre AX e BH.
      mov vamos4, BX
      add vamos4, 30

      pop DX
      pop CX
      pop BX
      pop AX
      RET


Rand4 ENDP

;*********************************************************************************************
;Procedimento que calcula as posies das duas estrelas iniciais do jogo.
;As duas estrelas sempre aparecero em lados diferentes, a nica exceo 
;ambas poderem aparecer em cima do viaduto.
;*********************************************************************************************
Item PROC NEAR

          push AX

geraItem:

           mov colidiu_item, 0
           call Rand                ;calcula a posio da estrela da esquerda
           call colisaoItemCenario
           cmp colidiu_item, 1      ;se a estrela colidiu com o cenrio, ento geraItem
           je geraItem              ; chamado novamente at que no ocorra coliso
           
geraItem2:

           mov colidiu_item2, 0
           call Rand1               ;calcula a posio da estrela da direita
           call colisaoItem2Cenario
           cmp colidiu_item2, 1
           je geraItem2

saiItem:
           pop AX
           ret

Item ENDP

;*****************************************************************************************************
;Macro que carrega as estrelas que aparecero na tela no buffer.
;Toda vez que tiver um caminho na tela, uma estrela aparecer.
;*****************************************************************************************************
carregarEstrelas MACRO

           push AX

           cmp contEstrelas, 0
           je comparaTempo
           cmp apareceu_item, 1    ;quando a estrela1 estiver na tela, apareceu_item ser 1
           je carregaItem1
           cmp apareceu_item2, 1   ;quando a estrela2 estiver na tela, apareceu_item2 ser 1
           je carregaItem2
           cmp contEstrelas, 1
           je verificaTank1

           jmp saiI

           verificaTank1:

                         cmp ehTank1, 0
                         jne verificaTank2
                         cmp ehTank2, 0
                         jne posicaoNovaEstrela
                         jmp geraDuasEstrelas

           geraDuasEstrelas:
                           add contEstrelas, 1
                           jmp posicaoNovaEstrela

           verificaTank2:
           
                         cmp ehTank2, 0
                         je posicaoNovaEstrela
                         jmp saiI
                         
           posicaoNovaEstrela:       ;calcula a posio das estrelas que aparecem toda vez 
                                     ;que algum tanque perder uma vida
                         mov colidiu_item2, 0
                         call Rand1
                         call colisaoItem3Cenario
                         cmp colidiu_item2, 1
                         je posicaoNovaEstrela
                         jmp carregaItem2

           comparaTempo:

                      mov AX, tempo_item       ;verifica se j passou o tempo necessrio
                      cmp SEC, AX              ;para aparecer as duas estrelas
                      jne saiI
                      jmp setaAparecer_item

           setaAparecer_item:

                             mov apareceu_item, 1
                             mov apareceu_item2, 1
                             jmp carregaItem1

           carregaItem1:    ;carrega a estrela1

                       mov apareceu_item, 1
                       mov SEC, 0
                       carregar_figura buffer_estrela, posX_item, posY_item, 0ah, 0ah
                       cmp apareceu_item2, 0
                       je saiI
                       jmp carregaItem2

           carregaItem2:     ;carrega a estrela2

                       mov SEC, 0
                       carregar_figura buffer_estrela, posX_item2, posY_item2, 0ah, 0ah
                       mov apareceu_item2, 1
                       cmp contEstrelas, 2
                       je geraDuasEstrelas
                       mov contEstrelas, 1
                       jmp saiI

           saiI:

                pop AX

ENDM

;***************************************************************************************************
;espera o tempo passado por parametro
;***************************************************************************************************
espera_tempo MACRO tempo_espera
             local fica_no_laco

       mov SEC, 0

fica_no_laco:

           cmp DS:[varEsc], 1
           je vaiProMenu  
           cmp SEC, tempo_espera
           jne fica_no_laco
        
ENDM




