;***********************************************************************************************************************
;Procedimento utilizado para criar o menu.                                                                             *
;***********************************************************************************************************************

menu PROC NEAR

     mov numMenu, 0                                                 ;zera o registrador CX.
     call inicializar_menu                                       ;imprime a primeira tela do menu
     sound 2000, 2
     inicio:

            mov AX, 0800h
            int 21h
            cmp AL, tecla_cima2               ;compara a tecla pressionada
            je tratar_cima             ;pula para esse rotulo caso a tecla cima seja pressionada
            cmp AL, tecla_baixo2              ;compara a tecla pressionada
            je tratar_baixo            ;pula para esse rotulo caso a tecla baixo seja pressionada
            cmp AL, tecla_enter        ;compara a tecla pressionada
            je tratar_enter            ;pula para esse rotulo caso a tecla enter seja pressionada
            jmp inicio                 ;volta para o rtulo inicio caso a tecla pressionada nao seja esperada


            ;Entra nesse rotulo caso o usuario tenha pressionado a seta pra cima.
            ;muda a figura do menu dependendo da tela anterior.
            tratar_cima:

                        sound 2000, 2
                        cmp numMenu, 0
                        je menu_sair          ;pula para o rotulo menu_sair
                        cmp numMenu, 1
                        je menu_jogar         ;pula para o rotulo menu_jogar
                        cmp numMenu, 2
                        je menu_ajuda      ;pula para o rotulo menu_recordes
                        cmp numMenu, 3
                        je menu_recordes        ;pula para o rotulo menu_ajuda
                        cmp numMenu, 4
                        je menu_creditos      ;pula para o rotulo menu_creditos
                        jmp inicio            ;volta para o rotulo inicio caso o valor de CX nao seja nenhum desses(improvavel de acontecer)

            ;Entra nesse rotulo caso o usuario tenha pressionado a seta pra baixo.
            ;muda a figura do menu dependendo da tela anterior.
            tratar_baixo:

                        sound 2000, 2
                        cmp numMenu, 0
                        je menu_ajuda      ;pula para o rotulo menu_recordes caso seja igual
                        cmp numMenu, 1
                        je menu_recordes        ;pula para o rotulo menu_ajuda caso seja igual
                        cmp numMenu, 2
                        je menu_creditos      ;pula para o rotulo menu_creditos caso seja igual
                        cmp numMenu, 3
                        je menu_sair          ;pula para o rotulo menu_sair caso seja igual
                        cmp numMenu, 4
                        je menu_jogar         ;pula para o rotulo menu_jogar caso seja igual
                        jmp inicio            ;volta para o rotulo inicio caso o valor de CX nao seja nenhum desses(improvavel acontecer)


            ;entra nesse rotulo quando a tecla enter for pressionada.
            tratar_enter:

                         sound 2000, 1
                         cmp numMenu, 0                 ;Verifica em que parte do menu a tecla enter foi pressionada para
                         je entrar_jogo
                         cmp numMenu, 1
                         je tela_ajuda              ;chamar o rotulo que executa a instruo correspondente  escolha
                         cmp numMenu, 2                 ;do usurio
                         je tela_recordes
                         cmp numMenu, 3
                         je tela_creditos
                         cmp numMenu, 4
                         je sair_jogo
                         jmp inicio



                menu_jogar:
                           mov numMenu, 0
                           call inicializar_menu
                           jmp inicio

                menu_ajuda:
                           mov numMenu, 1
                           call inicializar_menu
                           jmp inicio

                menu_recordes:
                              mov numMenu, 2
                              call inicializar_menu
                              jmp inicio

                menu_creditos:
                              mov numMenu, 3
                              call inicializar_menu
                              jmp inicio

                menu_sair:
                          mov numMenu, 4
                          call inicializar_menu
                          jmp inicio

                entrar_jogo:                              ;Entra nesse rotulo quando o escolhe a opo jogar.

                            call CoolDown
                            carrega_paleta fase2_pal, paleta_buffer
                            imprimir_tela fase2
                            call inicializar_jogo
                            call jogar


                tela_recordes:                           ;Entra nesse rotulo quando o escolhe a opo recordes;

                              carrega_paleta tela_recordes_pal, paleta_buffer
                              imprimir_tela tela_recordes_dat

                              ;call EscreveNoArquivo            ;usado para "limpar o arquivo dos recordes"
                              call imprimeTodos
                              jmp para_sair

                tela_ajuda:                              ;Entra nesse rotulo quando o escolhe a opo ajuda.

                           ;mostra tela de ajuda
                           carrega_paleta tela_ajuda_pal, paleta_buffer
                           imprimir_tela tela_ajuda_dat
                           jmp para_sair


                tela_creditos:                           ;entra nesse rotulo quando o usuario escolhe a opo creditos.

                              ;mostra a(as) telas referente aos creditos
                              carrega_paleta tela_creditos_pal, paleta_buffer
                              imprimir_tela tela_creditos_dat
                              jmp para_sair


                sair_jogo:                                 ;Entra nesse rotulo quando o escolhe a opo sair.

                          ;telas para sair do jogo
                          carrega_paleta tela_sair1_pal, paleta_buffer
                          imprimir_tela tela_sair1_dat

                sair_jogo2:
                          xor AX, AX                       ;AL recebe o ASCII caractere
                          int 16h
                          cmp AH, tecla_esc
                          je volta_menu_principal
                          cmp AL, 's'
                          je fim_jogo
                          cmp AL, 'S'
                          je fim_jogo
                          cmp AL, 'n'
                          je volta_menu_principal
                          cmp AL, 'N'
                          je volta_menu_principal
                          jmp sair_jogo2                   ;Caso a tecla digitada nao seja nenhuma das esperadas.


               ;esse rotulo fica esperando o usuario digitar a tecla esc pra voltar ao menu principal.
               para_sair:

                         xor AX, AX
                         int 16h
                         cmp AH, tecla_esc
                         je volta_menu_principal
                         jmp para_sair

                volta_menu_principal:

                                      call inicializar_menu
                                      jmp inicio

                fim_jogo:

                          mov AH, 4Ch
                          int 21h
                          ret

menu ENDP


inicializar_menu PROC NEAR

                 push CX
                 cmp numMenu, 0
                 je menuInicio
                 cmp numMenu, 1
                 je menuAjuda
                 cmp numMenu, 2
                 je menuRecordes
                 cmp numMenu, 3
                 je menuCreditos
                 cmp numMenu, 4
                 je menuSair

                 menuInicio:

                            carrega_paleta menu_pal, paleta_buffer
                            imprimir_tela menu_jogar_dat
                            jmp voltar_menu                            ;vai pro rotulo inicio do procedimento menu

                 menuAjuda:

                           carrega_paleta menu_pal, paleta_buffer
                           imprimir_tela menu_ajuda_dat
                           jmp voltar_menu

                 menuRecordes:

                           carrega_paleta menu_pal, paleta_buffer
                           imprimir_tela menu_recordes_dat
                           jmp voltar_menu

                 menuCreditos:

                             carrega_paleta menu_pal, paleta_buffer
                             imprimir_tela menu_creditos_dat
                             jmp voltar_menu

                 menuSair:

                          carrega_paleta menu_pal, paleta_buffer
                          imprimir_tela menu_sair_dat
                          jmp voltar_menu

                 voltar_menu:
                             pop CX
                             ret

inicializar_menu ENDP
