
;**********************************************************************************************************************
;                                                                                                                     *
;Macro set_video                                                                                                      *
;                                                                                                                     *
;Descrio: Macro que seta o modo de video para 320x200x256.                                                          *
;**********************************************************************************************************************                                                                                                   *
set_video MACRO

           push AX
           mov AX, 0013h           ;funo da interrupao 10h que seta o modo de video para 320x200x256
           int 10h
           pop AX

ENDM

;---------------------------------------------------------------------------------------------------------------------
;Fim set_video
;---------------------------------------------------------------------------------------------------------------------


;**********************************************************************************************************************
;                                                                                                                     *
;Macro ler_arquivo                                                                                                    *
;                                                                                                                     *
;Descrio: Macro utilizada para copiar um arquivo para o buffer que  passado como parmetro                         *
;           Recebe como parmetros o nome do arquivo, o buffer e o numero de bytes que sero lidos                    *                                                                                     *
;**********************************************************************************************************************

ler_arquivo MACRO nome, buffer, numero_bytes    ;precisa tratar os erros ainda.

            ;guarda o valor dos registradores na pilha
            push AX
            push BX
            push CX
            push DX
            push DS

            mov AX, SEG nome
            mov DS, AX                     ;faz com que DS aponte para o segmento do path
            mov DX, OFFSET nome
            mov AX, 3D00h                  ;Funo para abrir um arquivo em modo de somente leitura. AH = 3D, AL = 00.
            int 21h

            mov BX, AX                     ;move o handle do arquivo para BX
            mov CX, numero_bytes           ;coloca em CX o numero de bytes que sero lidos
            mov AX, SEG buffer
            mov DS, AX                     ;move o segmento do buffer para o DS
            mov DX, OFFSET buffer
            mov AH, 3Fh                    ;funo que l o arquivo usando o handle em BX
            int 21h

            mov AH, 3Eh                    ;funo para fechar o arquivo
            int 21h

            ;recupera o valor dos registradores na pilha
            pop DS
            pop DX
            pop CX
            pop BX
            pop AX

ENDM

;----------------------------------------------------------------------------------------------------------------------
;fim ler_arquivo
;----------------------------------------------------------------------------------------------------------------------

imprimir_tela MACRO nome_arquivo

            push AX
            push BX
            push CX
            push DX
            push DS

            mov AX, SEG nome_arquivo
            mov DS, AX
            mov DX, OFFSET nome_arquivo
            mov AX, 3D00h                     ;funo da interrupo 21h que abre um arquivo em modo de somente leitura
            int 21h

            mov BX, AX                       ;move o handle do arquivo para BX

			;faz com que DS:DX aponte para o inicio do segmento de video

            mov AX, 0A000h                   ;inicio do segmento de video
            mov DS, AX                       ;faz com que DS aponte para o inicio do segmento de video
            mov DX, 0

            ;Escreve no video

            mov CX, 64000                    ;numero de interaes modo VGA 320x200x256
            mov AH, 3Fh                      ;Funo de leitura do arquivo com handle armazenado em BX
            int 21h

            ;fechar o arquivo
            mov AH, 3Eh                      ;Funo para fechamento do arquivo
            int 21h

            pop DS
            pop DX
            pop CX
            pop BX
            pop AX

ENDM

;----------------------------------------------------------------------------------------------------------------------
;Fim imprimir_tela
;---------------------------------------------------------------------------------------------------------------------

;*********************************************************************************************************************
;                                                                                                                    *
;Macro carrega_paleta                                                                                                *
;                                                                                                                    *
;Descrio: Macro utilizada para carregar uma paleta de cores no video. So passados como parmetro o nome da        *
;           paleta e o seu buffer.                                                                                   *
;*********************************************************************************************************************
carrega_paleta MACRO nome_paleta, buffer_paleta

               push AX
               push BX
               push CX
               push DX
               push SI
               push DS

               ;copia o conteudo do arquivo para o buffer da paleta (paleta_buffer)
               ler_arquivo nome_paleta, buffer_paleta, 768

               ;avisa ao video que a paleta sera modificada
               mov DX, 3C8h
               mov Al, 0
               out DX, AL

               inc DX                            ;incrementa o valor de DX. DX = 3C9h
               mov SI, OFFSET buffer_paleta
               mov AX, SEG buffer_paleta
               mov DS, AX                        ;passa o segmento do buffer da paleta para DS
               mov CX, 768                     ;copia para CX a quantidade de bytes que a paleta possui

               ;A instruo outsb transfere um byte que se encontra em DS:SI para o hardware
               ;especificado em DX, e incrementa ou decrementa SI

               rep outsb                         ;repete a instruo outsb CX vezes

               pop DS
               pop SI
               pop DX
               pop CX
               pop BX
               pop AX


ENDM

;---------------------------------------------------------------------------------------------------------------------
;carrega_paleta
;---------------------------------------------------------------------------------------------------------------------

;******************************************************************************************
;                                                                                         *
;Macro carregar_figura                                                                    *
;                                                                                         *
;Descrio: Macro que carrega uma figura qualquer na posio do buffer especificado por   *
;           pos_x e pos_y.                                                                *
;                                                                                         *
;           buffer_figura - O buffer da figura.                                           *
;           pos_x - A posio inicial da figura no eixo X.                                *
;           pos_y - A posio final da figura no eixo y.                                  *
;           comp - O comprimento da figura.                                               *
;           larg - A largura da figura.                                                   *
;******************************************************************************************
carregar_figura MACRO buffer_figura, pos_x, pos_y, comprimento, largura
                local linha_loop, coluna_loop, volta_coluna_loop
                ;salva os valores dos registradores na pilha
                push AX
                push BX
                push CX
                push DX
                push DS
                push ES
                push DI

                ;zera DI

                xor DI, DI

                ;algoritmo para que faz com que DI = pos_y * 320 + pos_x
                mov bx, pos_x
                mov dx, pos_y
                mov di, bx
                mov bx, dx
                shl dx, 8                ;shift left 8 vezes
                shl bx, 6                ;shif left 6 vezes
                add dx, bx
                add di, dx               ;pos_y*320 + pos_X

                ;faz com que DS:SI aponte para o buffer da figura (buffer_figura)
                mov AX, SEG buffer_figura
                mov DS, AX
                mov SI, OFFSET buffer_figura

                mov AX, SEG buffer
                mov ES, AX                  ;faz com que ES aponte para o segmento do buffer da tela inteira

                mov DX, comprimento         ;move o comprimento da figura para o registrador DX

                linha_loop:

                ;move o tamanho da largura da figura para CX para que toda vez em que coluna_loop
                ;for chamada ela ser executada CX vezes.
                 mov CX, largura

                 coluna_loop:

                 mov AH, DS:[SI]            ;move um byte do buffer da figura para AH
                 cmp AH, 0b9h           ;compara AH com o codigo de uma cor que no deve ser impressa
                 je volta_coluna_loop
               ;  cmp AH, 000h           ;compara AH com o codigo de uma cor que no deve ser impressa
               ;  je volta_coluna_loop
                 cmp AH, 030h;002h          ;compara AH com o codigo de uma cor que no deve ser impressa
                 je volta_coluna_loop
                 cmp AH, 0ffh;002h          ;compara AH com o codigo de uma cor que no deve ser impressa
                 je volta_coluna_loop
                 mov ES:[DI], AH            ;Imprime no video

                 volta_coluna_loop:

                 inc DI                     ;incrementa o registrador DI - lugar a ser imprimido no video
                 inc SI                     ;incrementa o registrador SI - registrador que aponta o byte a ser lido do buffer

                 loop coluna_loop           ;volta para o loop coluna_loop

                 add DI, 320
                 sub DI, largura               ;DI recebe 320-largura.
                 dec DX                     ;decrementa o valor de DX
                 cmp DX, 0                  ;compara o valor de DX com zero para saber se chegou ao fim do linha_loop
                 jne linha_loop             ;volta para linha_loop caso DX for diferente de zero

                 ;recupera os valores dos registradores na pilha
                 pop DI
                 pop ES
                 pop DS
                 pop DX
                 pop CX
                 pop BX
                 pop AX

ENDM

;--------------------------------------------------------------------------------------------------------------------
;Fim da macro carregar_figura
;--------------------------------------------------------------------------------------------------------------------

;******************************************************************************************
;                                                                                         *
;Macro carregar_figura                                                                    *
;                                                                                         *
;Descrio: Macro que carrega uma figura qualquer na posio do buffer do painel          *
;                                                                                          *
;           buffer_figura - O buffer da figura.                                           *
;           pos_x - A posio inicial da figura no eixo X.                                *
;           pos_y - A posio final da figura no eixo y.                                  *
;           comp - O comprimento da figura.                                               *
;           larg - A largura da figura.                                                   *
;******************************************************************************************
carregar_figura2 MACRO buffer_figura, pos_x, pos_y, comprimento, largura
                local linha_loop2, coluna_loop2, volta_coluna_loop2
                ;salva os valores dos registradores na pilha
                push AX
                push BX
                push CX
                push DX
                push DS
                push ES
                push DI

                ;zera DI

                xor DI, DI

                ;algoritmo para que faz com que DI = pos_y * 320 + pos_x
                mov bx, pos_x
                mov dx, pos_y
                mov di, bx
                mov bx, dx
                shl dx, 8                ;shift left 8 vezes
                shl bx, 6                ;shif left 6 vezes
                add dx, bx
                add di, dx               ;pos_y*320 + pos_X

                ;faz com que DS:SI aponte para o buffer da figura (buffer_figura)
                mov AX, SEG buffer_figura
                mov DS, AX
                mov SI, OFFSET buffer_figura

                mov AX, SEG buffer_painel
                mov ES, AX                  ;faz com que ES aponte para o segmento do buffer da tela inteira

                mov DX, comprimento         ;move o comprimento da figura para o registrador DX

                linha_loop2:

                ;move o tamanho da largura da figura para CX para que toda vez em que coluna_loop
                ;for chamada ela ser executada CX vezes.
                 mov CX, largura

                 coluna_loop2:

                 mov AH, DS:[SI]            ;move um byte do buffer da figura para AH
                 cmp AH, 0b9h           ;compara AH com o codigo de uma cor que no deve ser impressa
                 je volta_coluna_loop2
               ;  cmp AH, 000h           ;compara AH com o codigo de uma cor que no deve ser impressa
               ;  je volta_coluna_loop
                 cmp AH, 030h;002h          ;compara AH com o codigo de uma cor que no deve ser impressa
                 je volta_coluna_loop2
                 cmp AH, 0ffh;002h          ;compara AH com o codigo de uma cor que no deve ser impressa
                 je volta_coluna_loop2
                 mov ES:[DI], AH            ;Imprime no video

                 volta_coluna_loop2:

                 inc DI                     ;incrementa o registrador DI - lugar a ser imprimido no video
                 inc SI                     ;incrementa o registrador SI - registrador que aponta o byte a ser lido do buffer

                 loop coluna_loop2           ;volta para o loop coluna_loop

                 add DI, 320
                 sub DI, largura               ;DI recebe 320-largura.
                 dec DX                     ;decrementa o valor de DX
                 cmp DX, 0                  ;compara o valor de DX com zero para saber se chegou ao fim do linha_loop
                 jne linha_loop2             ;volta para linha_loop caso DX for diferente de zero

                 ;recupera os valores dos registradores na pilha
                 pop DI
                 pop ES
                 pop DS
                 pop DX
                 pop CX
                 pop BX
                 pop AX

ENDM

;--------------------------------------------------------------------------------------------------------------------
;Fim da macro carregar_figura
;--------------------------------------------------------------------------------------------------------------------

;********************************************************************************************************************
;                                                                                                                   *
;Procedimento imprimir_tudo                                                                                         *
;                                                                                                                   *
;Descrio: Procedimento que descarrega o buffer principa todo no video.                                            *
;********************************************************************************************************************

imprimir_tudo PROC NEAR

              push AX
              push BX
              push CX
              push DX
              push DS
              push ES
              push SI

              mov AX, 0A000h
              mov ES, AX
              xor DI, DI                                ;Seta ES:DI com o inicio do segmento de video

              mov AX, SEG buffer
              mov DS, AX                                ;move para DS o segmento do buffer principal
              mov SI, OFFSET buffer                     ;move para SI o offset do buffer principal

              mov CX, 64000
              rep movsb

              pop SI
              pop ES
              pop DS
              pop DX
              pop CX
              pop BX
              pop AX

              ret

imprimir_tudo ENDP

;---------------------------------------------------------------------------------------------------------------------
;Fim imprimir_tudo
;---------------------------------------------------------------------------------------------------------------------

;********************************************************************************************************************
;                                                                                                                   *
;Procedimento carrega_buffer                                                                                        *
;                                                                                                                   *
;Descrio: Procedimento que carrega toda a figura do jogo para o seu buffer                                        *
;********************************************************************************************************************

carrega_buffer PROC NEAR

;------------------------------------------Tanques-------------------------------------------
               ler_arquivo tankB, buffer_tankB, 224
               ler_arquivo tankC, buffer_tankC, 224
               ler_arquivo tankD, buffer_tankD, 224
               ler_arquivo tankE, buffer_tankE, 224
               ler_arquivo tankB2, buffer_tank2B, 224
               ler_arquivo tankC2, buffer_tank2C, 224
               ler_arquivo tankD2, buffer_tank2D, 224
               ler_arquivo tankE2, buffer_tank2E, 224

;--------------------------------------Balas--------------------------------------------------
               ler_arquivo bala, buffer_bala, 4
               ler_arquivo balaVert, buffer_balaVert, 2

;-------------------------------------Vidas--------------------------------------------------
               ler_arquivo foto, buffer_fot, 288
               ler_arquivo bino, buffer_bino, 256
               
               ler_arquivo tiros, buffer_tiro, 10
               
;-------------------------------------exploses------------------------------------------------
               ler_arquivo fogo0, buffer_fogo0, 182
               ler_arquivo fogo, buffer_fogo, 256
               ler_arquivo fogo2, buffer_fogo2, 342
               ler_arquivo fogo3, buffer_fogo3, 462

;--------------------------piscadas----------------------------------------------------------
               ler_arquivo piscaB, buffer_piscadaB, 209
               ler_arquivo piscaC, buffer_piscadaC, 209
               ler_arquivo piscaD, buffer_piscadaD, 209
               ler_arquivo piscaE, buffer_piscadaE, 209

               ler_arquivo piscCamB, buffer_piscCamB, 224
               ler_arquivo piscCamC, buffer_piscCamC, 224
               ler_arquivo piscCamD, buffer_piscCamD, 224
               ler_arquivo piscCamE, buffer_piscCamE, 224


               ler_arquivo estrela, buffer_estrela, 100
               ler_arquivo caminhaoD, buffer_caminhaoD, 224
               ler_arquivo caminhaoB, buffer_caminhaoB, 224
               ler_arquivo caminhaoE, buffer_caminhaoE, 224
               ler_arquivo caminhaoC, buffer_caminhaoC, 224
               ler_arquivo caminhao2D, buffer_caminhao2D, 224
               ler_arquivo caminhao2B, buffer_caminhao2B, 224
               ler_arquivo caminhao2E, buffer_caminhao2E, 224
               ler_arquivo caminhao2C, buffer_caminhao2C, 224

;--------------------------pontoX----------------------------------------------------------
               ler_arquivo pontoX, buffer_pontoX, 840

;--------------------------posto Gasolina----------------------------------------------------------
               ler_arquivo posto, buffer_posto, 4680

               RET


carrega_buffer ENDP

;------------------------------------------------------------------------------------------------------
;Fim Carrega_buffer
;------------------------------------------------------------------------------------------------------


;********************************************************************************************************************
;                                                                                                                   *
;Procedimento copiar_buffer                                                                                         *
;                                                                                                                   *
;Descrio: Procedimento que copia o conteudo de um buffer para outro.                                               *
;********************************************************************************************************************

copiar_buffer MACRO buffer_inicial, buffer_final, numBytes

;empilha os registradores
    push AX
    push CX
    push DS
    push SI
    push ES
    push DI

    mov AX, SEG buffer_inicial
    mov DS, AX
    mov AX, OFFSET buffer_inicial
    mov SI, AX

    mov AX, SEG buffer_final
    mov ES, AX
    mov AX, OFFSET buffer_final
    mov DI, AX

    mov CX, numBytes                 ;CX contera o numero de iteraes da funo ret
    rep movsb                        ;movsb copia o conteudo em DS:SI para ES:DI incrementando ou decrementando SI e DI

;desempilha os registradores
    pop DI
    pop ES
    pop SI
    pop DS
    pop CX
    pop AX

ENDM
