<?php

include("json.php");

function getTags($q)
{
    $result = file_get_contents("http://ajax.googleapis.com/ajax/services/search/web?v=1.0&q=".urlencode($q));

    $json = new Services_JSON();
    $result = $json->decode($result);

    $array_results = $result->responseData->results;
    
    $obj_return->counting = $result->responseData->cursor->estimatedResultCount / 1;

    foreach ($array_results as $term)
    {
        $titles .= $term->title . "<br>";
        $contents .= $term->content . "<br>";
    }

    $titles = utf8_decode($titles);
    $contents = utf8_decode($contents);

    $obj_return->word = $q;
    $obj_return->titles = $titles;
    $obj_return->contents = $contents;
    $obj_return->tags = getSignificantTermsArray($titles . $contents);
    
    return $obj_return;

}

function getSignificantTermsArray($s)
{
    // cURL must be installed for this to work
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, 'http://api.search.yahoo.com/ContentAnalysisService/V1/termExtraction');
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

    curl_setopt( $ch, CURLOPT_POSTFIELDS, 'appid=YOUR_APP_ID&context=' . urlencode($s) );
    $xml = curl_exec($ch);
    curl_close($ch);

    $object_xml = simplexml_load_string($xml);

    foreach ($object_xml->Result as $result) {
        $arrTerms[] = utf8_decode($result . "");
    }

    return $arrTerms;
}

?>