<?php


class NuvemTags
{
    var $listaPalavras = array();

    function NuvemTags($palavras = false)
    {
        $this->addPalavra($palavras);
    }

    function addPalavra($palavras)
    {
        if(is_array($palavras))
        {
            foreach($palavras as $p)
            {
                $this->listaPalavras[$p]++;
            }
        }
        else
            $this->listaPalavras[$palavras]++;
    }

    function obtemCss($percentualUso)
    {
        if($pecentualUso >= 99)
            $classe = 10;
        else {
            $classe = floor(($percentualUso));
        }

        return $classe;
    }

    function misturaPalavras()
    {
        $listaValores            = $this->listaPalavras;
        $palavras                = array_keys($this->listaPalavras);
        $this->listaPalavras    = array();

        shuffle($palavras);

        foreach($palavras as $palavra)
            $this->listaPalavras[$palavra] = $listaValores[$palavra];
    }

    function mostraNuvem()
    {
        if(!sizeof($this->listaPalavras))
        {
            trigger_error('Nenhuma palavra adicionada.', E_USER_ERROR);
        }
        elseif(!is_array($this->listaPalavras))
        {
            trigger_error('O membro palavras deve ser um array.', E_USER_ERROR);
        }
        else
        {
            $quantidadePresencas = array_sum($this->listaPalavras);

            $this->misturaPalavras();

            $nuvemTags = array();

            foreach($this->listaPalavras as $palavra => $presenca)
            {
                $aparecimentoPercentual = ((100 * $presenca) / $quantidadePresencas);
                $classeCss = $this->obtemCss($aparecimentoPercentual);

                $nuvemTags[] = array(
                    'palavra'    =>    $palavra,
                    'classe'    =>    $classeCss,
                    'percentual'=>  floor($aparecimentoPercentual)
                );
            }

            return $nuvemTags;
        }
    }
}

?> 