<?php

    require_once("util.php");
    
    $nome_email = getAtributo('nome_email');
    $email_email = getAtributo('email_email');
    $assunto_email = getAtributo('assunto_email');
    $html_email = getAtributo('html_email');
    
    $html_email = str_replace('/emailniver/download/',$http_root.'/download/',$html_email);

    $pessoas = localizarNaTabela('pessoa','1','1');

    // headers adicionais
    $headers = "From: $nome_email <$email_email>\n" . "MIME-Version: 1.0\n" . "Content-type: text/html; charset=UTF-8";

    $data_hoje = date('d/m');
    
    $pessoasEnviadas = Array();

    foreach($pessoas as $pessoa)
    {
        if($pessoa->aniversario == $data_hoje)
        {
            $pessoasEnviadas[] = $pessoa;
            if(!$pessoa->jaenviou)
            {
                mail($pessoa->email, $assunto_email, $html_email, $headers);
                $pessoa->jaenviou = 1;
                atualizarNaTabela('pessoa','idpessoa',$pessoa->idpessoa,$pessoa);
            }
        }
        else
        {
            if($pessoa->jaenviou)
            {
                $pessoa->jaenviou = 0;
                atualizarNaTabela('pessoa','idpessoa',$pessoa->idpessoa,$pessoa);
            }
        }
    }


?>


<html>
<head>
<title>Email de Aniversrio</title>
    <link rel="stylesheet" href="menu/menu_style.css" type="text/css" />
</head>
<body>

<center>
    <div class="quadro">
        <center><h2>Aniversariantes (<?php echo date('d/m'); ?>)</h2></center>
        <ul>
        <?php
        
            $zeroenvios = 1;

            foreach($pessoasEnviadas as $pessoa)
            {
                $zeroenvios = 0;
                echo "<li><b>".$pessoa->nome."</b> - <font color='green'>enviado</font></li>";
            }
            
            echo "</ul>";
            
            if($zeroenvios)
            {
                echo "<p><i>Nenhum email foi enviado hoje.<i></p>";
            }

        ?>

    </div>
</center>
<br><br>
<center>
    <div class="quadro"><?php echo $html_email; ?></div>
</center>

</body>
</html>