/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.abaco.runtime;

import br.ufpe.abaco.runtime.AbacoExecutionEngine;
import br.ufpe.abaco.runtime.Operator;
import br.ufpe.abaco.runtime.Term;
import br.ufpe.abaco.runtime.TermLocation;
import java.util.HashMap;
import native_code.StringTerm;

public class AbacoPrettyPrinter {
    AbacoExecutionEngine engine;
    HashMap printRules = new HashMap();
    Operator ppOperator;
    Operator defaultRule_op;
    Term defaultTerm;
    Operator prefix_op;
    Operator newLine_op;
    Operator concat_op;
    Operator center_op;
    Operator box_op;
    Operator arg0_op;
    Operator arg1_op;
    Operator arg2_op;
    Operator arg3_op;
    Operator arg4_op;
    Operator arg5_op;
    Operator arg6_op;
    Operator arg7_op;
    Operator arg8_op;
    Operator arg9_op;
    String prefix = "\n";
    boolean firstChar = true;

    AbacoPrettyPrinter(AbacoExecutionEngine abacoExecutionEngine) {
        this.engine = abacoExecutionEngine;
        this.ppOperator = this.engine.getOperator("pretty-printer _");
        this.defaultRule_op = this.engine.getOperator("default-rule");
        this.prefix_op = this.engine.getOperator("prefix ( _ , _ )");
        this.concat_op = this.engine.getOperator("_ _");
        this.newLine_op = this.engine.getOperator("nl");
        this.arg0_op = this.engine.getOperator("%0");
        this.arg1_op = this.engine.getOperator("%1");
        this.arg2_op = this.engine.getOperator("%2");
        this.arg3_op = this.engine.getOperator("%3");
        this.arg4_op = this.engine.getOperator("%4");
        this.arg5_op = this.engine.getOperator("%5");
        this.arg6_op = this.engine.getOperator("%6");
        this.arg7_op = this.engine.getOperator("%7");
        this.arg8_op = this.engine.getOperator("%8");
        this.arg9_op = this.engine.getOperator("%9");
        this.defaultTerm = this.engine.run(this.defaultRule_op);
    }

    Term getRule(Term term) {
        Operator operator = term.operator();
        if (this.printRules.containsKey(operator)) {
            return (Term)this.printRules.get(operator);
        }
        Term term2 = null;
        try {
            term2 = this.engine.parse("pretty-printer \"" + operator.name + "\"");
        }
        catch (Exception exception) {
            System.out.println("Parser Error pretty-printer \"" + operator.name + "\"");
            exception.printStackTrace();
            term2 = this.defaultTerm;
        }
        if (term2.operator() == this.ppOperator) {
            term2 = this.defaultTerm;
        }
        this.printRules.put(operator, term2);
        return term2;
    }

    void append(String string, StringBuffer stringBuffer) {
        if (this.firstChar) {
            stringBuffer.append(this.prefix);
            this.firstChar = false;
        }
        stringBuffer.append(string);
    }

    void append(char c, StringBuffer stringBuffer) {
        if (this.firstChar) {
            stringBuffer.append(this.prefix);
            this.firstChar = false;
        }
        stringBuffer.append(c);
    }

    void printFollowingRule(Term term, Term term2, StringBuffer stringBuffer, TermLocation termLocation) {
        Operator operator = term2.operator();
        if (term2 instanceof StringTerm) {
            this.append(((StringTerm)term2).value(), stringBuffer);
        } else if (operator == this.arg0_op) {
            this.print(term.getArg(0), stringBuffer, termLocation);
        } else if (operator == this.arg1_op) {
            this.print(term.getArg(1), stringBuffer, termLocation);
        } else if (operator == this.arg2_op) {
            this.print(term.getArg(2), stringBuffer, termLocation);
        } else if (operator == this.arg3_op) {
            this.print(term.getArg(3), stringBuffer, termLocation);
        } else if (operator == this.arg4_op) {
            this.print(term.getArg(4), stringBuffer, termLocation);
        } else if (operator == this.arg5_op) {
            this.print(term.getArg(5), stringBuffer, termLocation);
        } else if (operator == this.arg6_op) {
            this.print(term.getArg(6), stringBuffer, termLocation);
        } else if (operator == this.arg7_op) {
            this.print(term.getArg(7), stringBuffer, termLocation);
        } else if (operator == this.arg8_op) {
            this.print(term.getArg(8), stringBuffer, termLocation);
        } else if (operator == this.arg9_op) {
            this.print(term.getArg(9), stringBuffer, termLocation);
        } else if (operator == this.prefix_op) {
            String string = this.prefix;
            this.prefix = this.prefix + ((StringTerm)term2.getArg(0)).value();
            this.firstChar = true;
            this.printFollowingRule(term, term2.getArg(1), stringBuffer, termLocation);
            this.firstChar = true;
            this.prefix = string;
        } else if (operator == this.newLine_op) {
            this.firstChar = true;
        } else if (operator == this.concat_op) {
            this.printFollowingRule(term, term2.getArg(0), stringBuffer, termLocation);
            if (!this.firstChar) {
                stringBuffer.append(" ");
            }
            this.printFollowingRule(term, term2.getArg(1), stringBuffer, termLocation);
        } else if (operator == this.defaultRule_op) {
            int n = 0;
            String string = term.operator().name;
            int n2 = 0;
            while (n2 < string.length()) {
                char c = string.charAt(n2);
                if (c == '_') {
                    Term term3;
                    if ((term3 = term.getArg(n++)).arity() > 0) {
                        this.append('(', stringBuffer);
                    }
                    this.print(term3, stringBuffer, termLocation);
                    if (term3.arity() > 0) {
                        this.append(')', stringBuffer);
                    }
                } else {
                    this.append(c, stringBuffer);
                }
                ++n2;
            }
        }
    }

    void print(Term term, StringBuffer stringBuffer, TermLocation termLocation) {
        if (termLocation != null) {
            termLocation.setBegin(term, stringBuffer.length());
        }
        if (term.operator() == null) {
            this.append(term.toString(), stringBuffer);
        } else {
            this.printFollowingRule(term, this.getRule(term), stringBuffer, termLocation);
        }
        if (termLocation != null) {
            termLocation.setEnd(term, stringBuffer.length());
        }
    }
}

