/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.abaco.ParserGen.parser;

import br.ufpe.abaco.ParserGen.parser.ParserGenerationException;
import br.ufpe.abaco.ParserGen.parser.Production;
import br.ufpe.abaco.ParserGen.parser.ReduceAction;
import br.ufpe.abaco.ParserGen.parser.ShiftAction;
import br.ufpe.abaco.ParserGen.parser.TerminalSymbol;
import java.io.Serializable;

abstract class ParserAction
implements Serializable {
    protected Production production;
    private int length = 1;
    private ParserAction nextAction;
    private boolean debug;
    private StringBuffer log;

    ParserAction() {
    }

    ParserAction(Production production) {
        this.production = production;
    }

    ParserAction(Production production, boolean bl, StringBuffer stringBuffer) {
        this.production = production;
        this.debug = bl;
        this.log = stringBuffer;
    }

    public int getLength() {
        return this.length;
    }

    public boolean hasAction(ParserAction parserAction) {
        boolean bl = false;
        ParserAction parserAction2 = this;
        while (parserAction2 != null) {
            if (parserAction2.equals(parserAction)) {
                bl = true;
                break;
            }
            parserAction2 = parserAction2.nextAction;
        }
        return bl;
    }

    public ParserAction[] toArray() {
        ParserAction[] parserActionArray = new ParserAction[this.length];
        ParserAction parserAction = this;
        int n = this.length - 1;
        while (n >= 0) {
            parserActionArray[n] = parserAction;
            parserAction = parserAction.nextAction;
            --n;
        }
        return parserActionArray;
    }

    ParserAction addAction(int n, TerminalSymbol terminalSymbol, ParserAction parserAction) {
        ParserAction parserAction2 = null;
        int n2 = this.getPrecedence();
        int n3 = parserAction.getPrecedence();
        if (n3 > n2) {
            parserAction2 = parserAction;
        } else if (n3 < n2) {
            parserAction2 = this;
        } else {
            if (this.debug && this.log != null) {
                this.log.append("<<CONFLICT>>\n");
                this.log.append("State: " + n + '\n');
                this.log.append("Symbol: " + terminalSymbol.name + '\n');
                this.log.append("Previous action: " + this + ", Rule: " + this.production + '\n');
                this.log.append("New action: " + parserAction + " Rule: " + parserAction.production + '\n');
                this.log.append("Previous actions's precedence = " + n2 + '\n');
                this.log.append("New actions's precedence = " + n3 + '\n');
                this.log.append("It is not possible to solve the ambiguity.\n\n");
            }
            if (parserAction.production.getAssociativity() == 4) {
                ParserAction parserAction3 = this.findActionWithProduction(parserAction.production);
                if (parserAction instanceof ShiftAction && parserAction3 instanceof ReduceAction || parserAction instanceof ReduceAction && parserAction3 instanceof ShiftAction) {
                    String string = "Shift-Reduce conflict envolving non-associative production " + parserAction.production.toString() + " between the actions " + parserAction.print() + " and " + parserAction3.print();
                    if (this.debug && this.log != null) {
                        this.log.append(string);
                    }
                    throw new ParserGenerationException(string);
                }
            }
            parserAction.nextAction = this;
            parserAction.length = this.length + 1;
            parserAction2 = parserAction;
        }
        return parserAction2;
    }

    ParserAction getNextAction() {
        return this.nextAction;
    }

    private ParserAction findActionWithProduction(Production production) {
        ParserAction parserAction = this;
        while (parserAction != null) {
            if (parserAction.production.equals(production)) break;
            parserAction = parserAction.nextAction;
        }
        return parserAction;
    }

    public abstract boolean equals(Object var1);

    public abstract String print();

    public abstract String toString();

    public abstract int getPrecedence();
}

