/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.abaco.ParserGen.parser;

import br.ufpe.abaco.ParserGen.CompilerException;
import br.ufpe.abaco.ParserGen.lexer.Token;
import br.ufpe.abaco.ParserGen.parser.AcceptAction;
import br.ufpe.abaco.ParserGen.parser.BNFGrammar;
import br.ufpe.abaco.ParserGen.parser.BacktrackingAction;
import br.ufpe.abaco.ParserGen.parser.ErrorAction;
import br.ufpe.abaco.ParserGen.parser.GrammarSymbol;
import br.ufpe.abaco.ParserGen.parser.LRTable;
import br.ufpe.abaco.ParserGen.parser.NonTerminalSymbol;
import br.ufpe.abaco.ParserGen.parser.ParserAction;
import br.ufpe.abaco.ParserGen.parser.ParsingException;
import br.ufpe.abaco.ParserGen.parser.Production;
import br.ufpe.abaco.ParserGen.parser.ReduceAction;
import br.ufpe.abaco.ParserGen.parser.SemanticAction;
import br.ufpe.abaco.ParserGen.parser.ShiftAction;
import br.ufpe.abaco.ParserGen.parser.TerminalSymbol;
import java.io.Serializable;

public class Parser
implements Serializable {
    public static final byte BACKTRACKING_PARSING = 1;
    public static final byte PSEUDO_PARALELL_PARSING = 2;
    public static final int MAX_BACKTRACKS = 20000000;
    private LRTable table;
    private BNFGrammar grammar;
    private SemanticAction[] semActions;
    private StringBuffer log = new StringBuffer();
    private static final boolean DEBUG = true;
    private static final String PARSER_FILE = "PARSER.TXT";
    private static final String LANGUAGE_FILE = "LANGUAGE.TXT";

    public Parser(BNFGrammar bNFGrammar) {
        this(bNFGrammar, false);
    }

    public Parser(BNFGrammar bNFGrammar, boolean bl) {
        Production production = bNFGrammar.augment();
        Production[] productionArray = bNFGrammar.getAllProductions();
        int n = productionArray.length;
        this.semActions = new SemanticAction[n];
        int n2 = 0;
        while (n2 < n) {
            this.semActions[n2] = productionArray[n2].getSemanticAction();
            ++n2;
        }
        this.table = new LRTable(bNFGrammar, production, bl);
        this.grammar = bNFGrammar;
        if (bl) {
            this.saveGrammarLog();
        }
    }

    public String getLog() {
        return this.log.toString();
    }

    public String getGrammarLog() {
        return this.table.getLog();
    }

    public void saveGrammarLog() {
    }

    public Object parse(Token[] tokenArray, byte by, boolean bl) throws CompilerException {
        Object[] objectArray = null;
        if (tokenArray != null && tokenArray.length > 0) {
            try {
                if (by == 1) {
                    objectArray = this.backtrackingParse(tokenArray, bl);
                } else if (by == 2) {
                    objectArray = this.paralellParse(tokenArray);
                } else {
                    throw new IllegalArgumentException("parametro parsingProcess invalido");
                }
                Object var6_5 = null;
                this.saveParserLog();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.saveParserLog();
                throw throwable;
            }
        }
        return objectArray;
    }

    public Object backtrackingParse(Token[] tokenArray, boolean bl) throws CompilerException {
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        this.log.setLength(0);
        int n2 = 0;
        ParserStackElement parserStackElement = new ParserStackElement(LRTable.FIRST_STATE, null, null);
        Object object = null;
        int n3 = -1;
        BacktrackingState[] backtrackingStateArray = new BacktrackingState[10000];
        BacktrackingState backtrackingState = null;
        int n4 = -1;
        TerminalSymbol terminalSymbol = null;
        String string = null;
        ParserAction parserAction = null;
        ParserAction[] parserActionArray = new ParserAction[1];
        TerminalSymbol[] terminalSymbolArray = null;
        boolean bl4 = true;
        while (!bl2 && n <= 20000000) {
            Serializable serializable;
            int n5;
            if (!bl3) {
                terminalSymbolArray = tokenArray[n2].getMatchings();
                if (bl4) {
                    terminalSymbol = terminalSymbolArray[0];
                }
                string = tokenArray[n2].getValue();
                n5 = parserStackElement.state;
                parserActionArray = this.table.getActionEntry(n5, terminalSymbol, new ParserAction[1]);
                parserAction = parserActionArray[0];
                if (parserActionArray.length > 1 || terminalSymbolArray.length > 1) {
                    backtrackingStateArray[++n4] = new BacktrackingState(n2, parserActionArray, terminalSymbolArray, string, parserStackElement);
                    if (bl) {
                        this.log.append("\n<<Ambiguity - Level " + n4 + ">>\n");
                        int n6 = 0;
                        while (n6 < parserActionArray.length) {
                            this.log.append("Action " + n6 + ": " + parserActionArray[n6].print());
                            ++n6;
                        }
                        this.log.append("\n\n");
                    }
                }
            } else {
                boolean bl5 = false;
                while (!bl5 && n4 >= 0) {
                    backtrackingState = backtrackingStateArray[n4];
                    if (backtrackingState.nextAction < backtrackingState.actions.length) {
                        bl5 = true;
                        terminalSymbol = backtrackingState.terminals[backtrackingState.nextTerminal];
                        parserStackElement = backtrackingState.top;
                        n2 = backtrackingState.sentenceIndex;
                        string = backtrackingState.lexema;
                        parserAction = backtrackingState.actions[backtrackingState.nextAction];
                        backtrackingState.nextAction++;
                        if (!bl) continue;
                        this.log.append("Level " + n4 + " - Trying action: " + parserAction.print());
                        continue;
                    }
                    backtrackingState.nextTerminal++;
                    if (backtrackingState.nextTerminal < backtrackingState.terminals.length) {
                        bl5 = true;
                        terminalSymbol = backtrackingState.terminals[backtrackingState.nextTerminal];
                        parserStackElement = backtrackingState.top;
                        n2 = backtrackingState.sentenceIndex;
                        string = backtrackingState.lexema;
                        parserActionArray = this.table.getActionEntry(parserStackElement.state, terminalSymbol, parserActionArray);
                        BacktrackingState.access$202(backtrackingState, parserActionArray);
                        parserAction = parserActionArray[0];
                        backtrackingState.nextAction = 1;
                        continue;
                    }
                    backtrackingStateArray[n4] = null;
                    --n4;
                }
                if (!bl5) {
                    serializable = new StringBuffer();
                    while (n3 < tokenArray.length && ((StringBuffer)serializable).length() < 20) {
                        ((StringBuffer)serializable).append(tokenArray[n3++].getValue());
                        ((StringBuffer)serializable).append(" ");
                    }
                    if (n3 < tokenArray.length) {
                        ((StringBuffer)serializable).append(" ...");
                    }
                    throw new ParsingException(((StringBuffer)serializable).toString());
                }
                bl3 = false;
                ++n;
                if (bl) {
                    this.log.append("<< Backtrack >>\n");
                }
            }
            if (bl) {
                this.log.append(">> Symbol: " + terminalSymbol + '\n' + ">> Text: " + string + '\n' + "   => Action: " + parserAction.print() + '\n');
            }
            if (parserAction instanceof ShiftAction) {
                parserStackElement = new ParserStackElement(((ShiftAction)parserAction).state, terminalSymbol.getAction().act(string, tokenArray[n2].getLine(), tokenArray[n2].getStartPos()), parserStackElement, terminalSymbol);
                ++n2;
                bl4 = true;
                continue;
            }
            if (parserAction instanceof ReduceAction) {
                Production production = ((ReduceAction)parserAction).production;
                serializable = production.getLeftSide();
                ParserStackElement parserStackElement2 = parserStackElement;
                int n7 = production.getRightSide().length;
                Object[] objectArray = new Object[n7];
                int n8 = 0;
                while (n8 < n7) {
                    objectArray[n7 - n8 - 1] = parserStackElement2.value;
                    parserStackElement2 = parserStackElement2.next;
                    ++n8;
                }
                n5 = parserStackElement2.state;
                SemanticAction semanticAction = this.semActions[production.index];
                parserStackElement = new ParserStackElement(this.table.getGotoEntry(n5, (NonTerminalSymbol)serializable), this.semActions[production.index].act(objectArray), parserStackElement2, (GrammarSymbol)serializable);
                if (semanticAction instanceof BacktrackingAction) {
                    bl3 = true;
                }
                bl4 = false;
                continue;
            }
            if (parserAction instanceof ErrorAction) {
                if (n2 > n3) {
                    n3 = n2;
                }
                bl3 = true;
                bl4 = false;
                continue;
            }
            if (!(parserAction instanceof AcceptAction)) continue;
            bl2 = true;
            object = parserStackElement.value;
        }
        if (n > 20000000) {
            throw new ParsingException(tokenArray[n3], "Backtracks limits reached!!!");
        }
        return object;
    }

    public Object[] paralellParse(Token[] tokenArray) throws CompilerException {
        Object object;
        boolean bl = false;
        ParserStackElement[] parserStackElementArray = new ParserStackElement[10000];
        ParserStackElement[] parserStackElementArray2 = new ParserStackElement[10000];
        Object[] objectArray = new Object[5000];
        int n = 0;
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        parserStackElementArray2[0] = new ParserStackElement(LRTable.FIRST_STATE, null, null);
        while (n3 >= 0) {
            ParserStackElement[] parserStackElementArray3 = parserStackElementArray;
            parserStackElementArray = parserStackElementArray2;
            parserStackElementArray2 = parserStackElementArray3;
            n2 = n3;
            n3 = -1;
            TerminalSymbol[] terminalSymbolArray = tokenArray[n].getMatchings();
            String string = tokenArray[n].getValue();
            ++n;
            ParserAction[] parserActionArray = new ParserAction[1];
            while (n2 >= 0) {
                object = parserStackElementArray[n2];
                --n2;
                int n5 = 0;
                while (n5 < terminalSymbolArray.length) {
                    TerminalSymbol terminalSymbol = terminalSymbolArray[n5];
                    parserActionArray = this.table.getActionEntry(((ParserStackElement)object).state, terminalSymbol, parserActionArray);
                    int n6 = 0;
                    while (n6 < parserActionArray.length) {
                        int n7;
                        ParserAction parserAction = parserActionArray[n6];
                        if (parserAction instanceof ShiftAction) {
                            n7 = ((ShiftAction)parserAction).state;
                            parserStackElementArray2[++n3] = new ParserStackElement(n7, terminalSymbol.getAction().act(string, tokenArray[n].getLine(), tokenArray[n].getStartPos()), (ParserStackElement)object, terminalSymbol);
                        } else if (parserAction instanceof ReduceAction) {
                            Production production = ((ReduceAction)parserAction).production;
                            Object object2 = object;
                            int n8 = production.getRightSide().length;
                            Object[] objectArray2 = new Object[n8];
                            int n9 = 0;
                            while (n9 < n8) {
                                objectArray2[n8 - n9 - 1] = ((ParserStackElement)object2).value;
                                object2 = ((ParserStackElement)object2).next;
                                ++n9;
                            }
                            n7 = this.table.getGotoEntry(((ParserStackElement)object2).state, production.getLeftSide());
                            Object object3 = this.semActions[production.index].act(objectArray2);
                            parserStackElementArray[++n2] = new ParserStackElement(n7, object3, (ParserStackElement)object2, production.getLeftSide());
                        } else if (parserAction instanceof AcceptAction) {
                            bl = true;
                            if (n4 < objectArray.length) {
                                objectArray[n4++] = ((ParserStackElement)object).value;
                            }
                        }
                        ++n6;
                    }
                    ++n5;
                }
            }
        }
        object = new Object[n4];
        int n10 = 0;
        while (n10 < n4) {
            object[n10] = objectArray[n10];
            ++n10;
        }
        return object;
    }

    public void saveParserLog() {
    }

    public void printTable() {
        this.table.print();
    }

    class BacktrackingState {
        private final ParserStackElement top;
        private final int sentenceIndex;
        private final String lexema;
        private final TerminalSymbol[] terminals;
        private int nextTerminal;
        private ParserAction[] actions;
        private int nextAction;

        BacktrackingState(int n, ParserAction[] parserActionArray, TerminalSymbol[] terminalSymbolArray, String string, ParserStackElement parserStackElement) {
            this.sentenceIndex = n;
            this.actions = parserActionArray;
            this.nextAction = 1;
            this.terminals = terminalSymbolArray;
            this.nextTerminal = 0;
            this.lexema = string;
            this.top = parserStackElement;
        }

        static /* synthetic */ ParserAction[] access$202(BacktrackingState backtrackingState, ParserAction[] parserActionArray) {
            backtrackingState.actions = parserActionArray;
            return parserActionArray;
        }
    }

    class ParserStackElement {
        private final ParserStackElement next;
        private final Object value;
        private final int state;
        private GrammarSymbol symbol;

        ParserStackElement(int n, Object object, ParserStackElement parserStackElement, GrammarSymbol grammarSymbol) {
            this.state = n;
            this.value = object;
            this.next = parserStackElement;
            this.symbol = grammarSymbol;
        }

        ParserStackElement(int n, Object object, ParserStackElement parserStackElement) {
            this.state = n;
            this.value = object;
            this.next = parserStackElement;
        }

        public int size() {
            if (this.next == null) {
                return 1;
            }
            return 1 + this.next.size();
        }

        public String toString() {
            String string = this.next == null ? "" : this.next.toString() + " ";
            String string2 = this.symbol == null ? "" : this.symbol.toString() + " ";
            String string3 = this.value == null ? "" : "<<" + this.value.toString() + ">> ";
            return string + string2 + string3 + this.state;
        }
    }
}

