/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.abaco.ParserGen.parser;

import br.ufpe.abaco.ParserGen.parser.AcceptAction;
import br.ufpe.abaco.ParserGen.parser.BNFGrammar;
import br.ufpe.abaco.ParserGen.parser.ErrorAction;
import br.ufpe.abaco.ParserGen.parser.GrammarSymbol;
import br.ufpe.abaco.ParserGen.parser.LRItem;
import br.ufpe.abaco.ParserGen.parser.LRState;
import br.ufpe.abaco.ParserGen.parser.NonTerminalSymbol;
import br.ufpe.abaco.ParserGen.parser.ParserAction;
import br.ufpe.abaco.ParserGen.parser.Production;
import br.ufpe.abaco.ParserGen.parser.ReduceAction;
import br.ufpe.abaco.ParserGen.parser.ShiftAction;
import br.ufpe.abaco.ParserGen.parser.TerminalSymbol;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;

public class LRTable
implements Serializable {
    static int FIRST_STATE = 0;
    private LRState[] states;
    private ParserAction[][] actionsTable;
    private int[][] gotoTable;
    private BNFGrammar grammar;
    private int numberOfStates;
    private boolean debug;
    private StringBuffer log = new StringBuffer();
    private static String TABLE_FILE = "TABELA.TXT";
    int ambiguities;

    public LRTable(BNFGrammar bNFGrammar, Production production) {
        this(bNFGrammar, production, false);
    }

    public LRTable(BNFGrammar bNFGrammar, Production production, boolean bl) {
        this.debug = bl;
        this.grammar = bNFGrammar;
        Map map = null;
        map = this.canonicalCollection(production);
        this.fillActionTable(map, production);
        this.fillGotoTable(map);
    }

    ParserAction getActionEntry(int n, TerminalSymbol terminalSymbol) {
        return this.actionsTable[terminalSymbol.index][n];
    }

    ParserAction[] getActionEntry(int n, TerminalSymbol terminalSymbol, ParserAction[] parserActionArray) {
        return this.actionsTable[terminalSymbol.index][n].toArray();
    }

    int getGotoEntry(int n, NonTerminalSymbol nonTerminalSymbol) {
        return this.gotoTable[nonTerminalSymbol.index][n];
    }

    private void fillActionTable(Map map, Production production) {
        Iterator iterator = map.keySet().iterator();
        TerminalSymbol[] terminalSymbolArray = this.grammar.getTerminals();
        this.createActionTable(map.size());
        if (this.debug) {
            this.log.append("\n\n================ AMBIGUITIES LIST =================\n\n");
        }
        while (iterator.hasNext()) {
            int n;
            Object object;
            LRState lRState = (LRState)iterator.next();
            LRItem[] lRItemArray = lRState.getItems();
            int n2 = (Integer)map.get(lRState);
            int n3 = 0;
            while (n3 < lRItemArray.length) {
                Production production2 = lRItemArray[n3].production;
                if (lRItemArray[n3].position == production2.getRightSide().length) {
                    if (production2 == production) {
                        this.addAction(n2, new AcceptAction());
                    } else {
                        object = new ReduceAction(production2, this.debug, this.log);
                        this.addAction(n2, terminalSymbolArray[0].index, (ParserAction)object);
                        int n4 = 1;
                        while (n4 < terminalSymbolArray.length) {
                            n = this.actionsTable[terminalSymbolArray[n4].index][n2].getLength();
                            this.actionsTable[terminalSymbolArray[n4].index][n2] = this.actionsTable[terminalSymbolArray[0].index][n2];
                            if (this.actionsTable[terminalSymbolArray[n4].index][n2].getLength() > n) {
                                ++this.ambiguities;
                            }
                            ++n4;
                        }
                    }
                }
                ++n3;
            }
            object = lRState.getReadSymbols();
            int[] nArray = lRState.destPlaces;
            n3 = 0;
            while (n3 < ((GrammarSymbol[])object).length) {
                if (object[n3] instanceof TerminalSymbol) {
                    n = nArray[n3];
                    Production production3 = lRState.getAssociatedProduction(n3);
                    this.addAction(n2, object[n3].index, new ShiftAction(n, production3, this.debug, this.log));
                }
                ++n3;
            }
        }
    }

    private void createActionTable(int n) {
        ErrorAction errorAction = new ErrorAction();
        int n2 = this.grammar.getNumTerminals();
        this.actionsTable = new ParserAction[n2][];
        int n3 = 0;
        while (n3 < n2) {
            ParserAction[] parserActionArray = new ParserAction[n];
            this.actionsTable[n3] = parserActionArray;
            int n4 = 0;
            while (n4 < n) {
                parserActionArray[n4] = errorAction;
                ++n4;
            }
            ++n3;
        }
    }

    private void addAction(int n, AcceptAction acceptAction) {
        this.addAction(n, TerminalSymbol.EOF.index, acceptAction);
    }

    private void addAction(int n, int n2, ParserAction parserAction) {
        if (parserAction == null) {
            throw new IllegalArgumentException("parametro newAction null!");
        }
        ParserAction parserAction2 = this.actionsTable[n2][n];
        TerminalSymbol terminalSymbol = this.grammar.getTerminals()[n2];
        if (parserAction2 instanceof ErrorAction) {
            this.actionsTable[n2][n] = parserAction;
        } else if (!this.actionsTable[n2][n].hasAction(parserAction)) {
            int n3 = this.actionsTable[n2][n].getLength();
            this.actionsTable[n2][n] = this.actionsTable[n2][n].addAction(n, terminalSymbol, parserAction);
            if (this.actionsTable[n2][n].getLength() > n3) {
                ++this.ambiguities;
            }
        }
    }

    private void fillGotoTable(Map map) {
        NonTerminalSymbol[] nonTerminalSymbolArray = this.grammar.getNonTerminals();
        Iterator iterator = map.keySet().iterator();
        int n = map.size();
        this.gotoTable = new int[nonTerminalSymbolArray.length][];
        int n2 = 0;
        while (n2 < this.gotoTable.length) {
            this.gotoTable[n2] = new int[n];
            ++n2;
        }
        while (iterator.hasNext()) {
            LRState lRState = (LRState)iterator.next();
            int n3 = (Integer)map.get(lRState);
            GrammarSymbol[] grammarSymbolArray = lRState.getReadSymbols();
            int[] nArray = lRState.destPlaces;
            n2 = 0;
            while (n2 < grammarSymbolArray.length) {
                if (grammarSymbolArray[n2] instanceof NonTerminalSymbol) {
                    this.gotoTable[grammarSymbolArray[n2].index][n3] = nArray[n2];
                }
                ++n2;
            }
        }
    }

    private Map canonicalCollection(Production production) {
        HashMap<LRState, Integer> hashMap = new HashMap<LRState, Integer>();
        Stack<LRState> stack = new Stack<LRState>();
        GrammarSymbol[] grammarSymbolArray = this.grammar.getSymbols();
        int n = 0;
        if (this.debug) {
            this.log.append("\n\n================ STATES & CANONICAL COLLECTION =================\n\n");
        }
        LRState lRState = new LRState();
        lRState.addItem(new LRItem(production, 0));
        if (this.debug) {
            this.log.append("State 0: \n\n" + lRState.toString() + "\n\n\n");
        }
        hashMap.put(lRState, new Integer(n++));
        stack.push(lRState);
        LRState lRState2 = new LRState();
        do {
            lRState = (LRState)stack.pop();
            GrammarSymbol[] grammarSymbolArray2 = lRState.getReadSymbols();
            int[] nArray = new int[grammarSymbolArray2.length];
            int n2 = 0;
            while (n2 < grammarSymbolArray2.length) {
                lRState2.clear();
                lRState.branch(grammarSymbolArray2[n2], lRState2);
                Object v = hashMap.get(lRState2);
                if (v == null) {
                    LRState lRState3 = lRState2.getCopy();
                    stack.push(lRState3);
                    nArray[n2] = n;
                    hashMap.put(lRState3, new Integer(n));
                    if (this.debug) {
                        this.log.append("State " + n + "\n\n" + lRState3.toString() + "\n\n\n");
                    }
                    ++n;
                } else {
                    nArray[n2] = (Integer)v;
                }
                ++n2;
            }
            lRState.destPlaces = nArray;
        } while (!stack.empty());
        this.numberOfStates = n;
        return hashMap;
    }

    public void print() {
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(TABLE_FILE));
            int n = this.actionsTable[0].length;
            TerminalSymbol[] terminalSymbolArray = this.grammar.getTerminals();
            int n2 = 0;
            while (n2 < n) {
                printWriter.println("State: " + n2);
                printWriter.println(this.states[n2]);
                printWriter.println("\n\n");
                ++n2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getLog() {
        String string = "\n\n================ LANGUAGE'S GRAMMAR =================\n\n" + this.grammar.toString() + "\n\n" + "Number of states = " + this.numberOfStates + "\n\n" + "Number of ambiguities = " + this.ambiguities + "\n\n" + this.log.toString();
        return string;
    }
}

