/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.abaco.ParserGen.parser;

import br.ufpe.abaco.ParserGen.parser.GrammarSymbol;
import br.ufpe.abaco.ParserGen.parser.LRItem;
import br.ufpe.abaco.ParserGen.parser.NonTerminalSymbol;
import br.ufpe.abaco.ParserGen.parser.Production;
import java.io.Serializable;

class LRState
implements Comparable,
Serializable {
    int maxPrecedence;
    int minPrecedence = 1000000;
    int[] destPlaces;
    private LRItem[] items;
    private int numItems;
    private GrammarSymbol[] readSymbols;
    private int[] readSymbolsProductions;
    private int numSymbols;
    int hCode;

    LRState(LRItem[] lRItemArray, GrammarSymbol[] grammarSymbolArray, int n, int n2) {
        this(lRItemArray, grammarSymbolArray);
        this.maxPrecedence = n2;
        this.minPrecedence = n;
    }

    LRState(LRItem[] lRItemArray, GrammarSymbol[] grammarSymbolArray) {
        this.readSymbols = grammarSymbolArray;
        this.numSymbols = grammarSymbolArray.length;
        this.items = lRItemArray;
        this.numItems = lRItemArray.length;
        this.hCode = 0;
        int n = 0;
        while (n < this.numItems) {
            this.hCode += this.items[n].ordem;
            ++n;
        }
        this.readSymbolsProductions = new int[this.numSymbols];
    }

    LRState(LRItem[] lRItemArray, GrammarSymbol[] grammarSymbolArray, int[] nArray) {
        this(lRItemArray, grammarSymbolArray);
        this.readSymbolsProductions = nArray;
    }

    LRState() {
        this.items = new LRItem[20];
        this.numItems = 0;
        this.readSymbols = new GrammarSymbol[20];
        this.readSymbolsProductions = new int[20];
        this.numSymbols = 0;
        this.hCode = 0;
    }

    public int hashCode() {
        return this.hCode;
    }

    public LRItem[] getItems() {
        if (this.items.length == this.numItems) {
            return this.items;
        }
        LRItem[] lRItemArray = new LRItem[this.numItems];
        int n = 0;
        while (n < this.numItems) {
            lRItemArray[n] = this.items[n];
            ++n;
        }
        return lRItemArray;
    }

    public GrammarSymbol[] getReadSymbols() {
        if (this.readSymbols.length == this.numSymbols) {
            return this.readSymbols;
        }
        GrammarSymbol[] grammarSymbolArray = new GrammarSymbol[this.numSymbols];
        int n = 0;
        while (n < this.numSymbols) {
            grammarSymbolArray[n] = this.readSymbols[n];
            ++n;
        }
        return grammarSymbolArray;
    }

    void clear() {
        this.numItems = 0;
        this.numSymbols = 0;
        this.hCode = 0;
    }

    LRState getCopy() {
        LRItem[] lRItemArray = new LRItem[this.numItems];
        int n = 0;
        while (n < this.numItems) {
            lRItemArray[n] = this.items[n];
            ++n;
        }
        GrammarSymbol[] grammarSymbolArray = new GrammarSymbol[this.numSymbols];
        int[] nArray = new int[this.numSymbols];
        n = 0;
        while (n < this.numSymbols) {
            grammarSymbolArray[n] = this.readSymbols[n];
            nArray[n] = this.readSymbolsProductions[n];
            ++n;
        }
        return new LRState(lRItemArray, grammarSymbolArray, nArray);
    }

    void addItem(LRItem lRItem) {
        int n;
        if (this.numItems == this.items.length) {
            LRItem[] lRItemArray = this.items;
            this.items = new LRItem[lRItemArray.length * 2];
            n = 0;
            while (n < this.numItems) {
                this.items[n] = lRItemArray[n];
                ++n;
            }
        }
        int n2 = 0;
        while (n2 < this.numItems && this.items[n2].ordem > lRItem.ordem) {
            ++n2;
        }
        if (n2 < this.numItems && this.items[n2].ordem == lRItem.ordem) {
            return;
        }
        n = this.numItems;
        while (n > n2) {
            this.items[n] = this.items[n - 1];
            --n;
        }
        this.items[n2] = lRItem;
        ++this.numItems;
        this.hCode += lRItem.ordem;
        if (lRItem.position > 0) {
            int n3 = lRItem.production.getShiftPrecedence();
            if (this.minPrecedence > n3) {
                this.minPrecedence = n3;
            }
            if (this.maxPrecedence < n3) {
                this.maxPrecedence = n3;
            }
        }
        if (lRItem.acceptedSym == null) {
            return;
        }
        GrammarSymbol grammarSymbol = lRItem.acceptedSym;
        n = 0;
        while (n < this.numSymbols) {
            if (this.readSymbols[n] == grammarSymbol) {
                return;
            }
            ++n;
        }
        if (this.numSymbols == this.readSymbols.length) {
            int n4 = this.numSymbols * 2;
            GrammarSymbol[] grammarSymbolArray = new GrammarSymbol[n4];
            int[] nArray = new int[n4];
            n = 0;
            while (n < this.numSymbols) {
                grammarSymbolArray[n] = this.readSymbols[n];
                nArray[n] = this.readSymbolsProductions[n];
                ++n;
            }
            this.readSymbols = grammarSymbolArray;
            this.readSymbolsProductions = nArray;
        }
        this.readSymbols[n] = grammarSymbol;
        this.readSymbolsProductions[n] = n2;
        ++this.numSymbols;
        if (grammarSymbol instanceof NonTerminalSymbol) {
            lRItem.production.getGrammar().insertProductionsOf((NonTerminalSymbol)grammarSymbol, this);
        }
    }

    Production getAssociatedProduction(int n) {
        Production production = null;
        if (n < this.numSymbols) {
            production = this.items[this.readSymbolsProductions[n]].production;
        }
        return production;
    }

    boolean isEmpty() {
        return this.numItems == 0;
    }

    public int compareTo(Object object) {
        LRState lRState = (LRState)object;
        if (lRState.numItems != this.numItems) {
            return lRState.numItems - this.numItems;
        }
        int n = 0;
        while (n < this.numItems) {
            if (this.items[n].ordem != lRState.items[n].ordem) {
                return this.items[n].ordem - lRState.items[n].ordem;
            }
            ++n;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof LRState)) {
            return false;
        }
        LRState lRState = (LRState)object;
        if (lRState.numItems != this.numItems) {
            return false;
        }
        int n = 0;
        while (n < this.numItems) {
            if (this.items[n] != lRState.items[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    boolean hasItem(LRItem lRItem) {
        int n = 0;
        while (n < this.numItems) {
            if (this.items[n] == lRItem) {
                return true;
            }
            if (this.items[n].ordem < lRItem.ordem) {
                return false;
            }
            ++n;
        }
        return false;
    }

    LRState branch(GrammarSymbol grammarSymbol) {
        LRState lRState = new LRState();
        this.branch(grammarSymbol, lRState);
        return lRState;
    }

    void branch(GrammarSymbol grammarSymbol, LRState lRState) {
        int n = 0;
        while (n < this.numItems) {
            LRItem lRItem = this.items[n];
            int n2 = lRItem.position;
            GrammarSymbol[] grammarSymbolArray = lRItem.production.getRightSide();
            if (n2 < grammarSymbolArray.length && grammarSymbolArray[n2] == grammarSymbol) {
                lRState.addItem(lRItem.production.items[n2 + 1]);
            }
            ++n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        int n = 0;
        while (n < this.numItems) {
            stringBuffer.append(this.items[n].toString());
            if (n < this.numItems - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

