/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.abaco.ParserGen.parser;

import br.ufpe.abaco.ParserGen.lexer.RegExp;
import br.ufpe.abaco.ParserGen.parser.GrammarSymbol;
import br.ufpe.abaco.ParserGen.parser.LRState;
import br.ufpe.abaco.ParserGen.parser.NonTerminalSymbol;
import br.ufpe.abaco.ParserGen.parser.Production;
import br.ufpe.abaco.ParserGen.parser.TerminalSymbol;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class BNFGrammar
implements Serializable {
    private NonTerminalSymbol startSymbol;
    private Production startProduction;
    private Production[] productions;
    private int numProds = 0;
    private TerminalSymbol[] terminals = new TerminalSymbol[40];
    private int numTerminals;
    private NonTerminalSymbol[] nonTerminals = new NonTerminalSymbol[40];
    private int numNonTerminals = 0;

    public BNFGrammar() {
        this.productions = new Production[40];
        this.terminals[0] = TerminalSymbol.EOF;
        this.numTerminals = 1;
    }

    public TerminalSymbol getTerminal(String string) {
        return this.getTerminal(string, null);
    }

    public TerminalSymbol getTerminal(String string, RegExp regExp) {
        int n = 0;
        while (n < this.numTerminals) {
            if (this.terminals[n].getName().equals(string)) {
                return this.terminals[n];
            }
            ++n;
        }
        if (this.numTerminals == this.terminals.length) {
            TerminalSymbol[] terminalSymbolArray = this.terminals;
            this.terminals = new TerminalSymbol[terminalSymbolArray.length + 40];
            int n2 = 0;
            while (n2 < terminalSymbolArray.length) {
                this.terminals[n2] = terminalSymbolArray[n2];
                ++n2;
            }
        }
        TerminalSymbol terminalSymbol = regExp != null ? new TerminalSymbol(string, regExp, this.numTerminals) : new TerminalSymbol(string, this.numTerminals);
        this.terminals[this.numTerminals] = terminalSymbol;
        ++this.numTerminals;
        return terminalSymbol;
    }

    public NonTerminalSymbol getNonTerminal(String string) {
        NonTerminalSymbol nonTerminalSymbol;
        int n = 0;
        while (n < this.numNonTerminals) {
            if (this.nonTerminals[n].getName().equals(string)) {
                return this.nonTerminals[n];
            }
            ++n;
        }
        if (this.numNonTerminals == this.nonTerminals.length) {
            NonTerminalSymbol[] nonTerminalSymbolArray = this.nonTerminals;
            this.nonTerminals = new NonTerminalSymbol[nonTerminalSymbolArray.length + 40];
            int n2 = 0;
            while (n2 < nonTerminalSymbolArray.length) {
                this.nonTerminals[n2] = nonTerminalSymbolArray[n2];
                ++n2;
            }
        }
        this.nonTerminals[this.numNonTerminals] = nonTerminalSymbol = new NonTerminalSymbol(string, this.numNonTerminals);
        ++this.numNonTerminals;
        return nonTerminalSymbol;
    }

    public Production addProduction(NonTerminalSymbol nonTerminalSymbol, GrammarSymbol[] grammarSymbolArray) {
        return this.addProduction(nonTerminalSymbol, grammarSymbolArray, 0, 3);
    }

    public Production addProduction(NonTerminalSymbol nonTerminalSymbol, GrammarSymbol[] grammarSymbolArray, int n) {
        return this.addProduction(nonTerminalSymbol, grammarSymbolArray, n, 3);
    }

    public Production addProduction(NonTerminalSymbol nonTerminalSymbol, GrammarSymbol[] grammarSymbolArray, int n, int n2) {
        if (grammarSymbolArray == null) {
            grammarSymbolArray = new GrammarSymbol[]{};
        }
        Production production = new Production(this, nonTerminalSymbol, grammarSymbolArray, this.numProds, n, n2);
        int n3 = 0;
        while (n3 < this.numProds) {
            if (this.productions[n3].equals(production)) {
                return this.productions[n3];
            }
            ++n3;
        }
        if (this.numProds == this.productions.length) {
            Production[] productionArray = this.productions;
            this.productions = new Production[productionArray.length + 40];
            int n4 = 0;
            while (n4 < productionArray.length) {
                this.productions[n4] = productionArray[n4];
                ++n4;
            }
        }
        this.productions[this.numProds] = production;
        ++production.getLeftSide().numProducoes;
        ++this.numProds;
        return production;
    }

    public Production augment() {
        if (this.startProduction == null) {
            NonTerminalSymbol nonTerminalSymbol = this.startSymbol;
            this.startSymbol = this.getNonTerminal(nonTerminalSymbol.getName() + "'");
            this.startProduction = this.addProduction(this.startSymbol, new GrammarSymbol[]{nonTerminalSymbol});
        }
        return this.startProduction;
    }

    public int getNumProductions() {
        return this.numProds;
    }

    public int getNumTerminals() {
        return this.numTerminals;
    }

    public int getNumNonTerminals() {
        return this.numNonTerminals;
    }

    public NonTerminalSymbol getStartSymbol() {
        return this.startSymbol;
    }

    public void insertProductionsOf(NonTerminalSymbol nonTerminalSymbol, LRState lRState) {
        int n = 0;
        while (n < this.numProds) {
            if (this.productions[n].getLeftSide() == nonTerminalSymbol) {
                lRState.addItem(this.productions[n].items[0]);
            }
            ++n;
        }
    }

    public Production[] getAllProductions() {
        Production[] productionArray = new Production[this.numProds];
        int n = 0;
        while (n < productionArray.length) {
            productionArray[n] = this.productions[n];
            ++n;
        }
        return productionArray;
    }

    public TerminalSymbol[] getTerminals() {
        TerminalSymbol[] terminalSymbolArray = new TerminalSymbol[this.numTerminals];
        int n = 0;
        while (n < terminalSymbolArray.length) {
            terminalSymbolArray[n] = this.terminals[n];
            ++n;
        }
        return terminalSymbolArray;
    }

    public NonTerminalSymbol[] getNonTerminals() {
        NonTerminalSymbol[] nonTerminalSymbolArray = new NonTerminalSymbol[this.numNonTerminals];
        int n = 0;
        while (n < nonTerminalSymbolArray.length) {
            nonTerminalSymbolArray[n] = this.nonTerminals[n];
            ++n;
        }
        return nonTerminalSymbolArray;
    }

    public void setStartSymbol(NonTerminalSymbol nonTerminalSymbol) {
        this.startSymbol = nonTerminalSymbol;
    }

    public GrammarSymbol[] getSymbols() {
        GrammarSymbol[] grammarSymbolArray = new GrammarSymbol[this.numTerminals + this.numNonTerminals];
        int n = 0;
        while (n < this.numTerminals) {
            grammarSymbolArray[n] = this.terminals[n];
            ++n;
        }
        int n2 = 0;
        while (n2 < this.numNonTerminals) {
            grammarSymbolArray[n + n2] = this.nonTerminals[n2];
            ++n2;
        }
        return grammarSymbolArray;
    }

    public FirstSets getFirstSets() {
        return null;
    }

    public FollowSets getFollowSets() {
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.numProds) {
            stringBuffer.append('\n');
            stringBuffer.append(this.productions[n].toString());
            ++n;
        }
        return stringBuffer.toString();
    }

    public class FirstSets {
        private Set[] firstSets;

        private FirstSets() {
            this.getNullables();
        }

        private boolean[] getNullables() {
            boolean[] blArray = new boolean[BNFGrammar.this.numNonTerminals];
            int[] nArray = new int[BNFGrammar.this.numNonTerminals];
            boolean[][] blArray2 = new boolean[BNFGrammar.this.numNonTerminals][BNFGrammar.this.numNonTerminals];
            int n = 0;
            while (n < BNFGrammar.this.numProds) {
                NonTerminalSymbol nonTerminalSymbol = BNFGrammar.this.productions[n].getLeftSide();
                GrammarSymbol[] grammarSymbolArray = BNFGrammar.this.productions[n].getRightSide();
                if (grammarSymbolArray.length == 0) {
                    blArray[nonTerminalSymbol.index] = true;
                } else {
                    int n2 = 0;
                    while (n2 < grammarSymbolArray.length) {
                        if (!(grammarSymbolArray[n2] instanceof NonTerminalSymbol)) break;
                        int n3 = grammarSymbolArray[n2].index;
                        if (grammarSymbolArray[n2] != nonTerminalSymbol && !blArray2[nonTerminalSymbol.index][n3]) {
                            blArray2[nonTerminalSymbol.index][n3] = true;
                            int n4 = nonTerminalSymbol.index;
                            nArray[n4] = nArray[n4] + 1;
                            int n5 = 0;
                            while (n5 < BNFGrammar.this.numNonTerminals) {
                                if (n5 != nonTerminalSymbol.index && blArray2[n5][nonTerminalSymbol.index] && !blArray2[n5][n3]) {
                                    blArray2[n5][n3] = true;
                                    int n6 = n5;
                                    nArray[n6] = nArray[n6] + 1;
                                }
                                ++n5;
                            }
                        }
                        ++n2;
                    }
                }
                ++n;
            }
            this.printTeste(blArray, blArray2, nArray);
            return blArray;
        }

        public void printTeste(boolean[] blArray, boolean[][] blArray2, int[] nArray) {
            System.out.println("Os nulos:");
            int n = 0;
            while (n < blArray.length) {
                System.out.print(blArray[n] + " ");
                ++n;
            }
            System.out.println("\nNumero de dependencias:");
            n = 0;
            while (n < nArray.length) {
                System.out.print(nArray[n] + " ");
                ++n;
            }
            System.out.println("\nAs dependecias");
            n = 0;
            while (n < blArray2.length) {
                int n2 = 0;
                while (n2 < blArray2[n].length) {
                    System.out.print(blArray2[n][n2] + (blArray2[n][n2] ? "  " : " "));
                    ++n2;
                }
                System.out.println();
                ++n;
            }
        }
    }

    public class FollowSets {
        private Set[] follow;

        private FollowSets() {
            this.follow = new Set[BNFGrammar.this.numNonTerminals];
            this.calculateFollowSets();
        }

        private void calculateFollowSets() {
            Set[] setArray = this.calculateFirst();
            Production[] productionArray = BNFGrammar.this.getAllProductions();
            int n = productionArray.length;
            this.addToFollow(BNFGrammar.this.startSymbol, TerminalSymbol.EOF);
            int n2 = 0;
            while (n2 < n) {
                GrammarSymbol[] grammarSymbolArray = productionArray[n2].getRightSide();
                int n3 = 0;
                while (n3 < grammarSymbolArray.length) {
                    if (grammarSymbolArray[n3] instanceof NonTerminalSymbol) {
                        Set set = this.firstOfString(setArray, grammarSymbolArray, n3 + 1);
                        Set set2 = this.getFollow((NonTerminalSymbol)grammarSymbolArray[n3]);
                        if (set.contains(null)) {
                            this.setDependency(productionArray[n2].getLeftSide(), (NonTerminalSymbol)grammarSymbolArray[n3]);
                            this.addSpecial(set2, set);
                        } else {
                            set2.addAll(set);
                        }
                    }
                    ++n3;
                }
                ++n2;
            }
        }

        private Set[] calculateFirst() {
            Set[] setArray = new Set[BNFGrammar.this.numNonTerminals];
            int n = 0;
            while (n < BNFGrammar.this.numNonTerminals) {
                setArray[n] = new HashSet();
                ++n;
            }
            Production[] productionArray = new Production[BNFGrammar.this.numProds];
            int n2 = 0;
            n = 0;
            while (n < BNFGrammar.this.numProds) {
                GrammarSymbol[] grammarSymbolArray = BNFGrammar.this.productions[n].getRightSide();
                if (grammarSymbolArray.length == 0 || grammarSymbolArray[0] instanceof TerminalSymbol) {
                    productionArray[n2] = BNFGrammar.this.productions[n];
                    ++n2;
                }
                ++n;
            }
            return setArray;
        }

        private Set firstOfString(Set[] setArray, GrammarSymbol[] grammarSymbolArray, int n) {
            return null;
        }

        private void addSpecial(Set set, Set set2) {
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e == null) continue;
                set.add(e);
            }
        }

        private void addToFollow(NonTerminalSymbol nonTerminalSymbol, TerminalSymbol terminalSymbol) {
        }

        private void setDependency(NonTerminalSymbol nonTerminalSymbol, NonTerminalSymbol nonTerminalSymbol2) {
        }

        public Set getFollow(NonTerminalSymbol nonTerminalSymbol) {
            return this.follow[nonTerminalSymbol.index];
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < BNFGrammar.this.numNonTerminals) {
                stringBuffer.append("FOLLOW(");
                stringBuffer.append(BNFGrammar.this.nonTerminals[n].getName());
                stringBuffer.append("): ");
                stringBuffer.append(this.getFollow(BNFGrammar.this.nonTerminals[n]));
                stringBuffer.append('\n');
                ++n;
            }
            return stringBuffer.toString();
        }
    }
}

