/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.abaco.ParserGen.lexer;

import br.ufpe.abaco.ParserGen.lexer.LexicalErrorException;
import br.ufpe.abaco.ParserGen.lexer.LexicalProcessor;
import br.ufpe.abaco.ParserGen.lexer.RegExp;
import br.ufpe.abaco.ParserGen.lexer.Token;
import br.ufpe.abaco.ParserGen.parser.TerminalSymbol;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class LexerFacade
implements Serializable {
    private RegExp regularExpression;
    private LexicalProcessor processor;

    public void insertRule(RegExp regExp) {
        this.regularExpression = this.regularExpression == null ? regExp : RegExp.choice(this.regularExpression, regExp);
    }

    public void insertBlank(RegExp regExp) {
        TerminalSymbol.BLANK.setRegularExpression(regExp);
        this.insertRule(regExp, TerminalSymbol.BLANK);
    }

    public void insertRule(RegExp regExp, TerminalSymbol terminalSymbol) {
        this.insertRule(RegExp.sequence(regExp, RegExp.produce(terminalSymbol)));
    }

    public void rejectRule(RegExp regExp, TerminalSymbol terminalSymbol) {
        this.insertRule(RegExp.sequence(regExp, RegExp.reject(terminalSymbol)));
    }

    public Token[] analyse(String string) throws LexicalErrorException {
        Vector<Token> vector = new Vector<Token>();
        if (!string.equals("")) {
            if (this.processor == null) {
                this.processor = new LexicalProcessor(this.regularExpression);
            }
            boolean bl = this.processor.process(string, vector);
            vector.addElement(Token.EOF);
            this.setTokensPositions(string, vector);
            if (!bl) {
                Token token = (Token)vector.elementAt(vector.size() - 1);
                throw new LexicalErrorException(string.substring(token.startPos));
            }
        }
        Token[] tokenArray = new Token[vector.size()];
        return vector.toArray(tokenArray);
    }

    private void setTokensPositions(String string, Vector vector) {
        int n = 0;
        int n2 = 0;
        List list = this.splitInLines(string);
        int n3 = list.size();
        Iterator iterator = ((AbstractList)vector).iterator();
        block0: while (iterator.hasNext()) {
            Token token = (Token)iterator.next();
            int n4 = n;
            while (n4 < n3) {
                String string2 = (String)list.get(n4);
                int n5 = string2.indexOf(token.text, n2);
                if (n5 != -1) {
                    n2 = n5 + token.text.length();
                    token.line = n4 + 1;
                    token.startPos = n5 + 1;
                    n = n4;
                    continue block0;
                }
                n2 = 0;
                ++n4;
            }
        }
    }

    private List splitInLines(String string) {
        Vector<String> vector = new Vector<String>();
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            n2 = string.indexOf(10, n3);
            if (n2 != -1) {
                vector.add(string.substring(n3, n2));
                n3 = n2 + 1;
                continue;
            }
            if (n3 >= n) break;
            vector.add(string.substring(n3, n));
            break;
        }
        return vector;
    }
}

