/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.agool.java;

import br.ufpe.agool.OOToolKit.AgoolProgram;
import br.ufpe.agool.OOToolKit.ArrayType;
import br.ufpe.agool.OOToolKit.Block;
import br.ufpe.agool.OOToolKit.Field;
import br.ufpe.agool.OOToolKit.GClass;
import br.ufpe.agool.OOToolKit.LanguageLibrary;
import br.ufpe.agool.OOToolKit.Method;
import br.ufpe.agool.OOToolKit.ObjectType;
import br.ufpe.agool.OOToolKit.PrimitiveType;
import br.ufpe.agool.OOToolKit.Type;
import br.ufpe.agool.OOToolKit.Variable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Vector;

public class JavaLibrary
implements LanguageLibrary {
    private HashMap fullNameToclasses = new HashMap();
    private HashMap nameToClasses = new HashMap();
    private Vector packages = new Vector();
    private String pack;
    boolean hasSetDefinitions;

    public JavaLibrary() {
        this.packages.add("java.lang.");
    }

    public void clear() {
        this.fullNameToclasses.clear();
        this.nameToClasses.clear();
        this.packages.clear();
        this.packages.add("java.lang.");
        this.pack = null;
        this.hasSetDefinitions = false;
    }

    public void setPackage(String string) {
        this.pack = string;
    }

    public void addClassDefinitions(AgoolProgram agoolProgram) {
        if (!this.hasSetDefinitions) {
            GClass[] gClassArray = agoolProgram.getClasses();
            String string = this.pack == null ? "" : this.pack + ".";
            int n = 0;
            while (n < gClassArray.length) {
                this.addGClass(string + gClassArray[n].getName(), gClassArray[n]);
                ++n;
            }
            this.hasSetDefinitions = true;
        }
    }

    public Vector getGClass(String string) {
        GClass gClass;
        Vector<Object> vector = new Vector<Object>();
        if (this.fullNameToclasses.containsKey(string)) {
            vector.add(this.fullNameToclasses.get(string));
        } else {
            try {
                gClass = this.findGClass(string);
                vector.add(gClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (this.nameToClasses.containsKey(string)) {
            vector.addAll((Vector)this.nameToClasses.get(string));
        } else {
            int n = 0;
            while (n < this.packages.size()) {
                String string2 = (String)this.packages.get(n);
                try {
                    gClass = this.findGClass(string2 + string);
                    vector.add(gClass);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                ++n;
            }
        }
        return vector;
    }

    public void addImport(String string) throws ClassNotFoundException {
        int n = string.indexOf(42);
        if (n > 0) {
            String string2 = string.substring(0, n);
            if (!this.packages.contains(string2)) {
                this.packages.add(string2);
            }
        } else {
            this.findGClass(string);
        }
    }

    private GClass findGClass(String string) throws ClassNotFoundException {
        GClass gClass = null;
        if (string == null) {
            throw new ClassNotFoundException("null");
        }
        if (this.fullNameToclasses.containsKey(string)) {
            gClass = (GClass)this.fullNameToclasses.get(string);
        } else {
            Class<?> clazz = Class.forName(string);
            gClass = this.convertToGClass(clazz);
        }
        return gClass;
    }

    private void addGClass(String string, GClass gClass) {
        int n = string.lastIndexOf(46);
        String string2 = n > 0 ? string.substring(n + 1) : string;
        Vector<GClass> vector = (Vector<GClass>)this.nameToClasses.get(string2);
        if (vector == null) {
            vector = new Vector<GClass>();
            this.nameToClasses.put(string2, vector);
        }
        vector.add(gClass);
        this.fullNameToclasses.put(string, gClass);
    }

    private GClass convertToGClass(Class clazz) throws ClassNotFoundException {
        Constructor<?>[] constructorArray = clazz.getConstructors();
        java.lang.reflect.Method[] methodArray = clazz.getMethods();
        java.lang.reflect.Field[] fieldArray = clazz.getFields();
        Class clazz2 = clazz.getSuperclass();
        String string = clazz2 == null ? null : clazz2.getName();
        GClass gClass = new GClass(clazz.getName(), string);
        this.addGClass(clazz.getName(), gClass);
        int n = 0;
        while (n < constructorArray.length) {
            gClass.addMethod(this.convertConstructor(constructorArray[n]));
            ++n;
        }
        n = 0;
        while (n < methodArray.length) {
            gClass.addMethod(this.convertMethod(methodArray[n]));
            ++n;
        }
        n = 0;
        while (n < fieldArray.length) {
            gClass.addField(this.convertField(fieldArray[n]));
            ++n;
        }
        if (clazz2 != null) {
            GClass gClass2 = this.findGClass(clazz2.getName());
            gClass.setSuperClass(gClass2);
        }
        return gClass;
    }

    private Field convertField(java.lang.reflect.Field field) {
        String string = field.getName();
        Type type = this.convertType(field.getType());
        int[] nArray = this.convertModifiers(field.getModifiers());
        return new Field(nArray, type, string);
    }

    private Method convertConstructor(Constructor constructor) {
        int[] nArray = this.convertModifiers(constructor.getModifiers());
        Class<?>[] classArray = constructor.getParameterTypes();
        Variable[] variableArray = new Variable[classArray.length];
        int n = 0;
        while (n < variableArray.length) {
            variableArray[n] = new Variable("var" + n, this.convertType(classArray[n]));
            ++n;
        }
        return new Method(nArray, variableArray, new Block());
    }

    private Method convertMethod(java.lang.reflect.Method method) {
        String string = method.getName();
        int[] nArray = this.convertModifiers(method.getModifiers());
        Type type = this.convertType(method.getReturnType());
        Class<?>[] classArray = method.getParameterTypes();
        Variable[] variableArray = new Variable[classArray.length];
        int n = 0;
        while (n < variableArray.length) {
            variableArray[n] = new Variable("var" + n, this.convertType(classArray[n]));
            ++n;
        }
        return new Method(string, nArray, variableArray, type);
    }

    private Type convertType(Class clazz) {
        Type type = null;
        String string = clazz.getName();
        if (string.equals("int") || string.equals("short") || string.equals("byte")) {
            type = PrimitiveType.INTEGER;
        } else if (string.equals("long")) {
            type = PrimitiveType.LONG;
        } else if (string.equals("void")) {
            type = PrimitiveType.VOID;
        } else if (string.equals("float")) {
            type = PrimitiveType.FLOAT;
        } else if (string.equals("double")) {
            type = PrimitiveType.DOUBLE;
        } else if (string.equals("char")) {
            type = PrimitiveType.CHAR;
        } else if (string.equals("boolean")) {
            type = PrimitiveType.BOOLEAN;
        } else if (string.indexOf(91) > -1) {
            int n = 0;
            while (string.charAt(n) == '[') {
                ++n;
            }
            Type type2 = this.convertDescriptor(string.substring(n));
            type = new ArrayType(type2, n);
        } else {
            ObjectType objectType = new ObjectType(string);
            try {
                GClass gClass = this.findGClass(string);
                objectType.setGClass(gClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            type = objectType;
        }
        return type;
    }

    private Type convertDescriptor(String string) {
        Type type = null;
        if (string.charAt(0) == 'L') {
            String string2 = string.substring(1, string.length() - 1);
            try {
                GClass gClass = this.findGClass(string2);
                type = new ObjectType(gClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
        } else if (string.equals("Z")) {
            type = PrimitiveType.BOOLEAN;
        } else if (string.equals("J")) {
            type = PrimitiveType.LONG;
        } else if (string.equals("D")) {
            type = PrimitiveType.DOUBLE;
        } else if (string.equals("F")) {
            type = PrimitiveType.FLOAT;
        } else if (string.equals("C")) {
            type = PrimitiveType.CHAR;
        } else if (string.equals("B")) {
            type = PrimitiveType.INTEGER;
        } else if (string.equals("I")) {
            type = PrimitiveType.INTEGER;
        } else if (string.equals("S")) {
            type = PrimitiveType.INTEGER;
        } else {
            System.out.println("Descritor inesperado: " + string);
        }
        return type;
    }

    private int[] convertModifiers(int n) {
        int[] nArray = new int[6];
        int n2 = 0;
        if (Modifier.isFinal(n)) {
            nArray[n2] = 5;
            ++n2;
        }
        if (Modifier.isPrivate(n)) {
            nArray[n2] = 3;
            ++n2;
        }
        if (Modifier.isProtected(n)) {
            nArray[n2] = 1;
            ++n2;
        }
        if (Modifier.isPublic(n)) {
            nArray[n2] = 2;
            ++n2;
        }
        if (Modifier.isStatic(n)) {
            nArray[n2] = 4;
            ++n2;
        }
        int[] nArray2 = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            nArray2[n3] = nArray[n3];
            ++n3;
        }
        return nArray2;
    }

    public static void main(String[] stringArray) {
        JavaLibrary javaLibrary = new JavaLibrary();
        GClass gClass = (GClass)javaLibrary.getGClass("Object").get(0);
        Method[] methodArray = gClass.getMethods();
        Field[] fieldArray = gClass.getFields();
        int n = 0;
        while (n < fieldArray.length) {
            System.out.println("> " + fieldArray[n].getName());
            ++n;
        }
        int n2 = 0;
        while (n2 < methodArray.length) {
            System.out.println("> " + methodArray[n2].getName());
            ++n2;
        }
    }
}

