/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.agool.java;

import br.ufpe.agool.OOToolKit.AgoolChecker;
import br.ufpe.agool.OOToolKit.AgoolCheckerError;
import br.ufpe.agool.OOToolKit.AgoolProgram;
import br.ufpe.agool.OOToolKit.ArrayAccess;
import br.ufpe.agool.OOToolKit.ArrayLength;
import br.ufpe.agool.OOToolKit.ArrayType;
import br.ufpe.agool.OOToolKit.Assignment;
import br.ufpe.agool.OOToolKit.BinaryExpression;
import br.ufpe.agool.OOToolKit.Block;
import br.ufpe.agool.OOToolKit.Cast;
import br.ufpe.agool.OOToolKit.ClassExpression;
import br.ufpe.agool.OOToolKit.Constant;
import br.ufpe.agool.OOToolKit.Conversion;
import br.ufpe.agool.OOToolKit.CurrentObject;
import br.ufpe.agool.OOToolKit.Declaration;
import br.ufpe.agool.OOToolKit.Expression;
import br.ufpe.agool.OOToolKit.Field;
import br.ufpe.agool.OOToolKit.FieldAccess;
import br.ufpe.agool.OOToolKit.GClass;
import br.ufpe.agool.OOToolKit.If;
import br.ufpe.agool.OOToolKit.InstanceOf;
import br.ufpe.agool.OOToolKit.Method;
import br.ufpe.agool.OOToolKit.MethodCall;
import br.ufpe.agool.OOToolKit.NewArray;
import br.ufpe.agool.OOToolKit.NewObject;
import br.ufpe.agool.OOToolKit.NullObject;
import br.ufpe.agool.OOToolKit.ObjectType;
import br.ufpe.agool.OOToolKit.PrimitiveType;
import br.ufpe.agool.OOToolKit.Print;
import br.ufpe.agool.OOToolKit.Return;
import br.ufpe.agool.OOToolKit.SideEffectExpression;
import br.ufpe.agool.OOToolKit.Statement;
import br.ufpe.agool.OOToolKit.SuperClassObject;
import br.ufpe.agool.OOToolKit.SymbolTable;
import br.ufpe.agool.OOToolKit.Type;
import br.ufpe.agool.OOToolKit.UnaryExpression;
import br.ufpe.agool.OOToolKit.Variable;
import br.ufpe.agool.OOToolKit.While;
import br.ufpe.agool.java.CompoundIdentifier;
import br.ufpe.agool.java.Decrement;
import br.ufpe.agool.java.Increment;
import br.ufpe.agool.java.JavaLibrary;
import br.ufpe.agool.java.JavaProgram;
import br.ufpe.agool.java.JavaVisitor;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

public class JavaChecker {
    private JavaPreChecker preChecker;
    private AgoolChecker checker = new AgoolChecker();
    private JavaLibrary library = new JavaLibrary();
    private SymbolTable table;
    private Vector errors = new Vector();
    private boolean debug = false;

    public JavaChecker() {
        this.preChecker = new JavaPreChecker();
    }

    public boolean check(JavaProgram javaProgram) {
        AgoolProgram agoolProgram = javaProgram.getAgoolProgram();
        String[] stringArray = javaProgram.getImports();
        String string = javaProgram.getPackage();
        this.library.clear();
        this.errors.clear();
        this.table.clear();
        if (string != null) {
            this.library.setPackage(string);
            try {
                this.library.addImport(string + ".*");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        int n = 0;
        while (n < stringArray.length) {
            try {
                this.library.addImport(stringArray[n]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.errors.add(new AgoolCheckerError("Import invalido: " + stringArray[n]));
            }
            catch (Exception exception) {
                this.errors.add(new AgoolCheckerError(exception));
            }
            ++n;
        }
        GClass gClass = (GClass)this.library.getGClass("java.lang.Object").get(0);
        ObjectType.OBJECT.setGClass(gClass);
        gClass = (GClass)this.library.getGClass("java.lang.String").get(0);
        ObjectType.STRING.setGClass(gClass);
        try {
            this.library.addClassDefinitions(agoolProgram);
            this.table.setLibrary(this.library);
            this.insertSymbols(agoolProgram);
            if (this.errors.size() == 0) {
                this.preChecker.visit(agoolProgram, null);
            }
            if (this.errors.size() == 0 && !this.checker.checkProgram(agoolProgram, this.library)) {
                AgoolCheckerError[] agoolCheckerErrorArray = this.checker.getErrors();
                n = 0;
                while (n < agoolCheckerErrorArray.length) {
                    this.errors.add(agoolCheckerErrorArray[n]);
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            this.errors.add(new AgoolCheckerError(exception));
        }
        catch (AgoolCheckerError agoolCheckerError) {
            this.errors.add(agoolCheckerError);
        }
        return this.errors.size() == 0;
    }

    private void insertSymbols(AgoolProgram agoolProgram) {
        GClass[] gClassArray = agoolProgram.getClasses();
        int n = 0;
        while (n < gClassArray.length) {
            if (!this.table.putSymbol(gClassArray[n])) {
                this.table.setClassScope(gClassArray[n].getName());
                this.insertSymbols(gClassArray[n]);
            } else {
                this.errors.add(new AgoolCheckerError("ERRO (J-0) - Simbolo repetido: " + gClassArray[n].getName()));
            }
            ++n;
        }
    }

    private void insertSymbols(GClass gClass) {
        Method[] methodArray = gClass.getMethods();
        Field[] fieldArray = gClass.getFields();
        int n = 0;
        while (n < methodArray.length) {
            if (this.table.putSymbol(methodArray[n])) {
                this.errors.add(new AgoolCheckerError("ERRO (J-0) - Simbolo repetido: " + methodArray[n].getName()));
            }
            ++n;
        }
        n = 0;
        while (n < fieldArray.length) {
            if (this.table.putSymbol(fieldArray[n])) {
                this.errors.add(new AgoolCheckerError("ERRO (J-0) - Simbolo repetido: " + fieldArray[n].getName()));
            }
            ++n;
        }
    }

    public boolean foundError() {
        return this.errors.size() != 0;
    }

    public AgoolCheckerError[] getErrors() {
        AgoolCheckerError[] agoolCheckerErrorArray = new AgoolCheckerError[this.errors.size()];
        this.errors.toArray(agoolCheckerErrorArray);
        return agoolCheckerErrorArray;
    }

    final class JavaPreChecker
    implements JavaVisitor {
        private Object COMP_IDENTIFIER_FLAG = new Object();
        private GClass thisClass;

        JavaPreChecker() {
            JavaChecker.this.table = new SymbolTable();
        }

        public Object visit(AgoolProgram agoolProgram, Object object) {
            GClass[] gClassArray = agoolProgram.getClasses();
            int n = gClassArray.length;
            if (JavaChecker.this.debug) {
                System.out.println(">> JavaChecker");
            }
            int n2 = 0;
            while (n2 < n) {
                if (gClassArray[n2].getSuperClass() == null) {
                    String string = gClassArray[n2].getSuperClassName();
                    Vector vector = JavaChecker.this.table.getGClass(string);
                    if (vector.size() == 1) {
                        gClassArray[n2].setSuperClass((GClass)vector.get(0));
                    } else if (vector.size() > 1) {
                        JavaChecker.this.errors.add(new AgoolCheckerError("ERRO (J) - Multiplas definicoes para o nome: " + string));
                    } else {
                        JavaChecker.this.errors.add(new AgoolCheckerError("ERRO (J) - Classe nao encontrada: " + string));
                    }
                }
                Field[] fieldArray = gClassArray[n2].getFields();
                int n3 = 0;
                while (n3 < fieldArray.length) {
                    fieldArray[n3].visit(this, null);
                    ++n3;
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < n) {
                this.thisClass = gClassArray[n2];
                JavaChecker.this.table.setClassScope(this.thisClass.getName());
                gClassArray[n2].visit(this, object);
                ++n2;
            }
            return null;
        }

        public Object visitGClass(GClass gClass, Object object) {
            Field[] fieldArray = gClass.getFields();
            Method[] methodArray = gClass.getMethods();
            if (JavaChecker.this.debug) {
                System.out.println("====== Classe " + gClass.getName());
            }
            int n = 0;
            while (n < methodArray.length) {
                methodArray[n].visit(this, null);
                ++n;
            }
            return null;
        }

        public Object visitArrayAccess(ArrayAccess arrayAccess, Object object) {
            Expression expression = arrayAccess.getArray();
            Expression[] expressionArray = arrayAccess.getIndices();
            expression = (Expression)expression.visit(this, null);
            arrayAccess.setArray(expression);
            int n = 0;
            while (n < expressionArray.length) {
                Expression expression2 = (Expression)expressionArray[n].visit(this, null);
                arrayAccess.setIndiceExpression(n, expression2);
                ++n;
            }
            if (!(expression.getType() instanceof ArrayType)) {
                throw new AgoolCheckerError("ERRO (J) - Expressao nao eh um array");
            }
            arrayAccess.setType(((ArrayType)expression.getType()).getResultingType(expressionArray.length));
            return arrayAccess;
        }

        public Object visitArrayLength(ArrayLength arrayLength, Object object) {
            return arrayLength;
        }

        public Object visitArrayType(ArrayType arrayType, Object object) {
            GClass gClass = arrayType.getGClass();
            gClass.setSuperClass(ObjectType.OBJECT.getGClass());
            arrayType.getBaseType().visit(this, null);
            return null;
        }

        public Object visitAssignment(Assignment assignment, Object object) throws AgoolCheckerError {
            Expression expression = assignment.getLeftExpression();
            Expression expression2 = assignment.getRightExpression();
            expression = (Expression)expression.visit(this, null);
            expression2 = (Expression)expression2.visit(this, null);
            assignment.setLeftExpression(expression);
            assignment.setRightExpression(expression2);
            return null;
        }

        public Object visitBinaryExpression(BinaryExpression binaryExpression, Object object) {
            int n = binaryExpression.getOperator();
            Expression expression = (Expression)binaryExpression.getOperand1().visit(this, null);
            Type type = expression.getType();
            binaryExpression.setOperand1(expression);
            expression = (Expression)binaryExpression.getOperand2().visit(this, null);
            Type type2 = expression.getType();
            binaryExpression.setOperand2(expression);
            switch (n) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    if (AgoolChecker.canBeConverted(type, type2)) {
                        binaryExpression.setType(type2);
                        break;
                    }
                    binaryExpression.setType(type);
                    break;
                }
                case 14: 
                case 15: 
                case 16: {
                    if (type == PrimitiveType.BOOLEAN) {
                        binaryExpression.setType(type);
                        break;
                    }
                    binaryExpression.setType(PrimitiveType.INTEGER);
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    binaryExpression.setType(PrimitiveType.BOOLEAN);
                    break;
                }
                default: {
                    throw new AgoolCheckerError("ERRO (1) - Operador binario desconhecido");
                }
            }
            return binaryExpression;
        }

        public Object visitBlock(Block block, Object object) {
            Statement[] statementArray = block.getStatements();
            JavaChecker.this.table.startLocalScope();
            int n = 0;
            while (n < statementArray.length) {
                try {
                    if (statementArray[n] instanceof Variable) {
                        this.visitVariableDeclaration((Variable)statementArray[n]);
                    } else {
                        statementArray[n].visit(this, null);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (JavaChecker.this.debug) {
                        System.out.println("<< ERROR >>");
                    }
                    JavaChecker.this.errors.add(new AgoolCheckerError(exception));
                }
                catch (AgoolCheckerError agoolCheckerError) {
                    agoolCheckerError.printStackTrace();
                    if (JavaChecker.this.debug) {
                        System.out.println("<< ERROR >>");
                    }
                    JavaChecker.this.errors.add(agoolCheckerError);
                }
                ++n;
            }
            JavaChecker.this.table.endLocalScope();
            return null;
        }

        private void visitVariableDeclaration(Variable variable) {
            Expression expression = variable.getInitialValue();
            variable.getType().visit(this, null);
            if (expression != null) {
                expression = (Expression)expression.visit(this, null);
                variable.setInitialValue(expression);
            }
            JavaChecker.this.table.addLocalVar(variable);
        }

        public Object visitCast(Cast cast, Object object) {
            Expression expression = (Expression)cast.getExpression().visit(this, null);
            cast.setExpression(expression);
            cast.getObjectType().visit(this, null);
            return cast;
        }

        public Object visitClassExpression(ClassExpression classExpression, Object object) {
            return classExpression;
        }

        public Object visitConstant(Constant constant, Object object) {
            return constant;
        }

        public Object visitConversion(Conversion conversion, Object object) {
            Expression expression = (Expression)conversion.getExpression().visit(this, null);
            conversion.setExpression(expression);
            conversion.getFinalType().visit(this, null);
            return conversion;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object visitCompoundIdentifier(CompoundIdentifier compoundIdentifier, Object object) {
            boolean bl = object != this.COMP_IDENTIFIER_FLAG;
            Expression expression = compoundIdentifier.getLeftExpression();
            String string = compoundIdentifier.getRightIdentifier();
            Declaration declaration = null;
            if (expression != null) {
                Object object2 = expression.visit(this, this.COMP_IDENTIFIER_FLAG);
                if (object2 instanceof Expression) {
                    expression = (Expression)object2;
                    compoundIdentifier.setLeftExpression(expression);
                    Type type = expression.getType();
                    if (type instanceof ArrayType) {
                        if (!string.equals("length")) throw new AgoolCheckerError("ERRO (J) - Atributo nao encontrado: " + string);
                        return new ArrayLength(expression);
                    }
                    if (!(type instanceof ObjectType)) throw new AgoolCheckerError("ERRO (J) - Expressao de tipo nao objeto");
                    Field field = JavaChecker.this.table.getField(((ObjectType)type).getName(), string);
                    if (field != null) return new FieldAccess(expression, field);
                    throw new AgoolCheckerError("ERRO (J) - Atributo nao encontrado: " + string);
                }
                if (!(object2 instanceof String)) throw new AgoolCheckerError("ERRO (J) - Expressao de tipo invalido");
                string = ((CompoundIdentifier)expression).getRightIdentifier() + '.' + string;
                Vector vector = JavaChecker.this.table.getGClass(string);
                if (vector.size() == 0) {
                    if (!bl) return string;
                    throw new AgoolCheckerError("ERRO (J) - Nao foi possivel resolver o nome composto " + string);
                }
                if (vector.size() != 1) throw new AgoolCheckerError("ERRO (J) - Multiplos nomes possiveis para identificador " + string);
                return new ClassExpression((GClass)vector.get(0));
            }
            Declaration declaration2 = JavaChecker.this.table.getVariable(string);
            if (declaration2 instanceof Variable) {
                return declaration2;
            }
            if (declaration2 instanceof Field) {
                return new FieldAccess((Field)declaration2);
            }
            Vector vector = JavaChecker.this.table.getGClass(string);
            if (vector.size() == 1) {
                return new ClassExpression((GClass)vector.get(0));
            }
            if (vector.size() > 2) {
                throw new AgoolCheckerError("ERRO (J) - Multiplos nomes possiveis para identificador " + string);
            }
            if (!bl) return string;
            throw new AgoolCheckerError("ERRO (J) - Nao foi possivel resolver o nome " + string);
        }

        public Object visitCurrentObject(CurrentObject currentObject, Object object) {
            currentObject.setGClass(this.thisClass);
            return currentObject;
        }

        public Object visitField(Field field, Object object) {
            Expression expression = field.getInitialValue();
            field.getType().visit(this, null);
            if (expression != null) {
                expression = (Expression)expression.visit(this, object);
                field.setInitialValue(expression);
            }
            return null;
        }

        public Object visitFieldAccess(FieldAccess fieldAccess, Object object) {
            String string;
            Expression expression = fieldAccess.getExpressionLeft();
            Field field = fieldAccess.getField();
            if (expression == null) {
                string = this.thisClass.getName();
            } else {
                expression = (Expression)expression.visit(this, null);
                fieldAccess.setExpressionLeft(expression);
                string = expression.getType().getName();
            }
            if (field == null) {
                field = JavaChecker.this.table.getField(string, fieldAccess.getFieldName());
                if (field == null) {
                    throw new AgoolCheckerError("ERRO (J) - Atributo inexistente: " + fieldAccess.getFieldName());
                }
                fieldAccess.setField(field);
            }
            return fieldAccess;
        }

        public Object visitIf(If if_, Object object) {
            Block block = if_.getFalseBlock();
            Expression expression = (Expression)if_.getExpression().visit(this, null);
            if_.setExpression(expression);
            if_.getTrueBlock().visit(this, null);
            if (block != null) {
                if (block.getStatements().length == 0) {
                    if_.setFalseBlockNull();
                } else {
                    block.visit(this, null);
                }
            }
            return null;
        }

        public Object visitInstanceOf(InstanceOf instanceOf, Object object) {
            Expression expression = (Expression)instanceOf.getExpression().visit(this, null);
            instanceOf.setExpression(expression);
            instanceOf.getDestinationType().visit(this, null);
            return instanceOf;
        }

        public Object visitMethod(Method method, Object object) {
            Variable[] variableArray = method.getFormals();
            JavaChecker.this.table.startLocalScope();
            int n = 0;
            while (n < variableArray.length) {
                this.visitVariableDeclaration(variableArray[n]);
                ++n;
            }
            if (JavaChecker.this.debug) {
                System.out.println(" -- Metodo: " + method.getName());
            }
            method.getReturnType().visit(this, null);
            if (JavaChecker.this.errors.size() == 0) {
                method.getBody().visit(this, null);
            }
            JavaChecker.this.table.endLocalScope();
            return null;
        }

        public Object visitMethodCall(MethodCall methodCall, Object object) {
            Type type;
            Expression expression = methodCall.getExpressionLeft();
            String string = methodCall.getMethodName();
            Expression[] expressionArray = methodCall.getArguments();
            if (expression == null) {
                type = this.thisClass.getObjectType();
            } else {
                expression = (Expression)expression.visit(this, null);
                methodCall.setExpresionLeft(expression);
                type = expression.getType();
            }
            if (!(type instanceof ObjectType)) {
                throw new AgoolCheckerError("ERRO (J) - Expressao invalida na chamada ao metodo (tipo nao objeto)");
            }
            int n = 0;
            while (n < expressionArray.length) {
                expressionArray[n] = (Expression)expressionArray[n].visit(this, null);
                ++n;
            }
            methodCall.setArguments(expressionArray);
            if (methodCall.isConstructor()) {
                return methodCall;
            }
            Vector vector = JavaChecker.this.table.getMethod(type.getName(), string);
            if (vector == null) {
                throw new AgoolCheckerError("ERRO (J) - Metodo nao encontrado: " + string);
            }
            Vector vector2 = this.filterMethods(vector, string, expressionArray, methodCall.isConstructor());
            if (vector2.size() != 1) {
                if (vector2.size() == 0) {
                    String string2 = "(";
                    n = 0;
                    while (n < expressionArray.length - 1) {
                        string2 = string2 + expressionArray[n].getType().getName() + ",";
                        ++n;
                    }
                    string2 = string2 + expressionArray[n].getType().getName() + ")";
                    throw new AgoolCheckerError("ERRO (J) - Nao foi possivel encontrar uma definicao do metodo \"" + string + "\" que corresponda a chamada: " + string2);
                }
                throw new AgoolCheckerError("ERRO (J) - Multiplas definicoes do metodo \"" + string + "\" " + "correspondem a chamada");
            }
            methodCall.setMethod((Method)vector2.get(0));
            return methodCall;
        }

        public Object visitNewArray(NewArray newArray, Object object) {
            int n;
            Expression[] expressionArray = newArray.getDimensions();
            Expression[] expressionArray2 = newArray.getInitialValues();
            ArrayType arrayType = newArray.getArrayType();
            if (arrayType == null) {
                return newArray;
            }
            arrayType.visit(this, null);
            if (expressionArray2 == null) {
                expressionArray2 = new Expression[]{};
            }
            if (expressionArray == null) {
                expressionArray = new Expression[]{new Constant(expressionArray2.length)};
            } else {
                n = 0;
                while (n < expressionArray.length) {
                    expressionArray[n] = (Expression)expressionArray[n].visit(this, null);
                    ++n;
                }
            }
            n = 0;
            while (n < expressionArray2.length) {
                expressionArray2[n] = (Expression)expressionArray2[n].visit(this, null);
                ++n;
            }
            newArray.setDimensions(expressionArray);
            newArray.setInitialValues(expressionArray2);
            return newArray;
        }

        public Object visitNewObject(NewObject newObject, Object object) {
            Expression[] expressionArray = newObject.getArguments();
            int n = 0;
            while (n < expressionArray.length) {
                expressionArray[n] = (Expression)expressionArray[n].visit(this, null);
                ++n;
            }
            newObject.setArguments(expressionArray);
            newObject.getObjectType().visit(this, null);
            return newObject;
        }

        public Object visitNullObject(NullObject nullObject, Object object) {
            return nullObject;
        }

        public Vector filterMethods(Vector vector, String string, Expression[] expressionArray, boolean bl) {
            Method method;
            Iterator iterator = ((AbstractList)vector).iterator();
            Vector<Method> vector2 = new Vector<Method>();
            while (iterator.hasNext()) {
                method = (Method)iterator.next();
                if (method.getNumParameters() != expressionArray.length || method.isConstructor() != bl) continue;
                vector2.add(method);
            }
            Vector<Method> vector3 = new Vector<Method>();
            int n = 0;
            while (n < expressionArray.length) {
                iterator = ((AbstractList)vector2).iterator();
                boolean bl2 = false;
                while (iterator.hasNext()) {
                    method = (Method)iterator.next();
                    if (!method.getFormalType(n).equals(expressionArray[n].getType())) continue;
                    bl2 = true;
                    vector3.add(method);
                }
                if (!bl2) {
                    iterator = ((AbstractList)vector2).iterator();
                    while (iterator.hasNext()) {
                        method = (Method)iterator.next();
                        if (!AgoolChecker.canBeConverted(expressionArray[n].getType(), method.getFormalType(n))) continue;
                        vector3.add(method);
                    }
                }
                Vector<Method> vector4 = vector2;
                vector2 = vector3;
                vector3 = vector4;
                vector3.clear();
                ++n;
            }
            return vector2;
        }

        public Object visitObjectType(ObjectType objectType, Object object) {
            if (objectType.getGClass() == null) {
                Vector vector = JavaChecker.this.table.getGClass(objectType.getName());
                if (vector.size() == 1) {
                    objectType.setGClass((GClass)vector.get(0));
                } else if (vector.size() > 1) {
                    JavaChecker.this.errors.add(new AgoolCheckerError("ERRO (J) - Multiplas definicoes para o tipo: " + objectType.getName()));
                } else {
                    JavaChecker.this.errors.add(new AgoolCheckerError("ERRO (J) - Tipo nao encontrado: " + objectType.getName()));
                }
            }
            return objectType;
        }

        public Object visitPrimitiveType(PrimitiveType primitiveType, Object object) {
            return null;
        }

        public Object visitPrint(Print print, Object object) {
            return null;
        }

        public Object visitReturn(Return return_, Object object) {
            Expression expression = return_.getExpression();
            if (expression != null) {
                return_.setExpression((Expression)expression.visit(this, null));
            }
            return null;
        }

        public Object visitSideEffectExpression(SideEffectExpression sideEffectExpression, Object object) {
            throw new UnsupportedOperationException("ERRO (J) - No invalido: usar Increment ou Decrement");
        }

        public Object visitIncrement(Increment increment, Object object) {
            Expression expression = increment.getTarget();
            Statement statement = increment.getCommand();
            expression = (Expression)expression.visit(this, null);
            statement.visit(this, null);
            if (!(expression instanceof Variable) && !(expression instanceof FieldAccess)) {
                throw new AgoolCheckerError("ERRO (J) - Expressao nao eh uma variavel");
            }
            increment.setExpression(expression);
            return increment;
        }

        public Object visitDecrement(Decrement decrement, Object object) {
            Expression expression = decrement.getTarget();
            Statement statement = decrement.getCommand();
            expression = (Expression)expression.visit(this, null);
            statement.visit(this, null);
            if (!(expression instanceof Variable)) {
                throw new AgoolCheckerError("ERRO (J) - Expressao nao eh uma variavel");
            }
            decrement.setExpression(expression);
            return decrement;
        }

        public Object visitSuperClassObject(SuperClassObject superClassObject, Object object) {
            superClassObject.setGClass(this.thisClass.getSuperClass());
            return superClassObject;
        }

        public Object visitUnaryExpression(UnaryExpression unaryExpression, Object object) {
            Expression expression = (Expression)unaryExpression.getOperand().visit(this, null);
            unaryExpression.setOperand(expression);
            unaryExpression.setType(expression.getType());
            return unaryExpression;
        }

        public Object visitVariable(Variable variable, Object object) {
            variable.getType().visit(this, null);
            return variable;
        }

        public Object visitWhile(While while_, Object object) {
            Expression expression = (Expression)while_.getExpression().visit(this, null);
            while_.setExpression(expression);
            while_.getBlock().visit(this, null);
            return null;
        }
    }
}

