/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.agool.java;

import br.ufpe.abaco.Benchmark;
import br.ufpe.abaco.ParserGen.lexer.LexerFacade;
import br.ufpe.abaco.ParserGen.lexer.Token;
import br.ufpe.abaco.ParserGen.parser.BNFGrammar;
import br.ufpe.abaco.ParserGen.parser.Parser;
import br.ufpe.agool.AGOOLException;
import br.ufpe.agool.OOToolKit.AgoolCheckerError;
import br.ufpe.agool.code.AgoolClassLoader;
import br.ufpe.agool.code.ByteArrayClassBag;
import br.ufpe.agool.code.BytecodeGenerator;
import br.ufpe.agool.code.FileClassBag;
import br.ufpe.agool.java.JavaChecker;
import br.ufpe.agool.java.JavaLanguage;
import br.ufpe.agool.java.JavaProgram;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;

public class AgoolJavaFacade {
    private BNFGrammar grammar;
    private LexerFacade lexerGenerator;
    private Parser parser;
    private BytecodeGenerator codeGenerator;
    private JavaChecker contextualChecker;

    public AgoolJavaFacade() {
        JavaLanguage javaLanguage = new JavaLanguage();
        this.lexerGenerator = javaLanguage.buildLexer();
        this.grammar = javaLanguage.buildGrammar();
        this.parser = new Parser(this.grammar);
        this.codeGenerator = new BytecodeGenerator(new ByteArrayClassBag());
        this.contextualChecker = new JavaChecker();
    }

    public AgoolClassLoader compileToClass(InputStream inputStream) throws AGOOLException {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = bufferedReader.readLine();
            while (string != null) {
                stringBuffer.append(string + '\n');
                string = bufferedReader.readLine();
            }
            bufferedReader.close();
            return this.compileToClass(stringBuffer.toString());
        }
        catch (Exception exception) {
            if (exception instanceof AGOOLException) {
                throw (AGOOLException)exception;
            }
            exception.printStackTrace();
            throw new AGOOLException(exception);
        }
    }

    public AgoolClassLoader compileToClass(String string) throws AGOOLException {
        try {
            ByteArrayClassBag byteArrayClassBag = null;
            Benchmark.mark("Inicio do Compilador Java");
            Benchmark.mark("Passo 0 - Lendo Entrada...");
            Token[] tokenArray = this.lexerGenerator.analyse(string);
            Benchmark.mark("Passo 1 - Gerando tokens...");
            JavaProgram javaProgram = (JavaProgram)this.parser.parse(tokenArray, (byte)1, false);
            Benchmark.mark("Passo 2 - Parsing...");
            boolean bl = this.contextualChecker.check(javaProgram);
            Benchmark.mark("Passo 3 - Analise contextual...");
            if (!bl) {
                AgoolCheckerError[] agoolCheckerErrorArray = this.contextualChecker.getErrors();
                throw new AGOOLException(agoolCheckerErrorArray);
            }
            byteArrayClassBag = (ByteArrayClassBag)this.codeGenerator.compile(javaProgram.getAgoolProgram());
            Benchmark.mark("Passo 4 - Gerando codigo...");
            return byteArrayClassBag.getAgoolClassLoader();
        }
        catch (Exception exception) {
            if (exception instanceof AGOOLException) {
                throw (AGOOLException)exception;
            }
            exception.printStackTrace();
            throw new AGOOLException(exception);
        }
    }

    public void compileToFile(String string) throws AGOOLException {
        this.compileToFile(new ByteArrayInputStream(string.getBytes()));
    }

    public void compileToFile(InputStream inputStream) throws AGOOLException {
        block5: {
            Object var2_2 = null;
            StringBuffer stringBuffer = new StringBuffer();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            try {
                System.out.println("0 - Lendo Entrada...");
                String string = bufferedReader.readLine();
                while (string != null) {
                    stringBuffer.append(string + '\n');
                    string = bufferedReader.readLine();
                }
                bufferedReader.close();
                System.out.println("1 - Gerando tokens...");
                Token[] tokenArray = this.lexerGenerator.analyse(stringBuffer.toString());
                System.out.println("2 - Parsing...");
                JavaProgram javaProgram = (JavaProgram)this.parser.parse(tokenArray, (byte)1, false);
                System.out.println("3 - Analise contextual...");
                boolean bl = this.contextualChecker.check(javaProgram);
                System.out.println("    Resultado - " + (bl ? "Ok" : "Erro encontrado"));
                if (bl) {
                    System.out.println("4 - Gerando codigo...");
                    this.codeGenerator = new BytecodeGenerator(new FileClassBag());
                    FileClassBag fileClassBag = (FileClassBag)this.codeGenerator.compile(javaProgram.getAgoolProgram());
                    fileClassBag.generateAllFiles();
                    break block5;
                }
                AgoolCheckerError[] agoolCheckerErrorArray = this.contextualChecker.getErrors();
                throw new AGOOLException(agoolCheckerErrorArray);
            }
            catch (Exception exception) {
                if (exception instanceof AGOOLException) {
                    throw (AGOOLException)exception;
                }
                throw new AGOOLException(exception);
            }
        }
    }
}

