/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.agool.code;

import br.ufpe.agool.OOToolKit.AgoolProgram;
import br.ufpe.agool.OOToolKit.ArrayAccess;
import br.ufpe.agool.OOToolKit.ArrayLength;
import br.ufpe.agool.OOToolKit.ArrayType;
import br.ufpe.agool.OOToolKit.Assignment;
import br.ufpe.agool.OOToolKit.BinaryExpression;
import br.ufpe.agool.OOToolKit.Block;
import br.ufpe.agool.OOToolKit.Cast;
import br.ufpe.agool.OOToolKit.ClassExpression;
import br.ufpe.agool.OOToolKit.Constant;
import br.ufpe.agool.OOToolKit.Conversion;
import br.ufpe.agool.OOToolKit.CurrentObject;
import br.ufpe.agool.OOToolKit.Expression;
import br.ufpe.agool.OOToolKit.Field;
import br.ufpe.agool.OOToolKit.FieldAccess;
import br.ufpe.agool.OOToolKit.GClass;
import br.ufpe.agool.OOToolKit.If;
import br.ufpe.agool.OOToolKit.InstanceOf;
import br.ufpe.agool.OOToolKit.Method;
import br.ufpe.agool.OOToolKit.MethodCall;
import br.ufpe.agool.OOToolKit.NewArray;
import br.ufpe.agool.OOToolKit.NewObject;
import br.ufpe.agool.OOToolKit.NullObject;
import br.ufpe.agool.OOToolKit.ObjectType;
import br.ufpe.agool.OOToolKit.PrimitiveType;
import br.ufpe.agool.OOToolKit.Print;
import br.ufpe.agool.OOToolKit.Return;
import br.ufpe.agool.OOToolKit.SideEffectExpression;
import br.ufpe.agool.OOToolKit.Statement;
import br.ufpe.agool.OOToolKit.SuperClassObject;
import br.ufpe.agool.OOToolKit.Type;
import br.ufpe.agool.OOToolKit.UnaryExpression;
import br.ufpe.agool.OOToolKit.Variable;
import br.ufpe.agool.OOToolKit.While;
import br.ufpe.agool.code.ClassBag;
import br.ufpe.agool.code.CodeGenerator;
import br.ufpe.agool.java.Decrement;
import br.ufpe.agool.java.Increment;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;

public class JavaCodeGenerator
implements CodeGenerator {
    private int level;
    private String className;
    private StringClassBag classBag;

    private void ident(PrintWriter printWriter) {
        int n = 0;
        while (n < this.level) {
            printWriter.print("\t");
            ++n;
        }
    }

    public ClassBag compile(AgoolProgram agoolProgram) {
        this.visit(agoolProgram, null);
        return this.classBag;
    }

    public StringClassBag getStringClassBag() {
        return this.classBag;
    }

    public Object visit(AgoolProgram agoolProgram, Object object) {
        GClass[] gClassArray = agoolProgram.getClasses();
        int n = gClassArray.length;
        this.classBag = new StringClassBag();
        n = gClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.className = gClassArray[n2].getName();
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            this.classBag.addClass(this.className, stringWriter);
            gClassArray[n2].visit(this, printWriter);
            printWriter.close();
            ++n2;
        }
        return null;
    }

    public Object visitArrayAccess(ArrayAccess arrayAccess, Object object) {
        PrintWriter printWriter = (PrintWriter)object;
        Expression[] expressionArray = arrayAccess.getIndices();
        arrayAccess.getArray().visit(this, printWriter);
        int n = 0;
        while (n < expressionArray.length) {
            printWriter.print("[");
            expressionArray[n].visit(this, printWriter);
            printWriter.print("]");
            ++n;
        }
        return null;
    }

    public Object visitArrayLength(ArrayLength arrayLength, Object object) {
        PrintWriter printWriter = (PrintWriter)object;
        arrayLength.getArray().visit(this, printWriter);
        printWriter.print(".length");
        return null;
    }

    public Object visitArrayType(ArrayType arrayType, Object object) {
        PrintWriter printWriter = (PrintWriter)object;
        int n = arrayType.getNumDimensions();
        arrayType.getBaseType().visit(this, printWriter);
        int n2 = 0;
        while (n2 < n) {
            printWriter.print("[]");
            ++n2;
        }
        return null;
    }

    public Object visitAssignment(Assignment assignment, Object object) {
        PrintWriter printWriter = (PrintWriter)object;
        this.ident(printWriter);
        assignment.getLeftExpression().visit(this, printWriter);
        printWriter.print(" = ");
        assignment.getRightExpression().visit(this, printWriter);
        printWriter.print(";");
        printWriter.println();
        return null;
    }

    public Object visitBinaryExpression(BinaryExpression binaryExpression, Object object) {
        PrintWriter printWriter = (PrintWriter)object;
        Expression expression = binaryExpression.getOperand1();
        Expression expression2 = binaryExpression.getOperand2();
        Type type = binaryExpression.getOperand1().getType();
        printWriter.print('(');
        expression.visit(this, printWriter);
        switch (binaryExpression.getOperator()) {
            case 15: {
                if (type == PrimitiveType.BOOLEAN) {
                    printWriter.print("&&");
                    break;
                }
                printWriter.print('&');
                break;
            }
            case 14: {
                if (type == PrimitiveType.BOOLEAN) {
                    printWriter.print("||");
                    break;
                }
                printWriter.print('|');
                break;
            }
            case 10: {
                printWriter.print("!=");
                break;
            }
            case 9: {
                printWriter.print("==");
                break;
            }
            case 8: {
                printWriter.print('>');
                break;
            }
            case 7: {
                printWriter.print('<');
                break;
            }
            case 11: {
                printWriter.print("<=");
                break;
            }
            case 12: {
                printWriter.print(">=");
                break;
            }
            case 3: {
                printWriter.print('/');
                break;
            }
            case 4: {
                printWriter.print('%');
                break;
            }
            case 5: {
                printWriter.print('*');
                break;
            }
            case 1: {
                printWriter.print('+');
                break;
            }
            case 2: {
                printWriter.print('-');
                break;
            }
            case 16: {
                printWriter.print('^');
                break;
            }
            default: {
                printWriter.print('#');
            }
        }
        expression2.visit(this, printWriter);
        printWriter.print(')');
        return null;
    }

    public Object visitBlock(Block block, Object object) {
        PrintWriter printWriter = (PrintWriter)object;
        Statement[] statementArray = block.getStatements();
        ++this.level;
        int n = 0;
        while (n < statementArray.length) {
            if (statementArray[n] instanceof Variable) {
                this.visitVariableDeclaration((Variable)statementArray[n], printWriter);
            } else {
                statementArray[n].visit(this, printWriter);
            }
            ++n;
        }
        --this.level;
        return null;
    }

    public Object visitCast(Cast cast, Object object) {
        PrintWriter printWriter = (PrintWriter)object;
        printWriter.print("((");
        cast.getType().visit(this, printWriter);
        printWriter.print(")");
        cast.getExpression().visit(this, printWriter);
        printWriter.print(")");
        return null;
    }

    public Object visitClassExpression(ClassExpression classExpression, Object object) {
        PrintWriter printWriter = (PrintWriter)object;
        printWriter.print(classExpression.getName());
        return null;
    }

    public Object visitConstant(Constant constant, Object object) {
        PrintWriter printWriter = (PrintWriter)object;
        if (constant.getType() == ObjectType.STRING) {
            printWriter.print('\"');
            printWriter.print(constant.getValue());
            printWriter.print('\"');
        } else {
            printWriter.print(constant.getValue());
        }
        return null;
    }

    public Object visitConversion(Conversion conversion, Object object) {
        PrintWriter printWriter = (PrintWriter)object;
        printWriter.print("((");
        conversion.getFinalType().visit(this, printWriter);
        printWriter.print(')');
        conversion.getExpression().visit(this, printWriter);
        printWriter.print(')');
        return null;
    }

    public Object visitCurrentObject(CurrentObject currentObject, Object object) {
        PrintWriter printWriter = (PrintWriter)object;
        printWriter.print("this");
        return null;
    }

    public Object visitField(Field field, Object object) {
        PrintWriter printWriter = (PrintWriter)object;
        this.ident(printWriter);
        if (field.hasModifier(2)) {
            printWriter.print("public ");
        } else if (field.hasModifier(3)) {
            printWriter.print("private ");
        } else if (field.hasModifier(1)) {
            printWriter.print("protected ");
        }
        if (field.hasModifier(4)) {
            printWriter.print("static ");
        }
        if (field.hasModifier(5)) {
            printWriter.print("final ");
        }
        field.getType().visit(this, printWriter);
        printWriter.print(" " + field.getName());
        Expression expression = field.getInitialValue();
        if (expression != null) {
            printWriter.print(" = ");
            expression.visit(this, printWriter);
        }
        printWriter.println(';');
        return null;
    }

    public Object visitFieldAccess(FieldAccess fieldAccess, Object object) {
        PrintWriter printWriter = (PrintWriter)object;
        Field field = fieldAccess.getField();
        fieldAccess.getExpressionLeft().visit(this, printWriter);
        if (field != null) {
            printWriter.print("." + field.getName());
        } else {
            printWriter.print("." + fieldAccess.getFieldName());
        }
        return null;
    }

    public Object visitGClass(GClass gClass, Object object) {
        PrintWriter printWriter = (PrintWriter)object;
        Field[] fieldArray = gClass.getFields();
        Method[] methodArray = gClass.getMethods();
        GClass gClass2 = gClass.getSuperClass();
        printWriter.println();
        printWriter.println();
        printWriter.print("public class ");
        printWriter.print(gClass.getName());
        if (gClass2 != null && !gClass2.equals(ObjectType.OBJECT)) {
            printWriter.print(" extends " + gClass2.getName());
        }
        printWriter.println(" {");
        this.level = 1;
        int n = 0;
        while (n < fieldArray.length) {
            fieldArray[n].visit(this, printWriter);
            ++n;
        }
        printWriter.println();
        n = 0;
        while (n < methodArray.length) {
            methodArray[n].visit(this, printWriter);
            ++n;
        }
        this.level = 0;
        printWriter.println("}");
        return null;
    }

    public Object visitIf(If if_, Object object) {
        PrintWriter printWriter = (PrintWriter)object;
        Block block = if_.getTrueBlock();
        Block block2 = if_.getFalseBlock();
        this.ident(printWriter);
        printWriter.print("if (");
        if_.getExpression().visit(this, printWriter);
        printWriter.println(") {");
        block.visit(this, printWriter);
        if (block2 != null) {
            this.ident(printWriter);
            printWriter.println("} else {");
            block2.visit(this, printWriter);
        }
        this.ident(printWriter);
        printWriter.println("}");
        return null;
    }

    public Object visitInstanceOf(InstanceOf instanceOf, Object object) {
        PrintWriter printWriter = (PrintWriter)object;
        printWriter.print('(');
        instanceOf.getExpression().visit(this, printWriter);
        printWriter.print(" instanceof ");
        instanceOf.getDestinationType().visit(this, printWriter);
        printWriter.print(')');
        return null;
    }

    public Object visitMethod(Method method, Object object) {
        PrintWriter printWriter = (PrintWriter)object;
        String string = method.getName();
        Variable[] variableArray = method.getFormals();
        this.ident(printWriter);
        if (method.hasModifier(2)) {
            printWriter.print("public ");
        } else if (method.hasModifier(3)) {
            printWriter.print("private ");
        } else if (method.hasModifier(1)) {
            printWriter.print("protected ");
        }
        if (method.hasModifier(4)) {
            printWriter.print("static ");
        }
        if (string.equals(Method.CONSTRUCTOR_NAME)) {
            printWriter.print(this.className + "(");
        } else {
            method.getReturnType().visit(this, printWriter);
            printWriter.print(" " + string + "(");
        }
        int n = 0;
        while (n < variableArray.length) {
            variableArray[n].getType().visit(this, printWriter);
            printWriter.print(" " + variableArray[n].getName());
            if (n != variableArray.length - 1) {
                printWriter.print(", ");
            }
            ++n;
        }
        printWriter.println(") {");
        method.getBody().visit(this, printWriter);
        this.ident(printWriter);
        printWriter.println("}");
        printWriter.println();
        return null;
    }

    public Object visitMethodCall(MethodCall methodCall, Object object) {
        PrintWriter printWriter = (PrintWriter)object;
        Expression expression = methodCall.getExpressionLeft();
        Expression[] expressionArray = methodCall.getArguments();
        boolean bl = !methodCall.isExpression();
        boolean bl2 = methodCall.isConstructor();
        if (bl) {
            this.ident(printWriter);
        }
        if (bl2) {
            if (expression instanceof SuperClassObject) {
                printWriter.print("super");
            } else {
                printWriter.print("this");
            }
        } else {
            expression.visit(this, object);
            printWriter.print(".");
            printWriter.print(methodCall.getMethodName());
        }
        int n = 0;
        while (n < expressionArray.length) {
            expressionArray[n].visit(this, printWriter);
            if (n != expressionArray.length - 1) {
                printWriter.print(",");
            }
            ++n;
        }
        printWriter.print(")");
        if (bl) {
            printWriter.println(';');
        }
        return null;
    }

    public Object visitNewArray(NewArray newArray, Object object) {
        PrintWriter printWriter = (PrintWriter)object;
        Expression[] expressionArray = newArray.getDimensions();
        Expression[] expressionArray2 = newArray.getInitialValues();
        ArrayType arrayType = newArray.getArrayType();
        int n = 0;
        if (arrayType != null) {
            int n2 = arrayType.getNumDimensions();
            printWriter.print(" new ");
            arrayType.getBaseType().visit(this, printWriter);
            if (expressionArray != null) {
                n = 0;
                while (n < expressionArray.length) {
                    printWriter.print('[');
                    expressionArray[n].visit(this, printWriter);
                    printWriter.print(']');
                    ++n;
                }
            }
            while (n < n2) {
                printWriter.print("[]");
                ++n;
            }
        }
        if (expressionArray2 != null) {
            printWriter.print('{');
            n = 0;
            while (n < expressionArray2.length) {
                expressionArray2[n].visit(this, printWriter);
                if (n < expressionArray2.length - 1) {
                    printWriter.print(',');
                }
                ++n;
            }
            printWriter.print('}');
        }
        return null;
    }

    public Object visitNewObject(NewObject newObject, Object object) {
        PrintWriter printWriter = (PrintWriter)object;
        Expression[] expressionArray = newObject.getArguments();
        printWriter.print("(new ");
        newObject.getObjectType().visit(this, object);
        printWriter.print('(');
        int n = 0;
        while (n < expressionArray.length) {
            expressionArray[n].visit(this, printWriter);
            if (n != expressionArray.length - 1) {
                printWriter.print(',');
            }
            ++n;
        }
        printWriter.print("))");
        return null;
    }

    public Object visitNullObject(NullObject nullObject, Object object) {
        PrintWriter printWriter = (PrintWriter)object;
        printWriter.print("null");
        return null;
    }

    public Object visitObjectType(ObjectType objectType, Object object) {
        PrintWriter printWriter = (PrintWriter)object;
        printWriter.print(objectType.getName());
        return null;
    }

    public Object visitPrimitiveType(PrimitiveType primitiveType, Object object) {
        PrintWriter printWriter = (PrintWriter)object;
        if (primitiveType == PrimitiveType.BOOLEAN) {
            printWriter.print("boolean");
        } else if (primitiveType == PrimitiveType.CHAR) {
            printWriter.print("char");
        } else if (primitiveType == PrimitiveType.DOUBLE) {
            printWriter.print("double");
        } else if (primitiveType == PrimitiveType.FLOAT) {
            printWriter.print("float");
        } else if (primitiveType == PrimitiveType.INTEGER) {
            printWriter.print("int");
        } else if (primitiveType == PrimitiveType.LONG) {
            printWriter.print("long");
        } else if (primitiveType == PrimitiveType.VOID) {
            printWriter.print("void");
        } else {
            printWriter.print("ERROR");
        }
        return null;
    }

    public Object visitPrint(Print print, Object object) {
        PrintWriter printWriter = (PrintWriter)object;
        this.ident(printWriter);
        printWriter.println("System.out.println(\"" + print.getMessage() + "\");");
        return null;
    }

    public Object visitReturn(Return return_, Object object) {
        PrintWriter printWriter = (PrintWriter)object;
        Expression expression = return_.getExpression();
        this.ident(printWriter);
        if (expression != null) {
            printWriter.print("return ");
            expression.visit(this, printWriter);
        } else {
            printWriter.print("return");
        }
        printWriter.println(";");
        return null;
    }

    public Object visitSideEffectExpression(SideEffectExpression sideEffectExpression, Object object) {
        Statement statement = sideEffectExpression.getCommand();
        Expression expression = sideEffectExpression.getTarget();
        boolean bl = sideEffectExpression.isPreOperation();
        PrintWriter printWriter = (PrintWriter)object;
        if (sideEffectExpression instanceof Increment) {
            printWriter.print('(');
            if (bl) {
                printWriter.print("++");
                expression.visit(this, object);
            } else {
                expression.visit(this, object);
                printWriter.print("++");
            }
            printWriter.print(')');
        } else if (sideEffectExpression instanceof Decrement) {
            printWriter.print('(');
            if (bl) {
                printWriter.print("--");
                expression.visit(this, object);
            } else {
                expression.visit(this, object);
                printWriter.print("--");
            }
            printWriter.print(')');
        } else {
            statement.visit(this, printWriter);
        }
        return null;
    }

    public Object visitSuperClassObject(SuperClassObject superClassObject, Object object) {
        PrintWriter printWriter = (PrintWriter)object;
        printWriter.print("super");
        return null;
    }

    public Object visitUnaryExpression(UnaryExpression unaryExpression, Object object) {
        PrintWriter printWriter = (PrintWriter)object;
        Expression expression = unaryExpression.getOperand();
        Type type = expression.getType();
        printWriter.print("(");
        switch (unaryExpression.getOperator()) {
            case 6: {
                printWriter.print("-");
                break;
            }
            case 13: {
                if (type == PrimitiveType.BOOLEAN) {
                    printWriter.print("!");
                    break;
                }
                printWriter.print("~");
                break;
            }
            default: {
                printWriter.print("#");
            }
        }
        expression.visit(this, printWriter);
        printWriter.print(")");
        return null;
    }

    public Object visitVariable(Variable variable, Object object) {
        PrintWriter printWriter = (PrintWriter)object;
        printWriter.print(variable.getName());
        return null;
    }

    public Object visitWhile(While while_, Object object) {
        PrintWriter printWriter = (PrintWriter)object;
        this.ident(printWriter);
        printWriter.print("while(");
        while_.getExpression().visit(this, printWriter);
        printWriter.println(") {");
        while_.getBlock().visit(this, printWriter);
        this.ident(printWriter);
        printWriter.println("}");
        return null;
    }

    private Object visitVariableDeclaration(Variable variable, Object object) {
        PrintWriter printWriter = (PrintWriter)object;
        this.ident(printWriter);
        variable.getType().visit(this, printWriter);
        printWriter.print(" " + variable.getName());
        Expression expression = variable.getInitialValue();
        if (expression != null) {
            printWriter.print(" = ");
            expression.visit(this, printWriter);
        }
        printWriter.println(";");
        return null;
    }

    public class StringClassBag
    implements ClassBag {
        private HashMap classes = new HashMap();

        public void addClass(String string, Object object) {
            if (!this.classes.containsKey(string)) {
                this.classes.put(string, object);
            }
        }

        public Object act(String string) {
            StringWriter stringWriter = (StringWriter)this.classes.get(string);
            return stringWriter.getBuffer().toString();
        }

        public void writeToFile(String string) throws IOException {
            this.writeToFile(string, string + ".java");
        }

        public void writeToFile(String string, String string2) throws IOException {
            String string3 = (String)this.act(string);
            PrintWriter printWriter = new PrintWriter(new FileWriter(string2));
            printWriter.print(string3);
            printWriter.close();
        }

        public void writeAllToFiles() throws IOException {
            Iterator iterator = this.classes.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = (String)this.act(string);
                PrintWriter printWriter = new PrintWriter(new FileWriter(string + ".java"));
                printWriter.print(string2);
                printWriter.close();
            }
        }
    }
}

