/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.agool.code;

import br.ufpe.agool.OOToolKit.AgoolProgram;
import br.ufpe.agool.OOToolKit.ArrayAccess;
import br.ufpe.agool.OOToolKit.ArrayLength;
import br.ufpe.agool.OOToolKit.ArrayType;
import br.ufpe.agool.OOToolKit.Assignment;
import br.ufpe.agool.OOToolKit.BinaryExpression;
import br.ufpe.agool.OOToolKit.Block;
import br.ufpe.agool.OOToolKit.Cast;
import br.ufpe.agool.OOToolKit.ClassExpression;
import br.ufpe.agool.OOToolKit.Constant;
import br.ufpe.agool.OOToolKit.Conversion;
import br.ufpe.agool.OOToolKit.CurrentObject;
import br.ufpe.agool.OOToolKit.Expression;
import br.ufpe.agool.OOToolKit.Field;
import br.ufpe.agool.OOToolKit.FieldAccess;
import br.ufpe.agool.OOToolKit.GClass;
import br.ufpe.agool.OOToolKit.If;
import br.ufpe.agool.OOToolKit.InstanceOf;
import br.ufpe.agool.OOToolKit.Method;
import br.ufpe.agool.OOToolKit.MethodCall;
import br.ufpe.agool.OOToolKit.NewArray;
import br.ufpe.agool.OOToolKit.NewObject;
import br.ufpe.agool.OOToolKit.NullObject;
import br.ufpe.agool.OOToolKit.ObjectType;
import br.ufpe.agool.OOToolKit.PrimitiveType;
import br.ufpe.agool.OOToolKit.Print;
import br.ufpe.agool.OOToolKit.Return;
import br.ufpe.agool.OOToolKit.SideEffectExpression;
import br.ufpe.agool.OOToolKit.Statement;
import br.ufpe.agool.OOToolKit.SuperClassObject;
import br.ufpe.agool.OOToolKit.Type;
import br.ufpe.agool.OOToolKit.UnaryExpression;
import br.ufpe.agool.OOToolKit.Variable;
import br.ufpe.agool.OOToolKit.VisitorNode;
import br.ufpe.agool.OOToolKit.While;
import br.ufpe.agool.classfile.ClassBuilder;
import br.ufpe.agool.classfile.ClassField;
import br.ufpe.agool.classfile.ClassMethod;
import br.ufpe.agool.classfile.Label;
import br.ufpe.agool.code.ByteArrayClassBag;
import br.ufpe.agool.code.ClassBag;
import br.ufpe.agool.code.CodeGenerator;
import java.util.HashMap;
import java.util.Stack;
import java.util.Vector;

public class BytecodeGenerator
implements CodeGenerator {
    private boolean debug = false;
    private ClassBag classbag;
    private ClassBuilder cbuilder;
    private Stack variables;
    private Stack scopes;
    int tamLocals;
    int maxTamLocals;
    private Vector initFields;
    private Vector initStaticFields;
    private int stackDepth;
    private int stackMaxDepth;
    private GClass currentClass;

    public BytecodeGenerator() {
        this(new ByteArrayClassBag());
    }

    public BytecodeGenerator(ClassBag classBag) {
        this.classbag = classBag;
        this.variables = new Stack();
        this.scopes = new Stack();
        this.initFields = new Vector();
        this.initStaticFields = new Vector();
    }

    public ClassBag getClassBag() {
        return this.classbag;
    }

    public ClassBag compile(AgoolProgram agoolProgram) {
        return (ClassBag)agoolProgram.visit(this, null);
    }

    private void incStack(int n) {
        this.stackDepth += n;
        if (this.stackDepth > this.stackMaxDepth) {
            this.stackMaxDepth = this.stackDepth;
        }
    }

    private void decStack(int n) {
        this.stackDepth -= n;
        if (this.stackDepth < 0) {
            System.out.println("[BYTECODE GEN] Pilha Negativa!!!");
        }
    }

    public Object visit(AgoolProgram agoolProgram, Object object) {
        GClass[] gClassArray = agoolProgram.getClasses();
        int n = gClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            gClassArray[n2].visit(this, null);
            ++n2;
        }
        return this.classbag;
    }

    public Object visitGClass(GClass gClass, Object object) {
        Field[] fieldArray = gClass.getFields();
        Method[] methodArray = gClass.getMethods();
        String string = gClass.getSuperClassName().equals(ObjectType.OBJECT.getName()) ? "java/lang/Object" : gClass.getSuperClass().getName();
        this.currentClass = gClass;
        String string2 = gClass.getName();
        if (this.debug) {
            System.out.println("\n[BYTECODE GEN] CLASSE: " + string2);
        }
        this.cbuilder = new ClassBuilder(string2.replace('.', '/'), string.replace('.', '/'), new String[0]);
        this.initFields.clear();
        this.initStaticFields.clear();
        int n = 0;
        while (n < fieldArray.length) {
            fieldArray[n].visit(this, null);
            ++n;
        }
        if (this.initStaticFields.size() > 0) {
            this.initializeStaticFields();
        }
        n = 0;
        while (n < methodArray.length) {
            methodArray[n].visit(this, null);
            ++n;
        }
        this.classbag.addClass(string2, this.cbuilder);
        return null;
    }

    private void initializeStaticFields() {
        Method method = new Method("<clinit>", new int[]{4}, new Variable[0], PrimitiveType.VOID);
        Block block = method.getBody();
        int n = 0;
        while (n < this.initStaticFields.size()) {
            Field field = (Field)this.initStaticFields.get(n);
            FieldAccess fieldAccess = new FieldAccess((Expression)new ClassExpression(this.currentClass), field);
            block.add(new Assignment(fieldAccess, field.getInitialValue()));
            ++n;
        }
        block.add(new Return());
        method.visit(this, null);
    }

    public Object visitField(Field field, Object object) {
        String string = field.getName();
        String string2 = (String)field.getType().visit(this, object);
        Expression expression = field.getInitialValue();
        boolean[] blArray = this.evaluateAccess(field.getAccess());
        if (expression != null) {
            if (field.hasModifier(4)) {
                this.initStaticFields.add(field);
            } else {
                this.initFields.add(field);
            }
        }
        ClassField classField = this.cbuilder.addField(string2, string);
        classField.setAccess(blArray[0], blArray[1], blArray[2], blArray[3], blArray[4]);
        return null;
    }

    public Object visitPrimitiveType(PrimitiveType primitiveType, Object object) {
        String string = "";
        if (primitiveType == PrimitiveType.CHAR) {
            string = "C";
        } else if (primitiveType == PrimitiveType.DOUBLE) {
            string = "D";
        } else if (primitiveType == PrimitiveType.FLOAT) {
            string = "F";
        } else if (primitiveType == PrimitiveType.INTEGER) {
            string = "I";
        } else if (primitiveType == PrimitiveType.LONG) {
            string = "J";
        } else if (primitiveType == PrimitiveType.BOOLEAN) {
            string = "Z";
        } else if (primitiveType == PrimitiveType.VOID) {
            string = "V";
        }
        return string;
    }

    public Object visitObjectType(ObjectType objectType, Object object) {
        String string = objectType.getGClass().getName();
        return "L" + string.replace('.', '/') + ";";
    }

    public Object visitArrayType(ArrayType arrayType, Object object) {
        String string = "";
        int n = arrayType.getNumDimensions();
        int n2 = 0;
        while (n2 < n) {
            string = string + "[";
            ++n2;
        }
        string = string + (String)arrayType.getBaseType().visit(this, null);
        return string;
    }

    private boolean[] evaluateAccess(int[] nArray) {
        boolean[] blArray = new boolean[6];
        int n = 0;
        while (n < nArray.length) {
            switch (nArray[n]) {
                case 5: {
                    blArray[4] = true;
                    break;
                }
                case 3: {
                    blArray[1] = true;
                    break;
                }
                case 1: {
                    blArray[2] = true;
                    break;
                }
                case 2: {
                    blArray[0] = true;
                    break;
                }
                case 4: {
                    blArray[3] = true;
                    break;
                }
                default: {
                    System.out.println("[BYTECODE GEN] Modificador inesperado - " + nArray[n]);
                }
            }
            ++n;
        }
        return blArray;
    }

    public Object visitMethod(Method method, Object object) {
        String string = method.getName();
        String string2 = this.evaluateMethodType(method);
        boolean[] blArray = this.evaluateAccess(method.getAccess());
        this.stackMaxDepth = 0;
        this.stackDepth = 0;
        this.maxTamLocals = 0;
        if (this.debug) {
            System.out.println("[BYTECODE GEN] Metodo " + method.getName());
        }
        ClassMethod classMethod = method.isConstructor() ? this.cbuilder.addMethod(string2, "<init>") : this.cbuilder.addMethod(string2, string);
        classMethod.setAccess(blArray[0], blArray[1], blArray[2], blArray[3], blArray[4], blArray[5]);
        this.evaluateMethod(method, classMethod);
        return null;
    }

    private String evaluateMethodType(Method method) {
        Type[] typeArray = method.getFormalsTypes();
        String string = (String)method.getReturnType().visit(this, null);
        String string2 = "";
        int n = 0;
        while (n < typeArray.length) {
            string2 = string2 + (String)typeArray[n].visit(this, null);
            ++n;
        }
        return "(" + string2 + ")" + string;
    }

    private void evaluateMethod(Method method, ClassMethod classMethod) {
        this.maxTamLocals = this.tamLocals = method.hasModifier(4) ? 0 : 1;
        this.scopes.clear();
        this.variables.clear();
        this.startScope();
        this.evaluateArguments(method);
        if (method.isConstructor()) {
            this.evaluateConstructorBlock(method.getBody(), classMethod);
        } else {
            method.getBody().visit(this, classMethod);
        }
        this.endScope();
        classMethod.setSize(this.maxTamLocals, this.stackMaxDepth + 2);
        if (this.debug) {
            System.out.println("[BYTECODE GEN] varLocais: " + this.maxTamLocals);
            System.out.println("[BYTECODE GEN] stack: " + this.stackMaxDepth);
        }
    }

    private void evaluateArguments(Method method) {
        Variable[] variableArray = method.getFormals();
        int n = 0;
        while (n < variableArray.length) {
            this.addVariable(variableArray[n]);
            ++n;
        }
    }

    private void addVariable(Variable variable) {
        HashMap hashMap = (HashMap)this.variables.peek();
        hashMap.put(variable.getName(), new Integer(this.tamLocals));
        Type type = variable.getType();
        if (this.debug) {
            System.out.println("[BYTECODE GEN] Variavel: " + variable.getName() + ", Slot: " + this.tamLocals);
        }
        this.tamLocals = type == PrimitiveType.LONG || type == PrimitiveType.DOUBLE ? (this.tamLocals += 2) : ++this.tamLocals;
        if (this.tamLocals > this.maxTamLocals) {
            this.maxTamLocals = this.tamLocals;
        }
    }

    private void evaluateConstructorBlock(Block block, ClassMethod classMethod) {
        int n;
        Statement[] statementArray = block.getStatements();
        MethodCall methodCall = (MethodCall)statementArray[0];
        methodCall.visit(this, classMethod);
        if (!(methodCall.getExpressionLeft() instanceof CurrentObject)) {
            n = 0;
            while (n < this.initFields.size()) {
                Field field = (Field)this.initFields.get(n);
                FieldAccess fieldAccess = new FieldAccess((Expression)new CurrentObject(this.currentClass), field);
                this.evaluateFieldAssignment(fieldAccess, field.getInitialValue(), classMethod);
                ++n;
            }
        }
        this.startScope();
        n = 1;
        while (n < statementArray.length) {
            if (statementArray[n] instanceof Variable) {
                this.evaluateVariableDeclaration((Variable)statementArray[n], classMethod);
            } else {
                statementArray[n].visit(this, classMethod);
            }
            if (this.stackDepth != 0) {
                System.out.println("[BYTECODE GEN] Erro: pilha nao nula apos finalizado statement: " + this.stackDepth);
                this.stackDepth = 0;
            }
            ++n;
        }
        this.endScope();
    }

    private int getVarIndice(Variable variable) {
        String string = variable.getName();
        Integer n = null;
        int n2 = this.scopes.size() - 1;
        while (n2 >= 0 && n == null) {
            HashMap hashMap = (HashMap)this.variables.get(n2);
            n = (Integer)hashMap.get(string);
            --n2;
        }
        return n;
    }

    private void startScope() {
        Integer n = new Integer(this.tamLocals);
        HashMap hashMap = new HashMap();
        this.scopes.push(n);
        this.variables.push(hashMap);
    }

    private void endScope() {
        Integer n = (Integer)this.scopes.pop();
        this.tamLocals = n;
        this.variables.pop();
    }

    public Object visitBlock(Block block, Object object) {
        ClassMethod classMethod = (ClassMethod)object;
        Statement[] statementArray = block.getStatements();
        this.startScope();
        int n = 0;
        while (n < statementArray.length) {
            if (statementArray[n] instanceof Variable) {
                this.evaluateVariableDeclaration((Variable)statementArray[n], classMethod);
            } else {
                statementArray[n].visit(this, classMethod);
            }
            if (this.stackDepth != 0) {
                System.out.println("[BYTECODE GEN] Erro: pilha nao nula apos finalizado statement: " + this.stackDepth);
                this.stackDepth = 0;
            }
            ++n;
        }
        this.endScope();
        return null;
    }

    private void evaluateVariableDeclaration(Variable variable, ClassMethod classMethod) {
        Expression expression = variable.getInitialValue();
        this.addVariable(variable);
        if (expression != null) {
            this.evaluateVarAssignment(variable, expression, classMethod);
        }
    }

    public Object visitAssignment(Assignment assignment, Object object) {
        ClassMethod classMethod = (ClassMethod)object;
        Expression expression = assignment.getLeftExpression();
        Expression expression2 = assignment.getRightExpression();
        if (expression instanceof FieldAccess) {
            this.evaluateFieldAssignment((FieldAccess)expression, expression2, classMethod);
        } else if (expression instanceof Variable) {
            this.evaluateVarAssignment((Variable)expression, expression2, classMethod);
        } else if (expression instanceof ArrayAccess) {
            this.evaluateArrayAssignment((ArrayAccess)expression, expression2, classMethod);
        } else {
            System.out.println("[BYTECODE GEN] Express\ufffdo inesperada: " + expression);
        }
        return null;
    }

    private void evaluateFieldAssignment(FieldAccess fieldAccess, Expression expression, ClassMethod classMethod) {
        int n;
        Field field = fieldAccess.getField();
        String string = (String)field.getType().visit(this, null);
        Type type = fieldAccess.getType();
        Expression expression2 = fieldAccess.getExpressionLeft();
        String string2 = ((ObjectType)expression2.getType()).getGClass().getName().replace('.', '/');
        expression2.visit(this, classMethod);
        expression.visit(this, classMethod);
        if (field.hasModifier(4)) {
            classMethod.op_putstatic(string2, field.getName(), string);
            n = 0;
        } else {
            classMethod.op_putfield(string2, field.getName(), string);
            n = 1;
        }
        if (type == PrimitiveType.DOUBLE || type == PrimitiveType.LONG) {
            this.decStack(n + 2);
        } else {
            this.decStack(n + 1);
        }
    }

    private void evaluateVarAssignment(Variable variable, Expression expression, ClassMethod classMethod) {
        int n = this.getVarIndice(variable);
        Type type = expression.getType();
        expression.visit(this, classMethod);
        if (type instanceof PrimitiveType) {
            if (type == PrimitiveType.DOUBLE) {
                classMethod.op_dstore(n);
                this.decStack(2);
            } else if (type == PrimitiveType.FLOAT) {
                classMethod.op_fstore(n);
                this.decStack(1);
            } else if (type == PrimitiveType.LONG) {
                classMethod.op_lstore(n);
                this.decStack(2);
            } else if (type == PrimitiveType.INTEGER || type == PrimitiveType.CHAR || type == PrimitiveType.BOOLEAN) {
                classMethod.op_istore(n);
                this.decStack(1);
            }
        } else {
            classMethod.op_astore(n);
            this.decStack(1);
        }
    }

    private void evaluateArrayAssignment(ArrayAccess arrayAccess, Expression expression, ClassMethod classMethod) {
        Type type = expression.getType();
        Expression[] expressionArray = arrayAccess.getIndices();
        int n = expressionArray.length;
        arrayAccess.getArray().visit(this, classMethod);
        int n2 = 0;
        while (n2 < n - 1) {
            expressionArray[n2].visit(this, classMethod);
            classMethod.op_aaload();
            this.decStack(1);
            ++n2;
        }
        expressionArray[n - 1].visit(this, classMethod);
        expression.visit(this, classMethod);
        this.evaluateArrayStore(type, classMethod);
    }

    private void evaluateArrayStore(Type type, ClassMethod classMethod) {
        if (type == PrimitiveType.BOOLEAN) {
            classMethod.op_bastore();
            this.decStack(3);
        } else if (type == PrimitiveType.CHAR) {
            classMethod.op_castore();
            this.decStack(3);
        } else if (type == PrimitiveType.INTEGER) {
            classMethod.op_iastore();
            this.decStack(3);
        } else if (type == PrimitiveType.LONG) {
            classMethod.op_lastore();
            this.decStack(4);
        } else if (type == PrimitiveType.FLOAT) {
            classMethod.op_fastore();
            this.decStack(3);
        } else if (type == PrimitiveType.DOUBLE) {
            classMethod.op_dastore();
            this.decStack(4);
        } else {
            classMethod.op_aastore();
            this.decStack(3);
        }
    }

    public Object visitReturn(Return return_, Object object) {
        ClassMethod classMethod = (ClassMethod)object;
        Expression expression = return_.getExpression();
        if (expression == null) {
            classMethod.op_return();
        } else {
            expression.visit(this, classMethod);
            Type type = expression.getType();
            if (type instanceof PrimitiveType) {
                if (type == PrimitiveType.DOUBLE) {
                    classMethod.op_dreturn();
                    this.decStack(2);
                } else if (type == PrimitiveType.FLOAT) {
                    classMethod.op_freturn();
                    this.decStack(1);
                } else if (type == PrimitiveType.LONG) {
                    classMethod.op_lreturn();
                    this.decStack(2);
                } else if (type == PrimitiveType.BOOLEAN || type == PrimitiveType.INTEGER || type == PrimitiveType.CHAR) {
                    classMethod.op_ireturn();
                    this.decStack(1);
                }
            } else {
                classMethod.op_areturn();
                this.decStack(1);
            }
        }
        return null;
    }

    public Object visitFieldAccess(FieldAccess fieldAccess, Object object) {
        ClassMethod classMethod = (ClassMethod)object;
        Field field = fieldAccess.getField();
        Type type = field.getType();
        String string = (String)type.visit(this, object);
        Expression expression = fieldAccess.getExpressionLeft();
        String string2 = ((ObjectType)expression.getType()).getGClass().getName().replace('.', '/');
        expression.visit(this, object);
        if (field.hasModifier(4)) {
            classMethod.op_getstatic(string2, field.getName(), string);
            if (type == PrimitiveType.DOUBLE || type == PrimitiveType.LONG) {
                this.incStack(2);
            } else {
                this.incStack(1);
            }
        } else {
            classMethod.op_getfield(string2, field.getName(), string);
            if (type == PrimitiveType.DOUBLE || type == PrimitiveType.LONG) {
                this.incStack(1);
            }
        }
        return field.getType();
    }

    public Object visitVariable(Variable variable, Object object) {
        ClassMethod classMethod = (ClassMethod)object;
        int n = this.getVarIndice(variable);
        Type type = variable.getType();
        if (type instanceof PrimitiveType) {
            if (type == PrimitiveType.DOUBLE) {
                classMethod.op_dload(n);
                this.incStack(2);
            } else if (type == PrimitiveType.FLOAT) {
                classMethod.op_fload(n);
                this.incStack(1);
            } else if (type == PrimitiveType.LONG) {
                classMethod.op_lload(n);
                this.incStack(2);
            } else if (type == PrimitiveType.INTEGER || type == PrimitiveType.CHAR || type == PrimitiveType.BOOLEAN) {
                classMethod.op_iload(n);
                this.incStack(1);
            }
        } else {
            classMethod.op_aload(n);
            this.incStack(1);
        }
        return type;
    }

    public Object visitConstant(Constant constant, Object object) {
        ClassMethod classMethod = (ClassMethod)object;
        Object object2 = constant.getValue();
        int n = 0;
        if (object2 instanceof Character) {
            this.visitConstant(new Constant((int)((Character)object2).charValue()), object);
        } else if (object2 instanceof Boolean) {
            if (((Boolean)object2).booleanValue()) {
                classMethod.op_iconst_1();
            } else {
                classMethod.op_iconst_0();
            }
            n = 1;
        } else if (object2 instanceof Integer) {
            int n2 = (Integer)object2;
            if (n2 >= -1 && n2 <= 5) {
                switch (n2) {
                    case -1: {
                        classMethod.op_iconst_m1();
                        break;
                    }
                    case 0: {
                        classMethod.op_iconst_0();
                        break;
                    }
                    case 1: {
                        classMethod.op_iconst_1();
                        break;
                    }
                    case 2: {
                        classMethod.op_iconst_2();
                        break;
                    }
                    case 3: {
                        classMethod.op_iconst_3();
                        break;
                    }
                    case 4: {
                        classMethod.op_iconst_4();
                        break;
                    }
                    case 5: {
                        classMethod.op_iconst_5();
                    }
                }
            } else if (n2 >= -128 && n2 <= 127) {
                classMethod.op_bipush(n2);
            } else if (n2 >= Short.MIN_VALUE && n2 <= Short.MAX_VALUE) {
                classMethod.op_sipush(n2);
            } else {
                classMethod.op_ldc(classMethod.getConstantPool().getConstant(n2));
            }
            n = 1;
        } else if (object2 instanceof Float) {
            float f = ((Float)object2).floatValue();
            classMethod.op_ldc(classMethod.getConstantPool().getConstant(f));
            n = 1;
        } else if (object2 instanceof Double) {
            double d = (Double)object2;
            classMethod.op_ldc2_w(classMethod.getConstantPool().getConstant(d));
            n = 2;
        } else if (object2 instanceof Long) {
            long l = (Long)object2;
            classMethod.op_ldc2_w(classMethod.getConstantPool().getConstant(l));
            n = 2;
        } else if (object2 instanceof Short) {
            short s = (Short)object2;
            classMethod.op_sipush(s);
            n = 1;
        } else if (object2 instanceof String) {
            classMethod.op_ldc(classMethod.getConstantPool().getConstant((String)object2));
            n = 1;
        }
        this.incStack(n);
        return null;
    }

    public Object visitCurrentObject(CurrentObject currentObject, Object object) {
        ClassMethod classMethod = (ClassMethod)object;
        classMethod.op_aload_0();
        this.incStack(1);
        return null;
    }

    public Object visitSideEffectExpression(SideEffectExpression sideEffectExpression, Object object) {
        Expression expression = sideEffectExpression.getTarget();
        if (sideEffectExpression.isPreOperation()) {
            sideEffectExpression.getCommand().visit(this, object);
        }
        if (sideEffectExpression.isExpression()) {
            expression.visit(this, object);
        }
        if (!sideEffectExpression.isPreOperation()) {
            sideEffectExpression.getCommand().visit(this, object);
        }
        return null;
    }

    public Object visitSuperClassObject(SuperClassObject superClassObject, Object object) {
        ClassMethod classMethod = (ClassMethod)object;
        classMethod.op_aload_0();
        this.incStack(1);
        return null;
    }

    public Object visitNewObject(NewObject newObject, Object object) {
        ClassMethod classMethod = (ClassMethod)object;
        ObjectType objectType = newObject.getObjectType();
        Expression[] expressionArray = newObject.getArguments();
        String string = objectType.getGClass().getName().replace('.', '/');
        String string2 = this.evaluateMethodType(newObject.getConstructor());
        int n = 0;
        classMethod.op_new(classMethod.getConstantPool().getClass(string));
        classMethod.op_dup();
        this.incStack(2);
        int n2 = 0;
        while (n2 < expressionArray.length) {
            expressionArray[n2].visit(this, classMethod);
            Type type = expressionArray[n2].getType();
            n = type == PrimitiveType.DOUBLE || type == PrimitiveType.LONG ? (n += 2) : ++n;
            ++n2;
        }
        classMethod.op_invokespecial(string, "<init>", string2);
        this.decStack(n + 1);
        return null;
    }

    public Object visitNullObject(NullObject nullObject, Object object) {
        ClassMethod classMethod = (ClassMethod)object;
        classMethod.op_aconst_null();
        this.incStack(1);
        return null;
    }

    public Object visitBinaryExpression(BinaryExpression binaryExpression, Object object) {
        ClassMethod classMethod = (ClassMethod)object;
        Expression expression = binaryExpression.getOperand1();
        Expression expression2 = binaryExpression.getOperand2();
        Type type = expression.getType();
        expression.visit(this, classMethod);
        expression2.visit(this, classMethod);
        int n = binaryExpression.getOperator();
        if (type == PrimitiveType.DOUBLE) {
            this.evaluateDoubleOPExpression(classMethod, n);
        } else if (type == PrimitiveType.FLOAT) {
            this.evaluateFloatOPExpression(classMethod, n);
        } else if (type == PrimitiveType.LONG) {
            this.evaluateLongOPExpression(classMethod, n);
        } else if (type == PrimitiveType.CHAR || type == PrimitiveType.BOOLEAN || type == PrimitiveType.INTEGER) {
            this.evaluateIntegerOPExpression(classMethod, n);
        } else if (type instanceof ObjectType) {
            this.evaluateObjectOPExpression(classMethod, n);
        } else {
            System.out.println("[BYTECODE GEN] Tipo inesperado!");
        }
        return null;
    }

    public Object visitUnaryExpression(UnaryExpression unaryExpression, Object object) {
        ClassMethod classMethod = (ClassMethod)object;
        Expression expression = unaryExpression.getOperand();
        Type type = expression.getType();
        int n = unaryExpression.getOperator();
        expression.visit(this, classMethod);
        switch (n) {
            case 13: {
                if (type == PrimitiveType.BOOLEAN) {
                    classMethod.op_iconst_1();
                    this.incStack(1);
                    classMethod.op_ixor();
                    this.decStack(1);
                    break;
                }
                classMethod.op_iconst_m1();
                this.incStack(1);
                classMethod.op_ixor();
                this.decStack(1);
                break;
            }
            case 6: {
                if (type == PrimitiveType.INTEGER) {
                    classMethod.op_ineg();
                    break;
                }
                if (type == PrimitiveType.LONG) {
                    classMethod.op_lneg();
                    break;
                }
                if (type == PrimitiveType.FLOAT) {
                    classMethod.op_fneg();
                    break;
                }
                if (type != PrimitiveType.DOUBLE) break;
                classMethod.op_dneg();
                break;
            }
            default: {
                System.out.println("[BYTECODE GEN] Operador unario invalido: " + n);
            }
        }
        return null;
    }

    private void evaluateIntegerOPExpression(ClassMethod classMethod, int n) {
        Label label = null;
        boolean bl = false;
        switch (n) {
            case 1: {
                classMethod.op_iadd();
                break;
            }
            case 3: {
                classMethod.op_idiv();
                break;
            }
            case 5: {
                classMethod.op_imul();
                break;
            }
            case 2: {
                classMethod.op_isub();
                break;
            }
            case 4: {
                classMethod.op_irem();
                break;
            }
            case 15: {
                classMethod.op_iand();
                break;
            }
            case 14: {
                classMethod.op_ior();
                break;
            }
            case 16: {
                classMethod.op_ixor();
                break;
            }
            case 10: {
                bl = true;
                label = new Label();
                classMethod.op_if_icmpeq(label);
                break;
            }
            case 9: {
                bl = true;
                label = new Label();
                classMethod.op_if_icmpne(label);
                break;
            }
            case 8: {
                bl = true;
                label = new Label();
                classMethod.op_if_icmple(label);
                break;
            }
            case 7: {
                bl = true;
                label = new Label();
                classMethod.op_if_icmpge(label);
                break;
            }
            case 11: {
                bl = true;
                label = new Label();
                classMethod.op_if_icmpgt(label);
                break;
            }
            case 12: {
                bl = true;
                label = new Label();
                classMethod.op_if_icmplt(label);
                break;
            }
            default: {
                System.out.println("[BYTECODE GEN] Operador " + n + " nao se aplica!");
                return;
            }
        }
        if (bl) {
            Label label2 = new Label();
            classMethod.op_iconst_1();
            classMethod.op_goto(label2);
            classMethod.setLabel(label);
            classMethod.op_iconst_0();
            classMethod.setLabel(label2);
        }
        this.decStack(1);
    }

    private void evaluateFloatOPExpression(ClassMethod classMethod, int n) {
        boolean bl = false;
        Label label = new Label();
        switch (n) {
            case 1: {
                classMethod.op_fadd();
                break;
            }
            case 3: {
                classMethod.op_fdiv();
                break;
            }
            case 5: {
                classMethod.op_fmul();
                break;
            }
            case 2: {
                classMethod.op_fsub();
                break;
            }
            case 4: {
                classMethod.op_frem();
                break;
            }
            case 10: {
                bl = true;
                classMethod.op_fcmpg();
                classMethod.op_ifeq(label);
                break;
            }
            case 9: {
                bl = true;
                classMethod.op_fcmpg();
                classMethod.op_ifne(label);
                break;
            }
            case 8: {
                bl = true;
                classMethod.op_fcmpg();
                classMethod.op_ifle(label);
                break;
            }
            case 7: {
                bl = true;
                classMethod.op_fcmpg();
                classMethod.op_ifge(label);
                break;
            }
            case 11: {
                bl = true;
                classMethod.op_fcmpg();
                classMethod.op_ifgt(label);
                break;
            }
            case 12: {
                bl = true;
                classMethod.op_fcmpg();
                classMethod.op_iflt(label);
                break;
            }
            default: {
                System.out.println("[BYTECODE GEN] Operador " + n + " nao se aplica!");
            }
        }
        if (bl) {
            Label label2 = new Label();
            classMethod.op_iconst_1();
            classMethod.op_goto(label2);
            classMethod.setLabel(label);
            classMethod.op_iconst_0();
            classMethod.setLabel(label2);
        }
        this.decStack(1);
    }

    private void evaluateDoubleOPExpression(ClassMethod classMethod, int n) {
        boolean bl = false;
        Label label = new Label();
        Label label2 = null;
        switch (n) {
            case 1: {
                classMethod.op_dadd();
                break;
            }
            case 3: {
                classMethod.op_ddiv();
                break;
            }
            case 5: {
                classMethod.op_dmul();
                break;
            }
            case 2: {
                classMethod.op_dsub();
                break;
            }
            case 4: {
                classMethod.op_drem();
                break;
            }
            case 10: {
                bl = true;
                classMethod.op_dcmpg();
                classMethod.op_ifeq(label);
                break;
            }
            case 9: {
                bl = true;
                classMethod.op_dcmpg();
                classMethod.op_ifne(label);
                break;
            }
            case 8: {
                bl = true;
                classMethod.op_dcmpg();
                classMethod.op_ifle(label);
                break;
            }
            case 7: {
                bl = true;
                classMethod.op_dcmpg();
                classMethod.op_ifge(label);
                break;
            }
            case 11: {
                bl = true;
                classMethod.op_dcmpg();
                classMethod.op_ifgt(label);
                break;
            }
            case 12: {
                bl = true;
                classMethod.op_dcmpg();
                classMethod.op_iflt(label);
                break;
            }
            default: {
                System.out.println("[BYTECODE GEN] Operador " + n + " nao se aplica!");
            }
        }
        if (bl) {
            label2 = new Label();
            classMethod.op_iload_1();
            classMethod.op_goto(label2);
            classMethod.setLabel(label);
            classMethod.op_iload_0();
            classMethod.setLabel(label2);
            this.decStack(3);
        } else {
            this.decStack(2);
        }
    }

    private void evaluateLongOPExpression(ClassMethod classMethod, int n) {
        boolean bl = false;
        Label label = new Label();
        Label label2 = null;
        switch (n) {
            case 1: {
                classMethod.op_ladd();
                break;
            }
            case 3: {
                classMethod.op_ldiv();
                break;
            }
            case 5: {
                classMethod.op_lmul();
                break;
            }
            case 2: {
                classMethod.op_lsub();
                break;
            }
            case 4: {
                classMethod.op_lrem();
                break;
            }
            case 10: {
                bl = true;
                classMethod.op_lcmp();
                classMethod.op_ifeq(label);
                break;
            }
            case 9: {
                bl = true;
                classMethod.op_lcmp();
                classMethod.op_ifne(label);
                break;
            }
            case 8: {
                bl = true;
                classMethod.op_lcmp();
                classMethod.op_ifle(label);
                break;
            }
            case 7: {
                bl = true;
                classMethod.op_lcmp();
                classMethod.op_ifge(label);
                break;
            }
            case 11: {
                bl = true;
                classMethod.op_lcmp();
                classMethod.op_ifgt(label);
                break;
            }
            case 12: {
                bl = true;
                classMethod.op_lcmp();
                classMethod.op_iflt(label);
                break;
            }
            default: {
                System.out.println("[BYTECODE GEN] Operador " + n + " nao se aplica!");
            }
        }
        if (bl) {
            label2 = new Label();
            classMethod.op_iconst_1();
            classMethod.op_goto(label2);
            classMethod.setLabel(label);
            classMethod.op_iconst_0();
            classMethod.setLabel(label2);
            this.decStack(3);
        } else {
            this.decStack(2);
        }
    }

    private void evaluateObjectOPExpression(ClassMethod classMethod, int n) {
        boolean bl = false;
        Label label = new Label();
        switch (n) {
            case 9: {
                bl = true;
                classMethod.op_if_acmpne(label);
                break;
            }
            case 10: {
                bl = true;
                classMethod.op_if_acmpeq(label);
                break;
            }
            default: {
                System.out.println("[BYTECODE GEN] Operador nao esperado: " + n);
            }
        }
        if (bl) {
            Label label2 = new Label();
            classMethod.op_iconst_1();
            classMethod.op_goto(label2);
            classMethod.setLabel(label);
            classMethod.op_iconst_0();
            classMethod.setLabel(label2);
            this.decStack(1);
        }
    }

    public Object visitInstanceOf(InstanceOf instanceOf, Object object) {
        ClassMethod classMethod = (ClassMethod)object;
        ObjectType objectType = instanceOf.getDestinationType();
        instanceOf.getExpression().visit(this, classMethod);
        if (objectType instanceof ArrayType) {
            classMethod.op_instanceof((String)objectType.visit(this, object));
        } else {
            classMethod.op_instanceof(objectType.getGClass().getName().replace('.', '/'));
        }
        return null;
    }

    public Object visitIf(If if_, Object object) {
        ClassMethod classMethod = (ClassMethod)object;
        Label label = new Label();
        Label label2 = new Label();
        Label label3 = new Label();
        Block block = if_.getTrueBlock();
        Block block2 = if_.getFalseBlock();
        Expression expression = if_.getExpression();
        if (block2 != null) {
            this.evaluateBranchExpression(if_.getExpression(), label, label2, classMethod);
            classMethod.setLabel(label2);
            block2.visit(this, classMethod);
        } else {
            this.evaluateBranchExpression(if_.getExpression(), label, label3, classMethod);
        }
        classMethod.op_goto(label3);
        classMethod.setLabel(label);
        block.visit(this, classMethod);
        classMethod.setLabel(label3);
        return null;
    }

    private void evaluateBranchExpression(Expression expression, Label label, Label label2, ClassMethod classMethod) {
        if (expression instanceof Constant) {
            boolean bl = (Boolean)((Constant)expression).getValue();
            if (bl) {
                classMethod.op_goto(label);
            }
        } else if (expression instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            Expression expression2 = binaryExpression.getOperand1();
            Expression expression3 = binaryExpression.getOperand2();
            Type type = expression2.getType();
            int n = binaryExpression.getOperator();
            switch (n) {
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    expression2.visit(this, classMethod);
                    expression3.visit(this, classMethod);
                    if (type instanceof PrimitiveType) {
                        this.evaluateBranchOperator(n, (PrimitiveType)type, classMethod, label);
                        break;
                    }
                    if (type instanceof ObjectType) {
                        this.evaluateBranchOperator(n, (ObjectType)type, classMethod, label);
                        break;
                    }
                    System.out.println("[BYTECODE GEN] Tipo inesperado: " + type);
                    break;
                }
                case 15: {
                    Label label3 = new Label();
                    this.evaluateBranchExpression(expression2, label3, label2, classMethod);
                    classMethod.op_goto(label2);
                    classMethod.setLabel(label3);
                    this.evaluateBranchExpression(expression3, label, label2, classMethod);
                    break;
                }
                case 14: {
                    Label label4 = new Label();
                    this.evaluateBranchExpression(expression2, label, label4, classMethod);
                    classMethod.setLabel(label4);
                    this.evaluateBranchExpression(expression3, label, label2, classMethod);
                    break;
                }
                default: {
                    System.out.println("[BYTECODE GEN] Operador invalido : \"" + n + "\"!");
                    break;
                }
            }
        } else if (expression instanceof UnaryExpression && ((UnaryExpression)expression).getOperator() == 13) {
            this.evaluateBranchExpression(((UnaryExpression)expression).getOperand(), label2, label, classMethod);
            classMethod.op_goto(label);
        } else {
            expression.visit(this, classMethod);
            classMethod.op_ifne(label);
            this.decStack(1);
        }
    }

    private void evaluateBranchOperator(int n, PrimitiveType primitiveType, ClassMethod classMethod, Label label) {
        if (primitiveType == PrimitiveType.INTEGER || primitiveType == PrimitiveType.BOOLEAN || primitiveType == PrimitiveType.CHAR) {
            switch (n) {
                case 10: {
                    classMethod.op_if_icmpne(label);
                    break;
                }
                case 9: {
                    classMethod.op_if_icmpeq(label);
                    break;
                }
                case 8: {
                    classMethod.op_if_icmpgt(label);
                    break;
                }
                case 7: {
                    classMethod.op_if_icmplt(label);
                    break;
                }
                case 11: {
                    classMethod.op_if_icmple(label);
                    break;
                }
                case 12: {
                    classMethod.op_if_icmpge(label);
                    break;
                }
                default: {
                    System.out.println("[BYTECODE GEN] Operador nao esperado: " + n);
                }
            }
            this.decStack(2);
        } else {
            if (primitiveType == PrimitiveType.LONG) {
                classMethod.op_lcmp();
                this.decStack(3);
            } else if (primitiveType == PrimitiveType.FLOAT) {
                classMethod.op_fcmpg();
                this.decStack(1);
            } else if (primitiveType == PrimitiveType.DOUBLE) {
                classMethod.op_dcmpg();
                this.decStack(3);
            } else {
                System.out.println("[BYTECODE GEN] Tipo inesperado!!");
            }
            switch (n) {
                case 10: {
                    classMethod.op_ifne(label);
                    break;
                }
                case 9: {
                    classMethod.op_ifeq(label);
                    break;
                }
                case 8: {
                    classMethod.op_ifgt(label);
                    break;
                }
                case 7: {
                    classMethod.op_iflt(label);
                    break;
                }
                case 11: {
                    classMethod.op_ifle(label);
                    break;
                }
                case 12: {
                    classMethod.op_ifge(label);
                    break;
                }
                default: {
                    System.out.println("[BYTECODE GEN] Operador nao esperado: " + n);
                }
            }
            this.decStack(1);
        }
    }

    private void evaluateBranchOperator(int n, ObjectType objectType, ClassMethod classMethod, Label label) {
        switch (n) {
            case 9: {
                classMethod.op_if_acmpeq(label);
                break;
            }
            case 10: {
                classMethod.op_if_acmpne(label);
                break;
            }
            default: {
                System.out.println("[BYTECODE GEN] Operador nao esperado: " + n);
            }
        }
        this.decStack(2);
    }

    public Object visitWhile(While while_, Object object) {
        ClassMethod classMethod = (ClassMethod)object;
        Block block = while_.getBlock();
        Label label = new Label();
        Label label2 = new Label();
        Label label3 = new Label();
        classMethod.op_goto(label2);
        classMethod.setLabel(label);
        block.visit(this, classMethod);
        classMethod.setLabel(label2);
        this.evaluateBranchExpression(while_.getExpression(), label, label3, classMethod);
        classMethod.setLabel(label3);
        return null;
    }

    public Object visitMethodCall(MethodCall methodCall, Object object) {
        ClassMethod classMethod = (ClassMethod)object;
        Method method = methodCall.getMethod();
        Type type = method.getReturnType();
        String string = this.evaluateMethodType(method);
        String string2 = method.getName();
        Expression[] expressionArray = methodCall.getArguments();
        Expression expression = methodCall.getExpressionLeft();
        String string3 = ((ObjectType)expression.getType()).getGClass().getName().replace('.', '/');
        int n = this.stackDepth;
        methodCall.getExpressionLeft().visit(this, classMethod);
        int n2 = 0;
        while (n2 < expressionArray.length) {
            expressionArray[n2].visit(this, classMethod);
            ++n2;
        }
        if (method.hasModifier(4)) {
            classMethod.op_invokestatic(string3, string2, string);
        } else if (methodCall.isConstructor()) {
            classMethod.op_invokespecial(string3, "<init>", string);
        } else if (method.hasModifier(3)) {
            classMethod.op_invokespecial(string3, string2, string);
        } else if (expression instanceof SuperClassObject) {
            classMethod.op_invokespecial(string3, string2, string);
        } else {
            classMethod.op_invokevirtual(string3, string2, string);
        }
        this.decStack(this.stackDepth - n);
        if (type == PrimitiveType.LONG || type == PrimitiveType.DOUBLE) {
            this.incStack(2);
            if (!methodCall.isExpression()) {
                classMethod.op_pop2();
                this.decStack(2);
            }
        } else if (type != PrimitiveType.VOID) {
            this.incStack(1);
            if (!methodCall.isExpression()) {
                classMethod.op_pop();
                this.decStack(1);
            }
        }
        return null;
    }

    public Object visitPrint(Print print, Object object) {
        ClassMethod classMethod = (ClassMethod)object;
        String string = print.getMessage();
        classMethod.op_getstatic("java/lang/System", "out", "Ljava/io/PrintStream;");
        this.incStack(1);
        classMethod.op_ldc(classMethod.getConstantPool().getConstant(string));
        this.incStack(1);
        classMethod.op_invokevirtual("java/io/PrintStream", "print", "(Ljava/lang/String;)V");
        this.decStack(2);
        return null;
    }

    public Object visitArrayLength(ArrayLength arrayLength, Object object) {
        ClassMethod classMethod = (ClassMethod)object;
        arrayLength.getArray().visit(this, classMethod);
        classMethod.op_arraylength();
        return null;
    }

    public Object visitNewArray(NewArray newArray, Object object) {
        VisitorNode visitorNode;
        ClassMethod classMethod = (ClassMethod)object;
        Expression[] expressionArray = newArray.getDimensions();
        Expression[] expressionArray2 = newArray.getInitialValues();
        ArrayType arrayType = newArray.getArrayType();
        String string = null;
        int n = expressionArray.length;
        int n2 = arrayType.getNumDimensions();
        int n3 = 0;
        while (n3 < n) {
            expressionArray[n3].visit(this, classMethod);
            ++n3;
        }
        if (n == 1 && n2 == 1) {
            visitorNode = arrayType.getBaseType();
            if (visitorNode == PrimitiveType.INTEGER) {
                classMethod.op_newarray(10);
            } else if (visitorNode == PrimitiveType.BOOLEAN) {
                classMethod.op_newarray(4);
            } else if (visitorNode == PrimitiveType.CHAR) {
                classMethod.op_newarray(5);
            } else if (visitorNode == PrimitiveType.LONG) {
                classMethod.op_newarray(11);
            } else if (visitorNode == PrimitiveType.FLOAT) {
                classMethod.op_newarray(6);
            } else if (visitorNode == PrimitiveType.DOUBLE) {
                classMethod.op_newarray(7);
            } else if (visitorNode instanceof ObjectType) {
                classMethod.op_anewarray(((ObjectType)visitorNode).getGClass().getName().replace('.', '/'));
            } else if (visitorNode instanceof ArrayType) {
                string = (String)((Type)visitorNode).visit(this, null);
                classMethod.op_anewarray(string);
            }
        } else if (n == 1 && n2 > 1) {
            string = (String)arrayType.getResultingType(1).visit(this, null);
            classMethod.op_anewarray(string);
        } else if (n > 1) {
            string = (String)arrayType.visit(this, null);
            classMethod.op_multianewarray(string, n);
        }
        this.decStack(n - 1);
        int n4 = 0;
        while (n4 < expressionArray2.length) {
            classMethod.op_dup();
            this.incStack(1);
            visitorNode = new Constant(n4);
            visitorNode.visit(this, classMethod);
            expressionArray2[n4].visit(this, object);
            this.evaluateArrayStore(expressionArray2[n4].getType(), classMethod);
            ++n4;
        }
        return null;
    }

    public Object visitArrayAccess(ArrayAccess arrayAccess, Object object) {
        ClassMethod classMethod = (ClassMethod)object;
        Type type = arrayAccess.getType();
        Expression[] expressionArray = arrayAccess.getIndices();
        int n = expressionArray.length;
        arrayAccess.getArray().visit(this, classMethod);
        int n2 = 0;
        while (n2 < n - 1) {
            expressionArray[n2].visit(this, classMethod);
            classMethod.op_aaload();
            this.decStack(1);
            ++n2;
        }
        expressionArray[n - 1].visit(this, classMethod);
        if (type == PrimitiveType.BOOLEAN) {
            classMethod.op_baload();
            this.decStack(1);
        } else if (type == PrimitiveType.CHAR) {
            classMethod.op_caload();
            this.decStack(1);
        } else if (type == PrimitiveType.INTEGER) {
            classMethod.op_iaload();
            this.decStack(1);
        } else if (type == PrimitiveType.LONG) {
            classMethod.op_laload();
        } else if (type == PrimitiveType.FLOAT) {
            classMethod.op_faload();
            this.decStack(1);
        } else if (type == PrimitiveType.DOUBLE) {
            classMethod.op_daload();
        } else {
            classMethod.op_aaload();
            this.decStack(1);
        }
        return null;
    }

    public Object visitClassExpression(ClassExpression classExpression, Object object) {
        return null;
    }

    public Object visitCast(Cast cast, Object object) {
        ClassMethod classMethod = (ClassMethod)object;
        Expression expression = cast.getExpression();
        Type type = cast.getType();
        expression.visit(this, classMethod);
        if (type instanceof ArrayType) {
            classMethod.op_checkcast((String)type.visit(this, null));
        } else {
            classMethod.op_checkcast(((ObjectType)type).getGClass().getName().replace('.', '/'));
        }
        return null;
    }

    public Object visitConversion(Conversion conversion, Object object) {
        ClassMethod classMethod = (ClassMethod)object;
        Expression expression = conversion.getExpression();
        PrimitiveType primitiveType = (PrimitiveType)expression.getType();
        PrimitiveType primitiveType2 = conversion.getFinalType();
        expression.visit(this, object);
        if (primitiveType2 == PrimitiveType.CHAR) {
            this.evaluateCharConversion(primitiveType, classMethod);
        } else if (primitiveType2 == PrimitiveType.INTEGER) {
            this.evaluateIntegerConversion(primitiveType, classMethod);
        } else if (primitiveType2 == PrimitiveType.LONG) {
            this.evaluateLongConversion(primitiveType, classMethod);
        } else if (primitiveType2 == PrimitiveType.FLOAT) {
            this.evaluateFloatConversion(primitiveType, classMethod);
        } else if (primitiveType2 == PrimitiveType.DOUBLE) {
            this.evaluateDoubleConversion(primitiveType, classMethod);
        } else {
            System.out.println("[BYTECODE GEN] Tipo inesperado - " + primitiveType2);
        }
        return null;
    }

    private void evaluateCharConversion(PrimitiveType primitiveType, ClassMethod classMethod) {
        if (primitiveType == PrimitiveType.INTEGER) {
            classMethod.op_i2c();
        } else if (primitiveType == PrimitiveType.LONG) {
            classMethod.op_l2i();
            this.decStack(1);
            classMethod.op_i2c();
        } else if (primitiveType == PrimitiveType.FLOAT) {
            classMethod.op_f2i();
            classMethod.op_i2c();
        } else if (primitiveType == PrimitiveType.DOUBLE) {
            classMethod.op_d2i();
            this.decStack(1);
            classMethod.op_i2c();
        } else {
            System.out.println("[BYTECODE GEN] Tipo de origem inesperado - " + primitiveType);
        }
    }

    private void evaluateIntegerConversion(PrimitiveType primitiveType, ClassMethod classMethod) {
        if (primitiveType == PrimitiveType.LONG) {
            classMethod.op_l2i();
            this.decStack(1);
        } else if (primitiveType == PrimitiveType.FLOAT) {
            classMethod.op_f2i();
        } else if (primitiveType == PrimitiveType.DOUBLE) {
            classMethod.op_d2i();
            this.decStack(1);
        } else {
            System.out.println("[BYTECODE GEN] Tipo de origem inesperado - " + primitiveType);
        }
    }

    private void evaluateLongConversion(PrimitiveType primitiveType, ClassMethod classMethod) {
        if (primitiveType == PrimitiveType.CHAR || primitiveType == PrimitiveType.INTEGER) {
            classMethod.op_i2l();
            this.incStack(1);
        } else if (primitiveType == PrimitiveType.FLOAT) {
            classMethod.op_f2l();
            this.incStack(1);
        } else if (primitiveType == PrimitiveType.DOUBLE) {
            classMethod.op_d2l();
        } else {
            System.out.println("[BYTECODE GEN] Tipo de origem inesperado - " + primitiveType);
        }
    }

    private void evaluateFloatConversion(PrimitiveType primitiveType, ClassMethod classMethod) {
        if (primitiveType == PrimitiveType.CHAR || primitiveType == PrimitiveType.INTEGER) {
            classMethod.op_i2f();
        } else if (primitiveType == PrimitiveType.LONG) {
            classMethod.op_l2f();
            this.decStack(1);
        } else if (primitiveType == PrimitiveType.DOUBLE) {
            classMethod.op_d2f();
            this.decStack(1);
        } else {
            System.out.println("[BYTECODE GEN] Tipo de origem inesperado - " + primitiveType);
        }
    }

    private void evaluateDoubleConversion(PrimitiveType primitiveType, ClassMethod classMethod) {
        if (primitiveType == PrimitiveType.CHAR || primitiveType == PrimitiveType.INTEGER) {
            classMethod.op_i2d();
            this.incStack(1);
        } else if (primitiveType == PrimitiveType.LONG) {
            classMethod.op_l2d();
        } else if (primitiveType == PrimitiveType.FLOAT) {
            classMethod.op_f2d();
            this.incStack(1);
        } else {
            System.out.println("[BYTECODE GEN] Tipo de origem inesperado - " + primitiveType);
        }
    }
}

