/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.agool.code;

import br.ufpe.agool.code.ByteArrayClassBag;
import br.ufpe.agool.java.AgoolJavaFacade;
import java.io.ByteArrayInputStream;
import java.util.HashMap;

public class AgoolClassLoader
extends ClassLoader {
    private ByteArrayClassBag classbag;
    private HashMap classes;

    AgoolClassLoader(ByteArrayClassBag byteArrayClassBag) {
        this.classbag = byteArrayClassBag;
        this.classes = new HashMap();
    }

    public ByteArrayClassBag classBag() {
        return this.classbag;
    }

    public Class findClass(String string) throws ClassNotFoundException {
        Class<?> clazz;
        if (this.classbag.hasClass(string)) {
            if (this.classes.containsKey(string)) {
                clazz = (Class<?>)this.classes.get(string);
            } else {
                byte[] byArray = this.classbag.getBytes(string);
                clazz = super.defineClass(string, byArray, 0, byArray.length);
                this.classes.put(string, clazz);
            }
        } else {
            throw new ClassNotFoundException(string);
        }
        return clazz;
    }

    public static void main(String[] stringArray) throws Exception {
        AgoolJavaFacade agoolJavaFacade = new AgoolJavaFacade();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream("class TesteClassLoader {\n }\n".getBytes());
        AgoolClassLoader agoolClassLoader = agoolJavaFacade.compileToClass(byteArrayInputStream);
        try {
            Class<?> clazz = agoolClassLoader.loadClass("java.lang.Object");
            System.out.println("Classe: " + clazz.toString() + ", " + clazz.getClassLoader());
            clazz = agoolClassLoader.loadClass("TesteClassLoader");
            System.out.println("Classe: " + clazz.toString() + ", " + clazz.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }
}

