/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.agool.classfile;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;

public class ConstantPool {
    String[] consLabel = new String[]{"", "utf8", "", "int", "float", "long", "double", "Class", "String", "Field", "method", "interfacemethod", "NameAndType"};
    Vector constants = new Vector();
    HashMap constToInt = new HashMap();

    ConstantPool() {
        this.constants.addElement(null);
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        int n = this.constants.size();
        dataOutputStream.writeShort(n);
        int n2 = 1;
        while (n2 < n) {
            Constant constant = (Constant)this.constants.elementAt(n2);
            dataOutputStream.writeByte(constant.type);
            switch (constant.type) {
                case 3: {
                    dataOutputStream.writeInt(constant.v1);
                    break;
                }
                case 4: {
                    dataOutputStream.writeFloat(constant.fvalue);
                    break;
                }
                case 5: {
                    dataOutputStream.writeLong(constant.lvalue);
                    break;
                }
                case 6: {
                    dataOutputStream.writeDouble(constant.dvalue);
                    break;
                }
                case 7: 
                case 8: {
                    dataOutputStream.writeShort(constant.v1);
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    dataOutputStream.writeShort(constant.v1);
                    dataOutputStream.writeShort(constant.v2);
                    break;
                }
                case 1: {
                    dataOutputStream.writeUTF(constant.name);
                }
            }
            ++n2;
        }
    }

    void print() {
        int n = 0;
        while (n < this.constants.size()) {
            System.out.println("Constante " + n + " = " + this.constants.elementAt(n).toString());
            ++n;
        }
    }

    int find(Constant constant) {
        Object v = this.constToInt.get(constant);
        if (v == null) {
            int n = this.constants.size();
            this.constToInt.put(constant, new Integer(n));
            this.constants.addElement(constant);
            return n;
        }
        Integer n = (Integer)v;
        return n;
    }

    public int getUTF8(String string) {
        return this.find(new Constant(string));
    }

    public int getConstant(int n) {
        return this.find(new Constant(n));
    }

    public int getConstant(float f) {
        return this.find(new Constant(f));
    }

    public int getConstant(long l) {
        return this.find(new Constant(l));
    }

    public int getConstant(double d) {
        return this.find(new Constant(d));
    }

    public int getConstant(String string) {
        return this.find(new Constant(8, this.getUTF8(string)));
    }

    public int getClass(String string) {
        return this.find(new Constant(7, this.getUTF8(string)));
    }

    public int getField(String string, String string2, String string3) {
        int n = this.getClass(string);
        int n2 = this.getUTF8(string2);
        int n3 = this.getUTF8(string3);
        int n4 = this.find(new Constant(12, n2, n3));
        return this.find(new Constant(9, n, n4));
    }

    public int getMethod(String string, String string2, String string3) {
        int n = this.getClass(string);
        int n2 = this.getUTF8(string2);
        int n3 = this.getUTF8(string3);
        int n4 = this.find(new Constant(12, n2, n3));
        return this.find(new Constant(10, n, n4));
    }

    public int getInterfaceMethod(String string, String string2, String string3) {
        int n = this.getClass(string);
        int n2 = this.getUTF8(string2);
        int n3 = this.getUTF8(string3);
        int n4 = this.find(new Constant(12, n2, n3));
        return this.find(new Constant(11, n, n4));
    }

    class Constant {
        int type;
        String name;
        long lvalue;
        float fvalue;
        double dvalue;
        int v1;
        int v2;
        int hCode = -999;

        Constant(String string) {
            this.type = 1;
            this.name = string;
        }

        Constant(int n, int n2) {
            this.type = n;
            this.v1 = n2;
            this.v2 = 0;
        }

        Constant(int n, int n2, int n3) {
            this.type = n;
            this.v1 = n2;
            this.v2 = n3;
        }

        Constant(int n) {
            this.type = 3;
            this.v1 = n;
            this.v2 = 0;
        }

        Constant(long l) {
            this.type = 5;
            this.lvalue = l;
        }

        Constant(float f) {
            this.type = 4;
            this.fvalue = f;
        }

        Constant(double d) {
            this.type = 6;
            this.dvalue = d;
        }

        public String toString() {
            switch (this.type) {
                case 1: {
                    return this.name;
                }
                case 3: {
                    return "I" + this.v1;
                }
                case 4: {
                    return "F" + this.fvalue;
                }
                case 5: {
                    return "L" + this.lvalue;
                }
                case 6: {
                    return "D" + this.dvalue;
                }
                case 7: {
                    return "class " + ConstantPool.this.getConstant(this.v1);
                }
                case 8: {
                    return "\"" + ConstantPool.this.getConstant(this.v1) + "\"";
                }
                case 9: {
                    return "Field(" + ConstantPool.this.getConstant(this.v1) + " :: " + ConstantPool.this.getConstant(this.v2) + " )";
                }
                case 10: {
                    return "Method(" + ConstantPool.this.getConstant(this.v1) + " :: " + ConstantPool.this.getConstant(this.v2) + " )";
                }
                case 11: {
                    return "InterfaceMethod(" + ConstantPool.this.getConstant(this.v1) + " :: " + ConstantPool.this.getConstant(this.v2) + " )";
                }
                case 12: {
                    return ConstantPool.this.getConstant(this.v1) + " " + ConstantPool.this.getConstant(this.v2);
                }
            }
            return "???";
        }

        public boolean equals(Object object) {
            if (!(object instanceof Constant)) {
                return false;
            }
            Constant constant = (Constant)object;
            if (constant.type != this.type) {
                return false;
            }
            switch (this.type) {
                case 1: {
                    return this.name.equals(constant.name);
                }
                case 4: {
                    return this.fvalue == constant.fvalue;
                }
                case 5: {
                    return this.lvalue == constant.lvalue;
                }
                case 6: {
                    return this.dvalue == constant.dvalue;
                }
                case 3: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    return this.v1 == constant.v1 && this.v2 == constant.v2;
                }
            }
            return false;
        }

        public int hashCode() {
            if (this.hCode == -999) {
                this.hCode = this.type * 1024;
                switch (this.type) {
                    case 1: {
                        this.hCode += this.name.hashCode();
                    }
                    case 4: {
                        this.hCode += (int)this.fvalue;
                    }
                    case 5: {
                        this.hCode += (int)this.lvalue;
                    }
                    case 6: {
                        this.hCode = (int)((double)this.hCode + this.dvalue);
                    }
                    case 3: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        return this.hCode += this.v1 + this.v2;
                    }
                }
            }
            return this.hCode;
        }
    }
}

