/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.agool.classfile;

import br.ufpe.agool.classfile.ConstantPool;
import br.ufpe.agool.classfile.Label;
import java.io.DataOutputStream;
import java.io.IOException;

public class ClassMethod {
    ConstantPool constants;
    int access;
    int type;
    int name;
    int stackSize = 10;
    int localSize = 30;
    int codeSize = 0;
    byte[] code = new byte[70000];
    int[] excessoes = new int[0];

    ClassMethod(String string, String string2, ConstantPool constantPool) {
        this.constants = constantPool;
        this.type = this.constants.getUTF8(string);
        this.name = this.constants.getUTF8(string2);
        this.constants.getUTF8("Code");
        this.access = 1;
    }

    public ConstantPool getConstantPool() {
        return this.constants;
    }

    public void setAccess(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        this.access = 0;
        if (bl) {
            this.access |= 1;
        } else if (bl2) {
            this.access |= 2;
        } else if (bl3) {
            this.access |= 4;
        }
        if (bl4) {
            this.access |= 8;
        }
        if (bl5) {
            this.access |= 8;
        }
        if (bl6) {
            this.access |= 0x20;
        }
    }

    public void setExcecoes(String[] stringArray) {
        this.excessoes = new int[stringArray.length];
        int n = 0;
        while (n < this.excessoes.length) {
            this.excessoes[n] = this.constants.getClass(stringArray[n]);
            ++n;
        }
    }

    public void setSize(int n, int n2) {
        this.localSize = n;
        this.stackSize = n2;
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.access);
        dataOutputStream.writeShort(this.name);
        dataOutputStream.writeShort(this.type);
        dataOutputStream.writeShort(1);
        dataOutputStream.writeShort(this.constants.getUTF8("Code"));
        dataOutputStream.writeInt(this.codeSize + 12);
        dataOutputStream.writeShort(this.stackSize);
        dataOutputStream.writeShort(this.localSize);
        dataOutputStream.writeInt(this.codeSize);
        int n = 0;
        while (n < this.codeSize) {
            dataOutputStream.writeByte(this.code[n]);
            ++n;
        }
        dataOutputStream.writeShort(0);
        dataOutputStream.writeShort(0);
    }

    void addByte(int n) {
        this.code[this.codeSize++] = (byte)n;
    }

    void addShort(int n) {
        this.addByte(n >> 8);
        this.addByte(n & 0xFF);
    }

    void addInt(int n) {
        this.addShort(n >> 16);
        this.addShort(n & 0xFFFF);
    }

    public void setLabel(Label label) {
        label.addr = this.codeSize;
        int n = 0;
        while (n < label.nextFree) {
            int n2 = label.unresolvedPositions[n];
            int n3 = this.codeSize - n2 + label.delta[n];
            if (label.longAddress[n]) {
                this.code[n2] = (byte)(n3 >> 24);
                this.code[n2 + 1] = (byte)(n3 >> 16 & 0xFF);
                this.code[n2 + 2] = (byte)(n3 >> 8 & 0xFF);
                this.code[n2 + 3] = (byte)(n3 & 0xFF);
            } else {
                this.code[n2] = (byte)(n3 >> 8);
                this.code[n2 + 1] = (byte)(n3 & 0xFF);
            }
            ++n;
        }
    }

    void addLabel(Label label, int n, boolean bl) {
        if (label.addr != -1) {
            if (bl) {
                this.addInt(label.addr - this.codeSize + n);
            } else {
                this.addShort(label.addr - this.codeSize + n);
            }
            return;
        }
        label.addUnresolved(this.codeSize, n, bl);
        this.codeSize += bl ? 4 : 2;
    }

    void addLabel(Label label) {
        this.addLabel(label, 1, false);
    }

    void wideOp(int n, int n2) {
        if (n2 < 255) {
            this.addByte(n);
            this.addByte(n2);
        } else {
            this.addByte(196);
            this.addByte(n);
            this.addShort(n2);
        }
    }

    public void op_aaload() {
        this.addByte(50);
    }

    public void op_aastore() {
        this.addByte(83);
    }

    public void op_aconst_null() {
        this.addByte(1);
    }

    public void op_aload_0() {
        this.addByte(42);
    }

    public void op_aload_1() {
        this.addByte(43);
    }

    public void op_aload_2() {
        this.addByte(44);
    }

    public void op_aload_3() {
        this.addByte(45);
    }

    public void op_aload(int n) {
        this.wideOp(25, n);
    }

    public void op_anewarray(int n) {
        this.addByte(189);
        this.addShort(n);
    }

    public void op_anewarray(String string) {
        this.op_anewarray(this.constants.getClass(string));
    }

    public void op_areturn() {
        this.addByte(176);
    }

    public void op_arraylength() {
        this.addByte(190);
    }

    public void op_astore_0() {
        this.addByte(75);
    }

    public void op_astore_1() {
        this.addByte(76);
    }

    public void op_astore_2() {
        this.addByte(77);
    }

    public void op_astore_3() {
        this.addByte(78);
    }

    public void op_astore(int n) {
        this.wideOp(58, n);
    }

    public void op_athrow() {
        this.addByte(191);
    }

    public void op_baload() {
        this.addByte(51);
    }

    public void op_bastore() {
        this.addByte(84);
    }

    public void op_bipush(int n) {
        this.addByte(16);
        this.addByte(n);
    }

    public void op_caload() {
        this.addByte(52);
    }

    public void op_castore() {
        this.addByte(85);
    }

    public void op_checkcast(int n) {
        this.addByte(192);
        this.addShort(n);
    }

    public void op_checkcast(String string) {
        this.op_checkcast(this.constants.getClass(string));
    }

    public void op_d2f() {
        this.addByte(144);
    }

    public void op_d2i() {
        this.addByte(142);
    }

    public void op_d2l() {
        this.addByte(143);
    }

    public void op_dadd() {
        this.addByte(99);
    }

    public void op_daload() {
        this.addByte(49);
    }

    public void op_dastore() {
        this.addByte(82);
    }

    public void op_dcmpg() {
        this.addByte(152);
    }

    public void op_dcmpl() {
        this.addByte(151);
    }

    public void op_dconst_0() {
        this.addByte(14);
    }

    public void op_dconst_1() {
        this.addByte(15);
    }

    public void op_ddiv() {
        this.addByte(111);
    }

    public void op_dload_0() {
        this.addByte(38);
    }

    public void op_dload_1() {
        this.addByte(39);
    }

    public void op_dload_2() {
        this.addByte(40);
    }

    public void op_dload_3() {
        this.addByte(41);
    }

    public void op_dload(int n) {
        this.wideOp(24, n);
    }

    public void op_dmul() {
        this.addByte(107);
    }

    public void op_dneg() {
        this.addByte(119);
    }

    public void op_drem() {
        this.addByte(115);
    }

    public void op_dreturn() {
        this.addByte(175);
    }

    public void op_dstore_0() {
        this.addByte(71);
    }

    public void op_dstore_1() {
        this.addByte(72);
    }

    public void op_dstore_2() {
        this.addByte(73);
    }

    public void op_dstore_3() {
        this.addByte(74);
    }

    public void op_dstore(int n) {
        this.wideOp(57, n);
    }

    public void op_dsub() {
        this.addByte(103);
    }

    public void op_dup2() {
        this.addByte(92);
    }

    public void op_dup2_x1() {
        this.addByte(93);
    }

    public void op_dup2_x2() {
        this.addByte(94);
    }

    public void op_dup() {
        this.addByte(89);
    }

    public void op_dup_x1() {
        this.addByte(90);
    }

    public void op_dup_x2() {
        this.addByte(91);
    }

    public void op_f2d() {
        this.addByte(141);
    }

    public void op_f2i() {
        this.addByte(139);
    }

    public void op_f2l() {
        this.addByte(140);
    }

    public void op_fadd() {
        this.addByte(98);
    }

    public void op_faload() {
        this.addByte(48);
    }

    public void op_fastore() {
        this.addByte(81);
    }

    public void op_fcmpg() {
        this.addByte(150);
    }

    public void op_fcmpl() {
        this.addByte(149);
    }

    public void op_fconst_0() {
        this.addByte(11);
    }

    public void op_fconst_1() {
        this.addByte(12);
    }

    public void op_fconst_2() {
        this.addByte(13);
    }

    public void op_fdiv() {
        this.addByte(110);
    }

    public void op_fload_0() {
        this.addByte(34);
    }

    public void op_fload_1() {
        this.addByte(35);
    }

    public void op_fload_2() {
        this.addByte(36);
    }

    public void op_fload_3() {
        this.addByte(37);
    }

    public void op_fload(int n) {
        this.wideOp(23, n);
    }

    public void op_fmul() {
        this.addByte(106);
    }

    public void op_fneg() {
        this.addByte(118);
    }

    public void op_frem() {
        this.addByte(114);
    }

    public void op_freturn() {
        this.addByte(174);
    }

    public void op_fstore_0() {
        this.addByte(67);
    }

    public void op_fstore_1() {
        this.addByte(68);
    }

    public void op_fstore_2() {
        this.addByte(69);
    }

    public void op_fstore_3() {
        this.addByte(70);
    }

    public void op_fstore(int n) {
        this.wideOp(56, n);
    }

    public void op_fsub() {
        this.addByte(102);
    }

    public void op_getfield(int n) {
        this.addByte(180);
        this.addShort(n);
    }

    public void op_getfield(String string, String string2, String string3) {
        this.op_getfield(this.constants.getField(string, string2, string3));
    }

    public void op_getstatic(int n) {
        this.addByte(178);
        this.addShort(n);
    }

    public void op_getstatic(String string, String string2, String string3) {
        this.op_getstatic(this.constants.getField(string, string2, string3));
    }

    public void op_goto(Label label) {
        this.addByte(167);
        this.addLabel(label);
    }

    public void op_i2b() {
        this.addByte(145);
    }

    public void op_i2c() {
        this.addByte(146);
    }

    public void op_i2d() {
        this.addByte(135);
    }

    public void op_i2f() {
        this.addByte(134);
    }

    public void op_i2l() {
        this.addByte(133);
    }

    public void op_i2s() {
        this.addByte(147);
    }

    public void op_iadd() {
        this.addByte(96);
    }

    public void op_iaload() {
        this.addByte(46);
    }

    public void op_iand() {
        this.addByte(126);
    }

    public void op_iastore() {
        this.addByte(79);
    }

    public void op_iconst_0() {
        this.addByte(3);
    }

    public void op_iconst_1() {
        this.addByte(4);
    }

    public void op_iconst_2() {
        this.addByte(5);
    }

    public void op_iconst_3() {
        this.addByte(6);
    }

    public void op_iconst_4() {
        this.addByte(7);
    }

    public void op_iconst_5() {
        this.addByte(8);
    }

    public void op_iconst_m1() {
        this.addByte(2);
    }

    public void op_idiv() {
        this.addByte(108);
    }

    public void op_if_acmpeq(Label label) {
        this.addByte(165);
        this.addLabel(label);
    }

    public void op_if_acmpne(Label label) {
        this.addByte(166);
        this.addLabel(label);
    }

    public void op_ifeq(Label label) {
        this.addByte(153);
        this.addLabel(label);
    }

    public void op_ifge(Label label) {
        this.addByte(156);
        this.addLabel(label);
    }

    public void op_ifgt(Label label) {
        this.addByte(157);
        this.addLabel(label);
    }

    public void op_if_icmpeq(Label label) {
        this.addByte(159);
        this.addLabel(label);
    }

    public void op_if_icmpge(Label label) {
        this.addByte(162);
        this.addLabel(label);
    }

    public void op_if_icmpgt(Label label) {
        this.addByte(163);
        this.addLabel(label);
    }

    public void op_if_icmple(Label label) {
        this.addByte(164);
        this.addLabel(label);
    }

    public void op_if_icmplt(Label label) {
        this.addByte(161);
        this.addLabel(label);
    }

    public void op_if_icmpne(Label label) {
        this.addByte(160);
        this.addLabel(label);
    }

    public void op_ifle(Label label) {
        this.addByte(158);
        this.addLabel(label);
    }

    public void op_iflt(Label label) {
        this.addByte(155);
        this.addLabel(label);
    }

    public void op_ifne(Label label) {
        this.addByte(154);
        this.addLabel(label);
    }

    public void op_ifnonnull(Label label) {
        this.addByte(199);
        this.addLabel(label);
    }

    public void op_ifnull(Label label) {
        this.addByte(198);
        this.addLabel(label);
    }

    public void op_iinc(int n, int n2) {
        if (n <= 255 && n2 <= 255) {
            this.addByte(132);
            this.addByte(n);
            this.addByte(n2);
        } else {
            this.addByte(196);
            this.addByte(132);
            this.addShort(n);
            this.addShort(n2);
        }
    }

    public void op_iload_0() {
        this.addByte(26);
    }

    public void op_iload_1() {
        this.addByte(27);
    }

    public void op_iload_2() {
        this.addByte(28);
    }

    public void op_iload_3() {
        this.addByte(29);
    }

    public void op_iload(int n) {
        this.wideOp(21, n);
    }

    public void op_imul() {
        this.addByte(104);
    }

    public void op_ineg() {
        this.addByte(116);
    }

    public void op_instanceof(int n) {
        this.addByte(193);
        this.addShort(n);
    }

    public void op_instanceof(String string) {
        this.op_instanceof(this.constants.getClass(string));
    }

    public void op_invokeinterface(int n, int n2) {
        this.addByte(185);
        this.addShort(n);
        this.addByte(n2);
        this.addByte(0);
    }

    public void op_invokeinterface(String string, String string2, String string3, int n) {
        this.addByte(185);
        this.addShort(this.constants.getInterfaceMethod(string, string2, string3));
        this.addByte(n);
        this.addByte(0);
    }

    public void op_invokespecial(int n) {
        this.addByte(183);
        this.addShort(n);
    }

    public void op_invokespecial(String string, String string2, String string3) {
        this.addByte(183);
        this.addShort(this.constants.getMethod(string, string2, string3));
    }

    public void op_invokestatic(int n) {
        this.addByte(184);
        this.addShort(n);
    }

    public void op_invokestatic(String string, String string2, String string3) {
        this.addByte(184);
        this.addShort(this.constants.getMethod(string, string2, string3));
    }

    public void op_invokevirtual(int n) {
        this.addByte(182);
        this.addShort(n);
    }

    public void op_invokevirtual(String string, String string2, String string3) {
        this.addByte(182);
        this.addShort(this.constants.getMethod(string, string2, string3));
    }

    public void op_ior() {
        this.addByte(128);
    }

    public void op_irem() {
        this.addByte(112);
    }

    public void op_ireturn() {
        this.addByte(172);
    }

    public void op_ishl() {
        this.addByte(120);
    }

    public void op_ishr() {
        this.addByte(122);
    }

    public void op_istore_0() {
        this.addByte(59);
    }

    public void op_istore_1() {
        this.addByte(60);
    }

    public void op_istore_2() {
        this.addByte(61);
    }

    public void op_istore_3() {
        this.addByte(62);
    }

    public void op_istore(int n) {
        this.wideOp(54, n);
    }

    public void op_isub() {
        this.addByte(100);
    }

    public void op_iushr() {
        this.addByte(124);
    }

    public void op_ixor() {
        this.addByte(130);
    }

    public void op_jsr(Label label) {
        this.addByte(168);
        this.addLabel(label);
    }

    public void op_l2d() {
        this.addByte(138);
    }

    public void op_l2f() {
        this.addByte(137);
    }

    public void op_l2i() {
        this.addByte(136);
    }

    public void op_ladd() {
        this.addByte(97);
    }

    public void op_laload() {
        this.addByte(47);
    }

    public void op_land() {
        this.addByte(127);
    }

    public void op_lastore() {
        this.addByte(80);
    }

    public void op_lcmp() {
        this.addByte(148);
    }

    public void op_lconst_0() {
        this.addByte(9);
    }

    public void op_lconst_1() {
        this.addByte(10);
    }

    public void op_ldc2_w(int n) {
        this.addByte(20);
        this.addShort(n);
    }

    public void op_ldc(int n) {
        if (n <= 255) {
            this.addByte(18);
            this.addByte(n);
        } else {
            this.addByte(19);
            this.addShort(n);
        }
    }

    public void op_ldiv() {
        this.addByte(109);
    }

    public void op_lload_0() {
        this.addByte(30);
    }

    public void op_lload_1() {
        this.addByte(31);
    }

    public void op_lload_2() {
        this.addByte(32);
    }

    public void op_lload_3() {
        this.addByte(33);
    }

    public void op_lload(int n) {
        this.wideOp(22, n);
    }

    public void op_lmul() {
        this.addByte(105);
    }

    public void op_lneg() {
        this.addByte(117);
    }

    public void op_lor() {
        this.addByte(129);
    }

    public void op_lrem() {
        this.addByte(113);
    }

    public void op_lreturn() {
        this.addByte(173);
    }

    public void op_lshl() {
        this.addByte(121);
    }

    public void op_lshr() {
        this.addByte(123);
    }

    public void op_lstore_0() {
        this.addByte(63);
    }

    public void op_lstore_1() {
        this.addByte(64);
    }

    public void op_lstore_2() {
        this.addByte(65);
    }

    public void op_lstore_3() {
        this.addByte(66);
    }

    public void op_lstore(int n) {
        this.wideOp(55, n);
    }

    public void op_lsub() {
        this.addByte(101);
    }

    public void op_lushr() {
        this.addByte(125);
    }

    public void op_lxor() {
        this.addByte(131);
    }

    public void op_monitorenter() {
        this.addByte(194);
    }

    public void op_monitorexit() {
        this.addByte(195);
    }

    public void op_multianewarray(int n, int n2) {
        this.addByte(197);
        this.addShort(n);
        this.addByte(n2);
    }

    public void op_multianewarray(String string, int n) {
        this.op_multianewarray(this.constants.getClass(string), n);
    }

    public void op_new(int n) {
        this.addByte(187);
        this.addShort(n);
    }

    public void op_new(String string) {
        this.op_new(this.constants.getClass(string));
    }

    public void op_newarray(int n) {
        this.addByte(188);
        this.addByte(n);
    }

    public void op_nop() {
        this.addByte(0);
    }

    public void op_pop2() {
        this.addByte(88);
    }

    public void op_pop() {
        this.addByte(87);
    }

    public void op_putfield(int n) {
        this.addByte(181);
        this.addShort(n);
    }

    public void op_putfield(String string, String string2, String string3) {
        this.op_putfield(this.constants.getField(string, string2, string3));
    }

    public void op_putstatic(int n) {
        this.addByte(179);
        this.addShort(n);
    }

    public void op_putstatic(String string, String string2, String string3) {
        this.op_putstatic(this.constants.getField(string, string2, string3));
    }

    public void op_ret(int n) {
        this.wideOp(169, n);
    }

    public void op_return() {
        this.addByte(177);
    }

    public void op_saload() {
        this.addByte(53);
    }

    public void op_sastore() {
        this.addByte(86);
    }

    public void op_sipush(int n) {
        this.addByte(17);
        this.addShort(n);
    }

    public void op_swap() {
        this.addByte(95);
    }

    public void op_tableswitch(Label label, int n, int n2, Label[] labelArray) {
        int n3 = this.codeSize;
        this.addByte(170);
        while (this.codeSize % 4 != 0) {
            this.addByte(0);
        }
        this.addLabel(label, this.codeSize - n3, true);
        this.addInt(n);
        this.addInt(n2);
        int n4 = 0;
        while (n4 < labelArray.length) {
            this.addLabel(labelArray[n4], this.codeSize - n3, true);
            ++n4;
        }
    }
}

