/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.agool.classfile;

import br.ufpe.agool.classfile.ClassField;
import br.ufpe.agool.classfile.ClassMethod;
import br.ufpe.agool.classfile.ConstantPool;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;

public class ClassBuilder {
    ConstantPool constants = new ConstantPool();
    int className;
    int superClass;
    int[] interfaces;
    Vector fields = new Vector();
    Vector methods = new Vector();
    Vector attributes = new Vector();

    public ClassBuilder(String string, String string2, String[] stringArray) {
        this.className = this.constants.getClass(string);
        this.superClass = this.constants.getClass(string2);
        this.interfaces = new int[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            this.interfaces[n] = this.constants.getClass(stringArray[n]);
            ++n;
        }
    }

    public ClassField addField(String string, String string2) {
        ClassField classField = new ClassField(this.constants.getUTF8(string), this.constants.getUTF8(string2));
        this.fields.addElement(classField);
        return classField;
    }

    public ClassField addField(String string, String string2, int n) {
        ClassField classField = new ClassField(this.constants.getUTF8(string), this.constants.getUTF8(string2));
        classField.setConstantValue(n, this.constants.getUTF8("ConstantValue"));
        this.fields.addElement(classField);
        return classField;
    }

    public ClassMethod addMethod(String string, String string2) {
        ClassMethod classMethod = new ClassMethod(string, string2, this.constants);
        this.methods.addElement(classMethod);
        return classMethod;
    }

    public ConstantPool getConstantPool() {
        return this.constants;
    }

    public void export(DataOutputStream dataOutputStream) throws IOException {
        Object object;
        dataOutputStream.writeInt(-889275714);
        dataOutputStream.writeShort(3);
        dataOutputStream.writeShort(45);
        this.constants.write(dataOutputStream);
        dataOutputStream.writeShort(33);
        dataOutputStream.writeShort(this.className);
        dataOutputStream.writeShort(this.superClass);
        dataOutputStream.writeShort(this.interfaces.length);
        int n = 0;
        while (n < this.interfaces.length) {
            dataOutputStream.writeShort(this.interfaces[n]);
            ++n;
        }
        dataOutputStream.writeShort(this.fields.size());
        n = 0;
        while (n < this.fields.size()) {
            object = (ClassField)this.fields.elementAt(n);
            ((ClassField)object).write(dataOutputStream);
            ++n;
        }
        dataOutputStream.writeShort(this.methods.size());
        n = 0;
        while (n < this.methods.size()) {
            object = (ClassMethod)this.methods.elementAt(n);
            ((ClassMethod)object).write(dataOutputStream);
            ++n;
        }
        dataOutputStream.writeShort(this.attributes.size());
        n = 0;
        while (n < this.attributes.size()) {
            ++n;
        }
    }
}

