/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.agool.OOToolKit;

import br.ufpe.agool.OOToolKit.Declaration;
import br.ufpe.agool.OOToolKit.Field;
import br.ufpe.agool.OOToolKit.GClass;
import br.ufpe.agool.OOToolKit.LanguageLibrary;
import br.ufpe.agool.OOToolKit.Method;
import br.ufpe.agool.OOToolKit.Variable;
import java.util.HashMap;
import java.util.Stack;
import java.util.Vector;

public final class SymbolTable {
    private HashMap classes = new HashMap();
    private Stack stackLocalVars = new Stack();
    private LanguageLibrary library;
    private ClassSymbol scope;

    public void setLibrary(LanguageLibrary languageLibrary) {
        this.library = languageLibrary;
    }

    public void clear() {
        this.scope = null;
        this.classes.clear();
        this.stackLocalVars.clear();
        this.library = null;
    }

    public boolean putSymbol(GClass gClass) {
        ClassSymbol classSymbol = new ClassSymbol(gClass);
        String string = gClass.getName();
        boolean bl = this.classes.containsKey(string);
        if (!bl) {
            this.classes.put(string, classSymbol);
        }
        return bl;
    }

    public void setClassScope(String string) {
        this.scope = (ClassSymbol)this.classes.get(string);
    }

    public boolean putSymbol(Method method) {
        boolean bl = this.scope.hasMethod(method);
        this.scope.putMethod(method);
        return bl;
    }

    public boolean putSymbol(Field field) {
        boolean bl = this.scope.hasField(field);
        this.scope.putField(field);
        return bl;
    }

    public Vector getGClass(String string) {
        Vector vector;
        ClassSymbol classSymbol = (ClassSymbol)this.classes.get(string);
        if (classSymbol == null) {
            vector = this.library != null ? this.library.getGClass(string) : new Vector();
        } else {
            vector = new Vector();
            vector.add(classSymbol.classe);
        }
        return vector;
    }

    public void startLocalScope() {
        this.stackLocalVars.push(new HashMap());
    }

    public void endLocalScope() {
        this.stackLocalVars.pop();
    }

    public boolean addLocalVar(Variable variable) {
        String string = variable.getName();
        HashMap hashMap = (HashMap)this.stackLocalVars.get(this.stackLocalVars.size() - 1);
        boolean bl = hashMap.containsKey(string);
        if (!bl) {
            hashMap.put(string, variable);
        }
        return bl;
    }

    public Declaration getVariable(String string) {
        Declaration declaration = null;
        int n = this.stackLocalVars.size() - 1;
        while (n >= 0 && declaration == null) {
            HashMap hashMap = (HashMap)this.stackLocalVars.get(n);
            declaration = (Variable)hashMap.get(string);
            --n;
        }
        if (declaration == null) {
            declaration = this.getField(string);
        }
        return declaration;
    }

    private ClassSymbol getClassSymbol(String string) {
        Vector vector;
        ClassSymbol classSymbol = (ClassSymbol)this.classes.get(string);
        if (classSymbol == null && this.library != null && (vector = this.library.getGClass(string)).size() > 0) {
            GClass gClass = (GClass)vector.get(0);
            classSymbol = new ClassSymbol(gClass, true);
            this.classes.put(string, classSymbol);
        }
        return classSymbol;
    }

    public Field getField(String string) {
        ClassSymbol classSymbol = this.scope;
        Field field = this.scope.getField(string);
        classSymbol = this.getClassSymbol(classSymbol.classe.getSuperClassName());
        while (field == null && classSymbol != null) {
            field = classSymbol.getField(string);
            if (field != null) continue;
            classSymbol = this.getClassSymbol(classSymbol.classe.getSuperClassName());
        }
        return field;
    }

    public Field getField(String string, String string2) {
        ClassSymbol classSymbol = this.getClassSymbol(string);
        Field field = null;
        while (field == null && classSymbol != null) {
            field = classSymbol.getField(string2);
            if (field != null) continue;
            classSymbol = this.getClassSymbol(classSymbol.classe.getSuperClassName());
        }
        return field;
    }

    public Vector getMethod(String string) {
        return this.getMethod(this.scope.classe.getName(), string);
    }

    public Vector getMethod(String string, String string2) {
        ClassSymbol classSymbol = this.getClassSymbol(string);
        Vector<Method> vector = new Vector<Method>();
        boolean bl = true;
        while (classSymbol != null) {
            Vector vector2 = classSymbol.getMethod(string2);
            if (vector2 != null) {
                int n = 0;
                while (n < vector2.size()) {
                    Method method = (Method)vector2.get(n);
                    if (!SymbolTable.vectorHasMethod(vector, method)) {
                        if (method.isConstructor()) {
                            if (bl) {
                                vector.add(method);
                            }
                        } else {
                            vector.add(method);
                        }
                    }
                    ++n;
                }
            }
            classSymbol = this.getClassSymbol(classSymbol.classe.getSuperClassName());
            bl = false;
        }
        return vector.size() == 0 ? null : vector;
    }

    private static boolean vectorHasMethod(Vector vector, Method method) {
        boolean bl = false;
        int n = 0;
        while (n < vector.size() && !bl) {
            Method method2 = (Method)vector.get(n);
            bl = method2.argumentsTypesMatch(method);
            ++n;
        }
        return bl;
    }

    class ClassSymbol {
        private HashMap fields = new HashMap();
        private HashMap methods = new HashMap();
        private GClass classe;

        ClassSymbol(GClass gClass) {
            this(gClass, false);
        }

        ClassSymbol(GClass gClass, boolean bl) {
            this.classe = gClass;
            if (bl) {
                Field[] fieldArray = gClass.getFields();
                Method[] methodArray = gClass.getMethods();
                int n = 0;
                while (n < fieldArray.length) {
                    this.putField(fieldArray[n]);
                    ++n;
                }
                int n2 = 0;
                while (n2 < methodArray.length) {
                    this.putMethod(methodArray[n2]);
                    ++n2;
                }
            }
        }

        void putField(Field field) {
            this.fields.put(field.getName(), field);
        }

        Field getField(String string) {
            return (Field)this.fields.get(string);
        }

        boolean hasField(Field field) {
            return this.fields.containsKey(field.getName());
        }

        boolean hasMethod(Method method) {
            Vector vector = (Vector)this.methods.get(method.getName());
            boolean bl = false;
            if (vector == null) {
                return false;
            }
            return SymbolTable.vectorHasMethod(vector, method);
        }

        void putMethod(Method method) {
            Vector<Method> vector = (Vector<Method>)this.methods.get(method.getName());
            if (vector == null) {
                vector = new Vector<Method>();
                vector.add(method);
                this.methods.put(method.getName(), vector);
            } else {
                vector.add(method);
            }
        }

        Vector getMethod(String string) {
            return (Vector)this.methods.get(string);
        }
    }
}

