/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.agool.OOToolKit;

import br.ufpe.agool.OOToolKit.CurrentObject;
import br.ufpe.agool.OOToolKit.Expression;
import br.ufpe.agool.OOToolKit.Method;
import br.ufpe.agool.OOToolKit.Statement;
import br.ufpe.agool.OOToolKit.SuperClassObject;
import br.ufpe.agool.OOToolKit.Type;
import br.ufpe.agool.OOToolKit.Visitor;

public class MethodCall
implements Statement,
Expression {
    private Expression expression;
    private Expression[] arguments;
    private String methodName;
    private Method method;
    private boolean isExpression;
    private boolean isConstr;

    public MethodCall(boolean bl, Expression[] expressionArray) {
        this.expression = bl ? new SuperClassObject() : new CurrentObject();
        this.methodName = Method.CONSTRUCTOR_NAME;
        this.isConstr = true;
        this.arguments = expressionArray == null ? new Expression[0] : expressionArray;
    }

    public MethodCall(Expression expression, Method method, Expression[] expressionArray) {
        this.expression = expression;
        this.methodName = method.getName();
        this.method = method;
        this.isConstr = method.isConstructor();
        this.arguments = expressionArray == null ? new Expression[0] : expressionArray;
    }

    public MethodCall(Expression expression, String string, Expression[] expressionArray) {
        this.expression = expression;
        this.methodName = string;
        this.isConstr = false;
        this.arguments = expressionArray == null ? new Expression[0] : expressionArray;
    }

    public MethodCall(String string, Expression[] expressionArray) {
        this.expression = null;
        this.methodName = string;
        this.isConstr = false;
        this.arguments = expressionArray == null ? new Expression[0] : expressionArray;
    }

    public Object visit(Visitor visitor, Object object) {
        return visitor.visitMethodCall(this, object);
    }

    public boolean isConstructor() {
        return this.isConstr;
    }

    public void setIsExpression(boolean bl) {
        this.isExpression = bl;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public boolean isExpression() {
        return this.isExpression;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Method getMethod() {
        return this.method;
    }

    public Expression[] getArguments() {
        return this.arguments;
    }

    public void setArguments(Expression[] expressionArray) {
        this.arguments = expressionArray;
    }

    public Expression getExpressionLeft() {
        return this.expression;
    }

    public void setExpresionLeft(Expression expression) {
        this.expression = expression;
    }

    public Type getType() {
        return this.method.getType();
    }
}

