/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.agool.OOToolKit;

import br.ufpe.agool.OOToolKit.Block;
import br.ufpe.agool.OOToolKit.ClassElement;
import br.ufpe.agool.OOToolKit.PrimitiveType;
import br.ufpe.agool.OOToolKit.Type;
import br.ufpe.agool.OOToolKit.Variable;
import br.ufpe.agool.OOToolKit.Visitor;

public class Method
extends ClassElement {
    private Variable[] formals;
    private Block body;
    private boolean constructor;
    public static String CONSTRUCTOR_NAME = "#constructor#";

    public Method(int[] nArray, Variable[] variableArray, Block block) {
        super(CONSTRUCTOR_NAME, nArray, PrimitiveType.VOID);
        this.body = block;
        this.formals = variableArray;
        this.constructor = true;
    }

    public Method(String string, int[] nArray, Variable[] variableArray, Type type, Block block) {
        super(string, nArray, type);
        this.body = block;
        this.formals = variableArray;
        this.constructor = false;
    }

    public Method(String string, int[] nArray, Variable[] variableArray, Block block) {
        super(string, nArray, PrimitiveType.VOID);
        this.body = block;
        this.formals = variableArray;
        this.constructor = false;
    }

    public Method(String string, int[] nArray, Variable[] variableArray, Type type) {
        super(string, nArray, type);
        this.body = new Block();
        this.formals = variableArray;
        this.constructor = false;
    }

    public Object visit(Visitor visitor, Object object) {
        return visitor.visitMethod(this, object);
    }

    public boolean isConstructor() {
        return this.constructor;
    }

    public int getNumParameters() {
        return this.formals.length;
    }

    public Variable[] getFormals() {
        return this.formals;
    }

    public Block getBody() {
        return this.body;
    }

    public Type getReturnType() {
        return this.type;
    }

    public Type getFormalType(int n) {
        return this.formals[n].getType();
    }

    public Type[] getFormalsTypes() {
        Type[] typeArray = new Type[this.formals.length];
        int n = 0;
        while (n < this.formals.length) {
            typeArray[n] = this.formals[n].getType();
            ++n;
        }
        return typeArray;
    }

    public boolean argumentsTypesMatch(Method method) {
        boolean bl;
        if (method.formals.length != this.formals.length) {
            bl = false;
        } else {
            bl = true;
            int n = 0;
            while (n < this.formals.length) {
                bl &= this.formals[n].getType().equals(method.formals[n].getType());
                ++n;
            }
        }
        return bl;
    }
}

