/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.agool.OOToolKit;

import br.ufpe.agool.OOToolKit.GClass;
import br.ufpe.agool.OOToolKit.ObjectType;
import br.ufpe.agool.OOToolKit.PrimitiveType;
import br.ufpe.agool.OOToolKit.Type;
import br.ufpe.agool.OOToolKit.Visitor;

public class ArrayType
extends ObjectType {
    private String name;
    private Type baseType;
    private int dimensions;

    public ArrayType(Type type, int n) {
        super("");
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            this.baseType = arrayType.getBaseType();
            this.dimensions = n + arrayType.getNumDimensions();
        } else {
            this.baseType = type;
            this.dimensions = n;
        }
        this.name = this.baseType.getName();
        int n2 = 0;
        while (n2 < this.dimensions) {
            this.name = this.name + ']';
            ++n2;
        }
        this.setGClass(new GClass(this.name));
    }

    public Type getBaseType() {
        return this.baseType;
    }

    public Type getResultingType(int n) {
        Type type = n == this.dimensions ? this.baseType : (n < this.dimensions ? new ArrayType(this.baseType, this.dimensions - n) : PrimitiveType.ERROR);
        return type;
    }

    public int getNumDimensions() {
        return this.dimensions;
    }

    public void setNumDimensions(int n) {
        this.dimensions = n;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object == this) {
            return true;
        }
        if (object instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)object;
            bl = arrayType.dimensions == this.dimensions && arrayType.baseType.equals(this.baseType);
        }
        return bl;
    }

    public Object visit(Visitor visitor, Object object) {
        return visitor.visitArrayType(this, object);
    }
}

