/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.agool.OOToolKit;

import br.ufpe.agool.OOToolKit.AgoolCheckerError;
import br.ufpe.agool.OOToolKit.AgoolProgram;
import br.ufpe.agool.OOToolKit.ArrayAccess;
import br.ufpe.agool.OOToolKit.ArrayLength;
import br.ufpe.agool.OOToolKit.ArrayType;
import br.ufpe.agool.OOToolKit.Assignment;
import br.ufpe.agool.OOToolKit.BinaryExpression;
import br.ufpe.agool.OOToolKit.Block;
import br.ufpe.agool.OOToolKit.Cast;
import br.ufpe.agool.OOToolKit.ClassExpression;
import br.ufpe.agool.OOToolKit.Constant;
import br.ufpe.agool.OOToolKit.Conversion;
import br.ufpe.agool.OOToolKit.CurrentObject;
import br.ufpe.agool.OOToolKit.Expression;
import br.ufpe.agool.OOToolKit.Field;
import br.ufpe.agool.OOToolKit.FieldAccess;
import br.ufpe.agool.OOToolKit.GClass;
import br.ufpe.agool.OOToolKit.If;
import br.ufpe.agool.OOToolKit.InstanceOf;
import br.ufpe.agool.OOToolKit.LanguageLibrary;
import br.ufpe.agool.OOToolKit.Method;
import br.ufpe.agool.OOToolKit.MethodCall;
import br.ufpe.agool.OOToolKit.NewArray;
import br.ufpe.agool.OOToolKit.NewObject;
import br.ufpe.agool.OOToolKit.NullObject;
import br.ufpe.agool.OOToolKit.NullType;
import br.ufpe.agool.OOToolKit.ObjectType;
import br.ufpe.agool.OOToolKit.PrimitiveType;
import br.ufpe.agool.OOToolKit.Print;
import br.ufpe.agool.OOToolKit.Return;
import br.ufpe.agool.OOToolKit.SideEffectExpression;
import br.ufpe.agool.OOToolKit.Statement;
import br.ufpe.agool.OOToolKit.SuperClassObject;
import br.ufpe.agool.OOToolKit.SymbolTable;
import br.ufpe.agool.OOToolKit.Type;
import br.ufpe.agool.OOToolKit.UnaryExpression;
import br.ufpe.agool.OOToolKit.Variable;
import br.ufpe.agool.OOToolKit.Visitor;
import br.ufpe.agool.OOToolKit.While;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

public final class AgoolChecker {
    private SymbolTable table;
    private CheckerStep1 checker1 = new CheckerStep1();
    private CheckerStep2 checker2 = new CheckerStep2();
    protected boolean foundError;
    protected Vector errors;
    private boolean debug = false;
    private static Object STATEMENT_FLAG = new Object();
    private static String NOT_IMPLEMENTED_MSG = "ERRO: noh invalido visitado na Analise Contextual!";
    private AgoolProgram program;

    public AgoolChecker() {
        this.table = new SymbolTable();
        this.errors = new Vector();
    }

    public final boolean checkProgram(AgoolProgram agoolProgram) {
        this.foundError = false;
        this.errors.clear();
        this.table.clear();
        this.program = agoolProgram;
        try {
            this.insertSymbols(agoolProgram);
            if (!this.foundError) {
                this.checker1.visit(agoolProgram, null);
            }
            if (!this.foundError) {
                this.checker2.visit(agoolProgram, null);
            }
        }
        catch (Exception exception) {
            this.errors.add(new AgoolCheckerError(exception));
            this.foundError = true;
        }
        catch (AgoolCheckerError agoolCheckerError) {
            this.errors.add(agoolCheckerError);
            this.foundError = true;
        }
        return !this.foundError;
    }

    public final boolean checkProgram(AgoolProgram agoolProgram, LanguageLibrary languageLibrary) {
        this.foundError = false;
        this.errors.clear();
        this.table.clear();
        this.program = agoolProgram;
        try {
            languageLibrary.addClassDefinitions(agoolProgram);
            this.table.setLibrary(languageLibrary);
            this.insertSymbols(agoolProgram);
            if (!this.foundError) {
                this.checker1.visit(agoolProgram, null);
            }
            if (!this.foundError) {
                this.checker2.visit(agoolProgram, null);
            }
        }
        catch (Exception exception) {
            this.errors.add(new AgoolCheckerError(exception));
            this.foundError = true;
        }
        catch (AgoolCheckerError agoolCheckerError) {
            this.errors.add(agoolCheckerError);
            this.foundError = true;
        }
        return !this.foundError;
    }

    public final boolean foundErrors() {
        return this.foundError;
    }

    public final AgoolCheckerError[] getErrors() {
        AgoolCheckerError[] agoolCheckerErrorArray = new AgoolCheckerError[this.errors.size()];
        this.errors.toArray(agoolCheckerErrorArray);
        return agoolCheckerErrorArray;
    }

    private void insertSymbols(AgoolProgram agoolProgram) {
        GClass[] gClassArray = agoolProgram.getClasses();
        int n = 0;
        while (n < gClassArray.length) {
            if (!this.table.putSymbol(gClassArray[n])) {
                this.table.setClassScope(gClassArray[n].getName());
                this.insertSymbols(gClassArray[n]);
            } else {
                this.errors.add(new AgoolCheckerError("ERRO (Fase 0) - Simbolo repetido: " + gClassArray[n].getName()));
                this.foundError = true;
            }
            ++n;
        }
    }

    private void insertSymbols(GClass gClass) {
        Method[] methodArray = gClass.getMethods();
        Field[] fieldArray = gClass.getFields();
        int n = 0;
        while (n < methodArray.length) {
            if (this.table.putSymbol(methodArray[n])) {
                this.errors.add(new AgoolCheckerError("ERRO (Fase 0) - Simbolo repetido: " + methodArray[n].getName()));
                this.foundError = true;
            }
            ++n;
        }
        n = 0;
        while (n < fieldArray.length) {
            if (this.table.putSymbol(fieldArray[n])) {
                this.errors.add(new AgoolCheckerError("ERRO (Fase 0) - Simbolo repetido: " + fieldArray[n].getName()));
                this.foundError = true;
            }
            ++n;
        }
    }

    private boolean isNumericalType(Type type) {
        return type instanceof PrimitiveType && type != PrimitiveType.BOOLEAN;
    }

    public static boolean canBeConverted(Type type, Type type2) {
        PrimitiveType[] primitiveTypeArray = PrimitiveType.convChain;
        boolean bl = false;
        if (type == type2 || type.equals(type2)) {
            return true;
        }
        if (type2 instanceof ObjectType) {
            if (type instanceof NullType) {
                bl = true;
            } else if (type instanceof ObjectType) {
                GClass gClass = ((ObjectType)type2).getGClass();
                GClass gClass2 = ((ObjectType)type).getGClass();
                while (gClass2 != null && !bl) {
                    bl = gClass2.equals(gClass);
                    gClass2 = gClass2.getSuperClass();
                }
            }
        } else if (!(type instanceof ObjectType)) {
            int n = primitiveTypeArray.length;
            int n2 = -1;
            int n3 = 0;
            while (n3 < primitiveTypeArray.length) {
                if (primitiveTypeArray[n3] == type) {
                    n = n3;
                }
                if (primitiveTypeArray[n3] == type2) {
                    n2 = n3;
                }
                ++n3;
            }
            bl = n <= n2;
        }
        return bl;
    }

    private Expression convert(Expression expression, PrimitiveType primitiveType) {
        PrimitiveType primitiveType2 = (PrimitiveType)expression.getType();
        Expression expression2 = primitiveType2.equals(primitiveType) ? expression : new Conversion(expression, primitiveType);
        return expression2;
    }

    final class CheckerStep2
    implements Visitor {
        Object CLASS_EXP_FLAG = new Object();
        GClass currentClass;
        Method currentMethod;
        boolean callConstructor;
        int numStatements;

        CheckerStep2() {
        }

        public Object visit(AgoolProgram agoolProgram, Object object) {
            GClass[] gClassArray = agoolProgram.getClasses();
            int n = gClassArray.length;
            if (AgoolChecker.this.debug) {
                System.out.println(">> AgoolChecker Step 2");
            }
            int n2 = 0;
            while (n2 < n) {
                gClassArray[n2].visit(this, null);
                ++n2;
            }
            return null;
        }

        public Object visitGClass(GClass gClass, Object object) {
            Field[] fieldArray = gClass.getFields();
            Method[] methodArray = gClass.getMethods();
            this.currentClass = gClass;
            if (AgoolChecker.this.debug) {
                System.out.println("====== Classe " + gClass.getName());
            }
            int n = 0;
            while (n < fieldArray.length) {
                fieldArray[n].visit(this, null);
                ++n;
            }
            n = 0;
            while (n < methodArray.length) {
                methodArray[n].visit(this, null);
                ++n;
            }
            return null;
        }

        public Object visitArrayAccess(ArrayAccess arrayAccess, Object object) {
            Expression expression = arrayAccess.getArray();
            Expression[] expressionArray = arrayAccess.getIndices();
            expression.visit(this, null);
            if (!(expression.getType() instanceof ArrayType)) {
                throw new AgoolCheckerError("ERRO (2) - Expressao nao eh uma array");
            }
            ArrayType arrayType = (ArrayType)arrayAccess.getArray().getType();
            if (arrayType.getNumDimensions() < expressionArray.length) {
                throw new AgoolCheckerError("ERRO (2) - Muitos indices: o array tem dimensao " + arrayType.getNumDimensions());
            }
            arrayAccess.setType(arrayType.getResultingType(expressionArray.length));
            int n = 0;
            while (n < expressionArray.length) {
                expressionArray[n].visit(this, null);
                if (expressionArray[n].getType() != PrimitiveType.INTEGER) {
                    throw new AgoolCheckerError("ERRO (2) - Expressao usada como indice do array nao eh do tipo INTEGER");
                }
                ++n;
            }
            return null;
        }

        public Object visitArrayLength(ArrayLength arrayLength, Object object) {
            Expression expression = arrayLength.getArray();
            expression.visit(this, null);
            if (!(expression.getType() instanceof ArrayType)) {
                throw new AgoolCheckerError("ERRO (2) - Expressao nao eh um array");
            }
            return null;
        }

        public Object visitArrayType(ArrayType arrayType, Object object) {
            throw new RuntimeException(NOT_IMPLEMENTED_MSG);
        }

        public Object visitAssignment(Assignment assignment, Object object) {
            Expression expression = assignment.getLeftExpression();
            Expression expression2 = assignment.getRightExpression();
            if (!(expression instanceof FieldAccess || expression instanceof Variable || expression instanceof ArrayAccess)) {
                throw new AgoolCheckerError("ERRO (2) - Atribuicao invalida");
            }
            expression.visit(this, null);
            Type type = expression.getType();
            expression2.visit(this, null);
            Type type2 = expression2.getType();
            if (AgoolChecker.canBeConverted(type2, type)) {
                if (type2 instanceof PrimitiveType) {
                    expression2 = AgoolChecker.this.convert(expression2, (PrimitiveType)type);
                    assignment.setRightExpression(expression2);
                }
            } else {
                throw new AgoolCheckerError("ERRO (2) - Atribuicao invalida");
            }
            return null;
        }

        public Object visitBinaryExpression(BinaryExpression binaryExpression, Object object) {
            Expression expression = binaryExpression.getOperand1();
            Expression expression2 = binaryExpression.getOperand2();
            int n = binaryExpression.getOperator();
            expression.visit(this, null);
            expression2.visit(this, null);
            Type type = expression.getType();
            Type type2 = expression2.getType();
            switch (n) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    if (AgoolChecker.this.isNumericalType(type) && AgoolChecker.this.isNumericalType(type2)) {
                        if (AgoolChecker.canBeConverted(type, type2)) {
                            binaryExpression.setType(type2);
                            binaryExpression.setOperand1(AgoolChecker.this.convert(expression, (PrimitiveType)type2));
                            break;
                        }
                        if (!AgoolChecker.canBeConverted(type2, type)) break;
                        binaryExpression.setType(type);
                        binaryExpression.setOperand2(AgoolChecker.this.convert(expression2, (PrimitiveType)type));
                        break;
                    }
                    throw new AgoolCheckerError("ERRO (2) - Operador aritmetico usado para tipos nao numericos");
                }
                case 14: 
                case 15: {
                    if (type == PrimitiveType.BOOLEAN && type2 == PrimitiveType.BOOLEAN) {
                        binaryExpression.setType(type);
                        break;
                    }
                    if (type == PrimitiveType.INTEGER && AgoolChecker.canBeConverted(type2, type)) {
                        binaryExpression.setType(PrimitiveType.INTEGER);
                        break;
                    }
                    if (type2 == PrimitiveType.INTEGER && AgoolChecker.canBeConverted(type, type2)) {
                        binaryExpression.setType(PrimitiveType.INTEGER);
                        break;
                    }
                    throw new AgoolCheckerError("ERRO (2) - Tipos dos operandos incompativeis com o operador");
                }
                case 16: {
                    if (type == PrimitiveType.INTEGER && AgoolChecker.canBeConverted(type2, type)) {
                        binaryExpression.setType(PrimitiveType.INTEGER);
                        break;
                    }
                    if (type2 == PrimitiveType.INTEGER && AgoolChecker.canBeConverted(type, type2)) {
                        binaryExpression.setType(PrimitiveType.INTEGER);
                        break;
                    }
                    throw new AgoolCheckerError("ERRO (2) - Tipos dos operandos incompativeis com o operador");
                }
                case 9: 
                case 10: {
                    if (AgoolChecker.canBeConverted(type, type2)) {
                        binaryExpression.setType(PrimitiveType.BOOLEAN);
                        if (!(type2 instanceof PrimitiveType)) break;
                        binaryExpression.setOperand1(AgoolChecker.this.convert(expression, (PrimitiveType)type2));
                        break;
                    }
                    if (AgoolChecker.canBeConverted(type2, type)) {
                        binaryExpression.setType(PrimitiveType.BOOLEAN);
                        if (!(type instanceof PrimitiveType)) break;
                        binaryExpression.setOperand2(AgoolChecker.this.convert(expression2, (PrimitiveType)type));
                        break;
                    }
                    throw new AgoolCheckerError("ERRO (2) - Comparacao invalida");
                }
                case 7: 
                case 8: 
                case 11: 
                case 12: {
                    if (AgoolChecker.this.isNumericalType(type) && AgoolChecker.this.isNumericalType(type2)) {
                        if (AgoolChecker.canBeConverted(type, type2)) {
                            binaryExpression.setType(PrimitiveType.BOOLEAN);
                            binaryExpression.setOperand1(AgoolChecker.this.convert(expression, (PrimitiveType)type2));
                            break;
                        }
                        if (!AgoolChecker.canBeConverted(type2, type)) break;
                        binaryExpression.setType(PrimitiveType.BOOLEAN);
                        binaryExpression.setOperand2(AgoolChecker.this.convert(expression2, (PrimitiveType)type));
                        break;
                    }
                    throw new AgoolCheckerError("ERRO (2) - Comparacao invalida");
                }
                default: {
                    throw new AgoolCheckerError("ERRO (2) - Operador binario desconhecido");
                }
            }
            return null;
        }

        public Object visitBlock(Block block, Object object) {
            Statement[] statementArray = block.getStatements();
            int n = 0;
            while (n < statementArray.length) {
                ++this.numStatements;
                try {
                    if (statementArray[n] != null) {
                        statementArray[n].visit(this, STATEMENT_FLAG);
                    }
                }
                catch (Exception exception) {
                    AgoolChecker.this.errors.add(new AgoolCheckerError(exception));
                    exception.printStackTrace();
                    AgoolChecker.this.foundError = true;
                }
                catch (AgoolCheckerError agoolCheckerError) {
                    AgoolChecker.this.errors.add(agoolCheckerError);
                    agoolCheckerError.printStackTrace();
                    AgoolChecker.this.foundError = true;
                }
                ++n;
            }
            return null;
        }

        public Object visitCast(Cast cast, Object object) {
            Expression expression = cast.getExpression();
            expression.visit(this, null);
            if (!(expression.getType() instanceof ObjectType)) {
                throw new AgoolCheckerError("ERRO (2) - A expressao no cast nao possui tipo complexo");
            }
            return null;
        }

        public Object visitClassExpression(ClassExpression classExpression, Object object) {
            if (object != this.CLASS_EXP_FLAG) {
                throw new AgoolCheckerError("ERRO (2) - Expressao invalida: " + classExpression.getName());
            }
            return null;
        }

        public Object visitConstant(Constant constant, Object object) {
            return null;
        }

        public Object visitConversion(Conversion conversion, Object object) {
            Expression expression = conversion.getExpression();
            expression.visit(this, null);
            Type type = expression.getType();
            PrimitiveType primitiveType = conversion.getFinalType();
            if (!(type instanceof PrimitiveType)) {
                throw new AgoolCheckerError("ERRO(2) - Expressao nao pode ser convertido para tipo primitivo");
            }
            if (!AgoolChecker.canBeConverted(type, primitiveType) && !AgoolChecker.canBeConverted(primitiveType, type)) {
                throw new AgoolCheckerError("ERRO (2) - Conversao invalida");
            }
            return null;
        }

        public Object visitCurrentObject(CurrentObject currentObject, Object object) {
            if (this.currentMethod.hasModifier(4)) {
                throw new AgoolCheckerError("ERRO (2) - Nao pode referenciar objeto atual em contexto estatico");
            }
            return null;
        }

        public Object visitField(Field field, Object object) {
            Expression expression = field.getInitialValue();
            if (expression != null) {
                if (!(expression instanceof Constant || expression instanceof NewArray || expression instanceof NewObject || expression instanceof MethodCall && ((MethodCall)expression).getMethod().hasModifier(4))) {
                    AgoolChecker.this.errors.add(new AgoolCheckerError("ERRO (2) - Apenas valores constantes sao aceitos na na inicializacao do atributo"));
                    AgoolChecker.this.foundError = true;
                }
                expression.visit(this, null);
                if (AgoolChecker.canBeConverted(expression.getType(), field.getType())) {
                    if (field.getType() instanceof PrimitiveType) {
                        expression = AgoolChecker.this.convert(expression, (PrimitiveType)field.getType());
                        field.setInitialValue(expression);
                    }
                } else {
                    AgoolChecker.this.errors.add(new AgoolCheckerError("ERRO (2) - Expressao invalida na inicializacao do atributo"));
                    AgoolChecker.this.foundError = true;
                }
            }
            return null;
        }

        public Object visitFieldAccess(FieldAccess fieldAccess, Object object) {
            Expression expression = fieldAccess.getExpressionLeft();
            Field field = fieldAccess.getField();
            expression.visit(this, this.CLASS_EXP_FLAG);
            if (!(expression.getType() instanceof ObjectType)) {
                throw new AgoolCheckerError("ERRO (2) - Expressao de tipo nao-complexo (nao possui atributo)");
            }
            if (expression instanceof ClassExpression && !field.hasModifier(4)) {
                throw new AgoolCheckerError("ERRO (2) - Expressao invalida: atributo nao estatico");
            }
            if (!(expression instanceof ClassExpression) && field.hasModifier(4)) {
                throw new AgoolCheckerError("ERRO (2) - Objeto invalido no acesso ao atributo estatico");
            }
            return null;
        }

        public Object visitIf(If if_, Object object) {
            Expression expression = if_.getExpression();
            Block block = if_.getTrueBlock();
            Block block2 = if_.getFalseBlock();
            try {
                expression.visit(this, null);
                if (expression.getType() != PrimitiveType.BOOLEAN) {
                    AgoolChecker.this.errors.add(new AgoolCheckerError("ERRO (2) - Expressao nao booleana no teste do \"if\""));
                    AgoolChecker.this.foundError = true;
                }
            }
            catch (AgoolCheckerError agoolCheckerError) {
                AgoolChecker.this.errors.add(agoolCheckerError);
                AgoolChecker.this.foundError = true;
            }
            block.visit(this, null);
            if (block2 != null) {
                block2.visit(this, null);
            }
            return null;
        }

        public Object visitInstanceOf(InstanceOf instanceOf, Object object) {
            Expression expression = instanceOf.getExpression();
            expression.visit(this, null);
            if (!(expression.getType() instanceof ObjectType)) {
                throw new AgoolCheckerError("ERRO (2) - Expressao nao possui tipo complexo no instanceof");
            }
            if (!(instanceOf.getDestinationType() instanceof ObjectType)) {
                throw new AgoolCheckerError("ERRO (2) - Tipo testado no instanceof eh invalido");
            }
            return null;
        }

        public Object visitMethod(Method method, Object object) {
            boolean bl;
            Block block = method.getBody();
            this.currentMethod = method;
            this.numStatements = 0;
            this.callConstructor = false;
            if (AgoolChecker.this.debug) {
                System.out.println(" -- Metodo: " + method.getName());
            }
            block.visit(this, null);
            if (method.isConstructor() && !this.callConstructor) {
                Vector vector = AgoolChecker.this.table.getMethod(this.currentClass.getSuperClassName(), Method.CONSTRUCTOR_NAME);
                Method method2 = null;
                Iterator iterator = ((AbstractList)vector).iterator();
                while (iterator.hasNext() && method2 == null) {
                    Method method3 = (Method)iterator.next();
                    if (method3.getNumParameters() != 0 || !method3.isConstructor()) continue;
                    method2 = method3;
                }
                if (method2 == null) {
                    AgoolChecker.this.errors.add(new AgoolCheckerError("ERRO (2) - Construtor default nao encontrado para classe " + this.currentClass.getSuperClassName()));
                    AgoolChecker.this.foundError = true;
                } else {
                    MethodCall methodCall = new MethodCall((Expression)new SuperClassObject(this.currentClass.getSuperClass()), method2, new Expression[0]);
                    methodCall.setIsExpression(false);
                    block.addAtBeginning(methodCall);
                }
            }
            if (!(bl = this.analyseLastStatements(block))) {
                if (this.currentMethod.getReturnType() == PrimitiveType.VOID) {
                    block.add(new Return());
                } else {
                    AgoolChecker.this.errors.add(new AgoolCheckerError("ERRO (2) - Nem todos os caminhos de controle retornam valor"));
                    AgoolChecker.this.foundError = true;
                }
            }
            return null;
        }

        private boolean analyseLastStatements(Block block) {
            Statement statement;
            Statement[] statementArray = block.getStatements();
            Statement statement2 = statement = statementArray.length == 0 ? null : statementArray[statementArray.length - 1];
            if (statement instanceof Block) {
                return this.analyseLastStatements((Block)statement);
            }
            if (statement instanceof If) {
                return this.analyseLastStatements((If)statement);
            }
            return statement instanceof Return;
        }

        private boolean analyseLastStatements(If if_) {
            Block block = if_.getTrueBlock();
            boolean bl = this.analyseLastStatements(block);
            block = if_.getFalseBlock();
            bl = block != null ? bl && this.analyseLastStatements(block) : false;
            return bl;
        }

        public Object visitMethodCall(MethodCall methodCall, Object object) {
            Expression[] expressionArray = methodCall.getArguments();
            Type[] typeArray = methodCall.getMethod().getFormalsTypes();
            Expression expression = methodCall.getExpressionLeft();
            Method method = methodCall.getMethod();
            expression.visit(this, this.CLASS_EXP_FLAG);
            if (expression instanceof ClassExpression && !method.hasModifier(4)) {
                throw new AgoolCheckerError("ERRO (2) - Expressao invalida: metodo nao estatico");
            }
            if (!(expression instanceof ClassExpression) && method.hasModifier(4)) {
                throw new AgoolCheckerError("ERRO (2) - Objeto invalido na chamada ao metodo estatico");
            }
            if (methodCall.isConstructor()) {
                if (!this.currentMethod.isConstructor()) {
                    throw new AgoolCheckerError("ERRO (2) - Chamadas a construtores so podem ser feitas em outro construtor");
                }
                if (this.numStatements > 1) {
                    throw new AgoolCheckerError("ERRO (2) - Chamadas a construtores devem ser feitas no primeiro comando");
                }
                this.callConstructor = true;
            }
            int n = 0;
            while (n < expressionArray.length) {
                expressionArray[n].visit(this, null);
                if (typeArray[n] instanceof PrimitiveType) {
                    expressionArray[n] = AgoolChecker.this.convert(expressionArray[n], (PrimitiveType)typeArray[n]);
                }
                ++n;
            }
            return null;
        }

        public Object visitNewArray(NewArray newArray, Object object) {
            Expression[] expressionArray = newArray.getDimensions();
            Expression[] expressionArray2 = newArray.getInitialValues();
            Type type = newArray.getArrayType().getResultingType(1);
            int n = 0;
            while (n < expressionArray.length) {
                expressionArray[n].visit(this, null);
                if (!AgoolChecker.canBeConverted(expressionArray[n].getType(), PrimitiveType.INTEGER)) {
                    throw new AgoolCheckerError("ERRO (2) - Expressao invalida: inteiro esperado");
                }
                expressionArray[n] = AgoolChecker.this.convert(expressionArray[n], PrimitiveType.INTEGER);
                ++n;
            }
            newArray.setDimensions(expressionArray);
            int n2 = 0;
            while (n2 < expressionArray2.length) {
                expressionArray2[n2].visit(this, null);
                if (AgoolChecker.canBeConverted(expressionArray2[n2].getType(), type)) {
                    if (type instanceof PrimitiveType) {
                        expressionArray2[n2] = AgoolChecker.this.convert(expressionArray2[n2], (PrimitiveType)type);
                    }
                } else {
                    throw new AgoolCheckerError("ERRO (2) - Elemento invalido na inicializacao do array");
                }
                ++n2;
            }
            newArray.setInitialValues(expressionArray2);
            return null;
        }

        public Object visitNewObject(NewObject newObject, Object object) {
            Expression[] expressionArray = newObject.getArguments();
            int n = 0;
            while (n < expressionArray.length) {
                expressionArray[n].visit(this, null);
                ++n;
            }
            return null;
        }

        public Object visitNullObject(NullObject nullObject, Object object) {
            return null;
        }

        public Object visitObjectType(ObjectType objectType, Object object) {
            throw new RuntimeException(NOT_IMPLEMENTED_MSG);
        }

        public Object visitPrimitiveType(PrimitiveType primitiveType, Object object) {
            throw new RuntimeException(NOT_IMPLEMENTED_MSG);
        }

        public Object visitPrint(Print print, Object object) {
            return null;
        }

        public Object visitReturn(Return return_, Object object) {
            Expression expression = return_.getExpression();
            Type type = this.currentMethod.getType();
            if (expression == null) {
                if (type != PrimitiveType.VOID) {
                    throw new AgoolCheckerError("ERRO (2) - Falta valor de retorno");
                }
                return null;
            }
            expression.visit(this, null);
            Type type2 = expression.getType();
            if (!type2.equals(type)) {
                if (AgoolChecker.canBeConverted(type2, type)) {
                    if (type instanceof PrimitiveType) {
                        return_.setExpression(AgoolChecker.this.convert(expression, (PrimitiveType)type));
                    }
                } else {
                    throw new AgoolCheckerError("ERRO (2) - Expressao de tipo imcompativel com a definicao do metodo");
                }
            }
            return null;
        }

        public Object visitSideEffectExpression(SideEffectExpression sideEffectExpression, Object object) {
            sideEffectExpression.getTarget().visit(this, null);
            sideEffectExpression.getCommand().visit(this, STATEMENT_FLAG);
            return null;
        }

        public Object visitSuperClassObject(SuperClassObject superClassObject, Object object) {
            if (this.currentMethod.hasModifier(4)) {
                throw new AgoolCheckerError("ERRO (2) - Nao pode referenciar objeto atual em contexto estatico");
            }
            return null;
        }

        public Object visitUnaryExpression(UnaryExpression unaryExpression, Object object) {
            int n = unaryExpression.getOperator();
            Expression expression = unaryExpression.getOperand();
            expression.visit(this, null);
            Type type = expression.getType();
            switch (n) {
                case 13: {
                    if (type == PrimitiveType.BOOLEAN || type == PrimitiveType.INTEGER) {
                        unaryExpression.setType(type);
                        break;
                    }
                    throw new AgoolCheckerError("ERRO (2) - Operando de tipo invalido (op NOT): " + type);
                }
                case 6: {
                    if (AgoolChecker.this.isNumericalType(type)) {
                        unaryExpression.setType(type);
                        break;
                    }
                    throw new AgoolCheckerError("ERRO (2) - Operando de tipo invalido (op UMINUS):" + type);
                }
                default: {
                    throw new AgoolCheckerError("ERRO (2) - Operador unario desconhecido");
                }
            }
            return null;
        }

        public Object visitVariable(Variable variable, Object object) {
            if (object == STATEMENT_FLAG) {
                Expression expression = variable.getInitialValue();
                Type type = variable.getType();
                if (expression != null) {
                    expression.visit(this, null);
                    Type type2 = expression.getType();
                    if (AgoolChecker.canBeConverted(type2, type)) {
                        if (type2 instanceof PrimitiveType) {
                            expression = AgoolChecker.this.convert(expression, (PrimitiveType)type);
                            variable.setInitialValue(expression);
                        }
                    } else {
                        throw new AgoolCheckerError("ERRO (2) - Atribuicao invalida");
                    }
                }
            }
            return null;
        }

        public Object visitWhile(While while_, Object object) {
            Expression expression = while_.getExpression();
            expression.visit(this, null);
            if (expression.getType() != PrimitiveType.BOOLEAN) {
                throw new AgoolCheckerError("ERRO (2) - Expressao de teste invalida (tipo nao booleano)");
            }
            while_.getBlock().visit(this, null);
            return null;
        }
    }

    final class CheckerStep1
    implements Visitor {
        GClass thisClass;

        CheckerStep1() {
        }

        public Object visit(AgoolProgram agoolProgram, Object object) {
            GClass[] gClassArray = agoolProgram.getClasses();
            int n = gClassArray.length;
            if (AgoolChecker.this.debug) {
                System.out.println(">> AgoolChecker Step 1");
            }
            int n2 = 0;
            while (n2 < n) {
                if (gClassArray[n2].getSuperClass() == null) {
                    String string = gClassArray[n2].getSuperClassName();
                    Vector vector = AgoolChecker.this.table.getGClass(string);
                    if (vector.size() == 1) {
                        gClassArray[n2].setSuperClass((GClass)vector.get(0));
                    } else if (vector.size() > 1) {
                        AgoolChecker.this.errors.add(new AgoolCheckerError("ERRO (1) - Multiplas definicoes para o nome: " + string));
                        AgoolChecker.this.foundError = true;
                    } else {
                        AgoolChecker.this.errors.add(new AgoolCheckerError("ERRO (1) - Classe nao encontrada: " + string));
                        AgoolChecker.this.foundError = true;
                    }
                }
                AgoolChecker.this.table.setClassScope(gClassArray[n2].getName());
                if (AgoolChecker.this.table.getMethod(Method.CONSTRUCTOR_NAME) == null) {
                    Method method = new Method(new int[]{2}, new Variable[0], new Block());
                    gClassArray[n2].addMethod(method);
                    AgoolChecker.this.table.putSymbol(method);
                }
                Field[] fieldArray = gClassArray[n2].getFields();
                int n3 = 0;
                while (n3 < fieldArray.length) {
                    fieldArray[n3].visit(this, object);
                    ++n3;
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < n) {
                this.thisClass = gClassArray[n2];
                AgoolChecker.this.table.setClassScope(this.thisClass.getName());
                gClassArray[n2].visit(this, object);
                ++n2;
            }
            return null;
        }

        public Object visitGClass(GClass gClass, Object object) {
            Field[] fieldArray = gClass.getFields();
            Method[] methodArray = gClass.getMethods();
            if (AgoolChecker.this.debug) {
                System.out.println("====== Classe " + gClass.getName());
            }
            int n = 0;
            while (n < methodArray.length) {
                methodArray[n].visit(this, null);
                ++n;
            }
            return null;
        }

        public Object visitArrayAccess(ArrayAccess arrayAccess, Object object) {
            Expression[] expressionArray = arrayAccess.getIndices();
            Expression expression = arrayAccess.getArray();
            expression.visit(this, null);
            int n = 0;
            while (n < expressionArray.length) {
                expressionArray[n].visit(this, null);
                ++n;
            }
            if (!(expression.getType() instanceof ArrayType)) {
                throw new AgoolCheckerError("ERRO (1) - Expressao nao eh um array");
            }
            if (arrayAccess.getType() == null) {
                arrayAccess.setType(((ArrayType)expression.getType()).getResultingType(expressionArray.length));
            }
            return null;
        }

        public Object visitArrayLength(ArrayLength arrayLength, Object object) {
            arrayLength.getArray().visit(this, null);
            return null;
        }

        public Object visitArrayType(ArrayType arrayType, Object object) {
            GClass gClass = arrayType.getGClass();
            if (gClass.getSuperClass() == null) {
                gClass.setSuperClass(ObjectType.OBJECT.getGClass());
            }
            arrayType.getBaseType().visit(this, arrayType);
            return null;
        }

        public Object visitAssignment(Assignment assignment, Object object) throws AgoolCheckerError {
            Expression expression = assignment.getLeftExpression();
            assignment.getLeftExpression().visit(this, null);
            assignment.getRightExpression().visit(this, null);
            return null;
        }

        public Object visitBinaryExpression(BinaryExpression binaryExpression, Object object) {
            int n = binaryExpression.getOperator();
            binaryExpression.getOperand1().visit(this, null);
            binaryExpression.getOperand2().visit(this, null);
            Type type = binaryExpression.getOperand1().getType();
            Type type2 = binaryExpression.getOperand2().getType();
            switch (n) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    if (AgoolChecker.canBeConverted(type, type2)) {
                        binaryExpression.setType(type2);
                        break;
                    }
                    binaryExpression.setType(type);
                    break;
                }
                case 14: 
                case 15: 
                case 16: {
                    if (type == PrimitiveType.BOOLEAN) {
                        binaryExpression.setType(type);
                        break;
                    }
                    binaryExpression.setType(PrimitiveType.INTEGER);
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    binaryExpression.setType(PrimitiveType.BOOLEAN);
                    break;
                }
                default: {
                    throw new AgoolCheckerError("ERRO (J) - Operador binario desconhecido");
                }
            }
            return null;
        }

        public Object visitBlock(Block block, Object object) {
            Statement[] statementArray = block.getStatements();
            AgoolChecker.this.table.startLocalScope();
            int n = 0;
            while (n < statementArray.length) {
                try {
                    statementArray[n].visit(this, STATEMENT_FLAG);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    AgoolChecker.this.errors.add(new AgoolCheckerError(exception));
                    AgoolChecker.this.foundError = true;
                }
                catch (AgoolCheckerError agoolCheckerError) {
                    agoolCheckerError.printStackTrace();
                    AgoolChecker.this.errors.add(agoolCheckerError);
                    AgoolChecker.this.foundError = true;
                }
                ++n;
            }
            AgoolChecker.this.table.endLocalScope();
            return null;
        }

        public Object visitCast(Cast cast, Object object) {
            cast.getExpression().visit(this, null);
            cast.getObjectType().visit(this, null);
            return null;
        }

        public Object visitClassExpression(ClassExpression classExpression, Object object) {
            return null;
        }

        public Object visitConstant(Constant constant, Object object) {
            return null;
        }

        public Object visitConversion(Conversion conversion, Object object) {
            conversion.getExpression().visit(this, null);
            conversion.getFinalType().visit(this, null);
            return null;
        }

        public Object visitCurrentObject(CurrentObject currentObject, Object object) {
            currentObject.setGClass(this.thisClass);
            return null;
        }

        public Object visitField(Field field, Object object) {
            Expression expression = field.getInitialValue();
            field.getType().visit(this, null);
            if (expression != null) {
                expression.visit(this, field.getType());
            }
            return null;
        }

        public Object visitFieldAccess(FieldAccess fieldAccess, Object object) {
            String string;
            Expression expression = fieldAccess.getExpressionLeft();
            Field field = fieldAccess.getField();
            if (expression == null) {
                string = this.thisClass.getName();
            } else {
                expression.visit(this, null);
                string = expression.getType().getName();
            }
            if (field == null) {
                field = AgoolChecker.this.table.getField(string, fieldAccess.getFieldName());
                if (field == null) {
                    throw new AgoolCheckerError("Atributo inexistente: " + fieldAccess.getFieldName());
                }
                fieldAccess.setField(field);
            }
            if (expression == null) {
                expression = field.hasModifier(4) ? new ClassExpression(this.thisClass) : new CurrentObject(this.thisClass);
                fieldAccess.setExpressionLeft(expression);
            }
            return null;
        }

        public Object visitIf(If if_, Object object) {
            Block block = if_.getFalseBlock();
            if_.getExpression().visit(this, null);
            if_.getTrueBlock().visit(this, null);
            if (block != null) {
                if (block.getStatements().length == 0) {
                    if_.setFalseBlockNull();
                } else {
                    block.visit(this, null);
                }
            }
            return null;
        }

        public Object visitInstanceOf(InstanceOf instanceOf, Object object) {
            instanceOf.getExpression().visit(this, null);
            instanceOf.getDestinationType().visit(this, null);
            return null;
        }

        public Object visitMethod(Method method, Object object) {
            Variable[] variableArray = method.getFormals();
            if (AgoolChecker.this.debug) {
                System.out.println(" -- Metodo: " + method.getName());
            }
            AgoolChecker.this.table.startLocalScope();
            try {
                int n = 0;
                while (n < variableArray.length) {
                    this.visitVariable(variableArray[n], STATEMENT_FLAG);
                    ++n;
                }
            }
            catch (AgoolCheckerError agoolCheckerError) {
                AgoolChecker.this.errors.add(agoolCheckerError);
                AgoolChecker.this.foundError = true;
            }
            try {
                method.getReturnType().visit(this, null);
            }
            catch (AgoolCheckerError agoolCheckerError) {
                AgoolChecker.this.errors.add(agoolCheckerError);
                AgoolChecker.this.foundError = true;
            }
            method.getBody().visit(this, null);
            AgoolChecker.this.table.endLocalScope();
            return null;
        }

        public Object visitMethodCall(MethodCall methodCall, Object object) {
            Type type;
            Expression expression = methodCall.getExpressionLeft();
            String string = methodCall.getMethodName();
            Expression[] expressionArray = methodCall.getArguments();
            methodCall.setIsExpression(object != STATEMENT_FLAG);
            if (expression == null) {
                type = this.thisClass.getObjectType();
            } else {
                expression.visit(this, null);
                type = expression.getType();
            }
            if (!(type instanceof ObjectType)) {
                throw new AgoolCheckerError("ERRO (1) - Expressao invalida na chamada ao metodo (tipo nao objeto)");
            }
            int n = 0;
            while (n < expressionArray.length) {
                expressionArray[n].visit(this, null);
                ++n;
            }
            if (methodCall.getMethod() == null) {
                Vector vector = AgoolChecker.this.table.getMethod(type.getName(), string);
                if (vector == null) {
                    throw new AgoolCheckerError("ERRO (1) - Metodo nao encontrado: " + string);
                }
                Vector vector2 = this.filterMethods(vector, string, expressionArray, methodCall.isConstructor());
                if (vector2.size() == 1) {
                    methodCall.setMethod((Method)vector2.get(0));
                } else {
                    if (vector2.size() == 0) {
                        throw new AgoolCheckerError("ERRO (1) - Nao foi possivel encontrar uma definicao do metodo \"" + string + "\" que corresponda a chamada");
                    }
                    throw new AgoolCheckerError("ERRO (1) - Multiplas definicoes do metodo \"" + string + "\" " + "correspondem a chamada");
                }
            }
            if (expression == null) {
                expression = methodCall.getMethod().hasModifier(4) ? new ClassExpression(this.thisClass) : new CurrentObject(this.thisClass);
                methodCall.setExpresionLeft(expression);
            }
            return null;
        }

        public Object visitNewArray(NewArray newArray, Object object) {
            Expression[] expressionArray = newArray.getDimensions();
            Expression[] expressionArray2 = newArray.getInitialValues();
            ArrayType arrayType = newArray.getArrayType();
            if (arrayType == null) {
                if (object == null) {
                    throw new AgoolCheckerError("ERRO (1) - Invalid Expression (new array)");
                }
                arrayType = (ArrayType)object;
                newArray.setArrayType(arrayType);
            }
            arrayType.visit(this, null);
            if (expressionArray2 == null) {
                expressionArray2 = new Expression[]{};
                newArray.setInitialValues(expressionArray2);
            }
            if (expressionArray == null) {
                expressionArray = new Expression[]{new Constant(expressionArray2.length)};
                newArray.setDimensions(expressionArray);
            } else {
                int n = 0;
                while (n < expressionArray.length) {
                    expressionArray[n].visit(this, null);
                    ++n;
                }
            }
            Type type = arrayType.getResultingType(1);
            int n = 0;
            while (n < expressionArray2.length) {
                expressionArray2[n].visit(this, type);
                ++n;
            }
            if (expressionArray.length > arrayType.getNumDimensions()) {
                throw new AgoolCheckerError("ERRO (1) - O array tem um numero de dimensoes incompativel com seu tipo");
            }
            return null;
        }

        public Object visitNewObject(NewObject newObject, Object object) {
            Expression[] expressionArray = newObject.getArguments();
            int n = 0;
            while (n < expressionArray.length) {
                expressionArray[n].visit(this, null);
                ++n;
            }
            newObject.getObjectType().visit(this, null);
            Vector vector = AgoolChecker.this.table.getMethod(newObject.getObjectType().getName(), Method.CONSTRUCTOR_NAME);
            if (vector == null) {
                throw new AgoolCheckerError("ERRO (1) - Construtor nao encontrado");
            }
            Vector vector2 = this.filterMethods(vector, Method.CONSTRUCTOR_NAME, expressionArray, true);
            if (vector2.size() != 1) {
                if (vector2.size() == 0) {
                    throw new AgoolCheckerError("ERRO (1) - Nao foi possivel encontrar um construtor compativel");
                }
                throw new AgoolCheckerError("ERRO (1) - Multiplos construtores correspondem a chamada");
            }
            newObject.setConstructor((Method)vector2.get(0));
            return null;
        }

        public Object visitNullObject(NullObject nullObject, Object object) {
            return null;
        }

        public Vector filterMethods(Vector vector, String string, Expression[] expressionArray, boolean bl) {
            Method method;
            Iterator iterator = ((AbstractList)vector).iterator();
            Vector<Method> vector2 = new Vector<Method>();
            while (iterator.hasNext()) {
                method = (Method)iterator.next();
                if (method.getNumParameters() != expressionArray.length || method.isConstructor() != bl) continue;
                vector2.add(method);
            }
            Vector<Method> vector3 = new Vector<Method>();
            int n = 0;
            while (n < expressionArray.length) {
                iterator = ((AbstractList)vector2).iterator();
                boolean bl2 = false;
                while (iterator.hasNext()) {
                    method = (Method)iterator.next();
                    if (!method.getFormalType(n).equals(expressionArray[n].getType())) continue;
                    bl2 = true;
                    vector3.add(method);
                }
                if (!bl2) {
                    iterator = ((AbstractList)vector2).iterator();
                    while (iterator.hasNext()) {
                        method = (Method)iterator.next();
                        if (!AgoolChecker.canBeConverted(expressionArray[n].getType(), method.getFormalType(n))) continue;
                        vector3.add(method);
                    }
                }
                Vector<Method> vector4 = vector2;
                vector2 = vector3;
                vector3 = vector4;
                vector3.clear();
                ++n;
            }
            return vector2;
        }

        public Object visitObjectType(ObjectType objectType, Object object) {
            if (objectType.getGClass() == null) {
                Vector vector = AgoolChecker.this.table.getGClass(objectType.getName());
                if (vector.size() == 1) {
                    objectType.setGClass((GClass)vector.get(0));
                } else {
                    if (vector.size() > 1) {
                        throw new AgoolCheckerError("ERRO (1) - Multiplas definicoes para o nome: " + objectType.getName());
                    }
                    throw new AgoolCheckerError("ERRO (1) - Identificador nao encontrado: " + objectType.getName());
                }
            }
            return null;
        }

        public Object visitPrimitiveType(PrimitiveType primitiveType, Object object) {
            return null;
        }

        public Object visitPrint(Print print, Object object) {
            return null;
        }

        public Object visitReturn(Return return_, Object object) {
            Expression expression = return_.getExpression();
            if (expression != null) {
                return_.getExpression().visit(this, null);
            }
            return null;
        }

        public Object visitSideEffectExpression(SideEffectExpression sideEffectExpression, Object object) {
            sideEffectExpression.setIsExpression(object != STATEMENT_FLAG);
            sideEffectExpression.getTarget().visit(this, null);
            sideEffectExpression.getCommand().visit(this, STATEMENT_FLAG);
            return null;
        }

        public Object visitSuperClassObject(SuperClassObject superClassObject, Object object) {
            superClassObject.setGClass(this.thisClass.getSuperClass());
            return null;
        }

        public Object visitUnaryExpression(UnaryExpression unaryExpression, Object object) {
            Expression expression = unaryExpression.getOperand();
            expression.visit(this, null);
            unaryExpression.setType(expression.getType());
            return null;
        }

        public Object visitVariable(Variable variable, Object object) {
            if (object == STATEMENT_FLAG) {
                Expression expression = variable.getInitialValue();
                if (expression != null) {
                    variable.getType().visit(this, null);
                    if (variable.getType() instanceof ArrayType) {
                        expression.visit(this, variable.getType());
                    } else {
                        expression.visit(this, null);
                    }
                }
                if (AgoolChecker.this.table.addLocalVar(variable)) {
                    throw new AgoolCheckerError("ERRO (1) - Variavel local ja definida: " + variable.getName());
                }
            } else {
                variable.getType().visit(this, null);
            }
            return null;
        }

        public Object visitWhile(While while_, Object object) {
            while_.getExpression().visit(this, null);
            while_.getBlock().visit(this, null);
            return null;
        }
    }
}

