/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.agool;

import br.ufpe.abaco.ParserGen.lexer.LexerFacade;
import br.ufpe.abaco.ParserGen.lexer.LexicalErrorException;
import br.ufpe.abaco.ParserGen.lexer.Token;
import br.ufpe.abaco.ParserGen.parser.BNFGrammar;
import br.ufpe.abaco.ParserGen.parser.Parser;
import br.ufpe.abaco.ParserGen.parser.ParsingException;
import br.ufpe.agool.AGOOLException;
import br.ufpe.agool.Language;
import br.ufpe.agool.code.BytecodeGenerator;
import br.ufpe.agool.code.CodeGenerator;
import br.ufpe.agool.code.FileClassBag;
import br.ufpe.agool.java.JavaLanguage;

public class AGOOLFacade {
    private static AGOOLFacade instance;
    private static final String LANGUAGE_FILE = "LANGUAGE.TXT";
    private CodeGenerator codeGenerator;
    private BNFGrammar grammar;
    private LexerFacade lexerGenerator;
    private String log = "";
    private Parser parser;
    private String parserLog;
    private String processingLog = "";

    public static AGOOLFacade getInstance() {
        return AGOOLFacade.getInstance(false);
    }

    public static AGOOLFacade getInstance(boolean bl) {
        if (instance == null) {
            instance = new AGOOLFacade(new JavaLanguage(), bl, new BytecodeGenerator(new FileClassBag()));
        }
        return instance;
    }

    public static AGOOLFacade getInstance(Language language) {
        return AGOOLFacade.getInstance(language, false);
    }

    public static AGOOLFacade getInstance(Language language, boolean bl) {
        if (instance == null) {
            instance = new AGOOLFacade(language, bl, new BytecodeGenerator(new FileClassBag()));
        }
        return instance;
    }

    public static AGOOLFacade getInstance(Language language, boolean bl, CodeGenerator codeGenerator) {
        if (instance == null) {
            instance = new AGOOLFacade(language, bl, codeGenerator);
        }
        return instance;
    }

    public static AGOOLFacade getInstance(Language language, CodeGenerator codeGenerator) {
        return AGOOLFacade.getInstance(language, false, codeGenerator);
    }

    private AGOOLFacade(Language language, boolean bl, CodeGenerator codeGenerator) {
        this.setLanguage(language, bl);
        this.setCodeGenerator(codeGenerator);
    }

    public String getGrammarLog() {
        return this.parser.getGrammarLog();
    }

    public String getLanguageTimesLog() {
        String string = this.log;
        this.log = "";
        return string;
    }

    public String getProcessingTimesLog() {
        return this.processingLog;
    }

    public Object process(String string, byte by, boolean bl) throws AGOOLException {
        if (string == null) {
            throw new IllegalArgumentException("input null");
        }
        this.processingLog = "";
        Object object = null;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        long l8 = 0L;
        try {
            System.out.println("Generating tokens...");
            l = System.currentTimeMillis();
            Token[] tokenArray = null;
            tokenArray = this.lexerGenerator.analyse(string);
            l2 = System.currentTimeMillis();
            this.processingLog = this.processingLog + "Time spent in the lexical analysis (in milliseconds): " + (l2 - l) + '\n';
            l3 = System.currentTimeMillis();
            System.out.println("Parsing...");
            object = this.parser.parse(tokenArray, by, bl);
            l4 = System.currentTimeMillis();
            this.processingLog = this.processingLog + this.parserLog + "Time spent in the syntactical analysis (in milliseconds): " + (l4 - l3) + '\n';
            this.processingLog = this.processingLog + this.parser.getLog() + '\n';
        }
        catch (LexicalErrorException lexicalErrorException) {
            l2 = System.currentTimeMillis();
            this.processingLog = this.processingLog + this.parser.getLog() + "Time spent in the lexical analysis (in milliseconds): " + (l2 - l) + '\n';
            throw new AGOOLException(lexicalErrorException);
        }
        catch (ParsingException parsingException) {
            l4 = System.currentTimeMillis();
            this.processingLog = this.processingLog + this.parserLog + "Time spent in the syntactical analysis (in milliseconds): " + (l4 - l3) + '\n';
            this.processingLog = this.processingLog + this.parser.getLog() + '\n';
            throw new AGOOLException(parsingException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return object;
    }

    public void saveGrammarLog() {
        this.parser.saveGrammarLog();
    }

    public void saveParserLog() {
        this.parser.saveParserLog();
    }

    public void setCodeGenerator(CodeGenerator codeGenerator) {
        this.codeGenerator = codeGenerator;
    }

    public void setLanguage(Language language, boolean bl) {
        if (language == null) {
            throw new IllegalArgumentException("parameter language null!");
        }
        long l = System.currentTimeMillis();
        this.lexerGenerator = language.buildLexer();
        this.grammar = language.buildGrammar();
        long l2 = System.currentTimeMillis();
        this.log = this.log + "Time spent to build the grammar (in milliseconds): " + (l2 - l) + '\n';
        long l3 = System.currentTimeMillis();
        this.parser = new Parser(this.grammar, bl);
        long l4 = System.currentTimeMillis();
        this.log = this.log + "Time spent to build the table and set the semantic actions (in milliseconds): " + (l4 - l3) + '\n';
    }
}

