/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.abaco.gui;

import br.ufpe.abaco.gui.PrintStatus;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import javax.swing.JTextPane;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.BoxView;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.StyleContext;
import javax.swing.text.View;

public class SpecificationPrinter
implements Printable {
    private PrintView m_printView = null;
    private JTextPane m_monitor;
    private DefaultStyledDocument m_doc = new DefaultStyledDocument(new StyleContext());
    private int numberOfPages;
    private boolean showPrintStatus = false;
    private PrintStatus printStatus = null;
    private boolean cancelledPrint = false;

    public SpecificationPrinter(String string) {
        this.m_monitor = new JTextPane();
        this.m_monitor.setDocument(this.m_doc);
        this.m_monitor.setText(string);
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        int n2 = (int)pageFormat.getImageableWidth();
        double d = (int)(pageFormat.getHeight() - (pageFormat.getImageableY() + pageFormat.getImageableHeight()));
        int n3 = (int)Math.ceil(n2 - Integer.toString(n + 1).length() * 14) - 30;
        pageFormat.getPaper().setImageableArea(pageFormat.getImageableX(), pageFormat.getImageableY(), pageFormat.getImageableWidth(), pageFormat.getImageableHeight() + d);
        int n4 = (int)pageFormat.getImageableHeight();
        graphics.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        graphics.setClip(0, 0, n2, n4);
        if (this.m_printView == null) {
            BasicTextUI basicTextUI = (BasicTextUI)this.m_monitor.getUI();
            View view = basicTextUI.getRootView(this.m_monitor);
            this.m_printView = new PrintView(this.m_doc.getDefaultRootElement(), view, n2, n4);
        }
        if (this.showPrintStatus) {
            if (this.printStatus == null) {
                this.printStatus = new PrintStatus(n, this.numberOfPages, this);
                ((Component)this.printStatus).setVisible(true);
            } else {
                this.printStatus.setLabel("Printing page " + (n + 1) + " of " + this.numberOfPages + "...");
            }
        }
        boolean bl = this.m_printView.paintPage(graphics, n4, n);
        if (this.cancelledPrint) {
            throw new PrinterAbortException("Printing cancelled successful!");
        }
        graphics.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY() + (n4 - (int)d));
        graphics.setClip(0, 0, n2, (int)d);
        graphics.setColor(Color.black);
        graphics.setFont(new Font("Courier New", 0, 14));
        graphics.drawString(Integer.toString(n + 1), n3, (int)d - 30);
        System.gc();
        pageFormat.getPaper().setImageableArea(pageFormat.getImageableX(), pageFormat.getImageableY(), pageFormat.getImageableWidth(), pageFormat.getImageableHeight() - d);
        if (bl) {
            return 0;
        }
        this.m_printView = null;
        return 1;
    }

    public void setNumberOfPages(int n) {
        this.numberOfPages = n;
    }

    public void showPrintStatus(boolean bl) {
        this.showPrintStatus = bl;
    }

    public void setCancelledPrintState() {
        this.cancelledPrint = true;
    }

    public PrintStatus getPrintStatusDialog() {
        return this.printStatus;
    }

    class PrintView
    extends BoxView {
        protected int m_firstOnPage = 0;
        protected int m_lastOnPage = 0;
        protected int m_pageIndex = 0;

        public PrintView(Element element, View view, int n, int n2) {
            super(element, 1);
            this.setParent(view);
            this.setSize(n, n2);
            this.layout(n, n2);
        }

        public boolean paintPage(Graphics graphics, int n, int n2) {
            if (n2 > this.m_pageIndex) {
                this.m_firstOnPage = this.m_lastOnPage + 1;
                if (this.m_firstOnPage >= this.getViewCount()) {
                    return false;
                }
                this.m_pageIndex = n2;
            }
            int n3 = this.getOffset(1, this.m_firstOnPage);
            int n4 = n3 + n;
            Rectangle rectangle = new Rectangle();
            int n5 = this.m_firstOnPage;
            while (n5 < this.getViewCount()) {
                rectangle.x = this.getOffset(0, n5);
                rectangle.y = this.getOffset(1, n5);
                rectangle.width = this.getSpan(0, n5);
                rectangle.height = this.getSpan(1, n5);
                if (rectangle.y + rectangle.height > n4) break;
                this.m_lastOnPage = n5;
                rectangle.y -= n3;
                this.paintChild(graphics, rectangle, n5);
                ++n5;
            }
            return true;
        }
    }
}

