/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.abaco.gui;

import br.ufpe.abaco.gui.AbacoTextEditor;
import br.ufpe.abaco.gui.DesktopWindow;
import br.ufpe.abaco.gui.Interface;
import br.ufpe.abaco.gui.Project;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class SpecificationEditor
extends DesktopWindow
implements CaretListener {
    private JTextArea edt = new AbacoTextEditor();
    private JScrollPane srcPan = new JScrollPane(this.edt);
    private UndoManager undoManager = new UndoManager();
    private Project sourceProject;
    private String specificationName;

    public Project sourceProject() {
        return this.sourceProject;
    }

    public String specificationName() {
        return this.specificationName;
    }

    void updateProject() {
        this.sourceProject.setSpecification(this.specificationName, this.edt.getText());
    }

    public SpecificationEditor(String string, Project project) {
        super(string, true, true, true, true);
        this.specificationName = string;
        this.sourceProject = project;
        this.getContentPane().add(this.srcPan);
        this.edt.addCaretListener(this);
        this.edt.setText(project.getSpecification(string));
        this.edt.setCaretPosition(0);
        this.edt.setRequestFocusEnabled(true);
        this.edt.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                SpecificationEditor.this.updateProject();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                SpecificationEditor.this.updateProject();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                SpecificationEditor.this.updateProject();
            }
        });
        this.edt.getDocument().addUndoableEditListener(new UndoableEditListener(){

            public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                UndoableEdit undoableEdit = undoableEditEvent.getEdit();
                SpecificationEditor.this.undoManager.addEdit(undoableEditEvent.getEdit());
                Interface.updateUndo(SpecificationEditor.this.undoManager);
            }
        });
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public String getValue() {
        return this.edt.getText();
    }

    public String getValue(int n, int n2) throws BadLocationException {
        this.edt.setCaretPosition(n);
        return this.edt.getText(n, n2);
    }

    public void setValue(String string) {
        this.edt.setText(string);
        this.edt.setCaretPosition(0);
    }

    public void replaceTextSelection(String string) {
        this.edt.replaceSelection(string);
    }

    void setEditable(boolean bl) {
        this.edt.setEditable(bl);
    }

    public boolean isEditable() {
        return this.edt.isEditable();
    }

    public void copy() {
        this.edt.copy();
    }

    public void cut() {
        this.edt.cut();
    }

    public void paste() {
        this.edt.paste();
    }

    public void selectAll() {
        this.edt.selectAll();
    }

    public void selectText(int n, int n2) {
        this.edt.grabFocus();
        this.edt.select(n, n2);
    }

    public int getCaretPosition() {
        return this.edt.getCaretPosition();
    }

    public void setCaretPosition(int n) {
        this.edt.setCaretPosition(n);
    }

    public String getSelectedText() {
        return this.edt.getSelectedText();
    }

    public void caretUpdate(CaretEvent caretEvent) {
        try {
            byte[] byArray = this.edt.getText().getBytes();
            int n = this.edt.getCaretPosition();
            int n2 = 1;
            int n3 = 1;
            int n4 = 0;
            while (n4 < n) {
                if (byArray[n4] == 10) {
                    ++n3;
                    n2 = 1;
                } else {
                    ++n2;
                }
                ++n4;
            }
            String string = "  lin : ";
            if (n3 < 100) {
                string = string + " ";
            } else if (n2 < 10) {
                string = string + "  ";
            }
            String string2 = " col : ";
            if (n2 < 100) {
                string2 = string2 + " ";
            } else if (n2 > 10) {
                string2 = string2 + "  ";
            }
            Interface.getInterface().setLabel(string + n3 + string2 + n2 + " ");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JTextArea getTextArea() {
        return this.edt;
    }
}

