/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.abaco.gui;

import br.ufpe.abaco.gui.DesktopWindow;
import br.ufpe.abaco.gui.HelpMenu;
import br.ufpe.abaco.gui.Interface;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class SearchDialog
extends JDialog {
    private JComboBox combo = new JComboBox();
    private JLabel label = new JLabel("Find what: ");
    private JCheckBox listLines = new JCheckBox("List Lines Containing String");
    private JCheckBox matchCase = new JCheckBox("Match Case");
    private JCheckBox wholeWord = new JCheckBox("Match Whole Word Only");
    private JRadioButton up = new JRadioButton("Up");
    private JRadioButton down = new JRadioButton("Down");
    private ButtonGroup group = new ButtonGroup();
    private JButton find = new JButton("Find Next");
    private JButton countAll = new JButton("Count All");
    private JButton cancel = new JButton("Cancel");
    private String lastWord = "";
    private int wordsCounter;
    private Interface window;
    private char[] WORD_SEPARATORS = new char[]{' ', '\t', '\n', '\r', '\f', '.', ',', ':', '-', '(', ')', '[', ']', '{', '}', '<', '>', '/', '|', '\\', '\'', '\"'};
    private Vector localsOfLines = new Vector();

    public SearchDialog(Interface interface_) {
        super(interface_, "Search", true);
        this.window = interface_;
        ((Component)this).setLocation((interface_.getWidth() + (int)interface_.getLocation().getX() - 470) / 2, (interface_.getHeight() + (int)interface_.getLocation().getY() - 160) / 2);
        String string = "                       ";
        this.combo.addItem("");
        this.combo.addItem(string + string + string);
        this.combo.setEditable(true);
        ((JTextField)this.combo.getEditor().getEditorComponent()).setCaretPosition(0);
        ((BasicComboBoxRenderer)this.combo.getRenderer()).setBackground(Color.white);
        this.combo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (SearchDialog.this.combo.getSelectedIndex() == ((DefaultComboBoxModel)SearchDialog.this.combo.getModel()).getSize() - 1) {
                    SearchDialog.this.combo.setSelectedIndex(((DefaultComboBoxModel)SearchDialog.this.combo.getModel()).getSize() - 2);
                }
            }
        });
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 5, 11);
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.label, gridBagConstraints);
        jPanel.add(this.label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 11, 5, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.combo, gridBagConstraints);
        jPanel.add(this.combo);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(3, 1));
        jPanel2.add(this.listLines);
        jPanel2.add(this.matchCase);
        jPanel2.add(this.wholeWord);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(1, 2));
        jPanel3.setBorder(BorderFactory.createTitledBorder("Direction"));
        this.group.add(this.up);
        this.down.setSelected(true);
        this.group.add(this.down);
        jPanel3.add(this.up);
        jPanel3.add(this.down);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(3, 1, 0, 5));
        this.find.setBorder(BorderFactory.createMatteBorder(1, 1, 2, 2, Color.black));
        this.find.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SearchDialog.this.listLines.isSelected()) {
                    if (SearchDialog.this.search(false)) {
                        // empty if block
                    }
                    ListLinesDialog listLinesDialog = new ListLinesDialog();
                } else {
                    SearchDialog.this.search(true);
                }
            }
        });
        jPanel4.add(this.find);
        this.countAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchDialog.this.search(false);
            }
        });
        jPanel4.add(this.countAll);
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)SearchDialog.this).setVisible(false);
            }
        });
        jPanel4.add(this.cancel);
        JPanel jPanel5 = new JPanel();
        gridBagLayout = new GridBagLayout();
        gridBagConstraints = new GridBagConstraints();
        jPanel5.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 10, 5, 10);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel5.add(jPanel2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 5, 10, 10);
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel5.add(jPanel3);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout());
        jPanel6.add((Component)jPanel, "North");
        jPanel6.add((Component)jPanel5, "Center");
        JPanel jPanel7 = new JPanel();
        gridBagLayout = new GridBagLayout();
        gridBagConstraints = new GridBagConstraints();
        jPanel7.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 5, 10, 10);
        gridBagConstraints.anchor = 12;
        gridBagLayout.setConstraints(jPanel6, gridBagConstraints);
        jPanel7.add(jPanel6);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(20, 10, 5, 10);
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel7.add(jPanel4);
        this.getContentPane().add(jPanel7);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ((Component)SearchDialog.this).setVisible(false);
            }
        });
        ((Component)this).setSize(550, 160);
        this.setResizable(false);
    }

    public boolean search(boolean bl) {
        String string = ((String)this.combo.getSelectedItem()).trim();
        String string2 = "";
        String string3 = "";
        Object[] objectArray = new Object[]{"Find Next", "Cancel"};
        DesktopWindow desktopWindow = (DesktopWindow)this.window.getPane().getSelectedFrame();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        this.wordsCounter = 0;
        if (desktopWindow instanceof HelpMenu) {
            return false;
        }
        ((Component)this).setVisible(false);
        if (string.trim().equals("")) {
            JOptionPane.showMessageDialog(this, "Invalid argument.", "Search result", 1);
        } else {
            if (this.down.isSelected()) {
                desktopWindow.setCaretPosition(0);
                for (int i = 0; i >= 0; ++i) {
                    try {
                        string2 = desktopWindow.getValue(i, 1);
                        if (string2.equalsIgnoreCase(String.valueOf(string.charAt(0))) && string.equalsIgnoreCase(desktopWindow.getValue(i, string.length()))) {
                            if (this.wholeWord.isSelected() && this.isSeparator(desktopWindow.getValue(i + string.length(), 1).charAt(0))) {
                                bl2 = true;
                            }
                            if (this.matchCase.isSelected() && string.equals(desktopWindow.getValue(i, string.length()))) {
                                bl3 = true;
                            }
                            if (bl2 && (bl3 || !this.matchCase.isSelected()) || bl3 && (bl2 || !this.wholeWord.isSelected()) || !this.wholeWord.isSelected() && !this.matchCase.isSelected()) {
                                bl4 = true;
                                if (bl) {
                                    string3 = "";
                                    desktopWindow.selectText(i, i + string.length());
                                    int n = JOptionPane.showOptionDialog(this.window, string3, "Search", 2, -1, null, objectArray, objectArray[0]);
                                    if (n != 0) {
                                        break;
                                    }
                                } else {
                                    ++this.wordsCounter;
                                }
                                i += string.length();
                            }
                        }
                        bl2 = false;
                        bl3 = false;
                        continue;
                    }
                    catch (Exception exception) {
                        break;
                    }
                }
            } else {
                int n;
                desktopWindow.selectAll();
                desktopWindow.selectText(0, 0);
                desktopWindow.setCaretPosition(n);
                for (n = desktopWindow.getCaretPosition() - 1; n >= 0; --n) {
                    try {
                        string2 = desktopWindow.getValue(n, 1);
                        if (string2.toUpperCase().equals(String.valueOf(string.charAt(string.length() - 1)).toUpperCase()) && string.toUpperCase().equals(desktopWindow.getValue(n - (string.length() - 1), string.length()).toUpperCase())) {
                            if (this.wholeWord.isSelected() && this.isSeparator(desktopWindow.getValue(n + 1, 1).charAt(0))) {
                                bl2 = true;
                            }
                            if (this.matchCase.isSelected() && string.equals(desktopWindow.getValue(n - (string.length() - 1), string.length()))) {
                                bl3 = true;
                            }
                            if (bl2 && (bl3 || !this.matchCase.isSelected()) || bl3 && (bl2 || !this.wholeWord.isSelected()) || !this.wholeWord.isSelected() && !this.matchCase.isSelected()) {
                                bl4 = true;
                                if (bl) {
                                    string3 = "";
                                    desktopWindow.selectText(n - (string.length() - 1), n + 1);
                                    int n2 = JOptionPane.showOptionDialog(this.window, string3, "Search", 2, -1, null, objectArray, objectArray[0]);
                                    if (n2 != 0) {
                                        break;
                                    }
                                } else {
                                    ++this.wordsCounter;
                                }
                                n -= string.length();
                            }
                        }
                        bl2 = false;
                        bl3 = false;
                        continue;
                    }
                    catch (Exception exception) {
                        System.out.println("Excecao : " + n);
                        break;
                    }
                }
            }
            if (!bl4) {
                string3 = "String " + string + " not found";
                JOptionPane.showMessageDialog(this, string3, "Search result", 1);
                ((Component)this).setVisible(true);
            } else if (bl4 && !bl && !this.listLines.isSelected()) {
                JOptionPane.showMessageDialog(this, this.wordsCounter + " ocurrences found.", "Search result", 1);
            }
        }
        this.lastWord = string;
        if (this.lastWord != "" && ((DefaultComboBoxModel)this.combo.getModel()).getIndexOf(this.lastWord) == -1) {
            this.combo.removeItem("");
            this.combo.insertItemAt(this.lastWord, 0);
        }
        return bl4;
    }

    public boolean isSeparator(char c) {
        int n = 0;
        while (n < this.WORD_SEPARATORS.length) {
            if (c == this.WORD_SEPARATORS[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    class ListLinesDialog
    extends JDialog {
        private JList list = new JList();
        private JScrollPane scroll = new JScrollPane(this.list);
        private JButton close = new JButton("Close");
        private JButton goTo = new JButton("Goto");
        private JButton clipboard = new JButton("Clipboard");

        ListLinesDialog() {
            super(SearchDialog.this.window, "Lines containing find String:", false);
            ((Component)this).setSize(450, 250);
            ((Component)this).setLocation((SearchDialog.this.window.getWidth() + (int)SearchDialog.this.window.getLocation().getX() - 450) / 2, (SearchDialog.this.window.getHeight() + (int)SearchDialog.this.window.getLocation().getY() - 250) / 2);
            this.setResizable(false);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(7, 1, 0, 5));
            jPanel.add(this.close);
            this.close.addActionListener(new ActionListener(this){
                private final /* synthetic */ ListLinesDialog this$1;
                {
                    this.this$1 = listLinesDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    SearchDialog.access$400(ListLinesDialog.access$300(this.this$1)).removeAllElements();
                    this.this$1.dispose();
                }
            });
            jPanel.add(this.goTo);
            this.goTo.addActionListener(new ActionListener(this){
                private final /* synthetic */ ListLinesDialog this$1;
                {
                    this.this$1 = listLinesDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (ListLinesDialog.access$500(this.this$1).getSelectedValue() != null) {
                        ListLinesDialog.access$600(this.this$1, ListLinesDialog.access$500(this.this$1).getSelectedIndex());
                    }
                }
            });
            jPanel.add(this.clipboard);
            this.clipboard.addActionListener(new ActionListener(this){
                private final /* synthetic */ ListLinesDialog this$1;
                {
                    this.this$1 = listLinesDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Clipboard clipboard = this.this$1.getToolkit().getSystemClipboard();
                    StringBuffer stringBuffer = new StringBuffer();
                    int n = 0;
                    while (n < ListLinesDialog.access$500(this.this$1).getModel().getSize()) {
                        stringBuffer.append(ListLinesDialog.access$500(this.this$1).getModel().getElementAt(n) + "\n");
                        ++n;
                    }
                    clipboard.setContents(new StringSelection(stringBuffer.toString()), null);
                    this.this$1.dispose();
                }
            });
            this.getContentPane().setLayout(gridBagLayout);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(10, 10, 5, 10);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 1;
            gridBagLayout.setConstraints(this.scroll, gridBagConstraints);
            this.scroll.setPreferredSize(new Dimension(350, 210));
            this.getContentPane().add(this.scroll);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(10, 10, 5, 10);
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(jPanel, gridBagConstraints);
            this.getContentPane().add(jPanel);
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ ListLinesDialog this$1;
                {
                    this.this$1 = listLinesDialog;
                }

                public void windowClosing(WindowEvent windowEvent) {
                    SearchDialog.access$400(ListLinesDialog.access$300(this.this$1)).removeAllElements();
                    this.this$1.dispose();
                }
            });
            this.list.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ ListLinesDialog this$1;
                {
                    this.this$1 = listLinesDialog;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2 && ListLinesDialog.access$500(this.this$1).getSelectedValue() != null) {
                        ListLinesDialog.access$600(this.this$1, ListLinesDialog.access$500(this.this$1).getSelectedIndex());
                    }
                }
            });
            this.list.setModel(new DefaultListModel());
            this.pack();
            this.fillList();
            if (SearchDialog.this.down.isSelected()) {
                this.list.setSelectedIndex(0);
                this.selectLine(0);
            } else {
                int n = this.list.getModel().getSize() - 1;
                this.list.setSelectedIndex(n);
                this.selectLine(n);
            }
            ((Component)this).setVisible(true);
        }

        private void fillList() {
            String string = ((DesktopWindow)SearchDialog.this.window.getPane().getSelectedFrame()).getValue();
            String string2 = ((String)SearchDialog.this.combo.getSelectedItem()).trim();
            int n = 0;
            int n2 = 0;
            boolean bl = false;
            boolean bl2 = false;
            int n3 = 0;
            while (n2 < string.length()) {
                String string3;
                n2 = string.indexOf(10, n);
                if (n2 == -1) {
                    n2 = string.length();
                }
                if ((string3 = string.substring(n, n2)).length() > 0 && string3.toUpperCase().indexOf(string2.toUpperCase()) != -1) {
                    if (SearchDialog.this.wholeWord.isSelected() && SearchDialog.this.isSeparator(string3.charAt(string3.indexOf(string2) + string2.length()))) {
                        bl = true;
                    }
                    if (SearchDialog.this.matchCase.isSelected() && string3.indexOf(string2) != -1) {
                        bl2 = true;
                    }
                    if (bl && (bl2 || !SearchDialog.this.matchCase.isSelected()) || bl2 && (bl || !SearchDialog.this.wholeWord.isSelected()) || !SearchDialog.this.wholeWord.isSelected() && !SearchDialog.this.matchCase.isSelected()) {
                        int[] nArray = new int[]{n, string3.length() - 1};
                        SearchDialog.this.localsOfLines.addElement(nArray);
                        ((DefaultListModel)this.list.getModel()).addElement(string3.trim());
                    }
                }
                bl = false;
                bl2 = false;
                n = n2 + 1;
                ++n3;
            }
        }

        private void selectLine(int n) {
            int[] nArray = (int[])SearchDialog.this.localsOfLines.elementAt(n);
            if (!((DesktopWindow)SearchDialog.this.window.getPane().getSelectedFrame() instanceof HelpMenu)) {
                ((DesktopWindow)SearchDialog.this.window.getPane().getSelectedFrame()).selectText(nArray[0], nArray[0] + nArray[1]);
            }
        }

        static /* synthetic */ SearchDialog access$300(ListLinesDialog listLinesDialog) {
            return listLinesDialog.SearchDialog.this;
        }

        static /* synthetic */ JList access$500(ListLinesDialog listLinesDialog) {
            return listLinesDialog.list;
        }

        static /* synthetic */ void access$600(ListLinesDialog listLinesDialog, int n) {
            listLinesDialog.selectLine(n);
        }
    }
}

