/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.abaco.gui;

import br.ufpe.abaco.gui.ExampleFileFilter;
import br.ufpe.abaco.gui.Interface;
import br.ufpe.abaco.gui.ProjectSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.JFileChooser;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class Project {
    String fileName = null;
    Hashtable definedSpecifications = new Hashtable();
    private boolean changed;

    Project(InputStream inputStream) throws Exception {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        Parser parser = sAXParser.getParser();
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(".");
        parser.setDocumentHandler(new ProjectDocumentHandler());
        parser.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String string, String string2) throws IOException {
                return new InputSource(ClassLoader.getSystemResource("Spec/" + string2).openStream());
            }
        });
        parser.parse(inputSource);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.definedSpecifications.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = this.definedSpecifications.get(string).toString();
            if (string2.length() > 20) {
                string2 = string2.substring(0, 20);
            }
            stringBuffer.append(string);
            stringBuffer.append("==>");
            stringBuffer.append(string2);
            stringBuffer.append("\n\n");
        }
        return stringBuffer.toString();
    }

    public void toNewFormat(OutputStream outputStream) {
        PrintStream printStream = new PrintStream(outputStream);
        printStream.println("<project>");
        Iterator iterator = this.definedSpecifications.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = this.definedSpecifications.get(string).toString();
            printStream.println("<specification name=\"" + string + "\">");
            printStream.println(string2);
            printStream.println("</specification>");
        }
        printStream.println("</project>");
    }

    public static void main(String[] stringArray) throws Exception {
        Project project = new Project(new FileInputStream("f:\\abaco\\micropascal.prj"));
        System.out.println("Lido");
        project.toNewFormat(new FileOutputStream("saida.xml"));
        System.out.println("Fim");
    }

    Project() {
    }

    Project(String string) throws Exception {
        this(new FileInputStream(string));
        this.fileName = string;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public boolean newSpecification(String string) {
        if (!this.definedSpecifications.containsKey(string)) {
            this.definedSpecifications.put(string, "");
            this.changed = true;
            return true;
        }
        return false;
    }

    public void removeAllFiles() {
        this.definedSpecifications = new Hashtable();
        this.changed = true;
    }

    void setSpecification(String string, String string2) {
        if (this.definedSpecifications.containsKey(string)) {
            this.definedSpecifications.put(string, string2);
            this.changed = true;
        }
    }

    String getSpecification(String string) {
        if (this.definedSpecifications.containsKey(string)) {
            return (String)this.definedSpecifications.get(string);
        }
        return null;
    }

    boolean containsSpecification(String string) {
        return this.definedSpecifications.containsKey(string);
    }

    void removeSpecification(String string) {
        this.definedSpecifications.remove(string);
        this.changed = true;
    }

    void removeSpecificationRecursive(String string) {
        String string2;
        Iterator<Object> iterator = this.definedSpecifications.keySet().iterator();
        HashSet<String> hashSet = new HashSet<String>();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            if (!string2.startsWith(string)) continue;
            hashSet.add(string2);
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            this.removeSpecification(string2);
        }
    }

    public void printPCData(PrintWriter printWriter, String string) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '<') {
                printWriter.print("&lt;");
            } else if (c == '>') {
                printWriter.print("&gt;");
            } else if (c == '&') {
                printWriter.print("&amp;");
            } else {
                printWriter.print(c);
            }
            ++n;
        }
    }

    public void saveProject(String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        PrintWriter printWriter = new PrintWriter(fileOutputStream);
        printWriter.println("<?xml version=\"1.0\" encoding=\"us-ascii\"?>");
        printWriter.println("<!DOCTYPE project SYSTEM \"projectDefinition.dtd\">");
        printWriter.println("<project>");
        printWriter.println("<project_name>Obsolete Field</project_name>");
        printWriter.println("<specifications>");
        Iterator iterator = this.definedSpecifications.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = (String)this.definedSpecifications.get(string2);
            printWriter.println("<file>");
            printWriter.print("<spec_name>");
            this.printPCData(printWriter, string2);
            printWriter.println("</spec_name>");
            printWriter.print("<spec_contents>");
            this.printPCData(printWriter, string3);
            printWriter.println("</spec_contents>");
            printWriter.println("</file>");
        }
        printWriter.println("</specifications>");
        printWriter.println("<libraries />\n<terms />\n<tools />");
        printWriter.println("</project>");
        printWriter.close();
    }

    public void saveProject() throws IOException {
        if (this.fileName == null) {
            this.fileName = this.chooseFileName();
            if (this.fileName == null) {
                return;
            }
        }
        this.saveProject(this.fileName);
        this.changed = false;
    }

    public String saveProjectAs() throws IOException {
        String string = this.chooseFileName();
        if (string == null) {
            return this.fileName;
        }
        this.saveProject(string);
        this.fileName = string;
        this.changed = false;
        return this.fileName;
    }

    public ProjectSource createSpecificationSource() {
        return new ProjectSource(this);
    }

    public String chooseFileName() {
        JFileChooser jFileChooser = new JFileChooser(new File("."));
        ExampleFileFilter exampleFileFilter = new ExampleFileFilter("prj", "Project Files");
        jFileChooser.setFileFilter(exampleFileFilter);
        int n = jFileChooser.showSaveDialog(Interface.getInterface());
        if (n != 0) {
            return null;
        }
        String string = jFileChooser.getSelectedFile().toString();
        if (!string.endsWith(".prj")) {
            string = string.concat(".prj");
        }
        return string;
    }

    public Iterator iterator() {
        return this.definedSpecifications.keySet().iterator();
    }

    class ProjectDocumentHandler
    implements DocumentHandler {
        final int ST_DONOTHING = 0;
        final int ST_FILE = 1;
        final int ST_FILENAME = 2;
        final int ST_CONTENTS = 3;
        int currState = 0;
        String specificationName = null;
        StringBuffer specificationSource = null;

        ProjectDocumentHandler() {
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            String string = new String(cArray, n, n2);
            switch (this.currState) {
                case 0: 
                case 1: {
                    break;
                }
                case 2: {
                    this.specificationName = this.specificationName + string;
                    break;
                }
                case 3: {
                    this.specificationSource.append(string);
                }
            }
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void startElement(String string, AttributeList attributeList) throws SAXException {
            if (string.equalsIgnoreCase("file") && this.currState == 0) {
                this.currState = 1;
                this.specificationSource = new StringBuffer();
                this.specificationName = "";
            } else if (string.equalsIgnoreCase("spec_name") && this.currState == 1) {
                this.currState = 2;
            } else if (string.equalsIgnoreCase("spec_contents") && this.currState == 1) {
                this.currState = 3;
            }
        }

        public void endElement(String string) throws SAXException {
            if (string.equalsIgnoreCase("file")) {
                Project.this.definedSpecifications.put(this.specificationName, this.specificationSource.toString());
                this.specificationName = null;
                this.specificationSource = null;
                this.currState = 0;
            } else if (string.equalsIgnoreCase("spec_name")) {
                this.currState = 1;
            } else if (string.equalsIgnoreCase("spec_contents")) {
                this.currState = 1;
            }
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        public void processingInstruction(String string, String string2) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
        }
    }
}

