/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.abaco.gui;

import br.ufpe.abaco.gui.SpecificationPrinter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.border.MatteBorder;

public class PrintPreview
extends JFrame {
    protected int m_wPage;
    protected int m_hPage;
    protected Printable m_target;
    protected JComboBox m_cbScale;
    protected PreviewContainer m_preview;
    protected int numberOfPages;

    public PrintPreview(Printable printable, PageFormat pageFormat) {
        this(printable, "Print Preview", pageFormat);
    }

    public PrintPreview(Printable printable, String string, final PageFormat pageFormat) {
        super(string);
        Object object;
        ((Component)this).setSize(600, 400);
        this.m_target = printable;
        JToolBar jToolBar = new JToolBar();
        JButton jButton = new JButton("Print", new ImageIcon(ClassLoader.getSystemResource("br/ufpe/abaco/icons/print.gif")));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrintPreview.this.dispose();
                Thread thread = new Thread(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        try {
                            Book book = new Book();
                            PrinterJob printerJob = PrinterJob.getPrinterJob();
                            if (1.access$000(this.this$1).m_target instanceof SpecificationPrinter) {
                                book.append(1.access$000(this.this$1).m_target, 1.access$100(this.this$1), 1.access$000(this.this$1).numberOfPages);
                                printerJob.setPageable(book);
                            } else {
                                printerJob.setPrintable(1.access$000(this.this$1).m_target, 1.access$100(this.this$1));
                            }
                            1.access$000(this.this$1).setCursor(Cursor.getPredefinedCursor(3));
                            printerJob.print();
                            if (1.access$000(this.this$1).m_target instanceof SpecificationPrinter && ((SpecificationPrinter)1.access$000(this.this$1).m_target).getPrintStatusDialog() != null) {
                                ((SpecificationPrinter)1.access$000(this.this$1).m_target).getPrintStatusDialog().dispose();
                            }
                            1.access$000(this.this$1).setCursor(Cursor.getPredefinedCursor(0));
                            JOptionPane.showMessageDialog(null, "Printing completed successfully", "Info", 1);
                        }
                        catch (PrinterException printerException) {
                            printerException.printStackTrace();
                            System.err.println("Printing error: " + printerException.toString());
                        }
                    }
                };
                thread.start();
            }

            static /* synthetic */ PrintPreview access$000(1 var0) {
                return var0.PrintPreview.this;
            }

            static /* synthetic */ PageFormat access$100(1 var0) {
                return var0.pageFormat;
            }
        };
        jButton.addActionListener(actionListener);
        jButton.setAlignmentY(0.5f);
        jButton.setMargin(new Insets(4, 6, 4, 6));
        jToolBar.add(jButton);
        jButton = new JButton("Close");
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrintPreview.this.dispose();
            }
        };
        jButton.addActionListener(actionListener);
        jButton.setAlignmentY(0.5f);
        jButton.setMargin(new Insets(2, 6, 2, 6));
        jToolBar.add(jButton);
        String[] stringArray = new String[]{"10 %", "25 %", "50 %", "100 %"};
        this.m_cbScale = new JComboBox<String>(stringArray);
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = new Thread(this){
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        String string = 4.access$200(this.this$1).m_cbScale.getSelectedItem().toString();
                        if (string.endsWith("%")) {
                            string = string.substring(0, string.length() - 1);
                        }
                        string = string.trim();
                        int n = 0;
                        try {
                            n = Integer.parseInt(string);
                        }
                        catch (NumberFormatException numberFormatException) {
                            return;
                        }
                        int n2 = 4.access$200(this.this$1).m_wPage * n / 100;
                        int n3 = 4.access$200(this.this$1).m_hPage * n / 100;
                        Component[] componentArray = 4.access$200(this.this$1).m_preview.getComponents();
                        int n4 = 0;
                        while (n4 < componentArray.length) {
                            if (componentArray[n4] instanceof PagePreview) {
                                PagePreview pagePreview = (PagePreview)componentArray[n4];
                                pagePreview.setScaledSize(n2, n3);
                            }
                            ++n4;
                        }
                        4.access$200(this.this$1).m_preview.doLayout();
                        4.access$200(this.this$1).m_preview.getParent().getParent().validate();
                    }
                };
                thread.start();
            }

            static /* synthetic */ PrintPreview access$200(4 var0) {
                return var0.PrintPreview.this;
            }
        };
        this.m_cbScale.addActionListener(actionListener);
        this.m_cbScale.setMaximumSize(this.m_cbScale.getPreferredSize());
        this.m_cbScale.setEditable(true);
        jToolBar.addSeparator();
        jToolBar.add(this.m_cbScale);
        this.getContentPane().add((Component)jToolBar, "North");
        this.m_preview = new PreviewContainer();
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (pageFormat.getHeight() == 0.0 || pageFormat.getWidth() == 0.0) {
            System.err.println("Unable to determine default page size");
            return;
        }
        this.m_wPage = (int)pageFormat.getWidth();
        this.m_hPage = (int)pageFormat.getHeight();
        int n = 10;
        int n2 = this.m_wPage * n / 100;
        int n3 = this.m_hPage * n / 100;
        int n4 = 0;
        try {
            while (true) {
                object = new BufferedImage(this.m_wPage, this.m_hPage, 1);
                Graphics graphics = ((BufferedImage)object).getGraphics();
                graphics.setColor(Color.white);
                graphics.fillRect(0, 0, this.m_wPage, this.m_hPage);
                if (printable.print(graphics, pageFormat, n4) == 0) {
                    PagePreview pagePreview = new PagePreview(n2, n3, (Image)object);
                    this.m_preview.add(pagePreview);
                    ++n4;
                    continue;
                }
                break;
            }
        }
        catch (PrinterException printerException) {
            printerException.printStackTrace();
            System.err.println("Printing error: " + printerException.toString());
        }
        this.numberOfPages = n4;
        if (this.m_target instanceof SpecificationPrinter) {
            ((SpecificationPrinter)this.m_target).setNumberOfPages(this.numberOfPages);
            ((SpecificationPrinter)this.m_target).showPrintStatus(true);
        }
        object = new JScrollPane(this.m_preview);
        this.getContentPane().add((Component)object, "Center");
        this.setDefaultCloseOperation(2);
        ((Component)this).setVisible(true);
    }

    class PagePreview
    extends JPanel {
        protected int m_w;
        protected int m_h;
        protected Image m_source;
        protected Image m_img;

        public PagePreview(int n, int n2, Image image) {
            this.m_w = n;
            this.m_h = n2;
            this.m_source = image;
            this.m_img = this.m_source.getScaledInstance(this.m_w, this.m_h, 4);
            this.m_img.flush();
            this.setBackground(Color.white);
            this.setBorder(new MatteBorder(1, 1, 2, 2, Color.black));
        }

        public void setScaledSize(int n, int n2) {
            this.m_w = n;
            this.m_h = n2;
            this.m_img = this.m_source.getScaledInstance(this.m_w, this.m_h, 4);
            this.repaint();
        }

        public Dimension getPreferredSize() {
            Insets insets = this.getInsets();
            return new Dimension(this.m_w + insets.left + insets.right, this.m_h + insets.top + insets.bottom);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void paint(Graphics graphics) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.drawImage(this.m_img, 0, 0, this);
            this.paintBorder(graphics);
        }
    }

    class PreviewContainer
    extends JPanel {
        protected int H_GAP = 16;
        protected int V_GAP = 10;

        PreviewContainer() {
        }

        public Dimension getPreferredSize() {
            int n = this.getComponentCount();
            if (n == 0) {
                return new Dimension(this.H_GAP, this.V_GAP);
            }
            Component component = this.getComponent(0);
            Dimension dimension = component.getPreferredSize();
            int n2 = dimension.width;
            int n3 = dimension.height;
            Dimension dimension2 = this.getParent().getSize();
            int n4 = Math.max((dimension2.width - this.H_GAP) / (n2 + this.H_GAP), 1);
            int n5 = n / n4;
            if (n5 * n4 < n) {
                ++n5;
            }
            int n6 = n4 * (n2 + this.H_GAP) + this.H_GAP;
            int n7 = n5 * (n3 + this.V_GAP) + this.V_GAP;
            Insets insets = this.getInsets();
            return new Dimension(n6 + insets.left + insets.right, n7 + insets.top + insets.bottom);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void doLayout() {
            Insets insets = this.getInsets();
            int n = insets.left + this.H_GAP;
            int n2 = insets.top + this.V_GAP;
            int n3 = this.getComponentCount();
            if (n3 == 0) {
                return;
            }
            Component component = this.getComponent(0);
            Dimension dimension = component.getPreferredSize();
            int n4 = dimension.width;
            int n5 = dimension.height;
            Dimension dimension2 = this.getParent().getSize();
            int n6 = Math.max((dimension2.width - this.H_GAP) / (n4 + this.H_GAP), 1);
            int n7 = n3 / n6;
            if (n7 * n6 < n3) {
                ++n7;
            }
            int n8 = 0;
            int n9 = 0;
            while (n9 < n7) {
                int n10 = 0;
                while (n10 < n6) {
                    if (n8 >= n3) {
                        return;
                    }
                    component = this.getComponent(n8++);
                    component.setBounds(n, n2, n4, n5);
                    n += n4 + this.H_GAP;
                    ++n10;
                }
                n2 += n5 + this.V_GAP;
                n = insets.left + this.H_GAP;
                ++n9;
            }
        }
    }
}

