/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.abaco.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class PageSetupDialog
extends JDialog {
    private PageFormat pageFormat;
    private Hashtable paperTypesAndSizes = new Hashtable();
    private JComboBox paperTypes;
    private ImageIcon portraitIcon = new ImageIcon(ClassLoader.getSystemResource("br/ufpe/abaco/icons/portrait.gif"));
    private ImageIcon landscapeIcon = new ImageIcon(ClassLoader.getSystemResource("br/ufpe/abaco/icons/landscape.gif"));
    private ImageIcon reverseLandscapeIcon = new ImageIcon(ClassLoader.getSystemResource("br/ufpe/abaco/icons/reverse_landscape.gif"));
    private JLabel orientationIcon = new JLabel(this.portraitIcon);
    private JRadioButton portrait = new JRadioButton("Portrait", true);
    private JRadioButton landscape = new JRadioButton("Landscape");
    private JRadioButton reverseLandscape = new JRadioButton("Reverse Landscape");
    private ButtonGroup btnGroup = new ButtonGroup();
    private JLabel paper = new JLabel("Paper: ");
    private JLabel leftLabel = new JLabel("Left ");
    private JLabel rightLabel = new JLabel("Right ");
    private JLabel topLabel = new JLabel("Top ");
    private JLabel bottomLabel = new JLabel("Bottom ");
    private JTextField left = new JTextField(20);
    private JTextField right = new JTextField(20);
    private JTextField top = new JTextField(20);
    private JTextField bottom = new JTextField(20);
    private JButton ok = new JButton("OK");
    private JButton cancel = new JButton("Cancel");
    private JLabel pageView = new JLabel();
    private int previousOrientation = 0;

    public PageSetupDialog(JFrame jFrame) {
        super(jFrame, "Page Setup", true);
        String string = "         ";
        this.btnGroup.add(this.portrait);
        this.portrait.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (PageSetupDialog.this.portrait.isSelected()) {
                    PageSetupDialog.this.orientationIcon.setIcon(PageSetupDialog.this.portraitIcon);
                }
                PageSetupDialog.this.pageView.setIcon(PageSetupDialog.this.paintPageView(PageSetupDialog.this.paperTypes.getSelectedItem()));
                if (PageSetupDialog.this.previousOrientation == 0) {
                    String string = PageSetupDialog.this.left.getText();
                    String string2 = PageSetupDialog.this.right.getText();
                    String string3 = PageSetupDialog.this.top.getText();
                    String string4 = PageSetupDialog.this.bottom.getText();
                    PageSetupDialog.this.top.setText(string);
                    PageSetupDialog.this.left.setText(string4);
                    PageSetupDialog.this.bottom.setText(string2);
                    PageSetupDialog.this.right.setText(string3);
                }
                PageSetupDialog.this.previousOrientation = 1;
            }
        });
        this.btnGroup.add(this.landscape);
        this.landscape.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (PageSetupDialog.this.landscape.isSelected()) {
                    PageSetupDialog.this.orientationIcon.setIcon(PageSetupDialog.this.landscapeIcon);
                }
                if (PageSetupDialog.this.previousOrientation == 1 || PageSetupDialog.this.previousOrientation == 2) {
                    String string = PageSetupDialog.this.left.getText();
                    String string2 = PageSetupDialog.this.right.getText();
                    String string3 = PageSetupDialog.this.top.getText();
                    String string4 = PageSetupDialog.this.bottom.getText();
                    PageSetupDialog.this.left.setText(string3);
                    PageSetupDialog.this.top.setText(string2);
                    PageSetupDialog.this.bottom.setText(string);
                    PageSetupDialog.this.right.setText(string4);
                }
                PageSetupDialog.this.pageView.setIcon(PageSetupDialog.this.paintPageView(PageSetupDialog.this.paperTypes.getSelectedItem()));
                PageSetupDialog.this.previousOrientation = 0;
            }
        });
        this.btnGroup.add(this.reverseLandscape);
        this.reverseLandscape.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (PageSetupDialog.this.reverseLandscape.isSelected()) {
                    PageSetupDialog.this.orientationIcon.setIcon(PageSetupDialog.this.reverseLandscapeIcon);
                }
                if (PageSetupDialog.this.previousOrientation == 0) {
                    String string = PageSetupDialog.this.left.getText();
                    String string2 = PageSetupDialog.this.right.getText();
                    String string3 = PageSetupDialog.this.top.getText();
                    String string4 = PageSetupDialog.this.bottom.getText();
                    PageSetupDialog.this.top.setText(string);
                    PageSetupDialog.this.left.setText(string4);
                    PageSetupDialog.this.bottom.setText(string2);
                    PageSetupDialog.this.right.setText(string3);
                }
                PageSetupDialog.this.pageView.setIcon(PageSetupDialog.this.paintPageView(PageSetupDialog.this.paperTypes.getSelectedItem()));
                PageSetupDialog.this.previousOrientation = 2;
            }
        });
        this.paperTypesAndSizes.put("US Letter", new double[]{215.9, 279.4});
        this.paperTypesAndSizes.put("US Legal", new double[]{215.9, 355.6});
        this.paperTypesAndSizes.put("A4", new double[]{210.0, 297.0});
        this.paperTypesAndSizes.put("B5", new double[]{182.0, 257.1});
        this.paperTypes = new JComboBox<Object>(this.paperTypesAndSizes.keySet().toArray());
        this.paperTypes.addItem(string + string + string);
        this.paperTypes.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PageSetupDialog.this.pageView.setIcon(PageSetupDialog.this.paintPageView(PageSetupDialog.this.paperTypes.getSelectedItem()));
            }
        });
        this.pageView.setBorder(BorderFactory.createMatteBorder(1, 1, 2, 2, Color.black));
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 5, 10);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.paper, gridBagConstraints);
        jPanel.add(this.paper);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 0, 10, 10);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.paperTypes, gridBagConstraints);
        jPanel.add(this.paperTypes);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(3, 1));
        jPanel2.add(this.portrait);
        jPanel2.add(this.landscape);
        jPanel2.add(this.reverseLandscape);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createTitledBorder("Orientation"));
        gridBagLayout = new GridBagLayout();
        gridBagConstraints = new GridBagConstraints();
        jPanel3.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.orientationIcon, gridBagConstraints);
        jPanel3.add(this.orientationIcon);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel3.add(jPanel2);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(2, 4, 30, 20));
        jPanel4.add(this.leftLabel);
        jPanel4.add(this.left);
        this.left.addInputMethodListener(new InputMethodListener(){

            public void inputMethodTextChanged(InputMethodEvent inputMethodEvent) {
                PageSetupDialog.this.pageView.setIcon(PageSetupDialog.this.paintPageView(PageSetupDialog.this.paperTypes.getSelectedItem()));
            }

            public void caretPositionChanged(InputMethodEvent inputMethodEvent) {
            }
        });
        jPanel4.add(this.topLabel);
        jPanel4.add(this.top);
        this.top.addInputMethodListener(new InputMethodListener(){

            public void inputMethodTextChanged(InputMethodEvent inputMethodEvent) {
                PageSetupDialog.this.pageView.setIcon(PageSetupDialog.this.paintPageView(PageSetupDialog.this.paperTypes.getSelectedItem()));
            }

            public void caretPositionChanged(InputMethodEvent inputMethodEvent) {
            }
        });
        jPanel4.add(this.rightLabel);
        jPanel4.add(this.right);
        this.right.addInputMethodListener(new InputMethodListener(){

            public void inputMethodTextChanged(InputMethodEvent inputMethodEvent) {
                PageSetupDialog.this.pageView.setIcon(PageSetupDialog.this.paintPageView(PageSetupDialog.this.paperTypes.getSelectedItem()));
            }

            public void caretPositionChanged(InputMethodEvent inputMethodEvent) {
            }
        });
        jPanel4.add(this.bottomLabel);
        jPanel4.add(this.bottom);
        this.bottom.addInputMethodListener(new InputMethodListener(){

            public void inputMethodTextChanged(InputMethodEvent inputMethodEvent) {
                PageSetupDialog.this.pageView.setIcon(PageSetupDialog.this.paintPageView(PageSetupDialog.this.paperTypes.getSelectedItem()));
            }

            public void caretPositionChanged(InputMethodEvent inputMethodEvent) {
            }
        });
        jPanel4.setBorder(new CompoundBorder(new TitledBorder("Margins (in milimeters)"), new EmptyBorder(10, 10, 10, 10)));
        jPanel4.setPreferredSize(new Dimension(406, 110));
        jPanel4.setMinimumSize(new Dimension(406, 110));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(1, 2, 10, 0));
        jPanel5.add(this.ok);
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PageSetupDialog.this.getParameters();
                ((Component)PageSetupDialog.this).setVisible(false);
            }
        });
        jPanel5.add(this.cancel);
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)PageSetupDialog.this).setVisible(false);
            }
        });
        JPanel jPanel6 = new JPanel();
        gridBagLayout = new GridBagLayout();
        gridBagConstraints = new GridBagConstraints();
        jPanel6.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 10);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        jPanel6.add(jPanel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel6.add(jPanel3);
        JPanel jPanel7 = new JPanel();
        jPanel7.setBorder(BorderFactory.createTitledBorder("View"));
        gridBagLayout = new GridBagLayout();
        gridBagConstraints = new GridBagConstraints();
        jPanel7.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jPanel7, gridBagConstraints);
        this.pageView.setIcon(this.paintPageView(this.paperTypes.getSelectedItem()));
        jPanel7.setPreferredSize(new Dimension(176, 186));
        jPanel7.setMinimumSize(new Dimension(176, 186));
        jPanel7.add(this.pageView);
        JPanel jPanel8 = new JPanel();
        gridBagLayout = new GridBagLayout();
        gridBagConstraints = new GridBagConstraints();
        jPanel8.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jPanel6, gridBagConstraints);
        jPanel8.add(jPanel6);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 10);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(jPanel7, gridBagConstraints);
        jPanel8.add(jPanel7);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel8.add(jPanel4);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(jPanel5, gridBagConstraints);
        jPanel8.add(jPanel5);
        this.getContentPane().add(jPanel8);
        ((Component)this).setSize(470, 430);
        this.setResizable(false);
        ((Component)this).setLocation((jFrame.getWidth() + jFrame.getX() - 470) / 2, (jFrame.getHeight() + jFrame.getY() - 430) / 2);
        this.pack();
    }

    private void setParameters() {
        double d;
        double d2;
        double d3 = this.pageFormat.getImageableX() * 0.35277777777777775;
        double d4 = this.pageFormat.getImageableY() * 0.35277777777777775;
        double d5 = (this.pageFormat.getWidth() - this.pageFormat.getImageableWidth() - this.pageFormat.getImageableX()) * 0.35277777777777775;
        double d6 = (this.pageFormat.getHeight() - this.pageFormat.getImageableHeight() - this.pageFormat.getImageableY()) * 0.35277777777777775;
        int n = this.pageFormat.getOrientation();
        if (n == 1) {
            d2 = this.pageFormat.getHeight() * 0.35277777777777775;
            d = this.pageFormat.getWidth() * 0.35277777777777775;
        } else {
            d2 = this.pageFormat.getWidth() * 0.35277777777777775;
            d = this.pageFormat.getHeight() * 0.35277777777777775;
        }
        this.left.setText(d3 + "");
        this.top.setText(d4 + "");
        this.right.setText(d5 + "");
        this.bottom.setText(d6 + "");
        if (n == 1) {
            this.portrait.setSelected(true);
        } else if (n == 0) {
            this.landscape.setSelected(true);
        } else {
            this.reverseLandscape.setSelected(true);
        }
        Enumeration enumeration = this.paperTypesAndSizes.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            double[] dArray = (double[])this.paperTypesAndSizes.get(k);
            if (Math.round(dArray[0]) != Math.round(d) || Math.round(dArray[1]) != Math.round(d2)) continue;
            this.paperTypes.setSelectedItem(k.toString());
            break;
        }
    }

    public void getParameters() {
        try {
            double d = Double.parseDouble(this.left.getText().trim()) * 2.834645669291339;
            double d2 = Double.parseDouble(this.top.getText().trim()) * 2.834645669291339;
            double d3 = Double.parseDouble(this.right.getText().trim()) * 2.834645669291339;
            double d4 = Double.parseDouble(this.bottom.getText().trim()) * 2.834645669291339;
            double[] dArray = (double[])this.paperTypesAndSizes.get(this.paperTypes.getSelectedItem());
            Paper paper = new Paper();
            double d5 = dArray[0] * 2.834645669291339;
            double d6 = dArray[1] * 2.834645669291339;
            int n = this.portrait.isSelected() ? 1 : (this.landscape.isSelected() ? 0 : 2);
            double d7 = d5 - d - d3;
            double d8 = d6 - d2 - d4;
            paper.setSize(d5, d6);
            paper.setImageableArea(d, d2, d7, d8);
            this.pageFormat.setOrientation(n);
            this.pageFormat.setPaper(paper);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(null, numberFormatException.getMessage(), "Internal Error", 0);
        }
    }

    private Icon paintPageView(Object object) {
        double[] dArray = (double[])this.paperTypesAndSizes.get(object);
        double d = 2.2;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        if (this.portrait.isSelected()) {
            n7 = (int)(dArray[0] / d);
            n8 = (int)(dArray[1] / d);
        } else {
            n7 = (int)(dArray[1] / d);
            n8 = (int)(dArray[0] / d);
        }
        try {
            n = (int)(Double.parseDouble(this.left.getText()) / d);
            n2 = (int)(Double.parseDouble(this.right.getText()) / d);
            n3 = (int)(Double.parseDouble(this.top.getText()) / d);
            n4 = (int)(Double.parseDouble(this.bottom.getText()) / d);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        n6 = n8 - n3 - n4;
        n5 = n7 - n - n2;
        BufferedImage bufferedImage = new BufferedImage(n7, n8, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, n7, n8);
        graphics2D.setColor(Color.black);
        int n9 = n3;
        while (n9 <= n8 - n4) {
            if (n5 <= 0 || n6 <= 0) break;
            if (n9 == n3) {
                graphics2D.drawLine(n + 10, n9, n7 - n2, n9);
            } else {
                graphics2D.drawLine(n, n9, n7 - n2, n9);
            }
            n9 += 8;
        }
        graphics2D.drawImage(bufferedImage, null, 0, 0);
        System.gc();
        return new ImageIcon(bufferedImage);
    }

    public PageFormat getNewPageFormat() {
        return this.pageFormat;
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.pageFormat = pageFormat;
        this.setParameters();
    }
}

