/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.abaco.gui;

import br.ufpe.abaco.gui.AbacoTreeListener;
import br.ufpe.abaco.gui.AbacoTreeViewer;
import br.ufpe.abaco.gui.ActionEvaluator;
import br.ufpe.abaco.gui.CompilerWindow;
import br.ufpe.abaco.gui.DesktopWindow;
import br.ufpe.abaco.gui.ExampleFileFilter;
import br.ufpe.abaco.gui.Exporter;
import br.ufpe.abaco.gui.HelpMenu;
import br.ufpe.abaco.gui.MethodActionListener;
import br.ufpe.abaco.gui.OpenedWindows;
import br.ufpe.abaco.gui.PageSetupDialog;
import br.ufpe.abaco.gui.PrintPreview;
import br.ufpe.abaco.gui.Project;
import br.ufpe.abaco.gui.ReplaceDialog;
import br.ufpe.abaco.gui.SearchDialog;
import br.ufpe.abaco.gui.SpecificationEditor;
import br.ufpe.abaco.gui.SpecificationPrinter;
import br.ufpe.abaco.gui.URLBrowser;
import br.ufpe.abaco.gui.XmlParser;
import com.sun.xml.tree.XmlDocument;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class Interface
extends JFrame {
    JSplitPane splitPane = new JSplitPane();
    JPanel messagesPanel = new JPanel();
    JLabel labelMessage = new JLabel(" ");
    JLabel helpMessage = new JLabel(" ");
    AbacoTreeViewer projectTree = new AbacoTreeViewer(true);
    JScrollPane scrollPane = new JScrollPane(this.projectTree);
    Project prj;
    private HelpSet mainHS = null;
    private HelpBroker mainHB = null;
    private String helpSetName = "doc/HelpABACO.hs";
    String abacoPath;
    OpenedWindows windows = new OpenedWindows();
    DesktopWindow f;
    private static Hashtable reflections = new Hashtable();
    JMenuBar menuBar = new JMenuBar();
    Hashtable name2menu = new Hashtable();
    JMenu fileMenu = new JMenu();
    JMenu editMenu = new JMenu();
    JMenu toolsMenu = new JMenu();
    JMenu helpMenu = new JMenu();
    JMenu newMenu = new JMenu();
    JMenu windowMenu = new JMenu();
    JMenu recentFilesMenu = new JMenu();
    PageFormat pageFormat = new PageFormat();
    File pageSetupFile = null;
    File pageSetupParametersFile = null;
    Vector recentFiles = new Vector();
    ReplaceDialog replaceDialog;
    SearchDialog searchDialog;
    boolean closing = false;
    static Interface currInterface = null;

    JMenu addMenuBar(String string, String string2) {
        JMenu jMenu = new JMenu();
        jMenu.setText(string);
        if (string2 == null) {
            this.menuBar.add(jMenu);
        } else {
            Object v = this.name2menu.get(string2);
            if (!(v instanceof JMenu)) {
                return null;
            }
            JMenu jMenu2 = (JMenu)v;
            jMenu2.add(jMenu);
        }
        this.name2menu.put(string, jMenu);
        return jMenu;
    }

    JMenuItem addMenuItem(String string, String string2, String string3) {
        Object v = this.name2menu.get(string3);
        if (!(v instanceof JMenu)) {
            return null;
        }
        JMenu jMenu = (JMenu)v;
        AbacoMenuItem abacoMenuItem = new AbacoMenuItem();
        abacoMenuItem.setText(string);
        abacoMenuItem.setAccelerator(KeyStroke.getKeyStroke(string2));
        abacoMenuItem.setEnabled(false);
        this.name2menu.put(string, abacoMenuItem);
        return abacoMenuItem;
    }

    void addActionListener(String string, ActionListener actionListener) {
        JMenuItem jMenuItem = (JMenuItem)this.name2menu.get(string);
        jMenuItem.addActionListener(actionListener);
        jMenuItem.setEnabled(true);
    }

    void removeActionListener(String string, ActionListener actionListener) {
        JMenuItem jMenuItem = (JMenuItem)this.name2menu.get(string);
        jMenuItem.removeActionListener(actionListener);
        jMenuItem.setEnabled(true);
    }

    public Interface() {
        currInterface = this;
        try {
            this.jbInit();
            this.replaceDialog = new ReplaceDialog(this);
            this.searchDialog = new SearchDialog(this);
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            JOptionPane.showMessageDialog(this, string, "Error", 0);
        }
    }

    public static void main(String[] stringArray) {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Interface interface_ = new Interface();
        if (stringArray.length == 1) {
            interface_.open(stringArray[0]);
            interface_.setTitle("The ABACO System - " + stringArray[0]);
        }
    }

    private void jbInit() throws Exception {
        Object object;
        Object object2;
        this.setJMenuBar(this.menuBar);
        this.setTitle("The ABACO System");
        this.enableEvents(64L);
        this.fileMenu.setText("File");
        this.editMenu.setText("Edit");
        this.toolsMenu.setText("Tools");
        this.helpMenu.setText("Help");
        this.newMenu.setText("New");
        this.windowMenu.setText("Window");
        this.recentFilesMenu.setText("Recent Files");
        this.getContentPane().add((Component)this.splitPane, "Center");
        this.splitPane.add((Component)this.scrollPane, "left");
        this.splitPane.add((Component)this.windows, "right");
        this.buildMenuItem(this.newMenu, "new specification", "Specification", "alt S", false, new MethodActionListener(this, "newSpecification"));
        this.buildMenuItem(this.newMenu, "new project", "Project", "alt P", true, new MethodActionListener(this, "newProject"));
        this.buildMenuItem(this.newMenu, "new action editor v1", "Action Editor (Version 1)", null, true, new MethodActionListener(this, "newActionEditorV1"));
        this.buildMenuItem(this.newMenu, "new action editor v2", "Action Editor (Version 2)", null, false, null);
        this.fileMenu.add(this.newMenu);
        this.buildMenuItem(this.fileMenu, "open project", "Open ...", "ctrl O", true, new MethodActionListener(this, "openProject"));
        this.buildMenuItem(this.fileMenu, "save project", "Save", "ctrl S", false, new MethodActionListener(this, "saveProject"));
        this.buildMenuItem(this.fileMenu, "save project as", "Save As", null, false, new MethodActionListener(this, "saveProjectAs"));
        this.buildMenuItem(this.fileMenu, "close", "Close", "alt C", false, new MethodActionListener(this, "close"));
        this.buildMenuItem(this.fileMenu, "remove specification", "Remove Specification", "DELETE", false, new MethodActionListener(this, "removeSpecification"));
        this.fileMenu.addSeparator();
        this.buildMenuItem(this.fileMenu, "page setup", "Page Setup...", null, true, new MethodActionListener(this, "pageSetup"));
        this.buildMenuItem(this.fileMenu, "print", "Print ...", null, true, new MethodActionListener(this, "print"));
        this.buildMenuItem(this.fileMenu, "print preview", "Print Preview...", null, true, new MethodActionListener(this, "printPreview"));
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.recentFilesMenu);
        this.recentFilesMenu.add(new JMenuItem("(Empty)"));
        this.fileMenu.addSeparator();
        this.buildMenuItem(this.fileMenu, "exit", "Exit", "alt E", true, new MethodActionListener(this, "exit"));
        this.buildMenuItem(this.editMenu, "copy", "Copy", "ctrl C", false, new MethodActionListener(this, "copy"));
        this.buildMenuItem(this.editMenu, "paste", "Paste", "ctrl V", false, new MethodActionListener(this, "paste"));
        this.buildMenuItem(this.editMenu, "cut", "Cut", "ctrl X", false, new MethodActionListener(this, "cut"));
        this.buildMenuItem(this.editMenu, "select all", "Select All", "ctrl A", false, new MethodActionListener(this, "selectAll"));
        this.buildMenuItem(this.editMenu, "undo", "Undo", "ctrl Z", false, new MethodActionListener(this, "undo"));
        this.buildMenuItem(this.editMenu, "redo", "Redo", "ctrl Y", false, new MethodActionListener(this, "redo"));
        this.editMenu.addSeparator();
        this.buildMenuItem(this.editMenu, "search", "Search", "ctrl E", false, new MethodActionListener(this, "search"));
        this.buildMenuItem(this.editMenu, "replace", "Replace", "ctrl R", false, new MethodActionListener(this, "replace"));
        this.buildMenuItem(this.toolsMenu, "compile", "Compile", "alt X", false, new MethodActionListener(this, "compile"));
        this.buildMenuItem(this.toolsMenu, "action perform", "Interpret Action", "alt I", false, null);
        this.buildMenuItem(this.toolsMenu, "action debug", "Debug Action", "alt D", false, null);
        this.buildMenuItem(this.toolsMenu, "export", "Export Text ...", null, false, new MethodActionListener(this, "exportProject"));
        this.buildMenuItem(this.toolsMenu, "save code", "Save Generated Code ...", null, false, null);
        this.buildMenuItem(this.windowMenu, "close all", "Close All Windows", null, false, new MethodActionListener(this, "closeAll"));
        this.buildMenuItem(this.windowMenu, "cascade windows", "Cascade", null, false, new MethodActionListener(this, "cascadeWindows"));
        this.projectTree.insertMenuItem("Compile", true, false, false);
        this.projectTree.insertMenuItem("Edit", true, false, false);
        this.projectTree.insertMenuItem("Delete", true, false, false);
        this.projectTree.insertMenuItem("Delete Recursive", true, true, false);
        this.projectTree.insertMenuItem("Save Project", true, true, true);
        this.projectTree.insertMenuItem("New Specification", true, true, true);
        this.projectTree.insertMenuItem("Export", true, false, false);
        this.projectTree.addAbacoTreeListener(new AbacoTreeListener(){

            public void actionMenu(String string, String string2) {
                if (string.equals("Compile")) {
                    Interface.this.compile();
                } else if (string.equals("Export")) {
                    Interface.this.exportProject();
                } else if (string.equals("Delete")) {
                    Interface.this.removeSpecification();
                } else if (string.equals("Delete Recursive")) {
                    Interface.this.removeRecursivelySpecification(string2);
                } else if (string.equals("New Specification")) {
                    Interface.this.newSpecification(string2 != null ? string2 : "");
                } else if (string.equals("Save Project")) {
                    Interface.this.saveProject();
                } else if (string.equals("Edit")) {
                    Interface.this.openSpecification(string2);
                }
            }

            public void doubleSelected(String string) {
                Interface.this.openSpecification(string);
            }

            public void selected(String string) {
            }
        });
        try {
            object2 = this.getClass().getClassLoader();
            object = HelpSet.findHelpSet((ClassLoader)object2, this.helpSetName);
            this.mainHS = new HelpSet((ClassLoader)object2, (URL)object);
            this.mainHB = this.mainHS.createHelpBroker();
            this.mainHB.enableHelpKey(this.getRootPane(), "Help", this.mainHS);
        }
        catch (HelpSetException helpSetException) {
            System.out.println("Problems parsing the helpset");
            return;
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            System.err.println("initialization error:");
            exceptionInInitializerError.getException().printStackTrace();
        }
        this.buildMenuItem(this.helpMenu, "help contents", "Help Contents ...", null, true, new CSH.DisplayHelpFromSource(this.mainHB));
        this.helpMenu.addSeparator();
        this.buildMenuItem(this.helpMenu, "about", "About", null, true, new MethodActionListener(this, "about"));
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.editMenu);
        this.menuBar.add(this.toolsMenu);
        this.menuBar.add(this.windowMenu);
        this.menuBar.add(this.helpMenu);
        this.splitPane.setDividerLocation(80);
        this.buildMessagesPanel();
        ((Component)this).setSize(700, 600);
        ((Component)this).setVisible(true);
        object2 = ClassLoader.getSystemResource("br/ufpe/abaco/pageSetup.xml");
        object = this.pageFormat.getPaper();
        try {
            if (object2 != null) {
                XmlDocument xmlDocument;
                Object object3;
                XmlParser xmlParser = new XmlParser();
                if (((URL)object2).toString().startsWith("jar")) {
                    int n;
                    object3 = (JarURLConnection)((URL)object2).openConnection();
                    JarFile jarFile = ((JarURLConnection)object3).getJarFile();
                    JarEntry jarEntry = jarFile.getJarEntry("br/ufpe/abaco/pageSetup.xml");
                    InputStream inputStream = jarFile.getInputStream(jarEntry);
                    FileOutputStream fileOutputStream = null;
                    byte[] byArray = new byte[10240];
                    if (this.pageSetupFile == null) {
                        this.pageSetupFile = File.createTempFile("pageSetup", "xml");
                    }
                    fileOutputStream = new FileOutputStream(this.pageSetupFile);
                    while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                    inputStream.close();
                    fileOutputStream.close();
                    String string = this.pageSetupFile.getPath();
                    jarEntry = jarFile.getJarEntry("br/ufpe/abaco/pageSetupParameters.dtd");
                    inputStream = jarFile.getInputStream(jarEntry);
                    if (this.pageSetupParametersFile == null) {
                        this.pageSetupParametersFile = new File(this.pageSetupFile.getParent(), "pageSetupParameters.dtd");
                    }
                    fileOutputStream = new FileOutputStream(this.pageSetupParametersFile);
                    while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                    inputStream.close();
                    fileOutputStream.close();
                    xmlDocument = xmlParser.parseXmlFile(this.pageSetupParametersFile.getPath(), string);
                } else {
                    String string = ((URL)object2).getPath();
                    xmlDocument = xmlParser.parseXmlFile("pageSetupParameters.dtd", string);
                }
                object3 = xmlDocument.getFirstChild().getChildNodes();
                double d = Double.parseDouble(object3.item(0).getFirstChild().getNodeValue());
                double d2 = Double.parseDouble(object3.item(1).getFirstChild().getNodeValue());
                double d3 = Double.parseDouble(object3.item(3).getFirstChild().getNodeValue());
                double d4 = Double.parseDouble(object3.item(4).getFirstChild().getNodeValue());
                double d5 = Double.parseDouble(object3.item(5).getFirstChild().getNodeValue());
                double d6 = Double.parseDouble(object3.item(6).getFirstChild().getNodeValue());
                String string = object3.item(2).getAttributes().item(0).getNodeValue().trim();
                int n = string.equals("PORTRAIT") ? 1 : (string.equals("LANDSCAPE") ? 0 : 2);
                ((Paper)object).setSize(d2, d);
                this.pageFormat.setOrientation(n);
                ((Paper)object).setImageableArea(d3, d4, d5, d6);
                this.pageFormat.setPaper((Paper)object);
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.windows, "Your settings to page setup couldnt' be loaded.\nReason:" + exception.getMessage(), "Internal Error", 0);
        }
    }

    public void processWindowEvent(WindowEvent windowEvent) {
        int n = windowEvent.getID();
        int n2 = 2;
        if (n == 201) {
            n2 = this.closeCurrentProject();
            if (n2 != 2) {
                super.processWindowEvent(windowEvent);
                System.exit(0);
            }
        } else {
            super.processWindowEvent(windowEvent);
        }
    }

    public void buildMessagesPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.messagesPanel.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        gridBagConstraints.fill = 2;
        JLabel jLabel = this.labelMessage;
        jLabel.setForeground(Color.black);
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jLabel.setBorder(new BevelBorder(1));
        this.messagesPanel.add(jLabel);
        jLabel = new JLabel(" ");
        jLabel.setForeground(Color.black);
        gridBagConstraints.weightx = 2.0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jLabel.setBorder(new BevelBorder(1));
        this.messagesPanel.add(jLabel);
        jLabel = this.helpMessage;
        jLabel.setForeground(Color.black);
        gridBagConstraints.weightx = 4.0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jLabel.setBorder(new BevelBorder(1));
        this.messagesPanel.add(jLabel);
        this.getContentPane().add((Component)this.messagesPanel, "South");
    }

    public void openURL(String string, String string2, boolean bl, boolean bl2) {
        new URLBrowser(string, string2, bl, bl2);
    }

    public void newActionEditorV1() {
        ActionEvaluator actionEvaluator = new ActionEvaluator(1);
    }

    public void showHelpContents() {
        HelpMenu helpMenu = new HelpMenu("Help Contents", "doc/index.html");
    }

    public void about() {
        this.openURL("doc/about.htm", "About", false, true);
    }

    public void openProject() {
        JFileChooser jFileChooser = new JFileChooser(new File("."));
        ExampleFileFilter exampleFileFilter = new ExampleFileFilter("prj", "Project Files");
        jFileChooser.addChoosableFileFilter(new ExampleFileFilter("an", "Action Version 1 Files"));
        jFileChooser.addChoosableFileFilter(new ExampleFileFilter("an2", "Action Version 2 Files"));
        jFileChooser.addChoosableFileFilter(exampleFileFilter);
        int n = jFileChooser.showOpenDialog(Interface.getInterface());
        if (n == 0) {
            String string = jFileChooser.getSelectedFile().toString();
            this.open(string);
        }
    }

    void initializeProjectTree() {
        this.projectTree.removeAll();
        if (this.prj == null) {
            return;
        }
        Iterator iterator = this.prj.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.projectTree.insertItem(string);
        }
    }

    public void open(String string) {
        boolean bl = true;
        if (string.endsWith(".prj")) {
            if (this.closeCurrentProject() == 2) {
                return;
            }
            try {
                this.prj = new Project(string);
                this.initializeProjectTree();
                this.enableItens(this.getMenuItens(new String[]{"export", "compile", "save project", "save project as", "close", "remove specification", "new specification"}));
            }
            catch (Exception exception) {
                String string2 = "Project Reading error" + exception;
                JOptionPane.showMessageDialog(null, string2, "Error", 0);
                this.prj = null;
                return;
            }
            this.setTitle("The ABACO System - " + string);
            if (this.recentFiles.size() < 10) {
                int n = 0;
                while (n < this.recentFiles.size()) {
                    if (string.equals((String)this.recentFiles.get(n))) {
                        bl = false;
                        break;
                    }
                    ++n;
                }
                if (bl) {
                    if (this.recentFilesMenu.getItemCount() == 1 && this.recentFilesMenu.getItem(0).getText().equals("(Empty)")) {
                        this.recentFilesMenu.remove(0);
                    }
                    this.recentFiles.add(string);
                    this.recentFilesMenu.add(new ProjectFileMenuItem(string, this.recentFiles.size() - 1));
                }
            }
        } else if (string.endsWith(".an")) {
            new ActionEvaluator(1, string);
        } else if (string.endsWith(".an2")) {
            new ActionEvaluator(2, string);
        }
    }

    public void saveProject() {
        if (this.prj != null) {
            try {
                this.prj.saveProject();
            }
            catch (Exception exception) {
                String string = "Impossible save project " + exception.getMessage();
                JOptionPane.showMessageDialog(this.windows, string, "Error", 0);
            }
        }
    }

    public void saveProjectAs() {
        if (this.prj != null) {
            try {
                String string = this.prj.saveProjectAs();
                if (!string.equals(null)) {
                    Interface.getInterface().setTitle("The ABACO System - " + string);
                }
            }
            catch (Exception exception) {
                String string = "Impossible save project " + exception.getMessage();
                JOptionPane.showMessageDialog(this.windows, string, "Error", 0);
            }
        }
    }

    public void close() {
        int n = this.closeCurrentProject();
        if (n == 0 || n == 1) {
            this.setTitle("The ABACO System");
        }
    }

    public void exit() {
        int n = this.closeCurrentProject();
        if (n == 0 || n == 1) {
            System.exit(0);
        }
    }

    public void copy() {
        DesktopWindow desktopWindow = (DesktopWindow)this.windows.getSelectedFrame();
        if (desktopWindow != null) {
            desktopWindow.copy();
        }
    }

    public void paste() {
        DesktopWindow desktopWindow = (DesktopWindow)this.windows.getSelectedFrame();
        if (desktopWindow != null) {
            desktopWindow.paste();
        }
    }

    public void cut() {
        DesktopWindow desktopWindow = (DesktopWindow)this.windows.getSelectedFrame();
        if (desktopWindow != null) {
            desktopWindow.cut();
        }
    }

    public void undo() {
        UndoManager undoManager = ((DesktopWindow)this.windows.getSelectedFrame()).getUndoManager();
        if (undoManager != null) {
            try {
                undoManager.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                JOptionPane.showMessageDialog(this.windows, "Unable to undo: " + cannotUndoException, "Error", 0);
            }
            Interface.updateUndo(undoManager);
        }
    }

    public void redo() {
        UndoManager undoManager = ((DesktopWindow)this.windows.getSelectedFrame()).getUndoManager();
        if (undoManager != null) {
            try {
                undoManager.redo();
            }
            catch (CannotRedoException cannotRedoException) {
                JOptionPane.showMessageDialog(this.windows, "Unable to redo: " + cannotRedoException, "Error", 0);
            }
            Interface.updateUndo(undoManager);
        }
    }

    public static void updateUndo(UndoManager undoManager) {
        if (undoManager.canUndo()) {
            ((JMenuItem)reflections.get("undo")).setEnabled(true);
            ((JMenuItem)reflections.get("undo")).setText(undoManager.getUndoPresentationName());
        } else {
            ((JMenuItem)reflections.get("undo")).setEnabled(false);
            ((JMenuItem)reflections.get("undo")).setText("Undo ");
        }
        if (undoManager.canRedo()) {
            ((JMenuItem)reflections.get("redo")).setEnabled(true);
            ((JMenuItem)reflections.get("redo")).setText(undoManager.getRedoPresentationName());
        } else {
            ((JMenuItem)reflections.get("redo")).setEnabled(false);
            ((JMenuItem)reflections.get("redo")).setText("Redo ");
        }
    }

    public void selectAll() {
        DesktopWindow desktopWindow = (DesktopWindow)this.windows.getSelectedFrame();
        if (desktopWindow != null) {
            desktopWindow.selectAll();
        }
    }

    public void newProject() {
        if (this.prj != null) {
            this.projectTree.removeAll();
            this.windows.closeAllWindows();
        }
        this.prj = new Project();
        this.enableItens(this.getMenuItens(new String[]{"export", "save project", "close", "compile"}));
        this.enableItens(this.getMenuItens(new String[]{"new specification", "save project as", "remove specification"}));
        this.setTitle("The ABACO System - New Project");
        this.repaint();
    }

    public void newSpecification() {
        this.newSpecification("");
    }

    public void newSpecification(String string) {
        if (this.prj == null) {
            return;
        }
        String string2 = JOptionPane.showInputDialog(this.windows, (Object)"Type specification name");
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (string2 == null) {
            return;
        }
        if ((string2 = string2.trim()).length() == 0) {
            return;
        }
        boolean bl4 = this.prj.newSpecification(string2);
        this.projectTree.insertItem(string2);
        this.openSpecification(string2);
    }

    SpecificationEditor findEditor(String string) {
        JInternalFrame[] jInternalFrameArray = this.windows.getAllFrames();
        int n = 0;
        while (n < jInternalFrameArray.length) {
            SpecificationEditor specificationEditor;
            if (jInternalFrameArray[n] instanceof SpecificationEditor && (specificationEditor = (SpecificationEditor)jInternalFrameArray[n]).sourceProject() == this.prj && specificationEditor.specificationName().equals(string)) {
                return specificationEditor;
            }
            ++n;
        }
        return null;
    }

    public void openSpecification(String string) {
        if (this.prj == null) {
            return;
        }
        SpecificationEditor specificationEditor = this.findEditor(string);
        if (specificationEditor != null) {
            try {
                specificationEditor.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            return;
        }
        if (!this.prj.containsSpecification(string)) {
            return;
        }
        new SpecificationEditor(string, this.prj);
    }

    public void search() {
        if (this.prj != null && this.windows.getSelectedFrame() != null && this.searchDialog != null) {
            ((Component)this.searchDialog).setVisible(true);
        }
    }

    public void replace() {
        if (this.prj != null && this.replaceDialog != null) {
            ((Component)this.replaceDialog).setVisible(true);
        }
    }

    public void removeSpecification() {
        if (this.prj == null) {
            return;
        }
        String string = this.projectTree.getSelection();
        if (string == null) {
            return;
        }
        SpecificationEditor specificationEditor = this.findEditor(string);
        if (specificationEditor != null) {
            specificationEditor.dispose();
        }
        this.prj.removeSpecification(string);
        this.projectTree.removeItem(string);
        this.projectTree.setSelectionPath(null);
    }

    public void removeRecursivelySpecification(String string) {
        if (this.prj == null) {
            return;
        }
        if (string == null) {
            return;
        }
        SpecificationEditor specificationEditor = this.findEditor(string);
        if (specificationEditor != null) {
            specificationEditor.dispose();
        }
        this.prj.removeSpecificationRecursive(string);
        this.projectTree.removeItemRecursively(string);
        this.projectTree.setSelectionPath(null);
    }

    public void cascadeWindows() {
        DesktopWindow.cascade(this.windows);
    }

    public void compile() {
        String string = this.projectTree.getSelection();
        if (string != null) {
            new CompilerWindow(this.windows, this.prj, string);
        }
    }

    public void exportProject() {
        String string = this.projectTree.getSelection();
        if (this.prj == null || string == null) {
            return;
        }
        Exporter.exportProject(this.prj, string);
    }

    public void pageSetup() {
        this.fileMenu.repaint();
        Thread thread = new Thread(){

            public void run() {
                Paper paper = Interface.this.pageFormat.getPaper();
                PageSetupDialog pageSetupDialog = null;
                URL uRL = ClassLoader.getSystemResource("br/ufpe/abaco/pageSetup.xml");
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                if (pageSetupDialog == null) {
                    pageSetupDialog = new PageSetupDialog(Interface.getInterface());
                }
                pageSetupDialog.setPageFormat(Interface.this.pageFormat);
                ((Component)pageSetupDialog).setVisible(true);
                Interface.this.pageFormat = pageSetupDialog.getNewPageFormat();
            }
        };
        thread.start();
    }

    public void print() {
        SpecificationEditor specificationEditor = (SpecificationEditor)this.windows.getActiveSpecEditor();
        if (specificationEditor != null) {
            final String string = specificationEditor.getTextArea().getText();
            this.fileMenu.repaint();
            Thread thread = new Thread(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    PrinterJob printerJob;
                    SpecificationPrinter specificationPrinter;
                    block9: {
                        specificationPrinter = new SpecificationPrinter(string);
                        printerJob = PrinterJob.getPrinterJob();
                        int n = (int)Interface.this.pageFormat.getWidth();
                        int n2 = (int)Interface.this.pageFormat.getHeight();
                        Book book = new Book();
                        int n3 = 0;
                        try {
                            try {}
                            catch (PrinterException printerException) {
                                JOptionPane.showMessageDialog(null, printerException.getMessage(), "Info", 1);
                                Object var10_12 = null;
                                Interface.this.setCursor(Cursor.getPredefinedCursor(0));
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var10_13 = null;
                            Interface.this.setCursor(Cursor.getPredefinedCursor(0));
                            throw throwable;
                        }
                        while (true) {
                            BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
                            Graphics graphics = bufferedImage.getGraphics();
                            graphics.setColor(Color.white);
                            graphics.fillRect(0, 0, n, n2);
                            if (specificationPrinter.print(graphics, Interface.this.pageFormat, n3) != 0) {
                                specificationPrinter.setNumberOfPages(n3);
                                specificationPrinter.showPrintStatus(true);
                                book.append(specificationPrinter, Interface.this.pageFormat, n3);
                                printerJob.setPageable(book);
                                if (!printerJob.printDialog()) {
                                    break;
                                }
                                break block9;
                            }
                            System.gc();
                            ++n3;
                        }
                        Object var10_10 = null;
                        Interface.this.setCursor(Cursor.getPredefinedCursor(0));
                        return;
                    }
                    Interface.this.setCursor(Cursor.getPredefinedCursor(3));
                    printerJob.print();
                    if (specificationPrinter.getPrintStatusDialog() != null) {
                        specificationPrinter.getPrintStatusDialog().dispose();
                    }
                    JOptionPane.showMessageDialog(null, "Printing completed successfully", "Info", 1);
                    Object var10_11 = null;
                    Interface.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            };
            thread.start();
        }
    }

    public void printPreview() {
        SpecificationEditor specificationEditor = (SpecificationEditor)this.windows.getActiveSpecEditor();
        if (specificationEditor != null) {
            final String string = specificationEditor.getTextArea().getText();
            final PageFormat pageFormat = this.pageFormat;
            Thread thread = new Thread(){

                public void run() {
                    Interface.this.fileMenu.repaint();
                    new PrintPreview(new SpecificationPrinter(string), pageFormat);
                }
            };
            thread.start();
        }
    }

    public void closeAll() {
        if (this.prj == null) {
            return;
        }
        this.windows.closeAllWindows();
    }

    public int closeCurrentProject() {
        int n = -1;
        if (this.prj == null) {
            return 0;
        }
        if (this.prj.isChanged()) {
            String string = "Do you want save changes in this project?";
            n = JOptionPane.showConfirmDialog(this.windows, string, "Warning", 1, 3);
            if (n == 0) {
                try {
                    this.prj.saveProject();
                    this.disableItens(this.getMenuItens(new String[]{"export", "compile", "save project", "save project as", "close", "remove specification", "new specification"}));
                }
                catch (Exception exception) {
                    string = "Impossible save project " + exception.getMessage();
                    JOptionPane.showMessageDialog(this.windows, string, "Error", 0);
                    return 0;
                }
            } else if (n == 2) {
                return 2;
            }
        }
        this.windows.closeAllWindows();
        this.prj = null;
        this.projectTree.removeAll();
        this.repaint();
        this.disableItens(this.getMenuItens(new String[]{"export", "save project", "save project as", "close", "remove specification", "new specification"}));
        return 0;
    }

    public void setLabel(String string) {
        this.labelMessage.setText(string);
    }

    public void setHelpMessage(String string) {
        this.helpMessage.setText(string);
    }

    public static Interface getInterface() {
        return currInterface;
    }

    public JMenu getWindowMenu() {
        return this.windowMenu;
    }

    public OpenedWindows getPane() {
        return this.windows;
    }

    public void buildMenuItem(JMenu jMenu, String string, String string2, String string3, boolean bl, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem(string2);
        jMenu.add(jMenuItem);
        jMenuItem.setEnabled(bl);
        reflections.put(string, jMenuItem);
        if (string3 != null) {
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(string3));
        }
        if (actionListener != null) {
            jMenuItem.addActionListener(actionListener);
        }
    }

    public JMenuItem getMenuItem(String string) {
        return (JMenuItem)reflections.get(string.toLowerCase());
    }

    public JMenuItem[] getMenuItens(String[] stringArray) {
        JMenuItem[] jMenuItemArray = new JMenuItem[stringArray.length];
        int n = 0;
        while (n < jMenuItemArray.length) {
            jMenuItemArray[n] = (JMenuItem)reflections.get(stringArray[n].toLowerCase());
            ++n;
        }
        return jMenuItemArray;
    }

    public void enableItens(JMenuItem[] jMenuItemArray) {
        int n = 0;
        while (n < jMenuItemArray.length) {
            if (jMenuItemArray[n] != null) {
                jMenuItemArray[n].setEnabled(true);
            }
            ++n;
        }
    }

    public void disableItens(JMenuItem[] jMenuItemArray) {
        int n = 0;
        while (n < jMenuItemArray.length) {
            if (jMenuItemArray[n] != null) {
                jMenuItemArray[n].setEnabled(false);
            }
            ++n;
        }
    }

    class ProjectFileMenuItem
    extends JMenuItem
    implements ActionListener {
        String projectFilePath;

        ProjectFileMenuItem(String string, int n) {
            super(string);
            this.addActionListener(this);
            this.setAccelerator(KeyStroke.getKeyStroke("ctrl " + n));
            this.projectFilePath = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Interface.this.open(this.projectFilePath);
        }
    }

    class AbacoMenuItem
    extends JMenuItem {
        int nListeners = 0;

        AbacoMenuItem() {
        }

        public void addActionListener(ActionListener actionListener) {
            ++this.nListeners;
            super.addActionListener(actionListener);
            this.setEnabled(true);
        }

        public void removeActionListener(ActionListener actionListener) {
            --this.nListeners;
            super.removeActionListener(actionListener);
            if (this.nListeners == 0) {
                this.setEnabled(false);
            }
        }
    }
}

