/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.abaco.gui;

import br.ufpe.abaco.gui.DesktopWindow;
import br.ufpe.abaco.gui.Interface;
import br.ufpe.abaco.gui.InternalCGI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class HelpMenu
extends DesktopWindow
implements ActionListener,
HyperlinkListener,
TreeSelectionListener {
    private DefaultTreeModel model;
    private JTree tree;
    private JEditorPane edtContents = new JEditorPane();
    private JSplitPane splitPane = new JSplitPane();
    private JPanel panButtons = new JPanel();
    private ImageIcon prev = new ImageIcon(ClassLoader.getSystemResource("br/ufpe/abaco/icons/StepBack16.gif"));
    private ImageIcon next = new ImageIcon(ClassLoader.getSystemResource("br/ufpe/abaco/icons/StepForward16.gif"));
    private JButton buttonPrev = new JButton(this.prev);
    private JButton buttonNext = new JButton(this.next);
    private URL urlCorrente = null;
    private Hashtable pages = new Hashtable();
    private Hashtable nodes = new Hashtable();
    private Vector forwardPages = new Vector();
    private Vector backwardPages = new Vector();
    private int indexLastBackwardPage = -1;
    private int indexLastForwardPage = -1;

    void createTree(DefaultMutableTreeNode defaultMutableTreeNode, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            this.pages.put(objectArray[n], objectArray[n + 1]);
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode((String)objectArray[n]);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            if (n + 2 < objectArray.length && objectArray[n + 2] instanceof Object[]) {
                Object[] objectArray2 = (Object[])objectArray[n + 2];
                this.createTree(defaultMutableTreeNode2, objectArray2);
                ++n;
            }
            n += 2;
        }
    }

    public HelpMenu(String string, String string2) {
        super(string, true, true, true, true);
        this.edtContents.setEnabled(true);
        this.edtContents.setEditable(false);
        this.edtContents.addHyperlinkListener(this);
        this.setTitle("Help Contents");
        this.setSize(300, 200);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Contents");
        this.pages.put("Contents", "doc/index.html");
        this.createAndLinkNodes(new String[]{"Action Notation 1", "Action Notation 2", "Data Notation", "FAQ"}, new String[]{"doc/actionNotation1/actionNotation1.html", "doc/actionNotation2/actionNotation2.html", "doc/dataNotation/dataNotation.html", "doc/auxiliar/onConstruction.html"});
        this.createTree(defaultMutableTreeNode, new Object[]{"Manual", "doc/manual/manual.htm", new Object[]{"Specification Compiler", "doc/manual/specification/SpecificationCompiler.html", "Action Library", "doc/manual/action/Library.html", "System Interface", "doc/manual/interface/system_interface.html"}, "License", "doc/license.htm"});
        this.addChildrenNodes(defaultMutableTreeNode, new String[]{"Action Notation 1", "Action Notation 2", "Data Notation", "FAQ"});
        this.createAndLinkNodes(new String[]{"Action Concepts", "Yielders Concepts", "Data Concepts", "Basic Action Notation", "Functional Action Notation", "Declarative Action Notation", "Imperative Action Notation", "Reflective Action Notation", "Communicative Action Notation", "Directive Action Notation", "Hybrid Action Notation", "Facets Action Notation"}, new String[]{"doc/actionNotation1/actions.html", "doc/actionNotation1/yielders.html", "doc/actionNotation1/data.html", "doc/actionNotation1/basic.html", "doc/actionNotation1/functional.html", "doc/actionNotation1/declarative.html", "doc/actionNotation1/imperative.html", "doc/actionNotation1/reflective.html", "doc/actionNotation1/communicative.html", "doc/actionNotation1/directive.html", "doc/actionNotation1/hybrid.html", "doc/actionNotation1/facets.html"});
        this.addChildrenNodes(this.nodes.get("Action Notation 1"), new String[]{"Action Concepts", "Yielders Concepts", "Data Concepts", "Basic Action Notation", "Functional Action Notation", "Declarative Action Notation", "Imperative Action Notation", "Reflective Action Notation", "Communicative Action Notation", "Directive Action Notation", "Hybrid Action Notation", "Facets Action Notation"});
        this.createAndLinkNodes(new String[]{"Basic Actions", "Basic Data", "Basic Yielders"}, new String[]{"doc/actionNotation1/actionsBasicNotation.html", "doc/actionNotation1/dataBasicNotation.html", "doc/actionNotation1/yieldersBasicNotation.html"});
        this.addChildrenNodes(this.nodes.get("Basic Action Notation"), new String[]{"Basic Actions", "Basic Data", "Basic Yielders"});
        this.createAndLinkNodes(new String[]{"Functional Actions", "Functional Data", "Functional Yielders"}, new String[]{"doc/actionNotation1/actionsFuncNotation.html", "doc/actionNotation1/dataFuncNotation.html", "doc/actionNotation1/yieldersFuncNotation.html"});
        this.addChildrenNodes(this.nodes.get("Functional Action Notation"), new String[]{"Functional Actions", "Functional Data", "Functional Yielders"});
        this.createAndLinkNodes(new String[]{"Declarative Actions", "Declarative Data", "Declarative Yielders"}, new String[]{"doc/actionNotation1/actionsDeclarativeNotation.html", "doc/actionNotation1/dataDeclarativeNotation.html", "doc/actionNotation1/yieldersDeclarativeNotation.html"});
        this.addChildrenNodes(this.nodes.get("Declarative Action Notation"), new String[]{"Declarative Actions", "Declarative Data", "Declarative Yielders"});
        this.createAndLinkNodes(new String[]{"Directive Actions", "Directive Data", "Directive Yielders"}, new String[]{"doc/actionNotation1/actionsDirectiveNotation.html", "doc/actionNotation1/dataDirectiveNotation.html", "doc/actionNotation1/yieldersDirectiveNotation.html"});
        this.addChildrenNodes(this.nodes.get("Directive Action Notation"), new String[]{"Directive Actions", "Directive Data", "Directive Yielders"});
        this.createAndLinkNodes(new String[]{"Imperative Actions", "Imperative Data", "Imperative Yielders"}, new String[]{"doc/actionNotation1/actionsImperativeNotation.html", "doc/actionNotation1/dataImperativeNotation.html", "doc/actionNotation1/yieldersImperativeNotation.html"});
        this.addChildrenNodes(this.nodes.get("Imperative Action Notation"), new String[]{"Imperative Actions", "Imperative Data", "Imperative Yielders"});
        this.createAndLinkNodes(new String[]{"Communicative Actions", "Communicative Data", "Communicative Yielders"}, new String[]{"doc/actionNotation1/actionsCommunicativeNotation.html", "doc/actionNotation1/dataCommunicativeNotation.html", "doc/actionNotation1/yieldersCommunicativeNotation.html"});
        this.addChildrenNodes(this.nodes.get("Communicative Action Notation"), new String[]{"Communicative Actions", "Communicative Data", "Communicative Yielders"});
        this.createAndLinkNodes(new String[]{"Reflective Actions", "Reflective Data", "Reflective Yielders"}, new String[]{"doc/actionNotation1/actionsReflectiveNotation.html", "doc/actionNotation1/dataReflectiveNotation.html", "doc/actionNotation1/yieldersReflectiveNotation.html"});
        this.addChildrenNodes(this.nodes.get("Reflective Action Notation"), new String[]{"Reflective Actions", "Reflective Data", "Reflective Yielders"});
        this.createAndLinkNodes(new String[]{"Hybrid Actions", "Hybrid Data", "Hybrid Yielders"}, new String[]{"doc/actionNotation1/actionsHybridNotation.html", "doc/actionNotation1/dataHybridNotation.html", "doc/actionNotation1/yieldersHybridNotation.html"});
        this.addChildrenNodes(this.nodes.get("Hybrid Action Notation"), new String[]{"Hybrid Actions", "Hybrid Data", "Hybrid Yielders"});
        this.createAndLinkNodes(new String[]{"Facet Actions", "Facet Incomes", "Facet Outcomes", "Facet Yielders"}, new String[]{"doc/actionNotation1/actionsFacetsNotation.html", "doc/actionNotation1/incomesFacetsNotation.html", "doc/actionNotation1/outcomesFacetsNotation.html", "doc/actionNotation1/yieldersFacetsNotation.html"});
        this.addChildrenNodes(this.nodes.get("Facets Action Notation"), new String[]{"Facet Actions", "Facet Incomes", "Facet Outcomes", "Facet Yielders"});
        this.createAndLinkNodes(new String[]{"Introduction to Action Notation 2", "Differences between AN-1 and AN-2", "Kernel AN-2", "Extension to Full AN-2"}, new String[]{"doc/actionNotation2/actionNotation2Introduction.html", "doc/actionNotation2/actionNotation2DifferencesAN2AN1.html", "doc/actionNotation2/actionNotation2KernellAN2.html", "doc/actionNotation2/actionNotation2ExtensionFullAN2.html"});
        this.addChildrenNodes(this.nodes.get("Action Notation 2"), new String[]{"Introduction to Action Notation 2", "Differences between AN-1 and AN-2", "Kernel AN-2", "Extension to Full AN-2"});
        this.createAndLinkNodes(new String[]{"Data", "Flow of Data and Control", "Scopes of Bindings", "Actions as Data", "Effects on Storage", "Interactive Processes"}, new String[]{"doc/actionNotation2/actionNotation2Data.html", "doc/actionNotation2/actionNotation2FlowDataControl.html", "doc/actionNotation2/actionNotation2ScopesBindings.html", "doc/actionNotation2/actionNotation2ActionsData.html", "doc/actionNotation2/actionNotation2EffectsStorage.html", "doc/actionNotation2/actionNotation2InteractiveProcesses.html"});
        this.addChildrenNodes(this.nodes.get("Kernel AN-2"), new String[]{"Data", "Flow of Data and Control", "Scopes of Bindings", "Actions as Data", "Effects on Storage", "Interactive Processes"});
        this.createAndLinkNodes(new String[]{"Data Full", "Flow of Data and Control Full", "Scopes of Bindings Full", "Actions as Data Full", "Effects on Storage Full", "Interactive Processes Full"}, new String[]{"doc/actionNotation2/actionNotation2ExtensionData.html", "doc/actionNotation2/actionNotation2ExtensionFlowDataControl.html", "doc/actionNotation2/actionNotation2ExtensionScopesBindings.html", "doc/actionNotation2/actionNotation2ExtensionActionsData.html", "doc/actionNotation2/actionNotation2ExtensionEffectsStorage.html", "doc/actionNotation2/actionNotation2ExtensionInteractiveProcesses.html"});
        this.addChildrenNodes(this.nodes.get("Extension to Full AN-2"), new String[]{"Data Full", "Flow of Data and Control Full", "Scopes of Bindings Full", "Actions as Data Full", "Effects on Storage Full", "Interactive Processes Full"});
        this.createAndLinkNodes(new String[]{"Tuples", "TruthValues", "Lists", "Strings", "Sets", "Maps"}, new String[]{"doc/dataNotation/tuples.html", "doc/dataNotation/truthValues.html", "doc/dataNotation/lists.html", "doc/dataNotation/strings.html", "doc/dataNotation/sets.html", "doc/dataNotation/maps.html"});
        this.addChildrenNodes(this.nodes.get("Data Notation"), new String[]{"Tuples", "TruthValues", "Lists", "Strings", "Sets", "Maps"});
        this.tree = new JTree(defaultMutableTreeNode);
        this.tree.setShowsRootHandles(true);
        this.tree.addTreeSelectionListener(this);
        int n = 1;
        this.tree.getSelectionModel().setSelectionMode(n);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jScrollPane.setVisible(true);
        this.getContentPane().add((Component)this.splitPane, "Center");
        this.splitPane.add((Component)jScrollPane, "left");
        this.splitPane.add((Component)new JScrollPane(this.edtContents), "right");
        this.panButtons.add(this.buttonPrev);
        this.panButtons.add(this.buttonNext);
        this.buttonPrev.addActionListener(this);
        this.buttonNext.addActionListener(this);
        this.setSelectionOnButtons();
        this.getContentPane().add((Component)this.panButtons, "North");
        try {
            this.urlCorrente = ClassLoader.getSystemResource(string2);
            this.edtContents.setPage(this.urlCorrente);
            String string3 = this.buildTitle();
            if (!string3.equals("")) {
                this.setTitle(string3);
            }
            this.setSelected(true);
        }
        catch (Exception exception) {
            System.err.println("Can't Open : " + string2);
            exception.printStackTrace();
            this.dispose();
        }
    }

    private void createAndLinkNodes(String[] stringArray, String[] stringArray2) {
        int n = 0;
        while (n < stringArray.length) {
            this.pages.put(stringArray[n], stringArray2[n]);
            this.nodes.put(stringArray[n], new DefaultMutableTreeNode(stringArray[n]));
            ++n;
        }
    }

    private void addChildrenNodes(Object object, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.nodes.get(stringArray[n]);
            ((DefaultMutableTreeNode)object).add(defaultMutableTreeNode);
            ++n;
        }
    }

    private void setSelectionOnButtons() {
        if (this.indexLastBackwardPage < 0) {
            this.buttonPrev.setEnabled(false);
        } else {
            this.buttonPrev.setEnabled(true);
        }
        if (this.indexLastForwardPage < 0) {
            this.buttonNext.setEnabled(false);
        } else {
            this.buttonNext.setEnabled(true);
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        String string = defaultMutableTreeNode.toString();
        this.setHelpPage(string);
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            Interface.getInterface().setHelpMessage(hyperlinkEvent.getDescription());
        } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.EXITED) {
            Interface.getInterface().setHelpMessage(" ");
        } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            Interface.getInterface().setHelpMessage(" ");
            URL uRL = hyperlinkEvent.getURL();
            if (uRL.toString().startsWith("http://abaco-cgi/")) {
                try {
                    String string;
                    String string2;
                    String string3 = uRL.toString().substring(17);
                    int n = string3.indexOf("/");
                    if (n == -1) {
                        string2 = string3;
                        string = "";
                    } else {
                        string2 = string3.substring(0, n);
                        string = string3.substring(n);
                    }
                    Class<?> clazz = Class.forName(string2);
                    InternalCGI internalCGI = (InternalCGI)clazz.newInstance();
                    internalCGI.act(this, string);
                }
                catch (Exception exception) {
                    System.err.println("Can't Open : " + uRL);
                }
            } else {
                try {
                    this.backwardPages.add(this.urlCorrente);
                    this.forwardPages.clear();
                    this.indexLastForwardPage = -1;
                    this.edtContents.setPage(uRL);
                    String string = this.buildTitle();
                    this.urlCorrente = uRL;
                    if (!string.equals("")) {
                        this.setTitle(string);
                    }
                    this.show();
                    ++this.indexLastBackwardPage;
                    this.setSelectionOnButtons();
                }
                catch (Exception exception) {
                    System.err.println("Can't Open : " + uRL);
                }
            }
        }
    }

    private String buildTitle() throws IOException {
        int n;
        String string = "";
        String string2 = "";
        StringBuffer stringBuffer = new StringBuffer();
        InputStream inputStream = this.urlCorrente.openStream();
        while ((n = inputStream.read()) != -1) {
            if ((char)n != '<') continue;
            while ((char)n != '>') {
                n = inputStream.read();
                string = string + (char)n;
            }
            if (string.startsWith("ABACO")) {
                string2 = string.substring(6, string.length() - 1);
            }
            string = "";
        }
        inputStream.close();
        return string2;
    }

    void setHelpPage(String string) {
        String string2 = (String)this.pages.get(string);
        try {
            this.backwardPages.add(this.urlCorrente);
            this.forwardPages.clear();
            this.indexLastForwardPage = -1;
            this.urlCorrente = ClassLoader.getSystemResource(string2);
            this.edtContents.setPage(this.urlCorrente);
            String string3 = this.buildTitle();
            if (!string3.equals("")) {
                this.setTitle(string3);
            }
            this.show();
            ++this.indexLastBackwardPage;
            this.setSelectionOnButtons();
        }
        catch (Exception exception) {
            System.err.println("Can't Open : " + string2);
            exception.printStackTrace();
            this.dispose();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.buttonPrev) {
            if (this.indexLastBackwardPage >= 0) {
                try {
                    this.edtContents.setPage((URL)this.backwardPages.get(this.indexLastBackwardPage));
                    this.forwardPages.add(this.urlCorrente);
                    ++this.indexLastForwardPage;
                    this.urlCorrente = (URL)this.backwardPages.get(this.indexLastBackwardPage);
                    this.backwardPages.remove(this.backwardPages.get(this.indexLastBackwardPage));
                    --this.indexLastBackwardPage;
                    String string = this.buildTitle();
                    if (!string.equals("")) {
                        this.setTitle(string);
                    }
                    this.show();
                    this.setSelectionOnButtons();
                }
                catch (Exception exception) {
                    System.err.println("Can't Open : " + this.urlCorrente);
                }
            }
        } else if (actionEvent.getSource() == this.buttonNext && this.indexLastForwardPage >= 0) {
            try {
                this.edtContents.setPage((URL)this.forwardPages.get(this.indexLastForwardPage));
                this.backwardPages.add(this.urlCorrente);
                ++this.indexLastBackwardPage;
                this.urlCorrente = (URL)this.forwardPages.get(this.indexLastForwardPage);
                this.forwardPages.remove(this.forwardPages.get(this.indexLastForwardPage));
                --this.indexLastForwardPage;
                String string = this.buildTitle();
                if (!string.equals("")) {
                    this.setTitle(string);
                }
                this.show();
                this.setSelectionOnButtons();
            }
            catch (Exception exception) {
                System.err.println("Can't Open : " + this.urlCorrente);
            }
        }
    }

    public void copy() {
        this.edtContents.copy();
    }

    public void selectAll() {
        this.edtContents.selectAll();
    }

    public String getValue() {
        return this.edtContents.getText();
    }

    public String getValue(int n, int n2) throws BadLocationException {
        return this.edtContents.getText(n, n2);
    }

    public void selectText(int n, int n2) {
        this.edtContents.select(n, n2);
    }

    public String getSelectedText() {
        return this.edtContents.getSelectedText();
    }

    public void setCaretPosition(int n) {
        this.edtContents.setCaretPosition(n);
    }
}

