/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.abaco.gui;

import br.ufpe.abaco.Exporter.DocumentBuilder;
import br.ufpe.abaco.Exporter.HTMLDocumentBuilder;
import br.ufpe.abaco.Exporter.LatexDocumentBuilder;
import br.ufpe.abaco.Exporter.PlainTextDocumentBuilder;
import br.ufpe.abaco.gui.CompilerWindow;
import br.ufpe.abaco.gui.ExampleFileFilter;
import br.ufpe.abaco.gui.Interface;
import br.ufpe.abaco.gui.Project;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class Exporter {
    public static boolean exporting = false;
    public static String fileName = null;
    public static DocumentBuilder dest;
    private static JRadioButton htmlOption;
    private static JRadioButton latexOption;
    private static JRadioButton plainTextOption;
    private static JCheckBox cssOption;
    private static JCheckBox separatedHtmlFiles;
    private static JCheckBox styOption;
    private static JCheckBox classOption;
    private static JCheckBox tocOption;
    private static JCheckBox preOption;
    private static JCheckBox separatedLatexFiles;
    private static JCheckBox separatedTextFiles;
    private static JTextField cssFilePath;
    private static JTextField styFilePath;
    private static JTextField classFilePath;
    private static ButtonGroup bgroup;
    private static JButton ok;
    private static JButton cancel;
    private static JButton browseCssFile;
    private static JButton browseStyFile;
    private static JButton browseClassFile;
    private static JDialog exportDialog;
    private static JLabel label;
    private static boolean useCustomCssFile;
    private static boolean useCustomStyFile;
    private static boolean useCustomClassFile;
    private static boolean generateToc;
    private static boolean generatePreambule;
    private static boolean multipleHtmlFiles;
    private static boolean multipleLatexFiles;
    private static boolean multipleTextFiles;
    private static String lastVisitedDirectory;

    public static void printFiles() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(fileName);
            fileOutputStream.write(dest.generateDocument().getBytes());
            fileOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        exporting = false;
    }

    public static String getOutputFileName() {
        return fileName;
    }

    public static void exportProject(Project project, String string) {
        Exporter.buildExportDialog(project, string);
        if (!exportDialog.isVisible()) {
            ((Component)exportDialog).setVisible(true);
        }
    }

    private static void buildExportDialog(final Project project, final String string) {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(htmlOption, gridBagConstraints);
        jPanel.add(htmlOption);
        htmlOption.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (!htmlOption.isSelected()) {
                    separatedHtmlFiles.setEnabled(false);
                    cssOption.setEnabled(false);
                } else {
                    separatedHtmlFiles.setEnabled(true);
                    cssOption.setEnabled(true);
                }
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(separatedHtmlFiles, gridBagConstraints);
        jPanel.add(separatedHtmlFiles);
        separatedHtmlFiles.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (!separatedHtmlFiles.isSelected()) {
                    multipleHtmlFiles = false;
                } else {
                    multipleHtmlFiles = true;
                }
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagLayout.setConstraints(cssOption, gridBagConstraints);
        jPanel.add(cssOption);
        cssOption.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (!cssOption.isSelected()) {
                    useCustomCssFile = false;
                    cssFilePath.setEnabled(false);
                    browseCssFile.setEnabled(false);
                } else {
                    useCustomCssFile = true;
                    cssFilePath.setEnabled(true);
                    browseCssFile.setEnabled(true);
                }
            }
        });
        JPanel jPanel2 = new JPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel2, 0);
        jPanel2.add(cssFilePath);
        jPanel2.add(browseCssFile);
        browseCssFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = lastVisitedDirectory == null ? new JFileChooser(new File(".")) : new JFileChooser(new File(lastVisitedDirectory.substring(0, lastVisitedDirectory.lastIndexOf(System.getProperty("file.separator")))));
                jFileChooser.addChoosableFileFilter(new ExampleFileFilter("css", "Cascading Style Sheet File"));
                jFileChooser.removeChoosableFileFilter(jFileChooser.getAcceptAllFileFilter());
                jFileChooser.setDialogTitle("Browse");
                jFileChooser.setFileSelectionMode(0);
                int n = jFileChooser.showOpenDialog(null);
                if (n == 0) {
                    cssFilePath.setText(jFileChooser.getSelectedFile().getPath());
                    lastVisitedDirectory = jFileChooser.getSelectedFile().getPath();
                }
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        jPanel.setBorder(BorderFactory.createTitledBorder(""));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(latexOption, gridBagConstraints);
        jPanel3.add(latexOption);
        latexOption.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (!latexOption.isSelected()) {
                    separatedLatexFiles.setEnabled(false);
                    styOption.setEnabled(false);
                    classOption.setEnabled(false);
                    preOption.setEnabled(false);
                    tocOption.setEnabled(false);
                    styFilePath.setEnabled(false);
                    browseStyFile.setEnabled(false);
                    classFilePath.setEnabled(false);
                    browseClassFile.setEnabled(false);
                } else {
                    separatedLatexFiles.setEnabled(true);
                    tocOption.setEnabled(true);
                    if (tocOption.isSelected()) {
                        generateToc = true;
                    }
                    styOption.setEnabled(true);
                    preOption.setEnabled(true);
                    if (preOption.isSelected()) {
                        generatePreambule = true;
                    }
                    classOption.setEnabled(true);
                }
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(separatedLatexFiles, gridBagConstraints);
        jPanel3.add(separatedLatexFiles);
        separatedLatexFiles.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (!separatedLatexFiles.isSelected()) {
                    multipleLatexFiles = false;
                } else {
                    multipleLatexFiles = true;
                }
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagLayout.setConstraints(tocOption, gridBagConstraints);
        jPanel3.add(tocOption);
        tocOption.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (tocOption.isSelected()) {
                    generateToc = true;
                } else {
                    generateToc = false;
                }
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagLayout.setConstraints(preOption, gridBagConstraints);
        jPanel3.add(preOption);
        preOption.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (preOption.isSelected() && latexOption.isSelected()) {
                    System.out.println("Chegou aqui");
                    generatePreambule = true;
                    classOption.setEnabled(true);
                    styOption.setEnabled(true);
                    if (classOption.isSelected()) {
                        useCustomClassFile = true;
                    }
                    if (styOption.isSelected()) {
                        useCustomStyFile = true;
                    }
                } else {
                    generatePreambule = false;
                    classOption.setEnabled(false);
                    styOption.setEnabled(false);
                    if (classOption.isSelected()) {
                        useCustomClassFile = false;
                    }
                    if (styOption.isSelected()) {
                        useCustomStyFile = false;
                    }
                }
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagLayout.setConstraints(styOption, gridBagConstraints);
        jPanel3.add(styOption);
        styOption.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (!styOption.isSelected()) {
                    useCustomStyFile = false;
                    styFilePath.setEnabled(false);
                    browseStyFile.setEnabled(false);
                } else {
                    useCustomStyFile = true;
                    styFilePath.setEnabled(true);
                    browseStyFile.setEnabled(true);
                }
            }
        });
        JPanel jPanel4 = new JPanel();
        BoxLayout boxLayout2 = new BoxLayout(jPanel4, 0);
        jPanel4.add(styFilePath);
        jPanel4.add(browseStyFile);
        browseStyFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = lastVisitedDirectory == null ? new JFileChooser(new File(".")) : new JFileChooser(new File(lastVisitedDirectory.substring(0, lastVisitedDirectory.lastIndexOf(System.getProperty("file.separator")))));
                jFileChooser.addChoosableFileFilter(new ExampleFileFilter("sty", "LaTeX Style File"));
                jFileChooser.removeChoosableFileFilter(jFileChooser.getAcceptAllFileFilter());
                jFileChooser.setDialogTitle("Browse");
                jFileChooser.setFileSelectionMode(0);
                int n = jFileChooser.showOpenDialog(null);
                if (n == 0) {
                    styFilePath.setText(jFileChooser.getSelectedFile().getPath());
                    lastVisitedDirectory = jFileChooser.getSelectedFile().getPath();
                }
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel3.add(jPanel4);
        classOption.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (!classOption.isSelected()) {
                    useCustomClassFile = false;
                    classFilePath.setEnabled(false);
                    browseClassFile.setEnabled(false);
                } else {
                    useCustomClassFile = true;
                    classFilePath.setEnabled(true);
                    browseClassFile.setEnabled(true);
                }
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagLayout.setConstraints(classOption, gridBagConstraints);
        jPanel3.add(classOption);
        JPanel jPanel5 = new JPanel();
        BoxLayout boxLayout3 = new BoxLayout(jPanel5, 0);
        jPanel5.add(classFilePath);
        jPanel5.add(browseClassFile);
        browseClassFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = lastVisitedDirectory == null ? new JFileChooser(new File(".")) : new JFileChooser(new File(lastVisitedDirectory));
                jFileChooser.addChoosableFileFilter(new ExampleFileFilter("cls", "LaTeX Class File"));
                jFileChooser.removeChoosableFileFilter(jFileChooser.getAcceptAllFileFilter());
                jFileChooser.setDialogTitle("Browse");
                jFileChooser.setFileSelectionMode(0);
                int n = jFileChooser.showOpenDialog(null);
                if (n == 0) {
                    classFilePath.setText(jFileChooser.getSelectedFile().getPath());
                    lastVisitedDirectory = jFileChooser.getSelectedFile().getPath();
                }
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagLayout.setConstraints(jPanel5, gridBagConstraints);
        jPanel3.add(jPanel5);
        jPanel3.setBorder(BorderFactory.createTitledBorder(""));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 30);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(plainTextOption, gridBagConstraints);
        jPanel6.add(plainTextOption);
        plainTextOption.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (!plainTextOption.isSelected()) {
                    separatedTextFiles.setEnabled(false);
                } else {
                    separatedTextFiles.setEnabled(true);
                }
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(separatedTextFiles, gridBagConstraints);
        jPanel6.add(separatedTextFiles);
        separatedTextFiles.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (!separatedTextFiles.isSelected()) {
                    multipleTextFiles = false;
                } else {
                    multipleTextFiles = true;
                }
            }
        });
        jPanel6.setBorder(BorderFactory.createTitledBorder(""));
        JPanel jPanel7 = new JPanel();
        ((FlowLayout)jPanel7.getLayout()).setAlignment(1);
        jPanel7.add(ok);
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                File file;
                if (htmlOption.isSelected() && cssOption.isSelected()) {
                    File file2 = new File(cssFilePath.getText());
                    if (!file2.exists()) {
                        JOptionPane.showMessageDialog(Interface.getInterface(), "File " + cssFilePath.getText() + " not exists!", "Error", 0);
                        return;
                    }
                } else if (latexOption.isSelected() && styOption.isSelected()) {
                    File file3 = new File(styFilePath.getText());
                    if (!file3.exists()) {
                        JOptionPane.showMessageDialog(Interface.getInterface(), "File " + styFilePath.getText() + " not exists!", "Error", 0);
                        return;
                    }
                } else if (latexOption.isSelected() && classOption.isSelected() && !(file = new File(classFilePath.getText())).exists()) {
                    JOptionPane.showMessageDialog(Interface.getInterface(), "File " + classFilePath.getText() + " not exists!", "Error", 0);
                    return;
                }
                JFileChooser jFileChooser = lastVisitedDirectory == null ? new JFileChooser(new File(".")) : new JFileChooser(new File(lastVisitedDirectory));
                ((Component)exportDialog).setVisible(false);
                if (multipleHtmlFiles && htmlOption.isSelected() || multipleLatexFiles && latexOption.isSelected() || multipleTextFiles && plainTextOption.isSelected()) {
                    jFileChooser.setDialogTitle("Select destination directory to export");
                    jFileChooser.setFileSelectionMode(1);
                    n = jFileChooser.showDialog(Interface.getInterface(), "Select");
                } else {
                    jFileChooser.removeChoosableFileFilter(jFileChooser.getAcceptAllFileFilter());
                    jFileChooser.setFileSelectionMode(0);
                    if (latexOption.isSelected()) {
                        jFileChooser.addChoosableFileFilter(new ExampleFileFilter("tex", "LaTeX format"));
                    } else if (htmlOption.isSelected()) {
                        jFileChooser.addChoosableFileFilter(new ExampleFileFilter("html", "HTML Hypertext"));
                    } else if (plainTextOption.isSelected()) {
                        jFileChooser.addChoosableFileFilter(new ExampleFileFilter("txt", "Plain Text"));
                    }
                    n = jFileChooser.showSaveDialog(Interface.getInterface());
                }
                if (n == 0) {
                    fileName = jFileChooser.getSelectedFile().toString();
                    lastVisitedDirectory = jFileChooser.getSelectedFile().getPath();
                    if (htmlOption.isSelected()) {
                        if (!multipleHtmlFiles && !fileName.endsWith(".html")) {
                            fileName = fileName + ".html";
                        }
                        dest = new HTMLDocumentBuilder(useCustomCssFile, multipleHtmlFiles, new File(cssFilePath.getText()));
                    } else if (latexOption.isSelected()) {
                        if (!multipleLatexFiles && !fileName.endsWith(".tex")) {
                            fileName = fileName + ".tex";
                        }
                        dest = new LatexDocumentBuilder(useCustomStyFile, useCustomClassFile, multipleLatexFiles, generateToc, generatePreambule, new File(styFilePath.getText()), new File(classFilePath.getText()));
                    } else if (plainTextOption.isSelected()) {
                        if (!multipleTextFiles && !fileName.endsWith(".txt")) {
                            fileName = fileName + ".txt";
                        }
                        dest = new PlainTextDocumentBuilder(multipleTextFiles);
                    } else {
                        dest = null;
                    }
                    if (dest != null) {
                        exporting = true;
                        new CompilerWindow(null, project, string);
                    }
                }
            }
        });
        jPanel7.add(cancel);
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)exportDialog).setVisible(false);
            }
        });
        bgroup.add(htmlOption);
        bgroup.add(latexOption);
        bgroup.add(plainTextOption);
        separatedLatexFiles.setEnabled(false);
        styOption.setEnabled(false);
        classOption.setEnabled(false);
        tocOption.setEnabled(false);
        preOption.setEnabled(false);
        preOption.setSelected(true);
        cssFilePath.setEnabled(false);
        styFilePath.setEnabled(false);
        classFilePath.setEnabled(false);
        browseCssFile.setEnabled(false);
        browseStyFile.setEnabled(false);
        browseClassFile.setEnabled(false);
        separatedTextFiles.setEnabled(false);
        exportDialog = new JDialog(Interface.getInterface(), "Export", true);
        exportDialog.getContentPane().setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        exportDialog.getContentPane().add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        exportDialog.getContentPane().add(jPanel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        exportDialog.getContentPane().add(jPanel3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(jPanel6, gridBagConstraints);
        exportDialog.getContentPane().add(jPanel6);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(jPanel7, gridBagConstraints);
        exportDialog.getContentPane().add(jPanel7);
        ((Component)exportDialog).setSize(500, 480);
        exportDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                exportDialog.dispose();
            }
        });
        exportDialog.pack();
    }

    static {
        htmlOption = new JRadioButton("HTML Format", true);
        latexOption = new JRadioButton("LaTeX Format");
        plainTextOption = new JRadioButton("Plain text Format");
        cssOption = new JCheckBox("Append a custom .css file");
        separatedHtmlFiles = new JCheckBox("Export each specification in a separated .html file");
        styOption = new JCheckBox("Append a custom LaTex .sty file");
        classOption = new JCheckBox("Append a custom LaTex .cls file");
        tocOption = new JCheckBox("Generate table of contents");
        preOption = new JCheckBox("Generate preambule");
        separatedLatexFiles = new JCheckBox("Export each specification in a separated .tex file");
        separatedTextFiles = new JCheckBox("Export each specification in a separated .txt file");
        cssFilePath = new JTextField(20);
        styFilePath = new JTextField(20);
        classFilePath = new JTextField(20);
        bgroup = new ButtonGroup();
        ok = new JButton("OK");
        cancel = new JButton("Cancel");
        browseCssFile = new JButton("Browse ...");
        browseStyFile = new JButton("Browse ...");
        browseClassFile = new JButton("Browse ...");
        label = new JLabel("Select a file format to export :");
        useCustomCssFile = false;
        useCustomStyFile = false;
        useCustomClassFile = false;
        generateToc = true;
        generatePreambule = true;
        multipleHtmlFiles = false;
        multipleLatexFiles = false;
        multipleTextFiles = false;
        lastVisitedDirectory = null;
    }
}

